/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsNameLinkingNamerKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamerBase;
import org.jetbrains.kotlin.ir.backend.js.utils.MinimizedNameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsImport;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u000f\u001a\u00020\f*\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0014\u0010!\u001a\u00020\f*\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\u00020\f*\u00020\u00102\u0006\u0010%\u001a\u00020#2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010'H\u0002J\u001c\u0010(\u001a\u00020\f*\u00020\u00102\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010'H\u0002J\u0018\u0010)\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020#0**\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00170\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsNameLinkingNamer;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "minimizedMemberNames", "", "isEsModules", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;ZZ)V", "nameMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getNameMap", "()Ljava/util/Map;", "getName", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "importedModules", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "getImportedModules", "()Ljava/util/List;", "imports", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getImports", "getNameForStaticDeclaration", "declaration", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForMemberField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "generateImportForDeclarationWithJsModule", "jsModule", "", "generateImportForDeclarationInFileWithJsModule", "fileJsModule", "jsQualifier", "", "generateRegularQualifiedImport", "fieldData", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsNameLinkingNamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsNameLinkingNamer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsNameLinkingNamer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,238:1\n381#2,3:239\n384#2,4:243\n381#2,3:251\n384#2,4:262\n1#3:242\n1#3:277\n1557#4:247\n1628#4,3:248\n1863#4:254\n1863#4,2:255\n1864#4:257\n1863#4:258\n1863#4,2:259\n1864#4:261\n1611#4,9:266\n1863#4:275\n1864#4:278\n1620#4:279\n123#5:276\n*S KotlinDebug\n*F\n+ 1 JsNameLinkingNamer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsNameLinkingNamer\n*L\n29#1:239,3\n29#1:243,4\n155#1:251,3\n155#1:262,4\n159#1:277\n45#1:247\n45#1:248,3\n167#1:254\n168#1:255,2\n167#1:257\n191#1:258\n192#1:259,2\n191#1:261\n159#1:266,9\n159#1:275\n159#1:278\n159#1:279\n160#1:276\n*E\n"})
public final class JsNameLinkingNamer
extends IrNamerBase {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean minimizedMemberNames;
    private final boolean isEsModules;
    @NotNull
    private final Map<IrDeclaration, JsName> nameMap;
    @NotNull
    private final List<JsImportedModule> importedModules;
    @NotNull
    private final Map<IrDeclaration, JsStatement> imports;

    public JsNameLinkingNamer(@NotNull JsIrBackendContext context, boolean minimizedMemberNames, boolean isEsModules) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.minimizedMemberNames = minimizedMemberNames;
        this.isEsModules = isEsModules;
        this.nameMap = new LinkedHashMap();
        this.importedModules = new ArrayList();
        this.imports = new LinkedHashMap();
    }

    @NotNull
    public final Map<IrDeclaration, JsName> getNameMap() {
        return this.nameMap;
    }

    private final JsName getName(IrDeclarationWithName $this$getName) {
        JsName jsName;
        block7: {
            JsName value$iv;
            block4: {
                Object object;
                Map<IrDeclaration, JsName> $this$getOrPut$iv;
                block6: {
                    IrDeclarationWithName it;
                    block5: {
                        $this$getOrPut$iv = this.nameMap;
                        boolean $i$f$getOrPut = false;
                        value$iv = $this$getOrPut$iv.get($this$getName);
                        if (value$iv != null) break block4;
                        boolean bl = false;
                        object = $this$getName instanceof IrClass ? (IrClass)$this$getName : null;
                        if (object == null) break block5;
                        it = object;
                        boolean bl2 = false;
                        String string2 = this.context.getLocalClassNames().get($this$getName);
                        object = string2;
                        if (string2 != null) break block6;
                    }
                    it = $this$getName;
                    boolean bl = false;
                    object = NameTablesKt.nameIfPropertyAccessor($this$getName);
                    if (object == null) {
                        String string3 = AnnotationUtilsKt.getJsNameOrKotlinName($this$getName).asString();
                        object = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                    }
                }
                Object name2 = object;
                JsName answer$iv = new JsName(NameTablesKt.sanitizeName$default((String)name2, false, 2, null), true);
                $this$getOrPut$iv.put($this$getName, answer$iv);
                jsName = answer$iv;
                break block7;
            }
            jsName = value$iv;
        }
        return jsName;
    }

    @NotNull
    public final List<JsImportedModule> getImportedModules() {
        return this.importedModules;
    }

    @NotNull
    public final Map<IrDeclaration, JsStatement> getImports() {
        return this.imports;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (IrUtilsKt.isEffectivelyExternal(declaration)) {
            List list;
            char[] cArray;
            IrFile maybeParentFile;
            String jsModule = AnnotationUtilsKt.getJsModule(declaration);
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            IrFile irFile = maybeParentFile = irDeclarationParent instanceof IrFile ? (IrFile)irDeclarationParent : null;
            String fileJsModule = irFile != null ? AnnotationUtilsKt.getJsModule(irFile) : null;
            Object object = maybeParentFile;
            if (object != null && (object = AnnotationUtilsKt.getJsQualifier((IrAnnotationContainer)object)) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{'.'}), (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new JsName((String)it, false));
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List jsQualifier = list;
            return jsModule != null ? this.generateImportForDeclarationWithJsModule(declaration, jsModule) : (fileJsModule != null ? this.generateImportForDeclarationInFileWithJsModule(declaration, fileJsModule, jsQualifier) : this.generateRegularQualifiedImport(declaration, jsQualifier));
        }
        JsName it = jsName = this.getName(declaration);
        boolean bl = false;
        if (Intrinsics.areEqual((Object)declaration, (Object)((IrProperty)this.context.getIntrinsics().getVoid().getOwner()).getBackingField())) {
            MetadataProperties.setConstant(it, true);
        }
        return jsName;
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (!(function2.getDispatchReceiverParameter() != null)) {
            boolean $i$a$-require-JsNameLinkingNamer$getNameForMemberFunction$22 = false;
            String $i$a$-require-JsNameLinkingNamer$getNameForMemberFunction$22 = "Function '" + IrUtilsKt.getFqNameWhenAvailable(function2) + "' has no dispatch receiver";
            throw new IllegalArgumentException($i$a$-require-JsNameLinkingNamer$getNameForMemberFunction$22.toString());
        }
        String signature = NameTablesKt.jsFunctionSignature(function2, this.context);
        if (this.context.getKeeper().shouldKeep(function2)) {
            this.context.getMinimizedNameGenerator().keepName(signature);
        }
        if (this.minimizedMemberNames && !MiscKt.hasStableJsName(function2, this.context)) {
            this.fieldData(IrUtilsKt.getParentAsClass(function2));
            string2 = this.context.getMinimizedNameGenerator().nameBySignature(signature);
        } else {
            string2 = signature;
        }
        String result2 = string2;
        return IrNamerBase.toJsName$default(this, result2, false, 1, null);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (!(!field.isStatic())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = this.fieldData(IrUtilsKt.getParentAsClass(field)).get(field);
        Intrinsics.checkNotNull((Object)string3);
        return new JsName(string3, false);
    }

    private final JsName generateImportForDeclarationWithJsModule(IrDeclarationWithName $this$generateImportForDeclarationWithJsModule, String jsModule) {
        String string2;
        if (AnnotationUtilsKt.isJsNonModule($this$generateImportForDeclarationWithJsModule)) {
            string2 = AnnotationUtilsKt.getJsNameOrKotlinName($this$generateImportForDeclarationWithJsModule).asString();
        } else {
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable($this$generateImportForDeclarationWithJsModule);
            Intrinsics.checkNotNull((Object)fqName);
            FqName parent2 = fqName.parent();
            string2 = parent2.child(AnnotationUtilsKt.getJsNameOrKotlinName($this$generateImportForDeclarationWithJsModule)).asString();
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        String nameString = string3;
        JsName name2 = new JsName(NameTablesKt.sanitizeName$default(nameString, false, 2, null), true);
        JsNameRef jsNameRef = name2.makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
        JsNameRef nameRef = jsNameRef;
        if (this.isEsModules) {
            JsImport.Target importSubject = $this$generateImportForDeclarationWithJsModule instanceof IrClass && IrUtilsKt.isObject((IrClass)$this$generateImportForDeclarationWithJsModule) ? (JsImport.Target)new JsImport.Target.All(nameRef) : (JsImport.Target)new JsImport.Target.Default(nameRef);
            this.imports.put($this$generateImportForDeclarationWithJsModule, new JsImport(jsModule, importSubject));
            this.nameMap.put($this$generateImportForDeclarationWithJsModule, name2);
        } else {
            ((Collection)this.importedModules).add(new JsImportedModule(jsModule, name2, nameRef, null, 8, null));
        }
        return name2;
    }

    private final JsName generateImportForDeclarationInFileWithJsModule(IrDeclarationWithName $this$generateImportForDeclarationInFileWithJsModule, String fileJsModule, List<? extends JsName> jsQualifier) {
        if (this.nameMap.containsKey($this$generateImportForDeclarationInFileWithJsModule)) {
            return this.getName($this$generateImportForDeclarationInFileWithJsModule);
        }
        String string2 = AnnotationUtilsKt.getJsNameOrKotlinName($this$generateImportForDeclarationInFileWithJsModule).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
        String declarationStableName = string2;
        if (this.isEsModules) {
            JsNode jsNode;
            JsNameRef qualifiedReference;
            List<? extends JsName> list = jsQualifier;
            if (list == null || (list = (JsName)CollectionsKt.firstOrNull(list)) == null) {
                list = this.toJsName(declarationStableName, false);
            }
            List<? extends JsName> importedName = list;
            Object object = new JsImport.Element[]{new JsImport.Element((JsName)((Object)importedName), null, 2, null)};
            JsImport importStatement = new JsImport(fileJsModule, (JsImport.Element[])object);
            object = this.imports;
            List<? extends JsName> list2 = jsQualifier;
            JsNameRef jsNameRef = qualifiedReference = list2 != null ? JsNameLinkingNamerKt.access$makeRef(list2) : null;
            if (qualifiedReference == null) {
                jsNode = importStatement;
            } else {
                Object[] objectArray = new JsNode[]{importStatement, JsAstUtilsKt.putIntoVariableWitName(JsAstUtilsKt.jsElementAccess(declarationStableName, (JsExpression)qualifiedReference), IrNamerBase.toJsName$default(this, declarationStableName, false, 1, null))};
                jsNode = new JsCompositeBlock(CollectionsKt.listOf((Object[])objectArray));
            }
            JsNode jsNode2 = jsNode;
            object.put($this$generateImportForDeclarationInFileWithJsModule, jsNode2);
        } else {
            JsName moduleName = new JsName(NameTablesKt.sanitizeName$default("$module$" + fileJsModule, false, 2, null), true);
            ((Collection)this.importedModules).add(new JsImportedModule(fileJsModule, moduleName, null, null, 8, null));
            JsNameRef jsNameRef = jsQualifier == null ? moduleName.makeRef() : JsNameLinkingNamerKt.access$makeRef(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)moduleName), (Iterable)jsQualifier));
            Intrinsics.checkNotNull((Object)jsNameRef);
            JsNameRef qualifiedReference = jsNameRef;
            this.imports.put($this$generateImportForDeclarationInFileWithJsModule, JsAstUtilsKt.putIntoVariableWitName(JsAstUtilsKt.jsElementAccess(declarationStableName, (JsExpression)qualifiedReference), IrNamerBase.toJsName$default(this, declarationStableName, false, 1, null)));
        }
        return this.getName($this$generateImportForDeclarationInFileWithJsModule);
    }

    private final JsName generateRegularQualifiedImport(IrDeclarationWithName $this$generateRegularQualifiedImport, List<? extends JsName> jsQualifier) {
        String string2 = AnnotationUtilsKt.getJsNameOrKotlinName($this$generateRegularQualifiedImport).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
        String name2 = string2;
        if (jsQualifier != null) {
            this.imports.put($this$generateRegularQualifiedImport, JsAstUtilsKt.putIntoVariableWitName(JsAstUtilsKt.jsElementAccess(name2, (JsExpression)JsNameLinkingNamerKt.access$makeRef(jsQualifier)), IrNamerBase.toJsName$default(this, name2, false, 1, null)));
            return this.getName($this$generateRegularQualifiedImport);
        }
        return this.toJsName(name2, false);
    }

    private final Map<IrField, String> fieldData(IrClass $this$fieldData) {
        Object object;
        block17: {
            Object value$iv;
            block12: {
                String signature;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                IrClass it;
                boolean $i$f$forEach2;
                Iterable $this$forEach$iv2;
                HashMap result2;
                List<IrClass> allClasses;
                HashMap nameCnt;
                Map $this$getOrPut$iv;
                block13: {
                    $this$getOrPut$iv = this.context.getFieldDataCache();
                    boolean $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get($this$fieldData);
                    if (value$iv != null) break block12;
                    boolean bl = false;
                    nameCnt = new HashMap();
                    allClasses = DFS.topologicalOrder(CollectionsKt.listOf((Object)$this$fieldData), JsNameLinkingNamer::fieldData$lambda$12$lambda$7);
                    result2 = new HashMap();
                    if (!this.minimizedMemberNames) break block13;
                    Intrinsics.checkNotNull(allClasses);
                    $this$forEach$iv2 = CollectionsKt.reversed((Iterable)allClasses);
                    $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        it = (IrClass)element$iv;
                        boolean bl2 = false;
                        $this$forEach$iv = it.getDeclarations();
                        $i$f$forEach = false;
                        for (Object element$iv2 : $this$forEach$iv) {
                            IrDeclaration declaration;
                            block14: {
                                block16: {
                                    IrProperty property2;
                                    block15: {
                                        declaration = (IrDeclaration)element$iv2;
                                        boolean bl3 = false;
                                        if (!(declaration instanceof IrFunction) || ((IrFunction)declaration).getDispatchReceiverParameter() == null) break block14;
                                        IrDeclaration irDeclaration2 = declaration;
                                        Object object2 = irDeclaration2 instanceof IrSimpleFunction ? (IrSimpleFunction)irDeclaration2 : null;
                                        IrProperty irProperty = property2 = object2 != null && (object2 = ((IrSimpleFunction)object2).getCorrespondingPropertySymbol()) != null ? (IrProperty)object2.getOwner() : null;
                                        if (irProperty != null ? ExportModelGeneratorKt.isExported(irProperty, this.context) : false) break block15;
                                        IrProperty irProperty2 = property2;
                                        boolean bl4 = irProperty2 != null ? IrUtilsKt.isEffectivelyExternal(irProperty2) : false;
                                        if (!bl4) break block16;
                                    }
                                    MinimizedNameGenerator minimizedNameGenerator = this.context.getMinimizedNameGenerator();
                                    String string2 = AnnotationUtilsKt.getJsNameOrKotlinName(property2).getIdentifier();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
                                    minimizedNameGenerator.reserveName(string2);
                                }
                                if (!MiscKt.hasStableJsName((IrFunction)declaration, this.context)) continue;
                                signature = NameTablesKt.jsFunctionSignature((IrFunction)declaration, this.context);
                                this.context.getMinimizedNameGenerator().reserveName(signature);
                                continue;
                            }
                            if (!(declaration instanceof IrProperty) || !ExportModelGeneratorKt.isExported(declaration, this.context)) continue;
                            MinimizedNameGenerator minimizedNameGenerator = this.context.getMinimizedNameGenerator();
                            String string3 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration).getIdentifier();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdentifier(...)");
                            minimizedNameGenerator.reserveName(string3);
                        }
                    }
                }
                Intrinsics.checkNotNull(allClasses);
                $this$forEach$iv2 = CollectionsKt.reversed((Iterable)allClasses);
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (IrClass)element$iv;
                    boolean bl = false;
                    $this$forEach$iv = it.getDeclarations();
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        IrDeclaration it2 = (IrDeclaration)element$iv2;
                        boolean bl5 = false;
                        if (it2 instanceof IrField) {
                            String string4;
                            String string5;
                            IrPropertySymbol irPropertySymbol = ((IrField)it2).getCorrespondingPropertySymbol();
                            IrProperty correspondingProperty = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
                            boolean hasStableName = correspondingProperty != null && correspondingProperty.getVisibility().isPublicAPI() && (ExportModelGeneratorKt.isExported(correspondingProperty, this.context) || AnnotationUtilsKt.getJsName(correspondingProperty) != null) && IrUtilsKt.isSimpleProperty(correspondingProperty);
                            if (hasStableName) {
                                IrProperty irProperty = correspondingProperty;
                                string5 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)(irProperty != null ? (IrElement)irProperty : (IrElement)it2)).getIdentifier();
                            } else {
                                string5 = this.minimizedMemberNames && !this.context.getKeeper().shouldKeep(it2) ? this.context.getMinimizedNameGenerator().generateNextName() : JsNameLinkingNamerKt.access$safeName((IrField)it2);
                            }
                            signature = string5;
                            Intrinsics.checkNotNull((Object)signature);
                            String safeName = signature;
                            if (!hasStableName) {
                                int suffix = ((Number)nameCnt.getOrDefault(safeName, 0)).intValue() + 1;
                                Integer n = suffix;
                                ((Map)nameCnt).put(safeName, n);
                                string4 = safeName + '_' + suffix;
                            } else {
                                string4 = safeName;
                            }
                            String resultName = string4;
                            ((Map)result2).put(it2, resultName);
                            continue;
                        }
                        if (!(it2 instanceof IrFunction) || ((IrFunction)it2).getDispatchReceiverParameter() == null) continue;
                        ((Map)nameCnt).put(NameTablesKt.jsFunctionSignature((IrFunction)it2, this.context), 1);
                    }
                }
                Map answer$iv = result2;
                $this$getOrPut$iv.put($this$fieldData, answer$iv);
                object = answer$iv;
                break block17;
            }
            object = value$iv;
        }
        return (Map)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable fieldData$lambda$12$lambda$7(IrClass node) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = node.getSuperTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrClass it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrType it = (IrType)element$iv$iv;
            boolean bl2 = false;
            IrType $this$safeAs$iv = it;
            boolean $i$f$safeAs = false;
            IrType irType = $this$safeAs$iv;
            if (!(irType instanceof IrSimpleType)) {
                irType = null;
            }
            IrSimpleType irSimpleType = (IrSimpleType)irType;
            IrClassifierSymbol $this$safeAs$iv2 = irSimpleType != null ? irSimpleType.getClassifier() : null;
            boolean $i$f$safeAs2 = false;
            IrClassifierSymbol irClassifierSymbol = $this$safeAs$iv2;
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

