/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.AnnotationsPosition;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponent;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.UnresolvedDeprecationProvider;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirBooleanOperatorExpression;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirIndexedAccessAugmentedAssignment;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirResolvedQualifierBuilder;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProvider;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderImplKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.impl.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformerDispatcher;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirDeclarationsResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirExpressionsResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirPartialBodyResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationEnhancementProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationEnhancementProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationsComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirPlaceholderProjection;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirPlaceholderProjectionBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirStarProjectionBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirTypeProjectionWithVarianceBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirUserTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirQualifierPartImpl;
import org.jetbrains.kotlin.fir.types.impl.FirTypeArgumentListImpl;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.PrivateForInline;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0004\u00a6\u0001\u00a7\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u0016\u0010:\u001a\u00020?2\u0006\u0010<\u001a\u00020=2\u0006\u0010@\u001a\u00020AJ\u0010\u0010B\u001a\u00020?2\u0006\u0010C\u001a\u00020DH\u0002J\u001a\u0010E\u001a\u00020;2\u0006\u0010F\u001a\u00020G2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u000e\u0010H\u001a\u00020 2\u0006\u0010@\u001a\u00020AJ\f\u0010I\u001a\u00020 *\u00020DH\u0002J&\u0010J\u001a\u00020 *\u00020K2\u0006\u0010\u0003\u001a\u00020\u00042\u0010\u0010L\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u001bH\u0002J\u001a\u0010M\u001a\u00020;2\u0006\u0010N\u001a\u00020O2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J0\u0010P\u001a\u00020?2\u0006\u0010N\u001a\u00020O2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020?0R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020?0RH\u0086\b\u00f8\u0001\u0000J\u001a\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020U2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\"\u0010W\u001a\u00020?2\u0006\u0010N\u001a\u00020O2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020?0RH\u0086\b\u00f8\u0001\u0000J\u001a\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020Z2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\\\u001a\u00020\u000b2\u0006\u0010]\u001a\u00020\u000b2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020_2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010a\u001a\u00020?2\u0006\u0010`\u001a\u00020_2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020?0RJ-\u0010b\u001a\u0002Hc\"\u0004\b\u0000\u0010c2\u0006\u0010`\u001a\u00020_2\f\u0010d\u001a\b\u0012\u0004\u0012\u0002Hc0RH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010eJ\u000e\u0010f\u001a\u00020?2\u0006\u0010g\u001a\u00020hJ\u0010\u0010f\u001a\u00020?2\u0006\u0010i\u001a\u00020jH\u0002J-\u0010k\u001a\u00020;\"\f\b\u0000\u0010c*\u00020j*\u00020;2\u0006\u0010i\u001a\u0002Hc2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0002\u0010lJ-\u0010s\u001a\u0002Hc\"\u0004\b\u0000\u0010c2\u0006\u0010`\u001a\u00020_2\f\u0010d\u001a\b\u0012\u0004\u0012\u0002Hc0RH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010eJ\u0010\u0010t\u001a\u00020 2\u0006\u0010]\u001a\u00020\u000bH&J\u001a\u0010u\u001a\u00020;2\u0006\u0010v\u001a\u00020w2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010x\u001a\u00020;2\u0006\u0010y\u001a\u00020z2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010{\u001a\u00020;2\u0006\u0010|\u001a\u00020}2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010~\u001a\u00020?*\u00020}H\u0002J\u001d\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0080\u00012\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\u0010\u0084\u0001\u001a\u00030\u0083\u00012\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u0085\u0001\u001a\u00030\u0083\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\u0088\u0001\u001a\u00020;2\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\u008b\u0001\u001a\u00020;2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\u008e\u0001\u001a\u00020;2\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001d\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0007\u0010@\u001a\u00030\u0092\u00012\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u0093\u0001\u001a\u00030\u0094\u00012\b\u0010\u0095\u0001\u001a\u00030\u0094\u00012\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016J0\u0010\u0096\u0001\u001a\u0003H\u0097\u0001\"\n\b\u0000\u0010\u0097\u0001*\u00030\u0098\u00012\b\u0010\u0099\u0001\u001a\u0003H\u0097\u00012\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0003\u0010\u009a\u0001J\u0016\u0010\u009b\u0001\u001a\b\u0012\u0004\u0012\u00020\u000b0.2\u0007\u0010\u009c\u0001\u001a\u00020\u000bJ\u0018\u0010\u009d\u0001\u001a\u00020?2\u000f\u0010\u009e\u0001\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010.J2\u0010Q\u001a\u0003H\u009f\u0001\"\u0005\b\u0000\u0010\u009f\u00012\u0007\u0010\u009c\u0001\u001a\u00020\u000b2\r\u0010X\u001a\t\u0012\u0005\u0012\u0003H\u009f\u00010RH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a0\u0001J\u0010\u0010\u00a1\u0001\u001a\u00020A2\u0007\u0010\u00a2\u0001\u001a\u00020AJ\u000f\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001*\u00030\u00a4\u0001H\u0002J\u000f\u0010\u00a3\u0001\u001a\u00030\u00a5\u0001*\u00030\u00a5\u0001H\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u00020$8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b%\u0010\u000f\u001a\u0004\b&\u0010'R \u0010(\u001a\u00060)R\u00020\u00008\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u000f\u001a\u0004\b+\u0010,R*\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0.8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b/\u0010\u000f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\"\u00104\u001a\b\u0012\u0004\u0012\u000206058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b7\u0010\u000f\u001a\u0004\b8\u00109R \u0010m\u001a\b\u0012\u0004\u0012\u00020n0\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010p\"\u0004\bq\u0010r\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00a8\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "computationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;Ljava/util/List;)V", "getSession$annotations", "()V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession$annotations", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getComputationSession$annotations", "getComputationSession", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "predicateBasedProvider", "Lorg/jetbrains/kotlin/fir/extensions/FirPredicateBasedProvider;", "annotationsFromPlugins", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "metaAnnotationsFromPlugins", "shouldRecordIntoPredicateBasedProvider", "", "getShouldRecordIntoPredicateBasedProvider", "()Z", "typeResolverTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "getTypeResolverTransformer$annotations", "getTypeResolverTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "argumentsTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformerDispatcher;", "getArgumentsTransformer$annotations", "getArgumentsTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformerDispatcher;", "owners", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "getOwners$annotations", "getOwners", "()Lkotlinx/collections/immutable/PersistentList;", "setOwners", "(Lkotlinx/collections/immutable/PersistentList;)V", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getClassDeclarationsStack$annotations", "getClassDeclarationsStack", "()Lkotlin/collections/ArrayDeque;", "transformAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "data", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "resolveAnnotationsOnAnnotationIfNeeded", "annotationTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "transformAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "shouldRunAnnotationResolve", "requiredToSave", "markedWithMetaAnnotation", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "metaAnnotations", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "resolveRegularClass", "transformChildren", "Lkotlin/Function0;", "afterChildrenTransform", "transformScript", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "script", "withRegularClass", "action", "transformTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "transformDeclaration", "declaration", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "withFileAndFileScopes", "withFile", "T", "f", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "calculateDeprecations", "classLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "callableDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "transformCallableDeclarationForDeprecations", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "scopes", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "getScopes", "()Ljava/util/List;", "setScopes", "(Ljava/util/List;)V", "withFileScopes", "shouldTransformDeclaration", "transformBackingField", "backingField", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "transformPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "transformProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "moveJavaDeprecatedAnnotationToBackingField", "transformSimpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "transformConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "transformErrorPrimaryConstructor", "errorPrimaryConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "transformEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "transformField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "transformValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "transformTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "transformAnnotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "annotationContainer", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/FirElement;", "beforeTransformingChildren", "parentDeclaration", "afterTransformingChildren", "state", "R", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createDeepCopyOfTypeRef", "original", "createDeepCopy", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "FirEnumAnnotationArgumentsTransformerDispatcher", "FirEnumAnnotationArgumentsTransformer", "resolve"})
@SourceDebugExtension(value={"SMAP\nAbstractFirSpecificAnnotationResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFirSpecificAnnotationResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TransformUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/TransformUtilsKt\n+ 4 FirSpecificTypeResolverTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer\n+ 5 BodyResolveContext.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveContext\n+ 6 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 FirUserTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirUserTypeRefBuilderKt\n+ 9 FirTypeProjectionWithVarianceBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirTypeProjectionWithVarianceBuilderKt\n+ 10 FirStarProjectionBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirStarProjectionBuilderKt\n+ 11 FirPlaceholderProjectionBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirPlaceholderProjectionBuilderKt\n*L\n1#1,667:1\n393#1:671\n426#1:672\n427#1:676\n394#1:677\n395#1,6:679\n625#1,3:685\n401#1,2:688\n629#1:690\n403#1,2:691\n428#1:693\n429#1:695\n405#1:696\n426#1:697\n427#1:701\n625#1,5:703\n428#1:708\n429#1:710\n625#1,5:711\n468#1:722\n469#1:727\n470#1:749\n471#1:752\n503#1,2:753\n625#1,5:755\n625#1,5:810\n625#1,5:815\n625#1,5:820\n1755#2,3:668\n1557#2:741\n1628#2,3:742\n1557#2:788\n1628#2,3:789\n1628#2,3:826\n1628#2,3:829\n88#3,3:673\n92#3:678\n93#3:694\n88#3,3:698\n92#3:702\n93#3:709\n88#3,6:716\n71#3,3:731\n75#3,4:764\n79#3:769\n71#3,3:778\n75#3,4:802\n79#3:807\n78#4,4:723\n83#4:770\n78#4,4:771\n83#4,2:808\n440#5,3:728\n443#5:734\n186#5,3:735\n444#5,3:738\n447#5:745\n154#5,3:746\n158#5:762\n190#5:763\n440#5,3:775\n443#5:781\n186#5,3:782\n444#5,3:785\n447#5:792\n154#5,3:793\n158#5:800\n190#5:801\n226#6,2:750\n228#6,2:760\n226#6,4:796\n1#7:768\n1#7:806\n31#8:825\n42#9:832\n36#10:833\n36#11:834\n*S KotlinDebug\n*F\n+ 1 AbstractFirSpecificAnnotationResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer\n*L\n375#1:671\n375#1:672\n375#1:676\n375#1:677\n375#1:679,6\n375#1:685,3\n375#1:688,2\n375#1:690\n375#1:691,2\n375#1:693\n375#1:695\n375#1:696\n393#1:697\n393#1:701\n400#1:703,5\n393#1:708\n393#1:710\n414#1:711,5\n458#1:722\n458#1:727\n458#1:749\n458#1:752\n459#1:753,2\n460#1:755,5\n523#1:810,5\n546#1:815,5\n561#1:820,5\n353#1:668,3\n458#1:741\n458#1:742,3\n469#1:788\n469#1:789,3\n637#1:826,3\n642#1:829,3\n375#1:673,3\n375#1:678\n375#1:694\n393#1:698,3\n393#1:702\n393#1:709\n426#1:716,6\n458#1:731,3\n458#1:764,4\n458#1:769\n469#1:778,3\n469#1:802,4\n469#1:807\n458#1:723,4\n458#1:770\n468#1:771,4\n468#1:808,2\n458#1:728,3\n458#1:734\n458#1:735,3\n458#1:738,3\n458#1:745\n458#1:746,3\n458#1:762\n458#1:763\n469#1:775,3\n469#1:781\n469#1:782,3\n469#1:785,3\n469#1:792\n469#1:793,3\n469#1:800\n469#1:801\n458#1:750,2\n458#1:760,2\n470#1:796,4\n458#1:768\n469#1:806\n633#1:825\n654#1:832\n662#1:833\n663#1:834\n*E\n"})
public abstract class AbstractFirSpecificAnnotationResolveTransformer
extends FirDefaultTransformer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final CompilerRequiredAnnotationsComputationSession computationSession;
    @NotNull
    private final FirPredicateBasedProvider predicateBasedProvider;
    @NotNull
    private final Set<FqName> annotationsFromPlugins;
    @NotNull
    private final Set<FqName> metaAnnotationsFromPlugins;
    @NotNull
    private final FirSpecificTypeResolverTransformer typeResolverTransformer;
    @NotNull
    private final FirEnumAnnotationArgumentsTransformerDispatcher argumentsTransformer;
    @NotNull
    private PersistentList<? extends FirDeclaration> owners;
    @NotNull
    private final ArrayDeque<FirClass> classDeclarationsStack;
    public List<? extends FirScope> scopes;

    /*
     * WARNING - void declaration
     */
    public AbstractFirSpecificAnnotationResolveTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull CompilerRequiredAnnotationsComputationSession computationSession, @NotNull List<? extends FirDeclaration> containingDeclarations) {
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)computationSession, (String)"computationSession");
        Intrinsics.checkNotNullParameter(containingDeclarations, (String)"containingDeclarations");
        this.session = session2;
        this.scopeSession = scopeSession;
        this.computationSession = computationSession;
        this.predicateBasedProvider = FirPredicateBasedProviderKt.getPredicateBasedProvider(this.session);
        this.annotationsFromPlugins = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session).getAnnotations();
        this.metaAnnotationsFromPlugins = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(this.session).getMetaAnnotations();
        this.typeResolverTransformer = new FirSpecificTypeResolverTransformer(this.session, false, false, null, false, 8, null);
        this.argumentsTransformer = new FirEnumAnnotationArgumentsTransformerDispatcher();
        this.owners = ExtensionsKt.persistentListOf();
        ArrayDeque arrayDeque2 = arrayDeque = new ArrayDeque();
        AbstractFirSpecificAnnotationResolveTransformer abstractFirSpecificAnnotationResolveTransformer = this;
        boolean bl = false;
        for (FirDeclaration firDeclaration : containingDeclarations) {
            void $this$classDeclarationsStack_u24lambda_u240;
            if (!(firDeclaration instanceof FirClass)) continue;
            $this$classDeclarationsStack_u24lambda_u240.add((Object)firDeclaration);
        }
        abstractFirSpecificAnnotationResolveTransformer.classDeclarationsStack = arrayDeque;
    }

    public /* synthetic */ AbstractFirSpecificAnnotationResolveTransformer(FirSession firSession, ScopeSession scopeSession, CompilerRequiredAnnotationsComputationSession compilerRequiredAnnotationsComputationSession, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(firSession, scopeSession, compilerRequiredAnnotationsComputationSession, list);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @PrivateForInline
    public static /* synthetic */ void getSession$annotations() {
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @PrivateForInline
    public static /* synthetic */ void getScopeSession$annotations() {
    }

    @NotNull
    public final CompilerRequiredAnnotationsComputationSession getComputationSession() {
        return this.computationSession;
    }

    @PrivateForInline
    public static /* synthetic */ void getComputationSession$annotations() {
    }

    protected boolean getShouldRecordIntoPredicateBasedProvider() {
        return true;
    }

    @NotNull
    public final FirSpecificTypeResolverTransformer getTypeResolverTransformer() {
        return this.typeResolverTransformer;
    }

    @PrivateForInline
    public static /* synthetic */ void getTypeResolverTransformer$annotations() {
    }

    @NotNull
    public final FirEnumAnnotationArgumentsTransformerDispatcher getArgumentsTransformer() {
        return this.argumentsTransformer;
    }

    @PrivateForInline
    public static /* synthetic */ void getArgumentsTransformer$annotations() {
    }

    @NotNull
    public final PersistentList<FirDeclaration> getOwners() {
        return this.owners;
    }

    public final void setOwners(@NotNull PersistentList<? extends FirDeclaration> persistentList) {
        Intrinsics.checkNotNullParameter(persistentList, (String)"<set-?>");
        this.owners = persistentList;
    }

    @PrivateForInline
    public static /* synthetic */ void getOwners$annotations() {
    }

    @NotNull
    public final ArrayDeque<FirClass> getClassDeclarationsStack() {
        return this.classDeclarationsStack;
    }

    @PrivateForInline
    public static /* synthetic */ void getClassDeclarationsStack$annotations() {
    }

    @Override
    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        FirTypeRef annotationTypeRef = annotationCall.getAnnotationTypeRef();
        if (!(annotationTypeRef instanceof FirUserTypeRef)) {
            return annotationCall;
        }
        if (!this.shouldRunAnnotationResolve((FirUserTypeRef)annotationTypeRef)) {
            return annotationCall;
        }
        this.transformAnnotationCall(annotationCall, (FirUserTypeRef)annotationTypeRef);
        return annotationCall;
    }

    public final void transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirUserTypeRef typeRef) {
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        FirTypeRef firTypeRef = this.typeResolverTransformer.transformUserTypeRef(this.createDeepCopyOfTypeRef(typeRef), new ScopeClassDeclaration(CollectionsKt.asReversed(this.getScopes()), (List)this.classDeclarationsStack, null, null, 12, null));
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        if (firResolvedTypeRef == null) {
            return;
        }
        FirResolvedTypeRef transformedAnnotationType = firResolvedTypeRef;
        this.resolveAnnotationsOnAnnotationIfNeeded(transformedAnnotationType);
        if (!this.requiredToSave(transformedAnnotationType)) {
            return;
        }
        annotationCall.replaceAnnotationTypeRef(transformedAnnotationType);
        annotationCall.replaceAnnotationResolvePhase(FirAnnotationResolvePhase.CompilerRequiredAnnotations);
        Set<ClassId> requiredAnnotationsWithArguments = FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(this.session).getRequiredAnnotationsWithArguments();
        ConeClassLikeLookupTag coneClassLikeLookupTag = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(transformedAnnotationType.getConeType());
        if (CollectionsKt.contains((Iterable)requiredAnnotationsWithArguments, (Object)(coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null))) {
            this.argumentsTransformer.transformAnnotation((FirAnnotation)annotationCall, ResolutionMode.ContextDependent.INSTANCE);
        }
    }

    private final void resolveAnnotationsOnAnnotationIfNeeded(FirResolvedTypeRef annotationTypeRef) {
        Object object = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(annotationTypeRef.getConeType());
        if (object == null || (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, this.session)) == null) {
            return;
        }
        Object symbol = object;
        this.computationSession.resolveAnnotationsOnAnnotationIfNeeded((FirRegularClassSymbol)symbol, this.scopeSession);
    }

    @Override
    @NotNull
    public FirStatement transformAnnotation(@NotNull FirAnnotation annotation, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        throw new IllegalStateException("Should not be there".toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldRunAnnotationResolve(@NotNull FirUserTypeRef typeRef) {
        FqName it;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Name name2 = ResolveUtilsKt.getShortName(typeRef);
        if (!((Collection)this.metaAnnotationsFromPlugins).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) {
            return true;
        }
        if (FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(this.session).getRequiredAnnotationsShortClassNames().contains(name2)) return true;
        Iterable $this$any$iv = this.annotationsFromPlugins;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (FqName)element$iv;
            boolean bl2 = false;
        } while (!Intrinsics.areEqual((Object)it.shortName(), (Object)name2));
        return true;
    }

    private final boolean requiredToSave(FirResolvedTypeRef $this$requiredToSave) {
        ClassId classId = ConeTypeUtilsKt.getClassId($this$requiredToSave.getConeType());
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        return FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(this.session).getRequiredAnnotations().contains(classId2) ? true : (this.annotationsFromPlugins.contains(classId2.asSingleFqName()) ? true : (this.metaAnnotationsFromPlugins.isEmpty() ? false : this.markedWithMetaAnnotation($this$requiredToSave.getConeType(), this.session, this.metaAnnotationsFromPlugins)));
    }

    private final boolean markedWithMetaAnnotation(ConeKotlinType $this$markedWithMetaAnnotation, FirSession session2, Set<FqName> metaAnnotations) {
        return FirPredicateBasedProviderImplKt.markedWithMetaAnnotationImpl(ToSymbolUtilsKt.toRegularClassSymbol($this$markedWithMetaAnnotation, session2), session2, metaAnnotations, true, new LinkedHashSet(), (Function1<? super FirRegularClassSymbol, ? extends List<? extends FirAnnotation>>)((Function1)arg_0 -> AbstractFirSpecificAnnotationResolveTransformer.markedWithMetaAnnotation$lambda$2(this, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
            boolean $i$f$resolveRegularClass = false;
            AbstractFirSpecificAnnotationResolveTransformer this_$iv$iv = this_$iv;
            boolean $i$f$withRegularClass = false;
            ArrayDeque<FirClass> classDeclarations$iv$iv$iv = this_$iv$iv.getClassDeclarationsStack();
            boolean $i$f$withClassDeclarationCleanup = false;
            classDeclarations$iv$iv$iv.addLast((Object)regularClass);
            try {
                boolean bl = false;
                boolean bl2 = false;
                if (!this_$iv.shouldTransformDeclaration(regularClass)) break block8;
                if (!this_$iv.getComputationSession().annotationResolutionWasAlreadyStarted(regularClass)) {
                    this_$iv.getComputationSession().recordThatAnnotationResolutionStarted(regularClass);
                    this_$iv.transformDeclaration((FirDeclaration)regularClass, null);
                    this_$iv.getComputationSession().recordThatAnnotationsAreResolved(regularClass);
                }
                AbstractFirSpecificAnnotationResolveTransformer this_$iv$iv2 = this_$iv;
                boolean $i$f$transformChildren = false;
                PersistentList<FirDeclaration> state$iv$iv = this_$iv$iv2.beforeTransformingChildren(regularClass);
                try {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    regularClass.transformDeclarations(this, data);
                    regularClass.transformContextParameters(this, data);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv$iv2.afterTransformingChildren(state$iv$iv);
                }
                boolean bl5 = false;
                this.calculateDeprecations(regularClass);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                classDeclarations$iv$iv$iv.removeLast();
            }
        }
        return regularClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resolveRegularClass(@NotNull FirRegularClass regularClass, @NotNull Function0<Unit> transformChildren, @NotNull Function0<Unit> afterChildrenTransform) {
        ArrayDeque<FirClass> classDeclarations$iv$iv;
        block8: {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter(transformChildren, (String)"transformChildren");
            Intrinsics.checkNotNullParameter(afterChildrenTransform, (String)"afterChildrenTransform");
            boolean $i$f$resolveRegularClass = false;
            AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
            boolean $i$f$withRegularClass = false;
            classDeclarations$iv$iv = this_$iv.getClassDeclarationsStack();
            boolean $i$f$withClassDeclarationCleanup = false;
            classDeclarations$iv$iv.addLast((Object)regularClass);
            boolean bl = false;
            boolean bl2 = false;
            if (this.shouldTransformDeclaration(regularClass)) break block8;
            InlineMarker.finallyStart((int)2);
            classDeclarations$iv$iv.removeLast();
            InlineMarker.finallyEnd((int)2);
            return;
        }
        try {
            if (!this.getComputationSession().annotationResolutionWasAlreadyStarted(regularClass)) {
                this.getComputationSession().recordThatAnnotationResolutionStarted(regularClass);
                this.transformDeclaration((FirDeclaration)regularClass, null);
                this.getComputationSession().recordThatAnnotationsAreResolved(regularClass);
            }
            AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
            boolean $i$f$transformChildren = false;
            PersistentList<FirDeclaration> state$iv = this_$iv.beforeTransformingChildren(regularClass);
            try {
                boolean bl = false;
                transformChildren.invoke();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this_$iv.afterTransformingChildren(state$iv);
                InlineMarker.finallyEnd((int)1);
            }
            afterChildrenTransform.invoke();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            classDeclarations$iv$iv.removeLast();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirScript transformScript(@NotNull FirScript script, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (this.shouldTransformDeclaration(script)) {
            FirDeclaration firDeclaration;
            this.computationSession.recordThatAnnotationsAreResolved(script);
            FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)script, null);
            boolean bl = false;
            AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
            boolean $i$f$transformChildren = false;
            PersistentList<FirDeclaration> state$iv = this_$iv.beforeTransformingChildren(script);
            try {
                boolean bl2 = false;
                script.transformDeclarations(this, data);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.afterTransformingChildren(state$iv);
            }
        }
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withRegularClass(@NotNull FirRegularClass regularClass, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withRegularClass = false;
        ArrayDeque<FirClass> classDeclarations$iv = this.getClassDeclarationsStack();
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast((Object)regularClass);
        try {
            boolean bl = false;
            action.invoke();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            classDeclarations$iv.removeLast();
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public FirTypeAlias transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Void data) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        if (!this.shouldTransformDeclaration(typeAlias)) {
            return typeAlias;
        }
        this.computationSession.recordThatAnnotationsAreResolved(typeAlias);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)typeAlias, data);
        boolean bl = false;
        this.calculateDeprecations(typeAlias);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
        return (FirTypeAlias)firDeclaration2;
    }

    @Override
    @NotNull
    public FirDeclaration transformDeclaration(@NotNull FirDeclaration declaration, @Nullable Void data) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirAnnotationContainer firAnnotationContainer = this.transformAnnotationContainer((FirAnnotationContainer)declaration, data);
        Intrinsics.checkNotNull((Object)firAnnotationContainer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirDeclaration");
        FirDeclaration it = firDeclaration = (FirDeclaration)firAnnotationContainer;
        boolean bl = false;
        if (this.getShouldRecordIntoPredicateBasedProvider()) {
            this.predicateBasedProvider.registerAnnotatedDeclaration(declaration, this.owners);
        }
        return firDeclaration;
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.shouldTransformDeclaration(file2)) {
            return file2;
        }
        this.withFileAndFileScopes(file2, (Function0<Unit>)((Function0)() -> AbstractFirSpecificAnnotationResolveTransformer.transformFile$lambda$12(file2, this, data)));
        return file2;
    }

    /*
     * Exception decompiling
     */
    public final void withFileAndFileScopes(@NotNull FirFile file, @NotNull Function0<Unit> action) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final <T> T withFile(@NotNull FirFile file, @NotNull Function0<? extends T> f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void calculateDeprecations(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter((Object)classLikeDeclaration, (String)"classLikeDeclaration");
        if (Intrinsics.areEqual((Object)classLikeDeclaration.getDeprecationsProvider(), (Object)UnresolvedDeprecationProvider.INSTANCE)) {
            classLikeDeclaration.replaceDeprecationsProvider(DeprecationUtilsKt.getDeprecationsProvider(classLikeDeclaration, this.session));
        }
    }

    private final void calculateDeprecations(FirCallableDeclaration callableDeclaration) {
        if (Intrinsics.areEqual((Object)callableDeclaration.getDeprecationsProvider(), (Object)UnresolvedDeprecationProvider.INSTANCE)) {
            callableDeclaration.replaceDeprecationsProvider(DeprecationUtilsKt.getDeprecationsProvider(callableDeclaration, this.session));
        }
    }

    private final <T extends FirCallableDeclaration> FirStatement transformCallableDeclarationForDeprecations(T callableDeclaration, Void data) {
        FirDeclaration firDeclaration;
        if (!this.shouldTransformDeclaration(callableDeclaration)) {
            return (FirStatement)((Object)callableDeclaration);
        }
        this.computationSession.recordThatAnnotationsAreResolved(callableDeclaration);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)callableDeclaration, data);
        boolean bl = false;
        this.calculateDeprecations(callableDeclaration);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        return (FirStatement)((Object)firDeclaration2);
    }

    @NotNull
    public final List<FirScope> getScopes() {
        List<FirScope> list = this.scopes;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scopes");
        return null;
    }

    public final void setScopes(@NotNull List<? extends FirScope> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.scopes = list;
    }

    public final <T> T withFileScopes(@NotNull FirFile file2, @NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$withFileScopes = false;
        this.setScopes(ImportingScopesKt.createImportingScopes(file2, this.getSession(), this.getScopeSession(), this.getComputationSession().getUseCacheForImportScope()));
        return (T)f.invoke();
    }

    public abstract boolean shouldTransformDeclaration(@NotNull FirDeclaration var1);

    @Override
    @NotNull
    public FirStatement transformBackingField(@NotNull FirBackingField backingField, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)backingField, (String)"backingField");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)backingField, data);
    }

    @Override
    @NotNull
    public FirStatement transformPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)propertyAccessor, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirStatement transformProperty(@NotNull FirProperty property2, @Nullable Void data) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        if (!this.shouldTransformDeclaration(property2)) {
            return property2;
        }
        this.computationSession.recordThatAnnotationsAreResolved(property2);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)property2, data);
        boolean bl = false;
        this.moveJavaDeprecatedAnnotationToBackingField(property2);
        AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
        boolean $i$f$transformChildren = false;
        PersistentList<FirDeclaration> state$iv = this_$iv.beforeTransformingChildren(property2);
        try {
            boolean bl2 = false;
            property2.transformSetter(this, data);
            property2.transformGetter(this, data);
            FirProperty firProperty = property2.transformBackingField(this, data);
        }
        finally {
            this_$iv.afterTransformingChildren(state$iv);
        }
        this.calculateDeprecations(property2);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        return (FirStatement)((Object)firDeclaration2);
    }

    private final void moveJavaDeprecatedAnnotationToBackingField(FirProperty $this$moveJavaDeprecatedAnnotationToBackingField) {
        block1: {
            AnnotationsPosition annotationsPosition = FirAnnotationsPlatformSpecificSupportComponent.extractBackingFieldAnnotationsFromProperty$default(FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(this.session), $this$moveJavaDeprecatedAnnotationToBackingField, this.session, null, null, 12, null);
            if (annotationsPosition == null) {
                return;
            }
            AnnotationsPosition newPosition = annotationsPosition;
            $this$moveJavaDeprecatedAnnotationToBackingField.replaceAnnotations(newPosition.getPropertyAnnotations());
            FirBackingField firBackingField = $this$moveJavaDeprecatedAnnotationToBackingField.getBackingField();
            if (firBackingField == null) break block1;
            firBackingField.replaceAnnotations(newPosition.getBackingFieldAnnotations());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FirSimpleFunction transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Void data) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        if (!this.shouldTransformDeclaration(simpleFunction)) {
            return simpleFunction;
        }
        this.computationSession.recordThatAnnotationsAreResolved(simpleFunction);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)simpleFunction, data);
        boolean bl = false;
        AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
        boolean $i$f$transformChildren = false;
        PersistentList<FirDeclaration> state$iv = this_$iv.beforeTransformingChildren(simpleFunction);
        try {
            boolean bl2 = false;
            FirSimpleFunction firSimpleFunction = simpleFunction.transformValueParameters(this, data);
        }
        finally {
            this_$iv.afterTransformingChildren(state$iv);
        }
        this.calculateDeprecations(simpleFunction);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirSimpleFunction");
        return (FirSimpleFunction)firDeclaration2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FirConstructor transformConstructor(@NotNull FirConstructor constructor, @Nullable Void data) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        if (!this.shouldTransformDeclaration(constructor)) {
            return constructor;
        }
        this.computationSession.recordThatAnnotationsAreResolved(constructor);
        FirDeclaration it = firDeclaration = this.transformDeclaration((FirDeclaration)constructor, data);
        boolean bl = false;
        AbstractFirSpecificAnnotationResolveTransformer this_$iv = this;
        boolean $i$f$transformChildren = false;
        PersistentList<FirDeclaration> state$iv = this_$iv.beforeTransformingChildren(constructor);
        try {
            boolean bl2 = false;
            FirConstructor firConstructor = constructor.transformValueParameters(this, data);
        }
        finally {
            this_$iv.afterTransformingChildren(state$iv);
        }
        this.calculateDeprecations(constructor);
        FirDeclaration firDeclaration2 = firDeclaration;
        Intrinsics.checkNotNull((Object)firDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirConstructor");
        return (FirConstructor)firDeclaration2;
    }

    @NotNull
    public FirConstructor transformErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)errorPrimaryConstructor, (String)"errorPrimaryConstructor");
        return this.transformConstructor((FirConstructor)errorPrimaryConstructor, data);
    }

    @Override
    @NotNull
    public FirStatement transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)enumEntry, data);
    }

    @Override
    @NotNull
    public FirStatement transformField(@NotNull FirField field, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)field, data);
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
        return this.transformCallableDeclarationForDeprecations((FirCallableDeclaration)valueParameter2, data);
    }

    @Override
    @NotNull
    public FirTypeRef transformTypeRef(@NotNull FirTypeRef typeRef, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        FirAnnotationContainer firAnnotationContainer = this.transformAnnotationContainer((FirAnnotationContainer)typeRef, data);
        Intrinsics.checkNotNull((Object)firAnnotationContainer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirTypeRef");
        return (FirTypeRef)firAnnotationContainer;
    }

    @Override
    @NotNull
    public FirAnnotationContainer transformAnnotationContainer(@NotNull FirAnnotationContainer annotationContainer, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)annotationContainer, (String)"annotationContainer");
        return annotationContainer.transformAnnotations(this, data);
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    @NotNull
    public final PersistentList<FirDeclaration> beforeTransformingChildren(@NotNull FirDeclaration parentDeclaration) {
        Intrinsics.checkNotNullParameter((Object)parentDeclaration, (String)"parentDeclaration");
        PersistentList<FirDeclaration> current = this.owners;
        this.owners = this.owners.add(parentDeclaration);
        return current;
    }

    public final void afterTransformingChildren(@Nullable PersistentList<? extends FirDeclaration> state) {
        if (state == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.owners = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R transformChildren(@NotNull FirDeclaration parentDeclaration, @NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter((Object)parentDeclaration, (String)"parentDeclaration");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$transformChildren = false;
        PersistentList<FirDeclaration> state = this.beforeTransformingChildren(parentDeclaration);
        try {
            Object object = action.invoke();
            return (R)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.afterTransformingChildren(state);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirUserTypeRef createDeepCopyOfTypeRef(@NotNull FirUserTypeRef original) {
        void $this$mapTo$iv;
        FirUserTypeRefBuilder firUserTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        boolean $i$f$buildUserTypeRef = false;
        FirUserTypeRefBuilder $this$createDeepCopyOfTypeRef_u24lambda_u2427 = firUserTypeRefBuilder = new FirUserTypeRefBuilder();
        boolean bl = false;
        $this$createDeepCopyOfTypeRef_u24lambda_u2427.setSource(original.getSource());
        $this$createDeepCopyOfTypeRef_u24lambda_u2427.setMarkedNullable(original.isMarkedNullable());
        $this$createDeepCopyOfTypeRef_u24lambda_u2427.getAnnotations().addAll((Collection<FirAnnotation>)original.getAnnotations());
        Iterable iterable = original.getQualifier();
        Collection destination$iv = $this$createDeepCopyOfTypeRef_u24lambda_u2427.getQualifier();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirQualifierPart firQualifierPart = (FirQualifierPart)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(this.createDeepCopy((FirQualifierPart)it));
        }
        return firUserTypeRefBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifierPart createDeepCopy(FirQualifierPart $this$createDeepCopy) {
        void $this$mapTo$iv;
        FirTypeArgumentListImpl firTypeArgumentListImpl;
        FirTypeArgumentListImpl $this$createDeepCopy_u24lambda_u2429 = firTypeArgumentListImpl = new FirTypeArgumentListImpl($this$createDeepCopy.getTypeArgumentList().getSource());
        boolean bl = false;
        Iterable iterable = $this$createDeepCopy.getTypeArgumentList().getTypeArguments();
        Collection destination$iv = $this$createDeepCopy_u24lambda_u2429.getTypeArguments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirTypeProjection firTypeProjection = (FirTypeProjection)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(this.createDeepCopy((FirTypeProjection)it));
        }
        FirTypeArgumentListImpl newArgumentList = firTypeArgumentListImpl;
        return new FirQualifierPartImpl($this$createDeepCopy.getSource(), $this$createDeepCopy.getName(), newArgumentList);
    }

    private final FirTypeProjection createDeepCopy(FirTypeProjection $this$createDeepCopy) {
        FirTypeProjection firTypeProjection;
        FirTypeProjection original = $this$createDeepCopy;
        if (original instanceof FirTypeProjectionWithVariance) {
            FirTypeProjectionWithVarianceBuilder firTypeProjectionWithVarianceBuilder;
            boolean $i$f$buildTypeProjectionWithVariance = false;
            FirTypeProjectionWithVarianceBuilder $this$createDeepCopy_u24lambda_u2430 = firTypeProjectionWithVarianceBuilder = new FirTypeProjectionWithVarianceBuilder();
            boolean bl = false;
            $this$createDeepCopy_u24lambda_u2430.setSource(((FirTypeProjectionWithVariance)original).getSource());
            FirTypeRef originalTypeRef = ((FirTypeProjectionWithVariance)original).getTypeRef();
            $this$createDeepCopy_u24lambda_u2430.setTypeRef(originalTypeRef instanceof FirUserTypeRef ? (FirTypeRef)this.createDeepCopyOfTypeRef((FirUserTypeRef)originalTypeRef) : originalTypeRef);
            $this$createDeepCopy_u24lambda_u2430.setVariance(((FirTypeProjectionWithVariance)original).getVariance());
            firTypeProjection = firTypeProjectionWithVarianceBuilder.build();
        } else if (original instanceof FirStarProjection) {
            FirStarProjectionBuilder firStarProjectionBuilder;
            boolean $i$f$buildStarProjection = false;
            FirStarProjectionBuilder $this$createDeepCopy_u24lambda_u2431 = firStarProjectionBuilder = new FirStarProjectionBuilder();
            boolean bl = false;
            $this$createDeepCopy_u24lambda_u2431.setSource(((FirStarProjection)original).getSource());
            firTypeProjection = firStarProjectionBuilder.build();
        } else if (original instanceof FirPlaceholderProjection) {
            FirPlaceholderProjectionBuilder firPlaceholderProjectionBuilder;
            boolean $i$f$buildPlaceholderProjection = false;
            FirPlaceholderProjectionBuilder $this$createDeepCopy_u24lambda_u2432 = firPlaceholderProjectionBuilder = new FirPlaceholderProjectionBuilder();
            boolean bl = false;
            $this$createDeepCopy_u24lambda_u2432.setSource(((FirPlaceholderProjection)original).getSource());
            firTypeProjection = firPlaceholderProjectionBuilder.build();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firTypeProjection;
    }

    private static final List markedWithMetaAnnotation$lambda$2(AbstractFirSpecificAnnotationResolveTransformer this$0, FirRegularClassSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.computationSession.resolveAnnotationsOnAnnotationIfNeeded(it, this$0.scopeSession);
        return it.getAnnotations();
    }

    private static final Unit transformFile$lambda$12(FirFile $file, AbstractFirSpecificAnnotationResolveTransformer this$0, Void $data) {
        $file.transformDeclarations(this$0, $data);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u0002022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u0002052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u0002082\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020AH\u0014J\u0018\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020D2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\u00172\u0006\u0010G\u001a\u00020\u00162\u0006\u0010H\u001a\u00020\u00162\u0006\u0010I\u001a\u00020J2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\f\u0010K\u001a\u00020L*\u00020\u0017H\u0002J\u001c\u0010M\u001a\u00020L*\u00020\u00172\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QH\u0002\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirExpressionsResolveTransformer;", "transformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;)V", "transformAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;", "transformAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "transformErrorAnnotationCall", "errorAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorAnnotationCall;", "transformExpression", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isAcceptableResolvedQualifiedAccess", "", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformThisReceiverExpression", "thisReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirThisReceiverExpression;", "transformComparisonExpression", "comparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "transformTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "transformCheckNotNullCall", "checkNotNullCall", "Lorg/jetbrains/kotlin/fir/expressions/FirCheckNotNullCall;", "transformBooleanOperatorExpression", "booleanOperatorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBooleanOperatorExpression;", "transformVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "transformCallableReferenceAccess", "callableReferenceAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "transformDelegatedConstructorCall", "delegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "transformIndexedAccessAugmentedAssignment", "indexedAccessAugmentedAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirIndexedAccessAugmentedAssignment;", "transformArrayLiteral", "arrayLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "transformAnonymousObjectExpression", "anonymousObjectExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirAnonymousObjectExpression;", "transformAnonymousFunctionExpression", "anonymousFunctionExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirAnonymousFunctionExpression;", "shouldComputeTypeOfGetClassCallWithNotQualifierInLhs", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "transformFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "resolveQualifiedAccessAndSelectCandidate", "qualifiedAccessExpression", "isUsedAsReceiver", "isUsedAsGetClassReceiver", "callSite", "Lorg/jetbrains/kotlin/fir/FirElement;", "resolveFromImportScope", "", "updateCallee", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/impl/FirSimpleNamedReference;", "calleeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirEnumEntrySymbol;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nAbstractFirSpecificAnnotationResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFirSpecificAnnotationResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformer\n+ 2 FirAbstractBodyResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirResolvedQualifierBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirResolvedQualifierBuilderKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirPartialBodyResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirPartialBodyResolveTransformer\n+ 7 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n*L\n1#1,667:1\n89#2:668\n89#2:669\n1#3:670\n81#4:671\n295#5,2:672\n18#6:674\n42#7:675\n*S KotlinDebug\n*F\n+ 1 AbstractFirSpecificAnnotationResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformer\n*L\n73#1:668\n75#1:669\n226#1:671\n236#1:672,2\n265#1:674\n268#1:675\n*E\n"})
    private final class FirEnumAnnotationArgumentsTransformer
    extends FirExpressionsResolveTransformer {
        public FirEnumAnnotationArgumentsTransformer(FirAbstractBodyResolveTransformerDispatcher transformer2) {
            Intrinsics.checkNotNullParameter((Object)transformer2, (String)"transformer");
            super(transformer2);
        }

        @Override
        @NotNull
        public FirStatement transformAnnotation(@NotNull FirAnnotation annotation, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirAbstractBodyResolveTransformer this_$iv = this;
            boolean $i$f$getDataFlowAnalyzer = false;
            this_$iv.getComponents().getDataFlowAnalyzer().enterAnnotation();
            annotation.transformChildren(this.getTransformer(), ResolutionMode.ContextDependent.INSTANCE);
            this_$iv = this;
            $i$f$getDataFlowAnalyzer = false;
            this_$iv.getComponents().getDataFlowAnalyzer().exitAnnotation();
            return annotation;
        }

        @Override
        @NotNull
        public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.transformAnnotation((FirAnnotation)annotationCall, data);
        }

        @Override
        @NotNull
        public FirStatement transformErrorAnnotationCall(@NotNull FirErrorAnnotationCall errorAnnotationCall, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)errorAnnotationCall, (String)"errorAnnotationCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.transformAnnotation((FirAnnotation)errorAnnotationCall, data);
        }

        @Override
        @NotNull
        public FirStatement transformExpression(@NotNull FirExpression expression2, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirElement firElement = expression2.transformChildren(this.getTransformer(), data);
            Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)firElement;
        }

        @Override
        protected boolean isAcceptableResolvedQualifiedAccess(@NotNull FirQualifiedAccessExpression $this$isAcceptableResolvedQualifiedAccess) {
            Intrinsics.checkNotNullParameter((Object)$this$isAcceptableResolvedQualifiedAccess, (String)"<this>");
            return !($this$isAcceptableResolvedQualifiedAccess.getCalleeReference() instanceof FirErrorNamedReference);
        }

        @Override
        @NotNull
        public FirStatement transformBlock(@NotNull FirBlock block, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return block;
        }

        @Override
        @NotNull
        public FirStatement transformThisReceiverExpression(@NotNull FirThisReceiverExpression thisReceiverExpression, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)thisReceiverExpression, (String)"thisReceiverExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return thisReceiverExpression;
        }

        @Override
        @NotNull
        public FirStatement transformComparisonExpression(@NotNull FirComparisonExpression comparisonExpression, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)comparisonExpression, (String)"comparisonExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return comparisonExpression;
        }

        @Override
        @NotNull
        public FirStatement transformTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return typeOperatorCall;
        }

        @Override
        @NotNull
        public FirStatement transformCheckNotNullCall(@NotNull FirCheckNotNullCall checkNotNullCall, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)checkNotNullCall, (String)"checkNotNullCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return checkNotNullCall;
        }

        @Override
        @NotNull
        public FirStatement transformBooleanOperatorExpression(@NotNull FirBooleanOperatorExpression booleanOperatorExpression, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)booleanOperatorExpression, (String)"booleanOperatorExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return booleanOperatorExpression;
        }

        @Override
        @NotNull
        public FirStatement transformVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return variableAssignment;
        }

        @Override
        @NotNull
        public FirStatement transformCallableReferenceAccess(@NotNull FirCallableReferenceAccess callableReferenceAccess, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return callableReferenceAccess;
        }

        @Override
        @NotNull
        public FirStatement transformDelegatedConstructorCall(@NotNull FirDelegatedConstructorCall delegatedConstructorCall, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)delegatedConstructorCall, (String)"delegatedConstructorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return delegatedConstructorCall;
        }

        @Override
        @NotNull
        public FirStatement transformIndexedAccessAugmentedAssignment(@NotNull FirIndexedAccessAugmentedAssignment indexedAccessAugmentedAssignment, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)indexedAccessAugmentedAssignment, (String)"indexedAccessAugmentedAssignment");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return indexedAccessAugmentedAssignment;
        }

        @Override
        @NotNull
        public FirStatement transformArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)arrayLiteral, (String)"arrayLiteral");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            arrayLiteral.transformChildren(this.getTransformer(), data);
            return arrayLiteral;
        }

        @Override
        @NotNull
        public FirStatement transformAnonymousObjectExpression(@NotNull FirAnonymousObjectExpression anonymousObjectExpression, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)anonymousObjectExpression, (String)"anonymousObjectExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return anonymousObjectExpression;
        }

        @Override
        @NotNull
        public FirStatement transformAnonymousFunctionExpression(@NotNull FirAnonymousFunctionExpression anonymousFunctionExpression, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)anonymousFunctionExpression, (String)"anonymousFunctionExpression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return anonymousFunctionExpression;
        }

        @Override
        protected boolean shouldComputeTypeOfGetClassCallWithNotQualifierInLhs(@NotNull FirGetClassCall getClassCall) {
            Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
            return false;
        }

        @Override
        @NotNull
        public FirStatement transformFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            functionCall.transformChildren(this.getTransformer(), data);
            return functionCall;
        }

        @Override
        @NotNull
        protected FirQualifiedAccessExpression resolveQualifiedAccessAndSelectCandidate(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, boolean isUsedAsReceiver, boolean isUsedAsGetClassReceiver, @NotNull FirElement callSite, @NotNull ResolutionMode data) {
            Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
            Intrinsics.checkNotNullParameter((Object)callSite, (String)"callSite");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.resolveFromImportScope(qualifiedAccessExpression);
            return qualifiedAccessExpression;
        }

        private final void resolveFromImportScope(FirQualifiedAccessExpression $this$resolveFromImportScope) {
            FirQualifiedAccessExpression receiver;
            FirPureAbstractElement firPureAbstractElement = $this$resolveFromImportScope.getCalleeReference();
            FirSimpleNamedReference firSimpleNamedReference = firPureAbstractElement instanceof FirSimpleNamedReference ? (FirSimpleNamedReference)firPureAbstractElement : null;
            if (firSimpleNamedReference == null) {
                return;
            }
            FirSimpleNamedReference calleeReference = firSimpleNamedReference;
            firPureAbstractElement = $this$resolveFromImportScope.getExplicitReceiver();
            FirQualifiedAccessExpression firQualifiedAccessExpression = receiver = firPureAbstractElement instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firPureAbstractElement : null;
            if (receiver != null) {
                Object v5;
                FirResolvedQualifier resolvedReceiver;
                Object symbol;
                block14: {
                    Object object;
                    Object it3;
                    block13: {
                        Name name2;
                        FirReference firReference = receiver.getCalleeReference();
                        FirSimpleNamedReference firSimpleNamedReference2 = firReference instanceof FirSimpleNamedReference ? (FirSimpleNamedReference)firReference : null;
                        if (firSimpleNamedReference2 == null) {
                            return;
                        }
                        FirSimpleNamedReference receiverCalleeReference = firSimpleNamedReference2;
                        Name it2 = name2 = receiverCalleeReference.getName();
                        boolean bl = false;
                        Name name3 = !it2.isSpecial() ? name2 : null;
                        if (name3 == null) {
                            return;
                        }
                        Name receiverName = name3;
                        for (Object it3 : (Iterable)AbstractFirSpecificAnnotationResolveTransformer.this.getScopes()) {
                            boolean bl2 = false;
                            FirClassifierSymbol<?> firClassifierSymbol = FirScopeKt.getSingleClassifier((FirScope)it3, receiverName);
                            if ((it3 = firClassifierSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassifierSymbol : null) == null) continue;
                            object = it3;
                            break block13;
                        }
                        object = null;
                    }
                    if (object == null) {
                        return;
                    }
                    symbol = object;
                    List segments2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)receiver.getExplicitReceiver(), FirEnumAnnotationArgumentsTransformer::resolveFromImportScope$lambda$2), arg_0 -> FirEnumAnnotationArgumentsTransformer.resolveFromImportScope$lambda$3(this, arg_0)));
                    if (!((Collection)segments2).isEmpty() && !Intrinsics.areEqual((Object)FqName.Companion.fromSegments(CollectionsKt.asReversed((List)segments2)), (Object)((FirClassLikeSymbol)symbol).getClassId().getPackageFqName())) {
                        return;
                    }
                    boolean $i$f$buildResolvedQualifier = false;
                    Object $this$resolveFromImportScope_u24lambda_u244 = it3 = new FirResolvedQualifierBuilder();
                    boolean bl = false;
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u244).setSource(receiver.getSource());
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u244).setPackageFqName(((FirClassLikeSymbol)symbol).getClassId().getPackageFqName());
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u244).setRelativeClassFqName(((FirClassLikeSymbol)symbol).getClassId().getRelativeClassName());
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u244).setConeTypeOrNull(this.getSession().getBuiltinTypes().getUnitType().getConeType());
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u244).setSymbol((FirClassLikeSymbol)symbol);
                    ((FirResolvedQualifierBuilder)$this$resolveFromImportScope_u24lambda_u244).setFullyQualified(!((Collection)segments2).isEmpty());
                    resolvedReceiver = ((FirResolvedQualifierBuilder)it3).build();
                    Iterable $this$firstOrNull$iv = ((FirClass)((FirBasedSymbol)symbol).getFir()).getDeclarations();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirDeclaration it4 = (FirDeclaration)element$iv;
                        boolean bl3 = false;
                        if (!(it4 instanceof FirEnumEntry && Intrinsics.areEqual((Object)((FirEnumEntry)it4).getName(), (Object)calleeReference.getName()))) continue;
                        v5 = element$iv;
                        break block14;
                    }
                    v5 = null;
                }
                FirDeclaration firDeclaration = v5;
                FirBasedSymbol<FirDeclaration> firBasedSymbol = firDeclaration != null ? firDeclaration.getSymbol() : null;
                FirEnumEntrySymbol firEnumEntrySymbol = firBasedSymbol instanceof FirEnumEntrySymbol ? (FirEnumEntrySymbol)firBasedSymbol : null;
                if (firEnumEntrySymbol == null) {
                    return;
                }
                FirEnumEntrySymbol calleeSymbol = firEnumEntrySymbol;
                Object object = CompilerRequiredAnnotationEnhancementProviderKt.getCompilerRequiredAnnotationEnhancementProvider(this.getSession());
                if (object == null || (object = ((CompilerRequiredAnnotationEnhancementProvider)object).enhance((FirClassSymbol<?>)symbol, calleeSymbol, this.getSession())) == null) {
                    object = calleeSymbol;
                }
                Object enhancedCalleeSymbol = object;
                this.updateCallee($this$resolveFromImportScope, calleeReference, (FirEnumEntrySymbol)enhancedCalleeSymbol);
                $this$resolveFromImportScope.replaceExplicitReceiver(resolvedReceiver);
                $this$resolveFromImportScope.replaceDispatchReceiver(resolvedReceiver);
            } else {
                FirVariableSymbol firVariableSymbol;
                block15: {
                    for (FirScope it : (Iterable)AbstractFirSpecificAnnotationResolveTransformer.this.getScopes()) {
                        boolean bl = false;
                        FirVariableSymbol firVariableSymbol2 = (FirVariableSymbol)CollectionsKt.firstOrNull(FirScopeKt.getProperties(it, calleeReference.getName()));
                        if (firVariableSymbol2 == null) continue;
                        firVariableSymbol = firVariableSymbol2;
                        break block15;
                    }
                    firVariableSymbol = null;
                }
                FirVariableSymbol firVariableSymbol3 = firVariableSymbol;
                FirEnumEntrySymbol firEnumEntrySymbol = firVariableSymbol3 instanceof FirEnumEntrySymbol ? (FirEnumEntrySymbol)firVariableSymbol3 : null;
                if (firEnumEntrySymbol == null) {
                    return;
                }
                FirEnumEntrySymbol calleeSymbol = firEnumEntrySymbol;
                this.updateCallee($this$resolveFromImportScope, calleeReference, calleeSymbol);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void updateCallee(FirQualifiedAccessExpression $this$updateCallee, FirSimpleNamedReference calleeReference, FirEnumEntrySymbol calleeSymbol) {
            block2: {
                void $this$updateCallee_u24lambda_u247;
                FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
                FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
                if (firLookupTrackerComponent != null) {
                    Name name2 = calleeReference.getName();
                    Object object = calleeSymbol.getDispatchReceiverType();
                    if (object == null || (object = ConeTypeUtilsKt.getClassId((ConeKotlinType)object)) == null || (object = ((ClassId)object).asFqNameString()) == null) {
                        object = calleeSymbol.getCallableId().getPackageName().asString();
                    }
                    FirPartialBodyResolveTransformer this_$iv = this;
                    boolean $i$f$getContext = false;
                    FirLookupTrackerComponentKt.recordNameLookup(firLookupTrackerComponent, name2, (String)object, $this$updateCallee.getSource(), this_$iv.getTransformer().getContext().getFile().getSource());
                }
                boolean $i$f$buildResolvedNamedReference = false;
                FirResolvedNamedReferenceBuilder $i$f$getContext = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
                FirQualifiedAccessExpression firQualifiedAccessExpression = $this$updateCallee;
                boolean bl = false;
                $this$updateCallee_u24lambda_u247.setSource(calleeReference.getSource());
                $this$updateCallee_u24lambda_u247.setName(calleeReference.getName());
                $this$updateCallee_u24lambda_u247.setResolvedSymbol(calleeSymbol);
                firQualifiedAccessExpression.replaceCalleeReference(firResolvedNamedReferenceBuilder.build());
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(calleeSymbol);
                if (coneClassLikeLookupTag == null) break block2;
                Object it = coneClassLikeLookupTag;
                boolean bl2 = false;
                it = new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)it, new ConeTypeProjection[0], false, null, 8, null);
                boolean bl3 = false;
                $this$updateCallee.replaceConeTypeOrNull((ConeKotlinType)it);
            }
        }

        private static final FirExpression resolveFromImportScope$lambda$2(FirExpression it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            FirQualifiedAccessExpression firQualifiedAccessExpression = it instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)it : null;
            return firQualifiedAccessExpression != null ? firQualifiedAccessExpression.getExplicitReceiver() : null;
        }

        private static final String resolveFromImportScope$lambda$3(FirEnumAnnotationArgumentsTransformer this$0, FirExpression it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            FirReference firReference = ReferenceUtilsKt.toReference(it, this$0.getSession());
            Object object = firReference instanceof FirSimpleNamedReference ? (FirSimpleNamedReference)firReference : null;
            return object != null && (object = ((FirSimpleNamedReference)object).getName()) != null ? ((Name)object).getIdentifier() : null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer$FirEnumAnnotationArgumentsTransformerDispatcher;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer;)V", "expressionsTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirExpressionsResolveTransformer;", "getExpressionsTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirExpressionsResolveTransformer;", "declarationsTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirDeclarationsResolveTransformer;", "getDeclarationsTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirDeclarationsResolveTransformer;", "resolve"})
    public final class FirEnumAnnotationArgumentsTransformerDispatcher
    extends FirAbstractBodyResolveTransformerDispatcher {
        @NotNull
        private final FirExpressionsResolveTransformer expressionsTransformer;
        @Nullable
        private final FirDeclarationsResolveTransformer declarationsTransformer;

        public FirEnumAnnotationArgumentsTransformerDispatcher() {
            FirSession firSession = AbstractFirSpecificAnnotationResolveTransformer.this.getSession();
            FirResolvePhase firResolvePhase = FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS;
            ScopeSession scopeSession = AbstractFirSpecificAnnotationResolveTransformer.this.getScopeSession();
            super(firSession, firResolvePhase, false, scopeSession, null, null, false, 48, null);
            this.expressionsTransformer = new FirEnumAnnotationArgumentsTransformer(this);
        }

        @Override
        @NotNull
        public FirExpressionsResolveTransformer getExpressionsTransformer() {
            return this.expressionsTransformer;
        }

        @Override
        @Nullable
        public FirDeclarationsResolveTransformer getDeclarationsTransformer() {
            return this.declarationsTransformer;
        }
    }
}

