/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentTypeMismatch;
import org.jetbrains.kotlin.fir.resolve.calls.ConeLambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConePostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleterKt;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeArgumentConstraintPosition;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemTransaction;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckLambdaAgainstTypeVariableContradiction;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkForContradiction", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeLambdaWithTypeVariableAsExpectedTypeAtom;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewConstraintSystemImpl;", "hasFunctionTypeConstraint", "", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckLambdaAgainstTypeVariableContradiction\n+ 2 ConstraintSystemBuilder.kt\norg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,912:1\n81#2,10:913\n1755#3,3:923\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckLambdaAgainstTypeVariableContradiction\n*L\n885#1:913,10\n909#1:923,3\n*E\n"})
public final class CheckLambdaAgainstTypeVariableContradiction
extends ResolutionStage {
    @NotNull
    public static final CheckLambdaAgainstTypeVariableContradiction INSTANCE = new CheckLambdaAgainstTypeVariableContradiction();

    private CheckLambdaAgainstTypeVariableContradiction() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context, @NotNull Continuation<? super Unit> $completion) {
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.CheckLambdaAgainstTypeVariableContradictionInResolution)) {
            return Unit.INSTANCE;
        }
        NewConstraintSystemImpl csBuilder = ConstraintSystemCompleterKt.getCsBuilder(candidate2);
        if (csBuilder.getHasContradiction()) {
            return Unit.INSTANCE;
        }
        for (ConePostponedResolvedAtom postponedAtom : candidate2.getPostponedAtoms()) {
            if (!(postponedAtom instanceof ConeLambdaWithTypeVariableAsExpectedTypeAtom)) continue;
            this.checkForContradiction((ConeLambdaWithTypeVariableAsExpectedTypeAtom)postponedAtom, csBuilder, context, sink);
        }
        return Unit.INSTANCE;
    }

    private final void checkForContradiction(ConeLambdaWithTypeVariableAsExpectedTypeAtom $this$checkForContradiction, NewConstraintSystemImpl csBuilder, ResolutionContext context, CheckerSink sink) {
        if (this.hasFunctionTypeConstraint($this$checkForContradiction, csBuilder, context)) {
            return;
        }
        ConeClassLikeType[] coneClassLikeTypeArray = new ConeClassLikeType[]{context.getSession().getBuiltinTypes().getNothingType().getConeType()};
        ConeClassLikeType lambdaType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getFunction(), coneClassLikeTypeArray, false, null, 6, null);
        boolean shouldReportError = false;
        ConstraintSystemBuilder $this$runTransaction$iv = csBuilder;
        boolean $i$f$runTransaction = false;
        ConstraintSystemTransaction transactionState$iv = $this$runTransaction$iv.prepareTransaction();
        ConstraintSystemOperation $this$checkForContradiction_u24lambda_u240 = $this$runTransaction$iv;
        boolean bl = false;
        $this$checkForContradiction_u24lambda_u240.addSubtypeConstraint(lambdaType, $this$checkForContradiction.getExpectedType(), new ConeArgumentConstraintPosition($this$checkForContradiction.getAnonymousFunction()));
        shouldReportError = $this$checkForContradiction_u24lambda_u240.getHasContradiction();
        if (false) {
            transactionState$iv.closeTransaction();
        } else {
            transactionState$iv.rollbackTransaction();
        }
        if (shouldReportError) {
            sink.reportDiagnostic(new ArgumentTypeMismatch($this$checkForContradiction.getExpectedType(), lambdaType, $this$checkForContradiction.getExpression(), InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context.getSession()), lambdaType, $this$checkForContradiction.getExpectedType())));
        }
    }

    private final boolean hasFunctionTypeConstraint(ConeLambdaWithTypeVariableAsExpectedTypeAtom $this$hasFunctionTypeConstraint, NewConstraintSystemImpl csBuilder, ResolutionContext context) {
        boolean bl;
        block4: {
            TypeConstructorMarker typeConstructor2 = TypeSystemContextHelpersKt.typeConstructor($this$hasFunctionTypeConstraint.getExpectedType(), context.getTypeContext());
            VariableWithConstraints variableWithConstraints = csBuilder.currentStorage().getNotFixedTypeVariables().get(typeConstructor2);
            if (variableWithConstraints == null) {
                return false;
            }
            VariableWithConstraints variableWithConstraints2 = variableWithConstraints;
            Iterable $this$any$iv = variableWithConstraints2.getConstraints();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Constraint it = (Constraint)element$iv;
                    boolean bl2 = false;
                    KotlinTypeMarker kotlinTypeMarker = it.getType();
                    Intrinsics.checkNotNull((Object)kotlinTypeMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                    if (!FunctionalTypeUtilsKt.isSomeFunctionType((ConeKotlinType)kotlinTypeMarker, context.getSession())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

