/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CheckIrElementVisitor;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.backend.common.checkers.CheckerUtilsKt;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.context.ContextUpdater;
import org.jetbrains.kotlin.backend.common.checkers.context.ParentChainUpdater;
import org.jetbrains.kotlin.backend.common.checkers.context.TypeParameterScopeUpdater;
import org.jetbrains.kotlin.backend.common.checkers.context.ValueScopeUpdater;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFieldVisibilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrValueParameterVarargTypesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrCrossFileFieldUsageChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrDeclarationReferenceVisibilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrNoInlineUseSitesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrValueAccessScopeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrVarargTypesChecker;
import org.jetbrains.kotlin.backend.common.checkers.type.IrSimpleTypeVisibilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeParameterScopeChecker;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.visitors.IrTypeVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00120\u0010\b\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020\nH\u0016J\u0010\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u000202H\u0016J\u0010\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020 H\u0016J\u0010\u0010B\u001a\u00020\r2\u0006\u0010?\u001a\u00020$H\u0016J\u0018\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\r2\u0006\u0010?\u001a\u00020)H\u0016J\u0010\u0010H\u001a\u00020\r2\u0006\u0010?\u001a\u00020,H\u0016J\u0010\u0010I\u001a\u00020\r2\u0006\u0010A\u001a\u00020/H\u0016J\u0010\u0010J\u001a\u00020\r2\u0006\u0010?\u001a\u000208H\u0016J\u0010\u0010K\u001a\u00020\r2\u0006\u0010?\u001a\u000205H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R;\u0010\b\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020 0\u001fj\u0002`!0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020$0#j\u0002`%0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020)0#j\u0002`*0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020,0#j\u0002`-0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020/0\u001fj\u0002`00\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00101\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002020#j\u0002`30\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002050#j\u0002`60\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00107\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002080#j\u0002`90\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/backend/common/FileIrValidator;", "Lorg/jetbrains/kotlin/ir/visitors/IrTypeVisitorVoid;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "config", "Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "reportError", "Lkotlin/Function4;", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "", "", "Lorg/jetbrains/kotlin/backend/common/ReportIrValidationError;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;Lkotlin/jvm/functions/Function4;)V", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getConfig", "()Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "getReportError", "()Lkotlin/jvm/functions/Function4;", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "contextUpdaters", "", "Lorg/jetbrains/kotlin/backend/common/checkers/context/ContextUpdater;", "fieldCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrDeclarationChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrFieldChecker;", "fieldAccessExpressionCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFieldAccessChecker;", "typeCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/type/IrTypeChecker;", "declarationReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrDeclarationReferenceChecker;", "varargCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrVarargChecker;", "valueParameterCheckers", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrValueParameterChecker;", "valueAccessCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrValueAccessChecker;", "functionAccessCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFunctionAccessChecker;", "functionReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFunctionReferenceChecker;", "elementChecker", "Lorg/jetbrains/kotlin/backend/common/CheckIrElementVisitor;", "visitElement", "element", "visitValueAccess", "expression", "visitField", "declaration", "visitFieldAccess", "visitType", "container", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "visitDeclarationReference", "visitVararg", "visitValueParameter", "visitFunctionReference", "visitFunctionAccess", "ir.backend.common"})
public final class FileIrValidator
extends IrTypeVisitorVoid {
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final IrFile file;
    @NotNull
    private final IrValidatorConfig config;
    @NotNull
    private final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> reportError;
    @NotNull
    private final CheckerContext context;
    @NotNull
    private final List<ContextUpdater> contextUpdaters;
    @NotNull
    private final List<IrDeclarationChecker<IrField>> fieldCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrFieldAccessExpression>> fieldAccessExpressionCheckers;
    @NotNull
    private final List<IrTypeChecker> typeCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrDeclarationReference>> declarationReferenceCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrVararg>> varargCheckers;
    @NotNull
    private final List<IrDeclarationChecker<IrValueParameter>> valueParameterCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrValueAccessExpression>> valueAccessCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrFunctionAccessExpression>> functionAccessCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrFunctionReference>> functionReferenceCheckers;
    @NotNull
    private final CheckIrElementVisitor elementChecker;

    public FileIrValidator(@NotNull IrBuiltIns irBuiltIns, @NotNull IrFile file2, @NotNull IrValidatorConfig config, @NotNull Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit> reportError) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        this.irBuiltIns = irBuiltIns;
        this.file = file2;
        this.config = config;
        this.reportError = reportError;
        this.context = new CheckerContext(this.irBuiltIns, this.file, this.reportError, this.config);
        Object[] objectArray = new ContextUpdater[]{ParentChainUpdater.INSTANCE};
        this.contextUpdaters = CollectionsKt.mutableListOf((Object[])objectArray);
        this.fieldCheckers = new ArrayList();
        this.fieldAccessExpressionCheckers = new ArrayList();
        this.typeCheckers = new ArrayList();
        this.declarationReferenceCheckers = new ArrayList();
        this.varargCheckers = new ArrayList();
        this.valueParameterCheckers = new ArrayList();
        this.valueAccessCheckers = new ArrayList();
        objectArray = new IrExpressionChecker[]{IrNoInlineUseSitesChecker.INSTANCE};
        this.functionAccessCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new IrExpressionChecker[]{IrNoInlineUseSitesChecker.INSTANCE};
        this.functionReferenceCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.config.getCheckValueScopes()) {
            this.contextUpdaters.add(ValueScopeUpdater.INSTANCE);
            this.valueAccessCheckers.add(IrValueAccessScopeChecker.INSTANCE);
        }
        if (this.config.getCheckTypeParameterScopes()) {
            this.contextUpdaters.add(TypeParameterScopeUpdater.INSTANCE);
            this.typeCheckers.add(IrTypeParameterScopeChecker.INSTANCE);
        }
        if (this.config.getCheckAllKotlinFieldsArePrivate()) {
            this.fieldCheckers.add(IrFieldVisibilityChecker.INSTANCE);
        }
        if (this.config.getCheckCrossFileFieldUsage()) {
            this.fieldAccessExpressionCheckers.add(IrCrossFileFieldUsageChecker.INSTANCE);
        }
        if (this.config.getCheckVisibilities() && !CheckerUtilsKt.getEXCLUDED_MODULE_NAMES().contains(this.file.getModule().getName())) {
            this.typeCheckers.add(IrSimpleTypeVisibilityChecker.INSTANCE);
            this.declarationReferenceCheckers.add(IrDeclarationReferenceVisibilityChecker.INSTANCE);
        }
        if (this.config.getCheckVarargTypes()) {
            this.varargCheckers.add(IrVarargTypesChecker.INSTANCE);
            this.valueParameterCheckers.add(IrValueParameterVarargTypesChecker.INSTANCE);
        }
        this.elementChecker = new CheckIrElementVisitor(this.irBuiltIns, (Function2<? super IrElement, ? super String, Unit>)((Function2)(arg_0, arg_1) -> FileIrValidator.elementChecker$lambda$0(this, arg_0, arg_1)), this.config);
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final IrFile getFile() {
        return this.file;
    }

    @NotNull
    public final IrValidatorConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> getReportError() {
        return this.reportError;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptVoid(element, this.elementChecker);
        Function0 block = () -> FileIrValidator.visitElement$lambda$1(element, this);
        for (ContextUpdater contextUpdater : this.contextUpdaters) {
            Function0 currentBlock = block;
            block = () -> FileIrValidator.visitElement$lambda$2(contextUpdater, this, element, currentBlock);
        }
        block.invoke();
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitValueAccess(expression2);
        IrExpressionCheckerKt.check(this.valueAccessCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitField(declaration);
        IrDeclarationCheckerKt.check(this.fieldCheckers, (IrDeclaration)declaration, this.context);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFieldAccess(expression2);
        IrExpressionCheckerKt.check(this.fieldAccessExpressionCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitType(@NotNull IrElement container, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        IrTypeCheckerKt.check(this.typeCheckers, type2, container, this.context);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitDeclarationReference(expression2);
        IrExpressionCheckerKt.check(this.declarationReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitVararg(expression2);
        IrExpressionCheckerKt.check(this.varargCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitValueParameter(declaration);
        IrDeclarationCheckerKt.check(this.valueParameterCheckers, (IrDeclaration)declaration, this.context);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFunctionReference(expression2);
        IrExpressionCheckerKt.check(this.functionReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFunctionAccess(expression2);
        IrExpressionCheckerKt.check(this.functionAccessCheckers, (IrExpression)expression2, this.context);
    }

    private static final Unit elementChecker$lambda$0(FileIrValidator this$0, IrElement element, String message) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this$0.context.error(element, message);
        return Unit.INSTANCE;
    }

    private static final Unit visitElement$lambda$1(IrElement $element, FileIrValidator this$0) {
        IrVisitorsKt.acceptChildrenVoid($element, this$0);
        return Unit.INSTANCE;
    }

    private static final Unit visitElement$lambda$2(ContextUpdater $contextUpdater, FileIrValidator this$0, IrElement $element, Function0 $currentBlock) {
        $contextUpdater.runInNewContext(this$0.context, $element, (Function0<Unit>)$currentBlock);
        return Unit.INSTANCE;
    }
}

