/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\bH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\f\u0010\u0011\u001a\u00020\u000b*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CollectClassDefaultConstructorsLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "couldContainDefaultConstructor", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "defaultConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getDefaultConstructor", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "isDefaultConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nCollectClassDefaultConstructorsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectClassDefaultConstructorsLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/CollectClassDefaultConstructorsLowering\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n385#2,11:36\n1734#3,3:47\n*S KotlinDebug\n*F\n+ 1 CollectClassDefaultConstructorsLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/CollectClassDefaultConstructorsLowering\n*L\n30#1:36,11\n33#1:47,3\n*E\n"})
public final class CollectClassDefaultConstructorsLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public CollectClassDefaultConstructorsLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrClass && this.couldContainDefaultConstructor((IrClass)declaration)) {
            Map map = this.context.getMapping().getClassToItsDefaultConstructor();
            IrDeclaration irDeclaration2 = declaration;
            IrConstructor irConstructor = this.getDefaultConstructor((IrClass)declaration);
            if (irConstructor == null) {
                return null;
            }
            IrConstructor irConstructor2 = irConstructor;
            map.put(irDeclaration2, irConstructor2);
        }
        return null;
    }

    private final boolean couldContainDefaultConstructor(IrClass $this$couldContainDefaultConstructor) {
        return IrUtilsKt.isClass($this$couldContainDefaultConstructor) && !$this$couldContainDefaultConstructor.isValue() && !$this$couldContainDefaultConstructor.isExpect() && $this$couldContainDefaultConstructor.getModality() != Modality.ABSTRACT && $this$couldContainDefaultConstructor.getModality() != Modality.SEALED;
    }

    private final IrConstructor getDefaultConstructor(IrClass $this$defaultConstructor) {
        Object v0;
        block2: {
            Sequence<IrConstructor> $this$singleOrNull$iv = IrUtilsKt.getConstructors($this$defaultConstructor);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getVisibility(), (Object)DescriptorVisibilities.PUBLIC) && this.isDefaultConstructor(it))) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefaultConstructor(IrFunction $this$isDefaultConstructor) {
        boolean bl;
        if ($this$isDefaultConstructor.getValueParameters().isEmpty()) return true;
        Iterable $this$all$iv = $this$isDefaultConstructor.getValueParameters();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl2 = false;
            if (it.getDefaultValue() == null) return false;
            bl = true;
        } while (bl);
        return false;
    }
}

