/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.actualizer.IrExtraActualDeclarationExtractor;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirBuiltinSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmBuiltinProviderActualDeclarationExtractor;", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExtraActualDeclarationExtractor;", "provider", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider;Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;)V", "getProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider;", "extract", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "expectIrClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "hasActualizeByJvmBuiltinProviderFqNameAnnotation", "", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "expectTopLevelCallables", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "expectCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "Companion", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmBuiltinProviderActualDeclarationExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmBuiltinProviderActualDeclarationExtractor.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmBuiltinProviderActualDeclarationExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1755#2,3:71\n1734#2,3:74\n2632#2,2:77\n1755#2,3:79\n2634#2:82\n1611#2,9:83\n1863#2:92\n1864#2:94\n1620#2:95\n1#3:93\n*S KotlinDebug\n*F\n+ 1 FirJvmBuiltinProviderActualDeclarationExtractor.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmBuiltinProviderActualDeclarationExtractor\n*L\n48#1:71,3\n53#1:74,3\n55#1:77,2\n56#1:79,3\n55#1:82\n62#1:83,9\n62#1:92\n62#1:94\n62#1:95\n62#1:93\n*E\n"})
public final class FirJvmBuiltinProviderActualDeclarationExtractor
extends IrExtraActualDeclarationExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirBuiltinSymbolProvider provider;
    @NotNull
    private final Fir2IrClassifierStorage classifierStorage;
    @NotNull
    private final Fir2IrDeclarationStorage declarationStorage;
    @NotNull
    private static final FqName ActualizeByJvmBuiltinProviderFqName = StandardClassIds.Annotations.INSTANCE.getActualizeByJvmBuiltinProvider().asSingleFqName();

    public FirJvmBuiltinProviderActualDeclarationExtractor(@NotNull FirBuiltinSymbolProvider provider2, @NotNull Fir2IrClassifierStorage classifierStorage, @NotNull Fir2IrDeclarationStorage declarationStorage) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)classifierStorage, (String)"classifierStorage");
        Intrinsics.checkNotNullParameter((Object)declarationStorage, (String)"declarationStorage");
        this.provider = provider2;
        this.classifierStorage = classifierStorage;
        this.declarationStorage = declarationStorage;
    }

    @NotNull
    public final FirBuiltinSymbolProvider getProvider() {
        return this.provider;
    }

    @Override
    @Nullable
    public IrClassSymbol extract(@NotNull IrClass expectIrClass) {
        Intrinsics.checkNotNullParameter((Object)expectIrClass, (String)"expectIrClass");
        if (!this.hasActualizeByJvmBuiltinProviderFqNameAnnotation(expectIrClass)) {
            return null;
        }
        FirRegularClassSymbol firRegularClassSymbol = FirSymbolProviderKt.getRegularClassSymbolByClassId(this.provider, AdditionalIrUtilsKt.getClassIdOrFail(expectIrClass));
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
        return this.classifierStorage.getIrClassSymbol(regularClassSymbol);
    }

    private final boolean hasActualizeByJvmBuiltinProviderFqNameAnnotation(IrClass $this$hasActualizeByJvmBuiltinProviderFqNameAnnotation) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = $this$hasActualizeByJvmBuiltinProviderFqNameAnnotation.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrConstructorCall it = (IrConstructorCall)element$iv;
                    boolean bl2 = false;
                    if (!IrUtilsKt.isAnnotation(it, ActualizeByJvmBuiltinProviderFqName)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        IrClass irClass = IrUtilsKt.getParentClassOrNull($this$hasActualizeByJvmBuiltinProviderFqNameAnnotation);
        return irClass != null ? this.hasActualizeByJvmBuiltinProviderFqNameAnnotation(irClass) : false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IrSymbol> extract(@NotNull List<? extends IrDeclarationWithName> expectTopLevelCallables, @NotNull CallableId expectCallableId) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl;
        block14: {
            boolean bl2;
            block12: {
                Intrinsics.checkNotNullParameter(expectTopLevelCallables, (String)"expectTopLevelCallables");
                Intrinsics.checkNotNullParameter((Object)expectCallableId, (String)"expectCallableId");
                Iterable $this$all$iv = expectTopLevelCallables;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        IrDeclarationWithName it = (IrDeclarationWithName)element$iv;
                        boolean bl3 = false;
                        if (IrUtilsKt.isTopLevel(it)) continue;
                        bl2 = false;
                        break block12;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                String $i$f$all = "Failed requirement.";
                throw new IllegalArgumentException($i$f$all.toString());
            }
            Iterable $this$none$iv = expectTopLevelCallables;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    boolean bl4;
                    block13: {
                        IrDeclarationWithName expectCallable = (IrDeclarationWithName)element$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv = expectCallable.getAnnotations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                IrConstructorCall it = (IrConstructorCall)element$iv2;
                                boolean bl6 = false;
                                if (!IrUtilsKt.isAnnotation(it, ActualizeByJvmBuiltinProviderFqName)) continue;
                                bl4 = true;
                                break block13;
                            }
                            bl4 = false;
                        }
                    }
                    if (!bl4) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = this.provider.getTopLevelCallableSymbols(expectCallableId.getPackageName(), expectCallableId.getCallableName());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl7 = false;
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl8 = false;
            FirCallableSymbol firCallableSymbol = it;
            if ((firCallableSymbol instanceof FirPropertySymbol ? Fir2IrDeclarationStorage.getIrPropertySymbol$default(this.declarationStorage, (FirPropertySymbol)it, null, 2, null) : (firCallableSymbol instanceof FirFunctionSymbol ? (IrSymbol)Fir2IrDeclarationStorage.getIrFunctionSymbol$default(this.declarationStorage, (FirFunctionSymbol)it, null, false, 6, null) : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmBuiltinProviderActualDeclarationExtractor$Companion;", "", "<init>", "()V", "ActualizeByJvmBuiltinProviderFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getActualizeByJvmBuiltinProviderFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "jvm-backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getActualizeByJvmBuiltinProviderFqName() {
            return ActualizeByJvmBuiltinProviderFqName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

