/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementOverridesChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\u0013\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "<init>", "()V", "hidesFromObjCClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "getHidesFromObjCClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "refinesInSwiftClassId", "getRefinesInSwiftClassId", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "findRefinedAnnotations", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.native"})
public final class FirNativeObjCRefinementChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirNativeObjCRefinementChecker INSTANCE = new FirNativeObjCRefinementChecker();
    @NotNull
    private static final ClassId hidesFromObjCClassId = ClassId.Companion.topLevel(new FqName("kotlin.native.HidesFromObjC"));
    @NotNull
    private static final ClassId refinesInSwiftClassId = ClassId.Companion.topLevel(new FqName("kotlin.native.RefinesInSwift"));

    private FirNativeObjCRefinementChecker() {
        super(MppCheckerKind.Platform);
    }

    @NotNull
    public final ClassId getHidesFromObjCClassId() {
        return hidesFromObjCClassId;
    }

    @NotNull
    public final ClassId getRefinesInSwiftClassId() {
        return refinesInSwiftClassId;
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirClass containingClass;
        Object swiftAnnotation2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration instanceof FirSimpleFunction) && !(declaration instanceof FirProperty)) {
            return;
        }
        Pair<List<FirAnnotation>, List<FirAnnotation>> pair = this.findRefinedAnnotations(declaration, context.getSession());
        List objCAnnotations = (List)pair.component1();
        List swiftAnnotations = (List)pair.component2();
        if (!((Collection)objCAnnotations).isEmpty() && !((Collection)swiftAnnotations).isEmpty()) {
            for (Object swiftAnnotation2 : swiftAnnotations) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirAnnotation)swiftAnnotation2).getSource(), FirNativeErrors.INSTANCE.getREDUNDANT_SWIFT_REFINEMENT(), (DiagnosticContext)context, null, 8, null);
            }
        }
        FirClass firClass = containingClass = (swiftAnnotation2 = CollectionsKt.lastOrNull(context.getContainingDeclarations())) instanceof FirClass ? (FirClass)swiftAnnotation2 : null;
        if (containingClass != null) {
            FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(containingClass, context);
            FirNativeObjCRefinementOverridesChecker.Companion.check(firTypeScope, declaration.getSymbol(), declaration, context, reporter, objCAnnotations, swiftAnnotations);
        }
    }

    private final Pair<List<FirAnnotation>, List<FirAnnotation>> findRefinedAnnotations(FirCallableDeclaration $this$findRefinedAnnotations, FirSession session2) {
        List objCAnnotations = new ArrayList();
        List swiftAnnotations = new ArrayList();
        block0: for (FirAnnotation annotation : $this$findRefinedAnnotations.getAnnotations()) {
            FirClassLikeSymbol<?> firClassLikeSymbol = FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(annotation, session2);
            List list = firClassLikeSymbol != null ? firClassLikeSymbol.getResolvedAnnotationsWithClassIds() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List metaAnnotations = list;
            for (FirAnnotation metaAnnotation : metaAnnotations) {
                ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId(metaAnnotation, session2);
                if (Intrinsics.areEqual((Object)classId, (Object)hidesFromObjCClassId)) {
                    objCAnnotations.add(annotation);
                    continue block0;
                }
                if (!Intrinsics.areEqual((Object)classId, (Object)refinesInSwiftClassId)) continue;
                swiftAnnotations.add(annotation);
                continue block0;
            }
        }
        return TuplesKt.to((Object)objCAnnotations, (Object)swiftAnnotations);
    }
}

