/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunInterfaceConstructorReferenceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirFunInterfaceConstructorReferenceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFunInterfaceConstructorReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunInterfaceConstructorReferenceChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n*L\n1#1,41:1\n55#2:42\n96#3:43\n87#3,11:44\n*S KotlinDebug\n*F\n+ 1 FirFunInterfaceConstructorReferenceChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunInterfaceConstructorReferenceChecker\n*L\n35#1:42\n35#1:43\n35#1:44,11\n*E\n"})
public final class FirFunInterfaceConstructorReferenceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirFunInterfaceConstructorReferenceChecker INSTANCE = new FirFunInterfaceConstructorReferenceChecker();

    private FirFunInterfaceConstructorReferenceChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(expression2 instanceof FirCallableReferenceAccess)) {
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.KotlinFunInterfaceConstructorReference)) {
            return;
        }
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(((FirCallableReferenceAccess)expression2).getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference2 = firResolvedNamedReference;
        FirBasedSymbol<?> referredSymbol = reference2.getResolvedSymbol();
        if (!(referredSymbol instanceof FirNamedFunctionSymbol)) return;
        if (!Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)referredSymbol).getOrigin(), (Object)FirDeclarationOrigin.SamConstructor.INSTANCE)) return;
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirNamedFunctionSymbol)referredSymbol).getResolvedReturnTypeRef(), context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol samClassSymbol = firRegularClassSymbol;
        FirClassLikeSymbol $this$isFun$iv = samClassSymbol;
        boolean $i$f$isFun = false;
        if (!$this$isFun$iv.getRawStatus().isFun()) return;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = samClassSymbol;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement2 = false;
        if ($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java) return;
        if (Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE)) {
            return;
        }
        boolean bl2 = false;
        if (bl2) return;
        Object e = $this$isJavaOrEnhancement$iv.getFir();
        Object object = e instanceof FirCallableDeclaration ? (FirCallableDeclaration)e : null;
        if (object != null && (object = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object)) != null && (object = ((ImportedFromObjectOrStaticData)object).getOriginal()) != null) {
            if (DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) {
                return;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl3 = false;
        if (bl3) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reference2.getSource(), FirErrors.INSTANCE.getFUN_INTERFACE_CONSTRUCTOR_REFERENCE(), (DiagnosticContext)context, null, 8, null);
    }
}

