/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReifiedTypeParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "areAccessorsInline", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReifiedTypeParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReifiedTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReifiedTypeParameterChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,40:1\n43#2:41\n43#2:42\n43#2:43\n*S KotlinDebug\n*F\n+ 1 FirReifiedTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReifiedTypeParameterChecker\n*L\n25#1:41\n34#1:42\n35#1:43\n*E\n"})
public final class FirReifiedTypeParameterChecker
extends FirDeclarationChecker<FirTypeParameter> {
    @NotNull
    public static final FirReifiedTypeParameterChecker INSTANCE = new FirReifiedTypeParameterChecker();

    private FirReifiedTypeParameterChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirTypeParameter declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block5: {
            FirDeclaration containingDeclaration;
            block6: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (!declaration.isReified()) {
                    return;
                }
                FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context.getContainingDeclarations());
                if (firDeclaration == null) {
                    return;
                }
                containingDeclaration = firDeclaration;
                if (containingDeclaration instanceof FirRegularClass) break block5;
                if (!(containingDeclaration instanceof FirSimpleFunction)) break block6;
                FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)containingDeclaration;
                boolean $i$f$isInline = false;
                if (!$this$isInline$iv.getStatus().isInline()) break block5;
            }
            if (!(containingDeclaration instanceof FirProperty)) return;
            if (this.areAccessorsInline((FirProperty)containingDeclaration)) return;
        }
        boolean bl = true;
        boolean forbidReified = bl;
        if (!forbidReified) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_NO_INLINE(), (DiagnosticContext)context, null, 8, null);
    }

    private final boolean areAccessorsInline(FirProperty $this$areAccessorsInline) {
        boolean bl;
        boolean $i$f$isInline;
        FirMemberDeclaration $this$isInline$iv;
        FirPropertyAccessor firPropertyAccessor = $this$areAccessorsInline.getGetter();
        if (firPropertyAccessor != null) {
            $this$isInline$iv = firPropertyAccessor;
            $i$f$isInline = false;
            bl = $this$isInline$iv.getStatus().isInline();
        } else {
            bl = false;
        }
        if (!bl) {
            return false;
        }
        if ($this$areAccessorsInline.isVar()) {
            boolean bl2;
            FirPropertyAccessor firPropertyAccessor2 = $this$areAccessorsInline.getSetter();
            if (firPropertyAccessor2 != null) {
                $this$isInline$iv = firPropertyAccessor2;
                $i$f$isInline = false;
                bl2 = $this$isInline$iv.getStatus().isInline();
            } else {
                bl2 = false;
            }
            if (!bl2) {
                return false;
            }
        }
        return true;
    }
}

