/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\u0011\u0012B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "Node", "", "node", "token", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "<init>", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getNode", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getToken", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "getSource", "()Lorg/jetbrains/kotlin/KtSourceElement;", "FirPsiModifier", "FirLightModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirLightModifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirPsiModifier;", "checkers"})
public abstract class FirModifier<Node> {
    @NotNull
    private final Node node;
    @NotNull
    private final KtModifierKeywordToken token;

    private FirModifier(Node node, KtModifierKeywordToken token) {
        this.node = node;
        this.token = token;
    }

    @NotNull
    public final Node getNode() {
        return this.node;
    }

    @NotNull
    public final KtModifierKeywordToken getToken() {
        return this.token;
    }

    @NotNull
    public abstract KtSourceElement getSource();

    public /* synthetic */ FirModifier(Object node, KtModifierKeywordToken token, DefaultConstructorMarker $constructor_marker) {
        this(node, token);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirLightModifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "node", "token", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "offsetDelta", "", "<init>", "(Lcom/intellij/lang/LighterASTNode;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;Lcom/intellij/util/diff/FlyweightCapableTreeStructure;I)V", "getTree", "()Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "getSource", "()Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirKeywordUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirKeywordUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirLightModifier\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,117:1\n798#2,7:118\n*S KotlinDebug\n*F\n+ 1 FirKeywordUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirLightModifier\n*L\n77#1:118,7\n*E\n"})
    public static final class FirLightModifier
    extends FirModifier<LighterASTNode> {
        @NotNull
        private final FlyweightCapableTreeStructure<LighterASTNode> tree;
        private final int offsetDelta;

        public FirLightModifier(@NotNull LighterASTNode node, @NotNull KtModifierKeywordToken token, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, int offsetDelta) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            super(node, token, null);
            this.tree = tree;
            this.offsetDelta = offsetDelta;
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> getTree() {
            return this.tree;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public KtSourceElement getSource() {
            void tree$iv;
            void endOffset$iv;
            void startOffset$iv;
            void $this$toKtLightSourceElement_u24default$iv;
            LighterASTNode lighterASTNode = (LighterASTNode)this.getNode();
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = this.tree;
            int n = ((LighterASTNode)this.getNode()).getStartOffset() + this.offsetDelta;
            int n2 = ((LighterASTNode)this.getNode()).getEndOffset() + this.offsetDelta;
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            boolean $i$f$toKtLightSourceElement = false;
            return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, (int)startOffset$iv, (int)endOffset$iv, (FlyweightCapableTreeStructure<LighterASTNode>)tree$iv, kind$iv);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirPsiModifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "node", "token", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "<init>", "(Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "getSource", "()Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirKeywordUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirKeywordUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirPsiModifier\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,117:1\n792#2,5:118\n*S KotlinDebug\n*F\n+ 1 FirKeywordUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirPsiModifier\n*L\n67#1:118,5\n*E\n"})
    public static final class FirPsiModifier
    extends FirModifier<ASTNode> {
        public FirPsiModifier(@NotNull ASTNode node, @NotNull KtModifierKeywordToken token) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            super(node, token, null);
        }

        @Override
        @NotNull
        public KtSourceElement getSource() {
            KtPsiSourceElement ktPsiSourceElement;
            PsiElement psiElement = ((ASTNode)this.getNode()).getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
            PsiElement $this$toKtPsiSourceElement_u24default$iv = psiElement;
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            boolean $i$f$toKtPsiSourceElement = false;
            KtSourceElementKind ktSourceElementKind = kind$iv;
            if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
            } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                ktPsiSourceElement = new KtFakeSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return ktPsiSourceElement;
        }
    }
}

