/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.IntInlineKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMap;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentHashMapValueStorage;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMapBase;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMapImpl;
import org.jetbrains.kotlin.com.intellij.util.io.PersistentMapInMemory;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;

@ApiStatus.Experimental
public final class PersistentMapBuilder<Key, Value> {
    @NotNull
    private final Path myFile;
    @NotNull
    private final KeyDescriptor<Key> myKeyDescriptor;
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    private Integer myInitialSize;
    private Integer myVersion;
    private StorageLockContext myLockContext;
    private Boolean myInlineValues;
    private Boolean myIsReadOnly;
    private Boolean myHasChunks;
    private Boolean myCompactOnClose;
    @NotNull
    private ExecutorService myWalExecutor;
    private boolean myEnableWal;

    private PersistentMapBuilder(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) {
        if (file2 == null) {
            PersistentMapBuilder.$$$reportNull$$$0(0);
        }
        if (keyDescriptor == null) {
            PersistentMapBuilder.$$$reportNull$$$0(1);
        }
        if (valueExternalizer == null) {
            PersistentMapBuilder.$$$reportNull$$$0(2);
        }
        this.myCompactOnClose = null;
        this.myWalExecutor = ConcurrencyUtil.newSameThreadExecutorService();
        this.myFile = file2;
        this.myKeyDescriptor = keyDescriptor;
        this.myValueExternalizer = valueExternalizer;
    }

    @NotNull
    public PersistentHashMap<Key, Value> build() throws IOException {
        return new PersistentHashMap<Key, Value>(this.buildImplementation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private PersistentMapBase<Key, Value> buildImplementation() throws IOException {
        Boolean oldHasNoChunksValue = null;
        if (this.myHasChunks != null) {
            oldHasNoChunksValue = PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.get();
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(this.myHasChunks == false);
        }
        Boolean previousReadOnly = PersistentHashMapValueStorage.CreationTimeOptions.READONLY.get();
        PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(this.myIsReadOnly);
        if (SystemProperties.getBooleanProperty("idea.use.in.memory.persistent.map", false)) {
            PersistentMapInMemory persistentMapInMemory = new PersistentMapInMemory(this);
            PersistentMapInMemory persistentMapInMemory2 = persistentMapInMemory;
            if (persistentMapInMemory2 == null) {
                PersistentMapBuilder.$$$reportNull$$$0(3);
            }
            return persistentMapInMemory2;
        }
        PersistentMapImpl persistentMapImpl = new PersistentMapImpl(this);
        PersistentMapImpl persistentMapImpl2 = persistentMapImpl;
        if (persistentMapImpl2 == null) {
            PersistentMapBuilder.$$$reportNull$$$0(4);
        }
        return persistentMapImpl2;
        finally {
            if (this.myHasChunks != null) {
                PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(oldHasNoChunksValue);
            }
            PersistentHashMapValueStorage.CreationTimeOptions.READONLY.set(previousReadOnly);
        }
    }

    @NotNull
    public Path getFile() {
        Path path = this.myFile;
        if (path == null) {
            PersistentMapBuilder.$$$reportNull$$$0(5);
        }
        return path;
    }

    @NotNull
    public KeyDescriptor<Key> getKeyDescriptor() {
        KeyDescriptor<Key> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            PersistentMapBuilder.$$$reportNull$$$0(6);
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<Value> getValueExternalizer() {
        DataExternalizer<Value> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            PersistentMapBuilder.$$$reportNull$$$0(7);
        }
        return dataExternalizer;
    }

    @NotNull
    public static <Key, Value> PersistentMapBuilder<Key, Value> newBuilder(@NotNull Path file2, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) {
        if (file2 == null) {
            PersistentMapBuilder.$$$reportNull$$$0(8);
        }
        if (keyDescriptor == null) {
            PersistentMapBuilder.$$$reportNull$$$0(9);
        }
        if (valueExternalizer == null) {
            PersistentMapBuilder.$$$reportNull$$$0(10);
        }
        return new PersistentMapBuilder<Key, Value>(file2, keyDescriptor, valueExternalizer);
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withInitialSize(int initialSize) {
        this.myInitialSize = initialSize;
        PersistentMapBuilder persistentMapBuilder = this;
        if (persistentMapBuilder == null) {
            PersistentMapBuilder.$$$reportNull$$$0(11);
        }
        return persistentMapBuilder;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withVersion(int version2) {
        this.myVersion = version2;
        PersistentMapBuilder persistentMapBuilder = this;
        if (persistentMapBuilder == null) {
            PersistentMapBuilder.$$$reportNull$$$0(12);
        }
        return persistentMapBuilder;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withReadonly(boolean readonly) {
        this.myIsReadOnly = readonly;
        PersistentMapBuilder persistentMapBuilder = this;
        if (persistentMapBuilder == null) {
            PersistentMapBuilder.$$$reportNull$$$0(13);
        }
        return persistentMapBuilder;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> inlineValues(boolean inlineValues) {
        if (inlineValues && !(this.myValueExternalizer instanceof IntInlineKeyDescriptor)) {
            throw new IllegalStateException("can't inline values for externalizer " + this.myValueExternalizer.getClass());
        }
        this.myInlineValues = inlineValues;
        PersistentMapBuilder persistentMapBuilder = this;
        if (persistentMapBuilder == null) {
            PersistentMapBuilder.$$$reportNull$$$0(18);
        }
        return persistentMapBuilder;
    }

    @NotNull
    public PersistentMapBuilder<Key, Value> withStorageLockContext(@Nullable StorageLockContext context) {
        this.myLockContext = context;
        PersistentMapBuilder persistentMapBuilder = this;
        if (persistentMapBuilder == null) {
            PersistentMapBuilder.$$$reportNull$$$0(20);
        }
        return persistentMapBuilder;
    }

    public int getInitialSize(int defaultValue) {
        if (this.myInitialSize != null) {
            return this.myInitialSize;
        }
        return defaultValue;
    }

    public int getVersion(int defaultValue) {
        if (this.myVersion != null) {
            return this.myVersion;
        }
        return defaultValue;
    }

    public boolean getInlineValues(boolean defaultValue) {
        if (this.myInlineValues != null) {
            return this.myInlineValues;
        }
        return defaultValue;
    }

    public boolean getReadOnly(boolean defaultValue) {
        if (this.myIsReadOnly != null) {
            return this.myIsReadOnly;
        }
        return defaultValue;
    }

    public boolean getCompactOnClose(boolean defaultCompactOnClose) {
        if (this.myCompactOnClose != null) {
            return this.myCompactOnClose;
        }
        return defaultCompactOnClose;
    }

    public boolean isEnableWal() {
        return this.myEnableWal;
    }

    public ExecutorService getWalExecutor() {
        return this.myWalExecutor;
    }

    @Nullable
    public StorageLockContext getLockContext() {
        return this.myLockContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentMapBuilder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/PersistentMapBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildImplementation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withInitialSize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withVersion";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withReadonly";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readonly";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withWal";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setWalExecutor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineValues";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "withStorageLockContext";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "hasChunks";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "hasNoChunks";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "withCompactOnClose";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "compactOnClose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setWalExecutor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

