/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.SharedVariablesManager;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmSharedVariablesManager;", "Lorg/jetbrains/kotlin/backend/common/ir/SharedVariablesManager;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "declareSharedVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "originalDeclaration", "defineSharedValue", "sharedVariableDeclaration", "getSharedValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "sharedVariableSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "originalGet", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "setSharedValue", "originalSet", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmSharedVariablesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmSharedVariablesManager.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmSharedVariablesManager\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,131:1\n35#2,2:132\n35#2,2:134\n*S KotlinDebug\n*F\n+ 1 WasmSharedVariablesManager.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmSharedVariablesManager\n*L\n69#1:132,2\n104#1:134,2\n*E\n"})
public final class WasmSharedVariablesManager
implements SharedVariablesManager {
    @NotNull
    private final WasmBackendContext context;

    public WasmSharedVariablesManager(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public IrVariable declareSharedVariable(@NotNull IrVariable originalDeclaration) {
        Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
        IrExpression irExpression = originalDeclaration.getInitializer();
        if (irExpression == null) {
            irExpression = IrConstImpl.Companion.defaultValueForType(originalDeclaration.getStartOffset(), originalDeclaration.getEndOffset(), originalDeclaration.getType());
        }
        IrExpression initializer = irExpression;
        IrClassSymbol boxClass = this.context.getWasmSymbols().findClosureBoxClass(originalDeclaration.getType());
        IrConstructorSymbol constructorSymbol = (IrConstructorSymbol)SequencesKt.first(IrUtilsKt.getConstructors(boxClass));
        IrElementBase irElementBase = new IrConstructorCallImpl(initializer.getStartOffset(), initializer.getEndOffset(), IrTypesKt.getDefaultType(boxClass), constructorSymbol, ((IrClass)boxClass.getOwner()).getTypeParameters().size(), ((IrConstructor)constructorSymbol.getOwner()).getTypeParameters().size(), ((IrConstructor)constructorSymbol.getOwner()).getValueParameters().size(), null, null, 384, null);
        IrConstructorCallImpl $this$declareSharedVariable_u24lambda_u240 = irElementBase;
        boolean bl = false;
        $this$declareSharedVariable_u24lambda_u240.putValueArgument(0, initializer);
        IrConstructorCallImpl irCall = irElementBase;
        IrElementBase it = irElementBase = new IrVariableImpl(originalDeclaration.getStartOffset(), originalDeclaration.getEndOffset(), originalDeclaration.getOrigin(), new IrVariableSymbolImpl(null, 1, null), originalDeclaration.getName(), irCall.getType(), false, false, false);
        boolean bl2 = false;
        ((IrDeclarationBase)it).setParent(originalDeclaration.getParent());
        ((IrVariableImpl)it).setInitializer(irCall);
        return (IrVariable)irElementBase;
    }

    @Override
    @NotNull
    public IrVariable defineSharedValue(@NotNull IrVariable originalDeclaration, @NotNull IrVariable sharedVariableDeclaration) {
        Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
        Intrinsics.checkNotNullParameter((Object)sharedVariableDeclaration, (String)"sharedVariableDeclaration");
        return sharedVariableDeclaration;
    }

    @Override
    @NotNull
    public IrExpression getSharedValue(@NotNull IrValueSymbol sharedVariableSymbol, @NotNull IrGetValue originalGet) {
        Object element$iv;
        Object object;
        IrClass boxClass;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sharedVariableSymbol, (String)"sharedVariableSymbol");
            Intrinsics.checkNotNullParameter((Object)originalGet, (String)"originalGet");
            boxClass = (IrClass)IrTypesKt.getClassOrFail(sharedVariableSymbol.getOwner().getType()).getOwner();
            Iterable $this$firstIsInstance$iv = boxClass.getDeclarations();
            boolean $i$f$firstIsInstance = false;
            object = $this$firstIsInstance$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                if (!(element$iv instanceof IrProperty)) continue;
                break block2;
            }
            throw new NoSuchElementException("No element of given type found");
        }
        IrProperty valueProperty = (IrProperty)element$iv;
        if (!Intrinsics.areEqual((Object)valueProperty.getName().asString(), (Object)"value")) {
            String $i$f$firstIsInstance = "Check failed.";
            throw new IllegalStateException($i$f$firstIsInstance.toString());
        }
        IrSimpleFunction irSimpleFunction = valueProperty.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrSimpleFunction propertyGetter = irSimpleFunction;
        Object it = object = new IrCallImpl(originalGet.getStartOffset(), originalGet.getEndOffset(), propertyGetter.getReturnType(), propertyGetter.getSymbol(), 0, 0, originalGet.getOrigin(), null, 128, null);
        boolean bl = false;
        ((IrCallImpl)it).setDispatchReceiver(BuildersKt.IrGetValueImpl(originalGet.getStartOffset(), originalGet.getEndOffset(), IrUtilsKt.getDefaultType(boxClass), sharedVariableSymbol, originalGet.getOrigin()));
        Object propertyGet = object;
        return BuildersKt.IrTypeOperatorCallImpl(originalGet.getStartOffset(), originalGet.getEndOffset(), originalGet.getType(), IrTypeOperator.IMPLICIT_CAST, originalGet.getType(), (IrExpression)propertyGet);
    }

    @Override
    @NotNull
    public IrExpression setSharedValue(@NotNull IrValueSymbol sharedVariableSymbol, @NotNull IrSetValue originalSet) {
        Object element$iv;
        Object object;
        IrClass boxClass;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sharedVariableSymbol, (String)"sharedVariableSymbol");
            Intrinsics.checkNotNullParameter((Object)originalSet, (String)"originalSet");
            boxClass = (IrClass)IrTypesKt.getClassOrFail(sharedVariableSymbol.getOwner().getType()).getOwner();
            Iterable $this$firstIsInstance$iv = boxClass.getDeclarations();
            boolean $i$f$firstIsInstance = false;
            object = $this$firstIsInstance$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                if (!(element$iv instanceof IrProperty)) continue;
                break block2;
            }
            throw new NoSuchElementException("No element of given type found");
        }
        IrProperty valueProperty = (IrProperty)element$iv;
        if (!Intrinsics.areEqual((Object)valueProperty.getName().asString(), (Object)"value")) {
            String $i$f$firstIsInstance = "Check failed.";
            throw new IllegalStateException($i$f$firstIsInstance.toString());
        }
        IrSimpleFunction irSimpleFunction = valueProperty.getSetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrSimpleFunction propertySetter = irSimpleFunction;
        Object it = object = new IrCallImpl(originalSet.getStartOffset(), originalSet.getEndOffset(), propertySetter.getReturnType(), propertySetter.getSymbol(), 0, 1, originalSet.getOrigin(), null, 128, null);
        boolean bl = false;
        ((IrCallImpl)it).setDispatchReceiver(BuildersKt.IrGetValueImpl(originalSet.getStartOffset(), originalSet.getEndOffset(), IrUtilsKt.getDefaultType(boxClass), sharedVariableSymbol, originalSet.getOrigin()));
        ((IrMemberAccessExpression)it).putValueArgument(0, originalSet.getValue());
        Object propertySet = object;
        return (IrExpression)propertySet;
    }
}

