/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.OptInDescription;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.checkers.UsageCheckerUtilsKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0006\u000f\u0010\u0011\u0012\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findRelevantDataClassPropertyIfAny", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "OptInDiagnosticReporter", "OptInFactoryBasedReporter", "OptInReporterMultiplexer", "Companion", "ClassifierUsage", "Overrides", "frontend"})
@SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,542:1\n1557#2:543\n1628#2,3:544\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker\n*L\n102#1:543\n102#1:544,3\n*E\n"})
public final class OptInUsageChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;
    @NotNull
    private static final Name WARNING_LEVEL;
    @NotNull
    private static final Name ERROR_LEVEL;
    @NotNull
    private static final OptInReporterMultiplexer USAGE_DIAGNOSTICS;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        Object resultingDescriptor = obj;
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
        Set optIns = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, (DeclarationDescriptor)resultingDescriptor, bindingContext2, languageVersionSettings, null, false, false, false, 60, null);
        if (resultingDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)resultingDescriptor).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED && (propertyDescriptor = this.findRelevantDataClassPropertyIfAny((FunctionDescriptor)resultingDescriptor, context2)) != null) {
            Companion.reportNotAllowedOptIns(SetsKt.plus((Set)optIns, (Iterable)org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, propertyDescriptor, bindingContext2, languageVersionSettings, null, false, false, false, 60, null)), reportOn, context2);
            return;
        }
        if (resultingDescriptor instanceof SamConstructorDescriptor) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            CallableMemberDescriptor methodDescriptor = ((SamConstructorDescriptor)resultingDescriptor).getSingleAbstractMethod();
            Iterable iterable = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, methodDescriptor, bindingContext2, languageVersionSettings, null, false, false, false, 60, null);
            boolean $i$f$map = false;
            void var12_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                OptInDescription optInDescription = (OptInDescription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FqName fqName = optInDescription.component1();
                String message = optInDescription.component3();
                collection.add(new OptInDescription(fqName, OptInDescription.Severity.WARNING, message, false));
            }
            List samOptIns = (List)destination$iv$iv;
            Companion.reportNotAllowedOptIns(samOptIns, reportOn, context2);
        }
        Companion.reportNotAllowedOptIns(optIns, reportOn, context2);
    }

    private final PropertyDescriptor findRelevantDataClassPropertyIfAny(FunctionDescriptor $this$findRelevantDataClassPropertyIfAny, CallCheckerContext context2) {
        String string2 = $this$findRelevantDataClassPropertyIfAny.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        Integer index = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)string2, (CharSequence)"component"));
        DeclarationDescriptor declarationDescriptor = $this$findRelevantDataClassPropertyIfAny.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor container = declarationDescriptor;
        if (container instanceof ClassDescriptor && ((ClassDescriptor)container).isData() && index != null) {
            ValueParameterDescriptor dataClassParameterDescriptor;
            Object object = ((ClassDescriptor)container).getUnsubstitutedPrimaryConstructor();
            ValueParameterDescriptor valueParameterDescriptor = object != null && (object = object.getValueParameters()) != null ? (ValueParameterDescriptor)CollectionsKt.getOrNull((List)object, (int)(index - 1)) : (dataClassParameterDescriptor = null);
            if (dataClassParameterDescriptor != null) {
                return (PropertyDescriptor)context2.getTrace().getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, dataClassParameterDescriptor);
            }
        }
        return null;
    }

    static {
        Name name2 = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        LEVEL = name2;
        Name name3 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        MESSAGE = name3;
        Name name4 = Name.identifier("WARNING");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        WARNING_LEVEL = name4;
        Name name5 = Name.identifier("ERROR");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
        ERROR_LEVEL = name5;
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2 = Errors.OPT_IN_USAGE;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, (String)"OPT_IN_USAGE");
        OptInDiagnosticReporter optInDiagnosticReporter = new OptInFactoryBasedReporter(diagnosticFactory2, Companion.getDefaultDiagnosticMessage$frontend(OptInNames.INSTANCE.buildMessagePrefix("should")));
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory22 = Errors.OPT_IN_USAGE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory22, (String)"OPT_IN_USAGE_ERROR");
        OptInDiagnosticReporter optInDiagnosticReporter2 = new OptInFactoryBasedReporter(diagnosticFactory22, Companion.getDefaultDiagnosticMessage$frontend(OptInNames.INSTANCE.buildMessagePrefix("must")));
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory23 = Errors.OPT_IN_USAGE_FUTURE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory23, (String)"OPT_IN_USAGE_FUTURE_ERROR");
        USAGE_DIAGNOSTICS = new OptInReporterMultiplexer(optInDiagnosticReporter, optInDiagnosticReporter2, new OptInFactoryBasedReporter(diagnosticFactory23, Companion.getDefaultDiagnosticMessage$frontend("This declaration is experimental due to signature types and its usage must be marked (will become an error in future releases)")));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\tH\u0002J\u0014\u0010\u0010\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "<init>", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "checkUsageOfKotlinRequiresOptInOrOptIn", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "isUsageAsQualifier", "", "isUsageAsOptInArgument", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$ClassifierUsage\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,542:1\n125#2:543\n125#2:544\n1755#3,3:545\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$ClassifierUsage\n*L\n459#1:543\n460#1:544\n464#1:545,3\n*E\n"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        /*
         * Unable to fully structure code
         */
        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    v0 = targetDescriptor.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
                    name = v0;
                    if ((Intrinsics.areEqual((Object)name, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().shortName()) || Intrinsics.areEqual((Object)name, (Object)OptInNames.INSTANCE.getOPT_IN_FQ_NAME().shortName())) && (Intrinsics.areEqual((Object)(fqName = DescriptorUtilsKt.getFqNameSafe(targetDescriptor)), (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME()) || Intrinsics.areEqual((Object)fqName, (Object)OptInNames.INSTANCE.getOPT_IN_FQ_NAME()))) {
                        this.checkUsageOfKotlinRequiresOptInOrOptIn(element, context);
                        return;
                    }
                    var6_6 = targetDescriptor;
                    targetClass = var6_6 instanceof ClassDescriptor != false ? (ClassDescriptor)targetDescriptor : (var6_6 instanceof TypeAliasDescriptor != false ? ((TypeAliasDescriptor)targetDescriptor).getClassDescriptor() : null);
                    v1 = context.getTrace().getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getBindingContext(...)");
                    bindingContext = v1;
                    if (targetClass != null && org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(OptInUsageChecker.Companion, targetClass, false, false, 3, null) != null && !UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsOptInArgument(element, bindingContext)) {
                        context.getTrace().report(Errors.OPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN.on(element));
                    }
                    var7_7 = element;
                    strict$iv = false;
                    $i$f$getParentOfType = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtImportDirective.class, strict$iv) != null) break block8;
                    strict$iv = element;
                    strict$iv = true;
                    $i$f$getParentOfType = false;
                    containingClass = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, strict$iv);
                    v2 = OptInUsageChecker.Companion;
                    v3 = targetDescriptor;
                    v4 = bindingContext;
                    v5 = context.getLanguageVersionSettings();
                    v6 = null;
                    v7 = false;
                    v8 = false;
                    if (containingClass == null) ** GOTO lbl-1000
                    strict$iv = containingClass.getSuperTypeListEntries();
                    var21_13 = v8;
                    var20_14 = v7;
                    var19_15 = v6;
                    var18_16 = v5;
                    var17_17 = v4;
                    var16_18 = v3;
                    var15_19 = v2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v9 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (KtSuperTypeListEntry)element$iv;
                            $i$a$-any-OptInUsageChecker$ClassifierUsage$check$descriptions$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getTypeAsUserType(), (Object)element.getParent())) continue;
                            v9 = true;
                            break block7;
                        }
                        v9 = false;
                    }
                }
                var22_24 = v9;
                v2 = var15_19;
                v3 = var16_18;
                v4 = var17_17;
                v5 = var18_16;
                v6 = var19_15;
                v7 = var20_14;
                v8 = var21_13;
                if (var22_24) {
                    v10 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v10 = false;
                }
                descriptions = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(v2, v3, v4, v5, v6, v7, v8, v10, 28, null);
                OptInUsageChecker.Companion.reportNotAllowedOptIns(descriptions, element, context);
            }
        }

        private final void checkUsageOfKotlinRequiresOptInOrOptIn(PsiElement element, CheckerContext context2) {
            List<String> optInFqNames = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getOptIn());
            if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.OptInRelease) && !optInFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) {
                context2.getTrace().report(Errors.OPT_IN_IS_NOT_ENABLED.on(element));
            }
            if (!UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsQualifier(element)) {
                context2.getTrace().report(Errors.OPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION.on(element));
            }
        }

        private final boolean isUsageAsQualifier(PsiElement $this$isUsageAsQualifier) {
            if ($this$isUsageAsQualifier instanceof KtSimpleNameExpression) {
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector((KtSimpleNameExpression)$this$isUsageAsQualifier);
                KtExpression qualifier = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)$this$isUsageAsQualifier;
                PsiElement psiElement = qualifier.getParent();
                KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
                if (Intrinsics.areEqual((Object)(ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null), (Object)qualifier)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsageAsOptInArgument(PsiElement $this$isUsageAsOptInArgument, BindingContext bindingContext) {
            KtExpression ktExpression = $this$isUsageAsOptInArgument instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)$this$isUsageAsOptInArgument : null;
            PsiElement qualifier = ktExpression != null && (ktExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(ktExpression)) != null ? (PsiElement)ktExpression : $this$isUsageAsOptInArgument;
            PsiElement parent2 = qualifier.getParent();
            if (!(parent2 instanceof KtClassLiteralExpression)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent() instanceof KtValueArgument)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent().getParent() instanceof KtValueArgumentList)) return false;
            PsiElement entry = ((KtClassLiteralExpression)parent2).getParent().getParent().getParent();
            boolean bl = false;
            if (!(entry instanceof KtAnnotationEntry)) return false;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
            if (annotationDescriptor == null) return false;
            AnnotationDescriptor annotation = annotationDescriptor;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)annotation.getFqName(), (Object)OptInNames.INSTANCE.getOPT_IN_FQ_NAME())) return true;
            if (Intrinsics.areEqual((Object)annotation.getFqName(), (Object)OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) return true;
            if (!Intrinsics.areEqual((Object)annotation.getFqName(), (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) return false;
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000eJ$\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J4\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010JN\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 *\u00020!2\u0006\u0010\u0018\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020!0$2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020&2\b\b\u0002\u0010(\u001a\u00020&J<\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150 *\u0004\u0018\u00010)2\u0006\u0010\u0018\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020!0$2\b\b\u0002\u0010+\u001a\u00020&H\u0002J'\u0010,\u001a\u0004\u0018\u00010\u0015*\u00020-2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010.\u001a\u00020&H\u0000\u00a2\u0006\u0002\b/J\u0018\u00100\u001a\u0004\u0018\u00010\u0015*\u0002012\b\u0010\u0018\u001a\u0004\u0018\u00010\"H\u0002J$\u00102\u001a\u00020&*\u00020\u00172\u0006\u00103\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010.\u001a\u00020&H\u0002J\"\u00102\u001a\u00020&*\u00020\u00172\u0006\u00103\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\"J,\u00102\u001a\u00020&*\u00020\u00172\u0006\u00103\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\"2\u0006\u0010.\u001a\u00020&H\u0002J!\u00105\u001a\u00020&*\u00020\u00172\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b6J\u001c\u00107\u001a\u00020&*\u00020\u00172\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\"H\u0002J\u001c\u00108\u001a\u00020&*\u00020\u00172\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\"H\u0002J0\u00109\u001a\u00020&*\u00020\u00172!\u0010:\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020&0\nH\u0082\bJ>\u0010=\u001a\u00020\u00122\u0006\u0010>\u001a\u00020?2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\n2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Companion;", "", "<init>", "()V", "LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "MESSAGE", "WARNING_LEVEL", "ERROR_LEVEL", "getDefaultDiagnosticMessage", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "", "prefix", "getDefaultDiagnosticMessage$frontend", "USAGE_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "reportNotAllowedOptIns", "", "descriptions", "", "Lorg/jetbrains/kotlin/resolve/checkers/OptInDescription;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "diagnostics", "loadOptIns", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "visited", "", "useFutureError", "", "useMarkersFromContainer", "fromSupertype", "Lorg/jetbrains/kotlin/types/KotlinType;", "visitedClassifiers", "warningsOnly", "loadOptInForMarkerAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "subclassesOnly", "loadOptInForMarkerAnnotation$frontend", "loadSubclassOptInRequired", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "isOptInAllowed", "annotationFqName", "bindingContext", "isDeclarationAnnotatedWith", "isDeclarationAnnotatedWith$frontend", "isElementAnnotatedWithOptIn", "isElementAnnotatedWithSubclassOptInRequired", "anyParentMatches", "predicate", "Lkotlin/ParameterName;", "name", "checkCompilerArguments", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "reportError", "reportWarning", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,542:1\n379#1,4:568\n1863#2,2:543\n1755#2,3:545\n1611#2,9:548\n1863#2:557\n1864#2:559\n1620#2:560\n1368#2:561\n1454#2,5:562\n1755#2,2:572\n1755#2,3:574\n1757#2:577\n1755#2,3:578\n1863#2,2:581\n1#3:558\n1#3:583\n125#4:567\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Companion\n*L\n333#1:568,4\n224#1:543,2\n238#1:545,3\n241#1:548,9\n241#1:557\n241#1:559\n241#1:560\n270#1:561\n270#1:562,5\n348#1:572,2\n352#1:574,3\n348#1:577\n366#1:578,3\n424#1:581,2\n241#1:558\n332#1:567\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<FqName, String> getDefaultDiagnosticMessage$frontend(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return arg_0 -> Companion.getDefaultDiagnosticMessage$lambda$0(prefix, arg_0);
        }

        public final void reportNotAllowedOptIns(@NotNull Collection<OptInDescription> descriptions, @NotNull PsiElement element, @NotNull CheckerContext context2) {
            Intrinsics.checkNotNullParameter(descriptions, (String)"descriptions");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.reportNotAllowedOptIns(descriptions, element, context2.getLanguageVersionSettings(), context2.getTrace(), USAGE_DIAGNOSTICS);
        }

        public final void reportNotAllowedOptIns(@NotNull Collection<OptInDescription> descriptions, @NotNull PsiElement element, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace, @NotNull OptInReporterMultiplexer diagnostics) {
            Intrinsics.checkNotNullParameter(descriptions, (String)"descriptions");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)diagnostics, (String)"diagnostics");
            for (OptInDescription optInDescription : descriptions) {
                OptInDiagnosticReporter optInDiagnosticReporter;
                FqName annotationFqName = optInDescription.component1();
                OptInDescription.Severity severity = optInDescription.component2();
                String message = optInDescription.component3();
                boolean subclassesOnly = optInDescription.component4();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                if (this.isOptInAllowed(element, annotationFqName, languageVersionSettings, bindingContext, subclassesOnly)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        optInDiagnosticReporter = diagnostics.getWarning();
                        break;
                    }
                    case 2: {
                        optInDiagnosticReporter = diagnostics.getError();
                        break;
                    }
                    case 3: {
                        optInDiagnosticReporter = diagnostics.getFutureError();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                OptInDiagnosticReporter diagnostic = optInDiagnosticReporter;
                diagnostic.report(trace, element, annotationFqName, message);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<OptInDescription> loadOptIns(@NotNull DeclarationDescriptor $this$loadOptIns, @NotNull BindingContext context2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Set<DeclarationDescriptor> visited2, boolean useFutureError, boolean useMarkersFromContainer, boolean fromSupertype) {
            SinceKotlinAccessibility accessibility;
            boolean bl;
            SmartSet result2;
            block15: {
                Object it;
                Intrinsics.checkNotNullParameter((Object)$this$loadOptIns, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
                Intrinsics.checkNotNullParameter(visited2, (String)"visited");
                if (!visited2.add($this$loadOptIns)) {
                    return SetsKt.emptySet();
                }
                result2 = SmartSet.Companion.create();
                if ($this$loadOptIns instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$loadOptIns).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)$this$loadOptIns).getOverriddenDescriptors()) {
                        ClassDescriptor it2;
                        Intrinsics.checkNotNull((Object)callableMemberDescriptor);
                        result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, callableMemberDescriptor, context2, languageVersionSettings, visited2, !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, false, 32, null));
                        if (!useMarkersFromContainer) continue;
                        DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)$this$loadOptIns).getContainingDeclaration();
                        if ((declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null) == null) continue;
                        it2 = it2;
                        boolean bl2 = false;
                        result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, it2, context2, languageVersionSettings, visited2, useFutureError, false, false, 48, null));
                    }
                    return (Set)((Object)result2);
                }
                for (AnnotationDescriptor annotationDescriptor : $this$loadOptIns.getAnnotations()) {
                    Collection collection = (Collection)((Object)result2);
                    Object object = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
                    if (object == null || (object = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(this, (ClassDescriptor)object, useFutureError, false, 2, null)) == null) {
                        object = fromSupertype ? this.loadSubclassOptInRequired(annotationDescriptor, context2) : null;
                    }
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(collection, object);
                }
                if ($this$loadOptIns instanceof CallableDescriptor && !($this$loadOptIns instanceof ClassConstructorDescriptor)) {
                    result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, ((CallableDescriptor)$this$loadOptIns).getReturnType(), context2, languageVersionSettings, visited2, false, 8, null));
                    ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)$this$loadOptIns).getExtensionReceiverParameter();
                    result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null, context2, languageVersionSettings, visited2, false, 8, null));
                }
                if ($this$loadOptIns instanceof FunctionDescriptor) {
                    List<ValueParameterDescriptor> list = ((FunctionDescriptor)$this$loadOptIns).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
                    Iterable $this$forEach$iv = list;
                    boolean bl2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (ValueParameterDescriptor)element$iv;
                        boolean bl3 = false;
                        result2.addAll(Companion.loadOptIns(it.getType(), context2, languageVersionSettings, visited2, $this$loadOptIns instanceof ConstructorDescriptor));
                    }
                }
                if ($this$loadOptIns instanceof TypeAliasDescriptor) {
                    result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, ((TypeAliasDescriptor)$this$loadOptIns).getExpandedType(), context2, languageVersionSettings, visited2, false, 8, null));
                }
                Iterable $this$any$iv = $this$loadOptIns.getAnnotations();
                boolean bl3 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (AnnotationDescriptor)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl && (accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility($this$loadOptIns, languageVersionSettings)) instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
                void $this$mapNotNullTo$iv$iv;
                Object element$iv;
                Iterable iterable = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
                SmartSet smartSet = result2;
                boolean $i$f$mapNotNull = false;
                element$iv = iterable;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    OptInDescription it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl5 = false;
                    ClassDescriptor it = (ClassDescriptor)element$iv$iv;
                    boolean bl6 = false;
                    if (org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(Companion, it, useFutureError, false, 2, null) == null) continue;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                smartSet.addAll((List)destination$iv$iv);
            }
            DeclarationDescriptor container = $this$loadOptIns.getContainingDeclaration();
            if (useMarkersFromContainer && container instanceof ClassDescriptor && !($this$loadOptIns instanceof ConstructorDescriptor)) {
                result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, container, context2, languageVersionSettings, visited2, useFutureError, false, false, 48, null));
            }
            return (Set)((Object)result2);
        }

        public static /* synthetic */ Set loadOptIns$default(Companion companion, DeclarationDescriptor declarationDescriptor, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings, Set set, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 4) != 0) {
                set = new LinkedHashSet();
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            return companion.loadOptIns(declarationDescriptor, bindingContext, languageVersionSettings, set, bl, bl2, bl3);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<OptInDescription> loadOptIns(KotlinType $this$loadOptIns, BindingContext context2, LanguageVersionSettings languageVersionSettings, Set<DeclarationDescriptor> visitedClassifiers, boolean warningsOnly) {
            Set set;
            KotlinType kotlinType = $this$loadOptIns;
            if (!(kotlinType != null ? !KotlinTypeKt.isError(kotlinType) : false)) {
                set = SetsKt.emptySet();
            } else if ($this$loadOptIns instanceof AbbreviatedType) {
                Set set2;
                ClassifierDescriptor classifierDescriptor = ((AbbreviatedType)$this$loadOptIns).getAbbreviation().getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, classifierDescriptor, context2, languageVersionSettings, visitedClassifiers, warningsOnly || !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, false, 48, null) : (set2 = null)) == null) {
                    set2 = SetsKt.emptySet();
                }
                set = SetsKt.plus((Set)set2, (Iterable)org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, ((AbbreviatedType)$this$loadOptIns).getExpandedType(), context2, languageVersionSettings, visitedClassifiers, false, 8, null));
            } else {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Set set3;
                ClassifierDescriptor classifierDescriptor = $this$loadOptIns.getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, classifierDescriptor, context2, languageVersionSettings, visitedClassifiers, warningsOnly || !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, false, 48, null) : (set3 = null)) == null) {
                    set3 = SetsKt.emptySet();
                }
                Iterable iterable = $this$loadOptIns.getArguments();
                Set set4 = set3;
                boolean $i$f$flatMap = false;
                void var8_9 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    TypeProjection it = (TypeProjection)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.isStarProjection() ? SetsKt.emptySet() : org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, it.getType(), context2, languageVersionSettings, visitedClassifiers, false, 8, null);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                set = SetsKt.plus((Set)set4, (Iterable)((List)destination$iv$iv));
            }
            return set;
        }

        static /* synthetic */ Set loadOptIns$default(Companion companion, KotlinType kotlinType, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings, Set set, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.loadOptIns(kotlinType, bindingContext, languageVersionSettings, set, bl);
        }

        @Nullable
        public final OptInDescription loadOptInForMarkerAnnotation$frontend(@NotNull ClassDescriptor $this$loadOptInForMarkerAnnotation, boolean useFutureError, boolean subclassesOnly) {
            Name name2;
            Intrinsics.checkNotNullParameter((Object)$this$loadOptInForMarkerAnnotation, (String)"<this>");
            AnnotationDescriptor annotationDescriptor = $this$loadOptInForMarkerAnnotation.getAnnotations().findAnnotation(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME());
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor optInAnnotationDescriptor = annotationDescriptor;
            Map<Name, ConstantValue<?>> arguments = optInAnnotationDescriptor.getAllValueArguments();
            ConstantValue<?> constantValue = arguments.get(LEVEL);
            EnumValue enumValue = constantValue instanceof EnumValue ? (EnumValue)constantValue : null;
            Name name3 = name2 = enumValue != null ? enumValue.getEnumEntryName() : null;
            OptInDescription.Severity severity = Intrinsics.areEqual((Object)name2, (Object)WARNING_LEVEL) ? OptInDescription.Severity.WARNING : (Intrinsics.areEqual((Object)name2, (Object)ERROR_LEVEL) ? (useFutureError ? OptInDescription.Severity.FUTURE_ERROR : OptInDescription.Severity.ERROR) : (OptInDescription.Companion.getDEFAULT_SEVERITY() == OptInDescription.Severity.ERROR && useFutureError ? OptInDescription.Severity.FUTURE_ERROR : OptInDescription.Companion.getDEFAULT_SEVERITY()));
            constantValue = arguments.get(MESSAGE);
            StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
            String message = stringValue != null ? (String)stringValue.getValue() : null;
            return new OptInDescription(DescriptorUtilsKt.getFqNameSafe($this$loadOptInForMarkerAnnotation), severity, message, subclassesOnly);
        }

        public static /* synthetic */ OptInDescription loadOptInForMarkerAnnotation$frontend$default(Companion companion, ClassDescriptor classDescriptor, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            return companion.loadOptInForMarkerAnnotation$frontend(classDescriptor, bl, bl2);
        }

        private final OptInDescription loadSubclassOptInRequired(AnnotationDescriptor $this$loadSubclassOptInRequired, BindingContext context2) {
            ClassDescriptor markerDescriptor;
            if (!Intrinsics.areEqual((Object)$this$loadSubclassOptInRequired.getFqName(), (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) {
                return null;
            }
            ConstantValue<?> markerClass = $this$loadSubclassOptInRequired.getAllValueArguments().get(OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS());
            if (!(markerClass instanceof KClassValue)) {
                return null;
            }
            KClassValue.Value value2 = (KClassValue.Value)((KClassValue)markerClass).getValue();
            if (!(value2 instanceof KClassValue.Value.NormalClass)) {
                return null;
            }
            BindingContext bindingContext = context2;
            ClassDescriptor classDescriptor = markerDescriptor = bindingContext != null ? (ClassDescriptor)bindingContext.get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, ((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName().toUnsafe()) : null;
            return classDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(this, classDescriptor, false, true, 1, null) : null;
        }

        private final boolean isOptInAllowed(PsiElement $this$isOptInAllowed, FqName annotationFqName, CheckerContext context2, boolean subclassesOnly) {
            LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            return this.isOptInAllowed($this$isOptInAllowed, annotationFqName, languageVersionSettings, bindingContext, subclassesOnly);
        }

        public final boolean isOptInAllowed(@NotNull PsiElement $this$isOptInAllowed, @NotNull FqName annotationFqName, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)$this$isOptInAllowed, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return this.isOptInAllowed($this$isOptInAllowed, annotationFqName, languageVersionSettings, bindingContext, false);
        }

        /*
         * Unable to fully structure code
         */
        private final boolean isOptInAllowed(PsiElement $this$isOptInAllowed, FqName annotationFqName, LanguageVersionSettings languageVersionSettings, BindingContext bindingContext, boolean subclassesOnly) {
            if (languageVersionSettings.getFlag(AnalysisFlags.getOptIn()).contains(annotationFqName.asString())) {
                return true;
            }
            if (!subclassesOnly) ** GOTO lbl-1000
            var7_6 = $this$isOptInAllowed;
            strict$iv = true;
            $i$f$getParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtSuperTypeListEntry.class, strict$iv) != null) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            isSubclass = v0;
            $this$getParentOfType$iv = this;
            $this$anyParentMatches$iv = $this$isOptInAllowed;
            $i$f$anyParentMatches = false;
            element$iv = $this$anyParentMatches$iv;
            while (true) {
                element = element$iv;
                $i$a$-anyParentMatches-OptInUsageChecker$Companion$isOptInAllowed$1 = false;
                if (OptInUsageChecker.Companion.isDeclarationAnnotatedWith$frontend(element, annotationFqName, bindingContext) != false || OptInUsageChecker.Companion.isElementAnnotatedWithOptIn(element, annotationFqName, bindingContext) != false || isSubclass != false && OptInUsageChecker.Companion.isElementAnnotatedWithSubclassOptInRequired(element, annotationFqName, bindingContext) != false) {
                    v1 = true;
                    break;
                }
                if (element$iv.getParent() != null) continue;
                v1 = false;
                break;
            }
            return v1;
        }

        public final boolean isDeclarationAnnotatedWith$frontend(@NotNull PsiElement $this$isDeclarationAnnotatedWith, @NotNull FqName annotationFqName, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)$this$isDeclarationAnnotatedWith, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            if (!($this$isDeclarationAnnotatedWith instanceof KtDeclaration)) {
                return false;
            }
            DeclarationDescriptor descriptor = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $this$isDeclarationAnnotatedWith);
            return descriptor != null && descriptor.getAnnotations().hasAnnotation(annotationFqName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithOptIn(PsiElement $this$isElementAnnotatedWithOptIn, FqName annotationFqName, BindingContext bindingContext) {
            boolean bl;
            if (!($this$isElementAnnotatedWithOptIn instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list = ((KtAnnotated)$this$isElementAnnotatedWithOptIn).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationEntries(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl2 = false;
                AnnotationDescriptor descriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
                if (descriptor != null && Intrinsics.areEqual((Object)descriptor.getFqName(), (Object)OptInNames.INSTANCE.getOPT_IN_FQ_NAME())) {
                    ConstantValue<?> annotationClasses = descriptor.getAllValueArguments().get(OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS());
                    if (annotationClasses instanceof ArrayValue) {
                        boolean bl3;
                        Iterable $this$any$iv2 = (Iterable)((ArrayValue)annotationClasses).getValue();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ConstantValue annotationClass = (ConstantValue)element$iv2;
                                boolean bl4 = false;
                                if (annotationClass instanceof KClassValue) {
                                    KClassValue.Value value2 = (KClassValue.Value)((KClassValue)annotationClass).getValue();
                                    boolean bl5 = false;
                                    if (value2 instanceof KClassValue.Value.NormalClass && Intrinsics.areEqual((Object)((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName(), (Object)annotationFqName) && ((KClassValue.Value.NormalClass)value2).getArrayDimensions() == 0) {
                                        return true;
                                    }
                                    boolean bl6 = false;
                                    if (bl6) {
                                        return true;
                                    }
                                }
                                boolean bl7 = false;
                                if (!bl7) continue;
                                return true;
                            }
                            bl3 = false;
                        }
                        if (bl3) {
                            return true;
                        }
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithSubclassOptInRequired(PsiElement $this$isElementAnnotatedWithSubclassOptInRequired, FqName annotationFqName, BindingContext bindingContext) {
            boolean bl;
            if (!($this$isElementAnnotatedWithSubclassOptInRequired instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list = ((KtAnnotated)$this$isElementAnnotatedWithSubclassOptInRequired).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationEntries(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl2 = false;
                AnnotationDescriptor descriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
                if (descriptor != null && Intrinsics.areEqual((Object)descriptor.getFqName(), (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) {
                    ConstantValue<?> annotationClass = descriptor.getAllValueArguments().get(OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS());
                    if (annotationClass instanceof KClassValue) {
                        KClassValue.Value value2 = (KClassValue.Value)((KClassValue)annotationClass).getValue();
                        boolean bl3 = false;
                        if (value2 instanceof KClassValue.Value.NormalClass && Intrinsics.areEqual((Object)((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName(), (Object)annotationFqName) && ((KClassValue.Value.NormalClass)value2).getArrayDimensions() == 0) {
                            return true;
                        }
                        boolean bl4 = false;
                        if (bl4) {
                            return true;
                        }
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public final void checkCompilerArguments(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super String, Unit> reportError, @NotNull Function1<? super String, Unit> reportWarning) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
            Intrinsics.checkNotNullParameter(reportWarning, (String)"reportWarning");
            DeprecationResolver deprecationResolver = new DeprecationResolver(new LockBasedStorageManager("OptInUsageChecker"), languageVersionSettings, DeprecationSettings.Default.INSTANCE);
            Iterable $this$forEach$iv = languageVersionSettings.getFlag(AnalysisFlags.getOptIn());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String fqName = (String)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)fqName, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) continue;
                org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.checkCompilerArguments$checkAnnotation(module2, reportWarning, deprecationResolver, reportError, fqName);
            }
        }

        private static final String getDefaultDiagnosticMessage$lambda$0(String $prefix, FqName fqName) {
            Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            String string2 = fqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            return OptInNames.INSTANCE.buildDefaultDiagnosticMessage($prefix, string2);
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean checkCompilerArguments$checkAnnotation(ModuleDescriptor $module, Function1<? super String, Unit> $reportWarning, DeprecationResolver deprecationResolver, Function1<? super String, Unit> $reportError, String fqName) {
            ClassDescriptor descriptor = DescriptorUtilKt.resolveClassByFqName($module, new FqName(fqName), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
            if (descriptor == null) {
                $reportWarning.invoke((Object)("Opt-in requirement marker " + fqName + " is unresolved. Please make sure it's present in the module dependencies"));
                return false;
            }
            if (org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(Companion, descriptor, false, false, 3, null) == null) {
                $reportWarning.invoke((Object)("Class " + fqName + " is not an opt-in requirement marker"));
                return false;
            }
            for (DescriptorBasedDeprecationInfo deprecation : deprecationResolver.getDeprecations(descriptor)) {
                String string2;
                String string3;
                Function1<? super String, Unit> report2;
                Function1<? super String, Unit> function1;
                switch (WhenMappings.$EnumSwitchMapping$1[deprecation.getDeprecationLevel().ordinal()]) {
                    case 1: {
                        function1 = $reportWarning;
                        break;
                    }
                    case 2: 
                    case 3: {
                        function1 = $reportError;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Function1<? super String, Unit> function12 = report2 = function1;
                StringBuilder stringBuilder = new StringBuilder().append("Opt-in requirement marker ").append(fqName).append(" is deprecated");
                if (deprecation.getMessage() != null) {
                    void it;
                    StringBuilder stringBuilder2 = stringBuilder;
                    Function1<? super String, Unit> function13 = function12;
                    boolean bl = false;
                    String string4 = ". " + (String)it;
                    function12 = function13;
                    stringBuilder = stringBuilder2;
                    string3 = string4;
                } else {
                    string3 = string2 = null;
                }
                if (string3 == null) {
                    string2 = "";
                }
                function12.invoke((Object)stringBuilder.append(string2).toString());
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[OptInDescription.Severity.values().length];
                try {
                    nArray[OptInDescription.Severity.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.FUTURE_ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[DeprecationLevelValue.values().length];
                try {
                    nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "message", "", "frontend"})
    public static interface OptInDiagnosticReporter {
        public void report(@NotNull BindingTrace var1, @NotNull PsiElement var2, @NotNull FqName var3, @Nullable String var4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0016R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInFactoryBasedReporter;", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/name/FqName;", "", "defaultMessage", "Lkotlin/Function1;", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;Lkotlin/jvm/functions/Function1;)V", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "getDefaultMessage", "()Lkotlin/jvm/functions/Function1;", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "fqName", "message", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInFactoryBasedReporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,542:1\n1#2:543\n*E\n"})
    public static final class OptInFactoryBasedReporter
    implements OptInDiagnosticReporter {
        @NotNull
        private final DiagnosticFactory2<PsiElement, FqName, String> factory;
        @NotNull
        private final Function1<FqName, String> defaultMessage;

        public OptInFactoryBasedReporter(@NotNull DiagnosticFactory2<PsiElement, FqName, String> factory2, @NotNull Function1<? super FqName, String> defaultMessage) {
            Intrinsics.checkNotNullParameter(factory2, (String)"factory");
            Intrinsics.checkNotNullParameter(defaultMessage, (String)"defaultMessage");
            this.factory = factory2;
            this.defaultMessage = defaultMessage;
        }

        @NotNull
        public final DiagnosticFactory2<PsiElement, FqName, String> getFactory() {
            return this.factory;
        }

        @NotNull
        public final Function1<FqName, String> getDefaultMessage() {
            return this.defaultMessage;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName, @Nullable String message) {
            String string2;
            FqName fqName2;
            PsiElement psiElement;
            DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2;
            BindingTrace bindingTrace;
            block4: {
                block3: {
                    void it;
                    String string3;
                    Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
                    bindingTrace = trace;
                    diagnosticFactory2 = this.factory;
                    psiElement = element;
                    fqName2 = fqName;
                    string2 = message;
                    if (string2 == null) break block3;
                    String string4 = string3 = string2;
                    FqName fqName3 = fqName2;
                    PsiElement psiElement2 = psiElement;
                    DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory22 = diagnosticFactory2;
                    BindingTrace bindingTrace2 = bindingTrace;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
                    bindingTrace = bindingTrace2;
                    diagnosticFactory2 = diagnosticFactory22;
                    psiElement = psiElement2;
                    fqName2 = fqName3;
                    string2 = bl2 ? string3 : null;
                    if (string2 != null) break block4;
                }
                string2 = (String)this.defaultMessage.invoke((Object)fqName);
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = diagnosticFactory2.on(psiElement, fqName2, string2);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "", "warning", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "error", "futureError", "<init>", "(Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;)V", "getWarning", "()Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "getError", "getFutureError", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class OptInReporterMultiplexer {
        @NotNull
        private final OptInDiagnosticReporter warning;
        @NotNull
        private final OptInDiagnosticReporter error;
        @NotNull
        private final OptInDiagnosticReporter futureError;

        public OptInReporterMultiplexer(@NotNull OptInDiagnosticReporter warning, @NotNull OptInDiagnosticReporter error, @NotNull OptInDiagnosticReporter futureError) {
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)futureError, (String)"futureError");
            this.warning = warning;
            this.error = error;
            this.futureError = futureError;
        }

        @NotNull
        public final OptInDiagnosticReporter getWarning() {
            return this.warning;
        }

        @NotNull
        public final OptInDiagnosticReporter getError() {
            return this.error;
        }

        @NotNull
        public final OptInDiagnosticReporter getFutureError() {
            return this.futureError;
        }

        @NotNull
        public final OptInDiagnosticReporter component1() {
            return this.warning;
        }

        @NotNull
        public final OptInDiagnosticReporter component2() {
            return this.error;
        }

        @NotNull
        public final OptInDiagnosticReporter component3() {
            return this.futureError;
        }

        @NotNull
        public final OptInReporterMultiplexer copy(@NotNull OptInDiagnosticReporter warning, @NotNull OptInDiagnosticReporter error, @NotNull OptInDiagnosticReporter futureError) {
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)futureError, (String)"futureError");
            return new OptInReporterMultiplexer(warning, error, futureError);
        }

        public static /* synthetic */ OptInReporterMultiplexer copy$default(OptInReporterMultiplexer optInReporterMultiplexer, OptInDiagnosticReporter optInDiagnosticReporter, OptInDiagnosticReporter optInDiagnosticReporter2, OptInDiagnosticReporter optInDiagnosticReporter3, int n, Object object) {
            if ((n & 1) != 0) {
                optInDiagnosticReporter = optInReporterMultiplexer.warning;
            }
            if ((n & 2) != 0) {
                optInDiagnosticReporter2 = optInReporterMultiplexer.error;
            }
            if ((n & 4) != 0) {
                optInDiagnosticReporter3 = optInReporterMultiplexer.futureError;
            }
            return optInReporterMultiplexer.copy(optInDiagnosticReporter, optInDiagnosticReporter2, optInDiagnosticReporter3);
        }

        @NotNull
        public String toString() {
            return "OptInReporterMultiplexer(warning=" + this.warning + ", error=" + this.error + ", futureError=" + this.futureError + ')';
        }

        public int hashCode() {
            int result2 = this.warning.hashCode();
            result2 = result2 * 31 + this.error.hashCode();
            result2 = result2 * 31 + this.futureError.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OptInReporterMultiplexer)) {
                return false;
            }
            OptInReporterMultiplexer optInReporterMultiplexer = (OptInReporterMultiplexer)other;
            if (!Intrinsics.areEqual((Object)this.warning, (Object)optInReporterMultiplexer.warning)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.error, (Object)optInReporterMultiplexer.error)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.futureError, (Object)optInReporterMultiplexer.futureError);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Overrides;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Overrides\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,542:1\n1368#2:543\n1454#2,2:544\n1557#2:546\n1628#2,3:547\n1456#2,3:550\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Overrides\n*L\n516#1:543\n516#1:544,2\n518#1:546\n518#1:547,3\n516#1:550,3\n*E\n"})
    public static final class Overrides
    implements DeclarationChecker {
        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(descriptor instanceof CallableMemberDescriptor)) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
            Iterable $this$flatMap$iv = collection;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CallableMemberDescriptor overriddenMember = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)overriddenMember);
                DeclarationDescriptor declarationDescriptor = overriddenMember;
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                Iterable iterable2 = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, declarationDescriptor, bindingContext, context2.getLanguageVersionSettings(), null, false, false, false, 60, null);
                boolean $i$f$map = false;
                void var16_18 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void description;
                    OptInDescription optInDescription = (OptInDescription)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(TuplesKt.to((Object)description, (Object)overriddenMember));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Map optInOverriddenDescriptorMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            for (Map.Entry entry : optInOverriddenDescriptorMap.entrySet()) {
                Pair pair;
                OptInDescription description = (OptInDescription)entry.getKey();
                CallableMemberDescriptor overriddenMember = (CallableMemberDescriptor)entry.getValue();
                if (Companion.isOptInAllowed(declaration, description.getAnnotationFqName(), context2, description.getSubclassesOnly())) continue;
                PsiElement psiElement = declaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration : null;
                if (psiElement == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                    psiElement = declaration;
                }
                PsiElement reportOn = psiElement;
                switch (WhenMappings.$EnumSwitchMapping$0[description.getSeverity().ordinal()]) {
                    case 1: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE, (Object)"should");
                        break;
                    }
                    case 2: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE_ERROR, (Object)"must");
                        break;
                    }
                    case 3: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE_ERROR, (Object)"must");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Pair pair2 = pair;
                DiagnosticFactory2 diagnostic = (DiagnosticFactory2)pair2.component1();
                String defaultMessageVerb = (String)pair2.component2();
                String string2 = overriddenMember.getContainingDeclaration().getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                String string3 = description.getMessage();
                String string4 = description.getAnnotationFqName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
                String message = OptInNames.INSTANCE.buildOverrideMessage(string2, string3, defaultMessageVerb, string4);
                context2.getTrace().report(diagnostic.on(reportOn, description.getAnnotationFqName(), message));
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OptInDescription.Severity.values().length];
                try {
                    nArray[OptInDescription.Severity.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.FUTURE_ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

