/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.KtErroneousCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtErroneousConstantReference;
import org.jetbrains.kotlin.contracts.description.KtErroneousContractElement;
import org.jetbrains.kotlin.contracts.description.KtErroneousIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtErroneousValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirContractElementDeclaration;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "<init>", "()V", "EMPTY_CONTRACT_MESSAGE", "", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkUnresolvedEffects", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "checkContractNotAllowed", "DiagnosticExtractor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,147:1\n12#2,2:148\n40#2:150\n41#2:151\n21#2:152\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n*L\n67#1:148,2\n67#1:150\n68#1:151\n69#1:152\n*E\n"})
public final class FirContractChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirContractChecker INSTANCE = new FirContractChecker();
    @NotNull
    private static final String EMPTY_CONTRACT_MESSAGE = "Empty contract block is not allowed";

    private FirContractChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration instanceof FirContractDescriptionOwner)) {
            return;
        }
        FirContractDescription firContractDescription = ((FirContractDescriptionOwner)((Object)declaration)).getContractDescription();
        FirResolvedContractDescription firResolvedContractDescription = firContractDescription instanceof FirResolvedContractDescription ? (FirResolvedContractDescription)firContractDescription : null;
        if (firResolvedContractDescription == null) {
            return;
        }
        FirResolvedContractDescription contractDescription = firResolvedContractDescription;
        this.checkUnresolvedEffects(contractDescription, context2, reporter);
        this.checkContractNotAllowed(declaration, contractDescription, context2, reporter);
        if (contractDescription.getEffects().isEmpty() && contractDescription.getUnresolvedEffects().isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)contractDescription.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)EMPTY_CONTRACT_MESSAGE, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkUnresolvedEffects(FirResolvedContractDescription contractDescription, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirContractElementDeclaration unresolvedEffect : contractDescription.getUnresolvedEffects()) {
            ConeDiagnostic diagnostic;
            if ((ConeDiagnostic)unresolvedEffect.getEffect().accept(DiagnosticExtractor.INSTANCE, null) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unresolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkContractNotAllowed(FirFunction declaration, FirResolvedContractDescription contractDescription, CheckerContext context2, DiagnosticReporter reporter) {
        block5: {
            KtSourceElement source;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                KtSourceElement ktSourceElement = source = contractDescription.getSource();
                                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                                    return;
                                }
                                if (!(declaration instanceof FirPropertyAccessor) && !(declaration instanceof FirAnonymousFunction)) break block4;
                                FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are only allowed for functions.");
                                break block5;
                            }
                            FirMemberDeclaration $this$isAbstract$iv = declaration;
                            boolean $i$f$isAbstract = false;
                            if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) break block6;
                            FirMemberDeclaration $this$isOpen$iv = declaration;
                            boolean $i$f$isOpen = false;
                            if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) break block6;
                            FirMemberDeclaration $this$isOverride$iv = declaration;
                            boolean $i$f$isOverride = false;
                            if (!$this$isOverride$iv.getStatus().isOverride()) break block7;
                        }
                        FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are not allowed for open or override functions.");
                        break block5;
                    }
                    FirMemberDeclaration $this$isOperator$iv = declaration;
                    boolean $i$f$isOperator = false;
                    if (!$this$isOperator$iv.getStatus().isOperator()) break block8;
                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are not allowed for operator functions.");
                    break block5;
                }
                if (declaration.getSymbol().getCallableId().isLocal()) break block9;
                FirMemberDeclaration $this$visibility$iv = declaration;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block5;
            }
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are not allowed for local functions.");
        }
    }

    private static final void checkContractNotAllowed$contractNotAllowed(DiagnosticReporter $reporter, KtSourceElement source, CheckerContext $context, String message) {
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message, (DiagnosticContext)$context, null, 16, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J1\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\nj\u0002`\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ1\u0010\r\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0010j\u0002`\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J1\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0015j\u0002`\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0016J1\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001aj\u0002`\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u001c\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J1\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020!j\u0002` 2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\"J1\u0010#\u001a\u0004\u0018\u00010\u00022\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020&j\u0002`%2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010'J1\u0010(\u001a\u0004\u0018\u00010\u00022\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020+j\u0002`*2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010,J&\u0010-\u001a\u00020\u00022\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020.2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J1\u0010/\u001a\u0004\u0018\u00010\u00022\u0016\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000202j\u0002`12\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00103J&\u00104\u001a\u00020\u00022\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002062\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00107\u001a\u00020\u00022\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002092\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010:\u001a\u00020\u00022\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020<2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$DiagnosticExtractor;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "()V", "visitContractDescriptionElement", "contractDescriptionElement", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "data", "(Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "(Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "Lorg/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "(Lorg/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "Lorg/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;", "(Lorg/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "visitErroneousCallsEffectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousCallsEffectDeclaration;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "Lorg/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "(Lorg/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "Lorg/jetbrains/kotlin/contracts/description/KtLogicalNot;", "(Lorg/jetbrains/kotlin/contracts/description/KtLogicalNot;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "Lorg/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "(Lorg/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "visitErroneousIsInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "Lorg/jetbrains/kotlin/contracts/description/KtIsNullPredicate;", "(Lorg/jetbrains/kotlin/contracts/description/KtIsNullPredicate;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "visitErroneousConstantReference", "erroneousConstantReference", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousConstantReference;", "visitErroneousValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousValueParameterReference;", "visitErroneousElement", "element", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousContractElement;", "checkers"})
    private static final class DiagnosticExtractor
    extends KtContractDescriptionVisitor {
        @NotNull
        public static final DiagnosticExtractor INSTANCE = new DiagnosticExtractor();

        private DiagnosticExtractor() {
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(contractDescriptionElement, (String)"contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)conditionalEffect.getEffect().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)conditionalEffect.getCondition().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitReturnsEffectDeclaration(@NotNull KtReturnsEffectDeclaration<ConeKotlinType, ConeDiagnostic> returnsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(returnsEffect, (String)"returnsEffect");
            return (ConeDiagnostic)returnsEffect.getValue().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitCallsEffectDeclaration(@NotNull KtCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return (ConeDiagnostic)callsEffect.getValueParameterReference().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousCallsEffectDeclaration(@NotNull KtErroneousCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return callsEffect.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return (ConeDiagnostic)isInstancePredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousIsInstancePredicate(@NotNull KtErroneousIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return isInstancePredicate.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitIsNullPredicate(@NotNull KtIsNullPredicate<ConeKotlinType, ConeDiagnostic> isNullPredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isNullPredicate, (String)"isNullPredicate");
            return (ConeDiagnostic)isNullPredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousConstantReference(@NotNull KtErroneousConstantReference<ConeKotlinType, ConeDiagnostic> erroneousConstantReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(erroneousConstantReference, (String)"erroneousConstantReference");
            return erroneousConstantReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousValueParameterReference(@NotNull KtErroneousValueParameterReference<ConeKotlinType, ConeDiagnostic> valueParameterReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(valueParameterReference, (String)"valueParameterReference");
            return valueParameterReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousElement(@NotNull KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> element, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            return element.getDiagnostic();
        }
    }
}

