/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiReceiverParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordComponent;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;

public enum JavaElementKind {
    ABSTRACT_METHOD("element.abstract_method"),
    ANNOTATION("element.annotation"),
    ANONYMOUS_CLASS("element.anonymous_class"),
    CLASS("element.class"),
    TYPE_PARAMETER("element.type.parameter"),
    CONSTANT("element.constant"),
    CONSTRUCTOR("element.constructor"),
    ENUM("element.enum"),
    ENUM_CONSTANT("element.enum_constant"),
    EXPRESSION("element.expression"),
    FIELD("element.field"),
    INITIALIZER("element.initializer"),
    INTERFACE("element.interface"),
    LABEL("element.label"),
    LOCAL_VARIABLE("element.local_variable"),
    METHOD("element.method"),
    MODULE("element.module"),
    PACKAGE("element.package"),
    PARAMETER("element.parameter"),
    PATTERN_VARIABLE("element.pattern_variable"),
    RECORD("element.record"),
    RECORD_COMPONENT("element.record_component"),
    STATEMENT("element.statement"),
    UNKNOWN("element.unknown"),
    VARIABLE("element.variable"),
    THROWS_LIST("element.throws.list"),
    EXTENDS_LIST("element.extends.list"),
    RECEIVER_PARAMETER("element.receiver.parameter"),
    METHOD_CALL("element.method.call"),
    TYPE_ARGUMENTS("element.type.arguments");

    @PropertyKey(resourceBundle="messages.JavaPsiBundle")
    private final @PropertyKey(resourceBundle="messages.JavaPsiBundle") String propertyKey;

    private JavaElementKind(String key) {
        this.propertyKey = key;
    }

    @Nls
    @NotNull
    public String subject() {
        String string2 = JavaPsiBundle.message(this.propertyKey, 0);
        if (string2 == null) {
            JavaElementKind.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls
    @NotNull
    public String object() {
        String string2 = JavaPsiBundle.message(this.propertyKey, 1);
        if (string2 == null) {
            JavaElementKind.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public JavaElementKind lessDescriptive() {
        switch (this) {
            case ABSTRACT_METHOD: {
                JavaElementKind javaElementKind = METHOD;
                if (javaElementKind == null) {
                    JavaElementKind.$$$reportNull$$$0(2);
                }
                return javaElementKind;
            }
            case LOCAL_VARIABLE: 
            case PATTERN_VARIABLE: {
                JavaElementKind javaElementKind = VARIABLE;
                if (javaElementKind == null) {
                    JavaElementKind.$$$reportNull$$$0(3);
                }
                return javaElementKind;
            }
            case CONSTANT: {
                JavaElementKind javaElementKind = FIELD;
                if (javaElementKind == null) {
                    JavaElementKind.$$$reportNull$$$0(4);
                }
                return javaElementKind;
            }
            case TYPE_PARAMETER: 
            case ANONYMOUS_CLASS: {
                JavaElementKind javaElementKind = CLASS;
                if (javaElementKind == null) {
                    JavaElementKind.$$$reportNull$$$0(5);
                }
                return javaElementKind;
            }
        }
        JavaElementKind javaElementKind = this;
        if (javaElementKind == null) {
            JavaElementKind.$$$reportNull$$$0(6);
        }
        return javaElementKind;
    }

    public static JavaElementKind fromElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaElementKind.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (psiClass instanceof PsiAnonymousClass) {
                return ANONYMOUS_CLASS;
            }
            if (psiClass.isEnum()) {
                return ENUM;
            }
            if (psiClass.isRecord()) {
                return RECORD;
            }
            if (psiClass.isAnnotationType()) {
                return ANNOTATION;
            }
            if (psiClass.isInterface()) {
                return INTERFACE;
            }
            if (psiClass instanceof PsiTypeParameter) {
                return TYPE_PARAMETER;
            }
            return CLASS;
        }
        if (element instanceof PsiMethod) {
            if (((PsiMethod)element).isConstructor()) {
                return CONSTRUCTOR;
            }
            if (((PsiMethod)element).hasModifierProperty("abstract")) {
                return ABSTRACT_METHOD;
            }
            return METHOD;
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            if (field instanceof PsiEnumConstant) {
                return ENUM_CONSTANT;
            }
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return CONSTANT;
            }
            return FIELD;
        }
        if (element instanceof PsiReferenceParameterList) {
            return TYPE_ARGUMENTS;
        }
        if (element instanceof PsiReferenceList) {
            PsiReferenceList.Role role = ((PsiReferenceList)element).getRole();
            if (role == PsiReferenceList.Role.THROWS_LIST) {
                return THROWS_LIST;
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST) {
                return EXTENDS_LIST;
            }
        }
        if (element instanceof PsiAnnotation) {
            return ANNOTATION;
        }
        if (element instanceof PsiRecordComponent) {
            return RECORD_COMPONENT;
        }
        if (element instanceof PsiLocalVariable) {
            return LOCAL_VARIABLE;
        }
        if (element instanceof PsiPatternVariable) {
            return PATTERN_VARIABLE;
        }
        if (element instanceof PsiParameter) {
            return PARAMETER;
        }
        if (element instanceof PsiReceiverParameter) {
            return RECEIVER_PARAMETER;
        }
        if (element instanceof PsiVariable) {
            return VARIABLE;
        }
        if (element instanceof PsiPackage) {
            return PACKAGE;
        }
        if (element instanceof PsiJavaModule) {
            return MODULE;
        }
        if (element instanceof PsiClassInitializer) {
            return INITIALIZER;
        }
        if (element instanceof PsiLabeledStatement) {
            return LABEL;
        }
        if (element instanceof PsiStatement) {
            return STATEMENT;
        }
        if (element instanceof PsiMethodCallExpression) {
            return METHOD_CALL;
        }
        if (element instanceof PsiExpression) {
            return EXPRESSION;
        }
        return UNKNOWN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaElementKind";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "subject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "object";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "lessDescriptive";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaElementKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

