/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImplKt;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00fc\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0000\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0000\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000fH\u0000\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0000\u001a\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00180\u0019H\u0000\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u000e\u0010 \u001a\u0004\u0018\u00010\t*\u00020\u001cH\u0000\u001a \u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u001bH\u0000\u001a\n\u0010&\u001a\u00020\u000f*\u00020\u000f\u001a\n\u0010'\u001a\u00020\u000f*\u00020\u000f\u001a \u0010(\u001a\u0006\u0012\u0002\b\u00030\u0017*\n\u0012\u0006\u0012\u0004\u0018\u00010*0)2\u0006\u0010+\u001a\u00020$H\u0000\u001a\u0014\u0010,\u001a\u0004\u0018\u00010$*\u00020\u00152\u0006\u0010-\u001a\u00020.\u001a\f\u0010/\u001a\u00020\t*\u00020\u000fH\u0000\u001a\f\u00100\u001a\u00020\u001b*\u000201H\u0000\u001a\f\u00102\u001a\u00020\u001b*\u00020$H\u0000\u001a\f\u00103\u001a\u00020\u001b*\u00020$H\u0000\u001a\f\u00104\u001a\u00020\t*\u000201H\u0000\u001a\u0016\u00105\u001a\u00020\u001b*\u0004\u0018\u00010\u000f2\u0006\u00106\u001a\u000207H\u0000\u001a2\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)*\u00020\u000f2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0)H\u0000\u001a\f\u0010?\u001a\u00020\t*\u00020$H\u0000\u001a\f\u0010@\u001a\u00020\t*\u00020$H\u0000\u001a\f\u0010A\u001a\u00020\u001b*\u00020BH\u0000\u001a\u0014\u0010C\u001a\u00020D*\u0002012\u0006\u0010E\u001a\u00020\tH\u0000\u001a\f\u0010F\u001a\u00020\u000f*\u00020\u0015H\u0000\u001a&\u0010G\u001a\u0004\u0018\u00010H*\u00020I2\u0006\u0010J\u001a\u00020\u000f2\u000e\u0010K\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010L0)H\u0000\u001a\u0014\u0010M\u001a\u00020$*\u00020$2\u0006\u0010N\u001a\u00020OH\u0000\u001a \u0010M\u001a\u00020$*\u00020$2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020$0QH\u0000\u001a \u0010S\u001a\u000e\u0012\u0004\u0012\u00020U\u0012\u0004\u0012\u00020V0T*\u0002072\u0006\u0010W\u001a\u00020\u0015H\u0000\u001a\f\u0010X\u001a\u00020\u001b*\u00020\u000fH\u0000\u001a\f\u0010Y\u001a\u00020\u000f*\u000201H\u0000\u001a\u000e\u0010Z\u001a\u00020\u001b*\u0004\u0018\u00010HH\u0000\u001a\f\u0010[\u001a\u00020\u001b*\u00020\u000fH\u0000\u001a\f\u0010\\\u001a\u00020\t*\u00020>H\u0000\u001a\u000e\u0010]\u001a\u00020\t*\u0004\u0018\u00010*H\u0000\u001a\u0014\u0010^\u001a\u00020_*\u00020`2\u0006\u0010a\u001a\u00020bH\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0018\u0010\b\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001a\u0010c\u001a\u0004\u0018\u00010D*\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010e\"\u001a\u0010c\u001a\u0004\u0018\u00010D*\u00020f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010g\"\u001a\u0010h\u001a\u0004\u0018\u00010D*\u00020i8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bj\u0010k\"\u001a\u0010l\u001a\u00020\u001b*\u0004\u0018\u00010D8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bl\u0010m\u00a8\u0006n"}, d2={"intrinsicConstEvaluationAnnotation", "Lorg/jetbrains/kotlin/name/FqName;", "getIntrinsicConstEvaluationAnnotation", "()Lorg/jetbrains/kotlin/name/FqName;", "compileTimeAnnotation", "getCompileTimeAnnotation", "evaluateIntrinsicAnnotation", "getEvaluateIntrinsicAnnotation", "fqName", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "getFqName", "(Lorg/jetbrains/kotlin/ir/IrElement;)Ljava/lang/String;", "getDispatchReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getExtensionReceiver", "getReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getThisReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "toPrimitive", "Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "hasAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "annotation", "getAnnotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "getEvaluateIntrinsicValue", "getPrimitiveClass", "Ljava/lang/Class;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "getFirstNonInterfaceOverridden", "getLastOverridden", "toPrimitiveStateArray", "", "", "type", "getVarargType", "index", "", "getCapitalizedFileName", "isSubclassOfThrowable", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isUnsignedArray", "isPrimitiveArray", "internalName", "checkCast", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getArgsForMethodInvocation", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "methodType", "Ljava/lang/invoke/MethodType;", "args", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "fqNameWithNullability", "getOnlyName", "accessesTopLevelOrObjectField", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "getOriginalPropertyByName", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "name", "getFunctionThatContainsDefaults", "getDefaultWithActualParameters", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "newParent", "actualParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getTypeIfReified", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "loadReifiedTypeArguments", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState;", "expression", "hasFunInterfaceParent", "getSingleAbstractMethod", "isAccessToNotNullableObject", "isAccessorOfPropertyWithBackingField", "unsignedToString", "specialToStringForJs", "toState", "Lorg/jetbrains/kotlin/ir/interpreter/state/Common;", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "property", "getProperty", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "correspondingProperty", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getCorrespondingProperty", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "isConst", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Z", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/ir/interpreter/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 IrSimpleTypeImpl.kt\norg/jetbrains/kotlin/ir/types/impl/IrSimpleTypeImplKt\n+ 7 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 8 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,372:1\n1755#2,3:373\n295#2,2:376\n230#2,2:378\n230#2,2:402\n1557#2:422\n1628#2,3:423\n774#2:427\n865#2,2:428\n1557#2:430\n1628#2,3:431\n808#2,11:434\n626#2,12:445\n808#2,11:457\n808#2,11:468\n1863#2,2:479\n1557#2:481\n1628#2,3:482\n1557#2:485\n1628#2,3:486\n1611#2,9:489\n1863#2:498\n1864#2:500\n1620#2:501\n669#2,11:502\n1557#2:513\n1628#2,3:514\n127#3,2:380\n1251#3,2:386\n1317#3,2:388\n350#3,12:390\n37#4,2:382\n1#5:384\n1#5:499\n156#6:385\n156#6:426\n26#7,16:404\n42#7:421\n28#8:420\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/ir/interpreter/UtilsKt\n*L\n63#1:373,3\n69#1:376,2\n70#1:378,2\n246#1:402,2\n284#1:422\n284#1:423,3\n296#1:427\n296#1:428,2\n296#1:430\n296#1:431,3\n307#1:434,11\n307#1:445,12\n346#1:457,11\n354#1:468,11\n354#1:479,2\n99#1:481\n99#1:482,3\n110#1:485\n110#1:486,3\n144#1:489,9\n144#1:498\n144#1:500\n144#1:501\n144#1:502,11\n241#1:513\n241#1:514,3\n100#1:380,2\n145#1:386,2\n161#1:388,2\n232#1:390,12\n123#1:382,2\n144#1:499\n131#1:385\n290#1:426\n268#1:404,16\n268#1:421\n268#1:420\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final FqName intrinsicConstEvaluationAnnotation = new FqName("kotlin.internal.IntrinsicConstEvaluation");
    @NotNull
    private static final FqName compileTimeAnnotation = new FqName("kotlin.CompileTimeCalculation");
    @NotNull
    private static final FqName evaluateIntrinsicAnnotation = new FqName("kotlin.EvaluateIntrinsic");

    @NotNull
    public static final FqName getIntrinsicConstEvaluationAnnotation() {
        return intrinsicConstEvaluationAnnotation;
    }

    @NotNull
    public static final FqName getCompileTimeAnnotation() {
        return compileTimeAnnotation;
    }

    @NotNull
    public static final FqName getEvaluateIntrinsicAnnotation() {
        return evaluateIntrinsicAnnotation;
    }

    @NotNull
    public static final String getFqName(@NotNull IrElement $this$fqName) {
        Intrinsics.checkNotNullParameter((Object)$this$fqName, (String)"<this>");
        Object object = $this$fqName instanceof IrDeclarationWithName ? (IrDeclarationWithName)$this$fqName : null;
        if (object == null || (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) == null || (object = ((FqName)object).asString()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public static final IrValueParameterSymbol getDispatchReceiver(@NotNull IrFunction $this$getDispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getDispatchReceiver, (String)"<this>");
        IrValueParameter irValueParameter = $this$getDispatchReceiver.getDispatchReceiverParameter();
        return irValueParameter != null ? irValueParameter.getSymbol() : null;
    }

    @Nullable
    public static final IrValueParameterSymbol getExtensionReceiver(@NotNull IrFunction $this$getExtensionReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getExtensionReceiver, (String)"<this>");
        IrValueParameter irValueParameter = $this$getExtensionReceiver.getExtensionReceiverParameter();
        return irValueParameter != null ? irValueParameter.getSymbol() : null;
    }

    @Nullable
    public static final IrSymbol getReceiver(@NotNull IrFunction $this$getReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiver, (String)"<this>");
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver($this$getReceiver);
        return irValueParameterSymbol != null ? (IrSymbol)irValueParameterSymbol : (IrSymbol)UtilsKt.getExtensionReceiver($this$getReceiver);
    }

    @NotNull
    public static final IrValueSymbol getThisReceiver(@NotNull IrFunctionAccessExpression $this$getThisReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getThisReceiver, (String)"<this>");
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(((IrFunctionSymbol)$this$getThisReceiver.getSymbol()).getOwner()).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        return irValueParameter.getSymbol();
    }

    @NotNull
    public static final <T> Primitive<T> toPrimitive(@NotNull IrConst<T> $this$toPrimitive) {
        Primitive<Object> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitive, (String)"<this>");
        if (IrTypePredicatesKt.isByte($this$toPrimitive.getType())) {
            T t = $this$toPrimitive.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            primitive = new Primitive<Object>(((Number)t).byteValue(), $this$toPrimitive.getType());
        } else if (IrTypePredicatesKt.isShort($this$toPrimitive.getType())) {
            T t = $this$toPrimitive.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            primitive = new Primitive<Object>(((Number)t).shortValue(), $this$toPrimitive.getType());
        } else {
            primitive = new Primitive<T>($this$toPrimitive.getValue(), $this$toPrimitive.getType());
        }
        return primitive;
    }

    public static final boolean hasAnnotation(@Nullable IrAnnotationContainer $this$hasAnnotation, @NotNull FqName annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if ($this$hasAnnotation == null) {
            return false;
        }
        if (!((Collection)$this$hasAnnotation.getAnnotations()).isEmpty()) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = $this$hasAnnotation.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrConstructorCall it = (IrConstructorCall)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), (Object)annotation)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    @NotNull
    public static final IrConstructorCall getAnnotation(@NotNull IrAnnotationContainer $this$getAnnotation, @NotNull FqName annotation) {
        IrConstructorCall irConstructorCall;
        Object v0;
        IrConstructorCall it;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$getAnnotation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Iterable $this$firstOrNull$iv = $this$getAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (IrConstructorCall)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), (Object)annotation)) continue;
                v0 = element$iv2;
                break block3;
            }
            v0 = null;
        }
        if ((irConstructorCall = (IrConstructorCall)v0) == null) {
            Object element$iv2;
            block4: {
                IrDeclarationParent irDeclarationParent = ((IrFunction)$this$getAnnotation).getParent();
                Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                Iterable $this$first$iv = ((IrClass)irDeclarationParent).getAnnotations();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    it = (IrConstructorCall)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass((IrDeclaration)it.getSymbol().getOwner())), (Object)annotation)) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            irConstructorCall = (IrConstructorCall)element$iv2;
        }
        return irConstructorCall;
    }

    @Nullable
    public static final String getEvaluateIntrinsicValue(@NotNull IrAnnotationContainer $this$getEvaluateIntrinsicValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getEvaluateIntrinsicValue, (String)"<this>");
        if ($this$getEvaluateIntrinsicValue instanceof IrClass && StringsKt.startsWith$default((String)UtilsKt.getFqName((IrElement)((Object)$this$getEvaluateIntrinsicValue)), (String)"java", (boolean)false, (int)2, null)) {
            return UtilsKt.getFqName((IrElement)((Object)$this$getEvaluateIntrinsicValue));
        }
        if (!UtilsKt.hasAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation)) {
            return null;
        }
        IrExpression irExpression = UtilsKt.getAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation).getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
        return String.valueOf(((IrConst)irExpression).getValue());
    }

    @Nullable
    public static final Class<?> getPrimitiveClass(@NotNull IrType irType, boolean asObject) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(irType);
        switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            case 1: {
                if (asObject) {
                    clazz = Boolean.class;
                    break;
                }
                clazz = Boolean.TYPE;
                break;
            }
            case 2: {
                if (asObject) {
                    clazz = Character.class;
                    break;
                }
                clazz = Character.TYPE;
                break;
            }
            case 3: {
                if (asObject) {
                    clazz = Byte.class;
                    break;
                }
                clazz = Byte.TYPE;
                break;
            }
            case 4: {
                if (asObject) {
                    clazz = Short.class;
                    break;
                }
                clazz = Short.TYPE;
                break;
            }
            case 5: {
                if (asObject) {
                    clazz = Integer.class;
                    break;
                }
                clazz = Integer.TYPE;
                break;
            }
            case 6: {
                if (asObject) {
                    clazz = Float.class;
                    break;
                }
                clazz = Float.TYPE;
                break;
            }
            case 7: {
                if (asObject) {
                    clazz = Long.class;
                    break;
                }
                clazz = Long.TYPE;
                break;
            }
            case 8: {
                if (asObject) {
                    clazz = Double.class;
                    break;
                }
                clazz = Double.TYPE;
                break;
            }
            default: {
                clazz = IrTypePredicatesKt.isString(irType) ? String.class : null;
            }
        }
        return clazz;
    }

    public static /* synthetic */ Class getPrimitiveClass$default(IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UtilsKt.getPrimitiveClass(irType, bl);
    }

    @NotNull
    public static final IrFunction getFirstNonInterfaceOverridden(@NotNull IrFunction $this$getFirstNonInterfaceOverridden) {
        Object element$iv2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$getFirstNonInterfaceOverridden, (String)"<this>");
            if (!($this$getFirstNonInterfaceOverridden instanceof IrSimpleFunction)) {
                return $this$getFirstNonInterfaceOverridden;
            }
            Sequence $this$first$iv = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.generateSequence((Object)CollectionsKt.listOf((Object)$this$getFirstNonInterfaceOverridden), UtilsKt::getFirstNonInterfaceOverridden$lambda$4));
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                boolean bl;
                IrSimpleFunction overriddenFunction = (IrSimpleFunction)element$iv2;
                boolean bl2 = false;
                if (overriddenFunction.isFakeOverride()) {
                    bl = false;
                } else {
                    IrClass irClass = IrUtilsKt.getParentClassOrNull(overriddenFunction);
                    ClassKind kind = irClass != null ? irClass.getKind() : null;
                    bl = kind != ClassKind.INTERFACE;
                }
                if (!bl) continue;
                break block4;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return (IrFunction)element$iv2;
    }

    @NotNull
    public static final IrFunction getLastOverridden(@NotNull IrFunction $this$getLastOverridden) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastOverridden, (String)"<this>");
        if (!($this$getLastOverridden instanceof IrSimpleFunction)) {
            return $this$getLastOverridden;
        }
        return (IrFunction)SequencesKt.last((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.generateSequence((Object)CollectionsKt.listOf((Object)$this$getLastOverridden), UtilsKt::getLastOverridden$lambda$7)));
    }

    @NotNull
    public static final Primitive<?> toPrimitiveStateArray(@NotNull List<? extends Object> $this$toPrimitiveStateArray, @NotNull IrType type2) {
        Primitive<boolean[]> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitiveStateArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (IrTypePredicatesKt.isByteArray(type2)) {
            int n = 0;
            int n2 = $this$toPrimitiveStateArray.size();
            byte[] byArray = new byte[n2];
            while (n < n2) {
                int n3 = n++;
                Object object = $this$toPrimitiveStateArray.get(n3);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                byArray[n3] = ((Number)object).byteValue();
            }
            IrType irType = type2;
            byte[] byArray2 = byArray;
            primitive = new Primitive<boolean[]>((boolean[])byArray2, irType);
        } else if (IrTypePredicatesKt.isCharArray(type2)) {
            int n = 0;
            int n4 = $this$toPrimitiveStateArray.size();
            char[] cArray = new char[n4];
            while (n < n4) {
                int n5 = n++;
                Object object = $this$toPrimitiveStateArray.get(n5);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Char");
                cArray[n5] = ((Character)object).charValue();
            }
            IrType irType = type2;
            char[] cArray2 = cArray;
            primitive = new Primitive<boolean[]>((boolean[])cArray2, irType);
        } else if (IrTypePredicatesKt.isShortArray(type2)) {
            int n = 0;
            int n6 = $this$toPrimitiveStateArray.size();
            short[] sArray = new short[n6];
            while (n < n6) {
                int n7 = n++;
                Object object = $this$toPrimitiveStateArray.get(n7);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                sArray[n7] = ((Number)object).shortValue();
            }
            IrType irType = type2;
            short[] sArray2 = sArray;
            primitive = new Primitive<boolean[]>((boolean[])sArray2, irType);
        } else if (IrTypePredicatesKt.isIntArray(type2)) {
            int n = 0;
            int n8 = $this$toPrimitiveStateArray.size();
            int[] nArray = new int[n8];
            while (n < n8) {
                int n9 = n++;
                Object object = $this$toPrimitiveStateArray.get(n9);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                nArray[n9] = ((Number)object).intValue();
            }
            IrType irType = type2;
            int[] nArray2 = nArray;
            primitive = new Primitive<boolean[]>((boolean[])nArray2, irType);
        } else if (IrTypePredicatesKt.isLongArray(type2)) {
            int n = 0;
            int n10 = $this$toPrimitiveStateArray.size();
            long[] lArray = new long[n10];
            while (n < n10) {
                int n11 = n++;
                Object object = $this$toPrimitiveStateArray.get(n11);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                lArray[n11] = ((Number)object).longValue();
            }
            IrType irType = type2;
            long[] lArray2 = lArray;
            primitive = new Primitive<boolean[]>((boolean[])lArray2, irType);
        } else if (IrTypePredicatesKt.isFloatArray(type2)) {
            int n = 0;
            int n12 = $this$toPrimitiveStateArray.size();
            float[] fArray = new float[n12];
            while (n < n12) {
                int n13 = n++;
                Object object = $this$toPrimitiveStateArray.get(n13);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                fArray[n13] = ((Number)object).floatValue();
            }
            IrType irType = type2;
            float[] fArray2 = fArray;
            primitive = new Primitive<boolean[]>((boolean[])fArray2, irType);
        } else if (IrTypePredicatesKt.isDoubleArray(type2)) {
            int n = 0;
            int n14 = $this$toPrimitiveStateArray.size();
            double[] dArray = new double[n14];
            while (n < n14) {
                int n15 = n++;
                Object object = $this$toPrimitiveStateArray.get(n15);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                dArray[n15] = ((Number)object).doubleValue();
            }
            IrType irType = type2;
            double[] dArray2 = dArray;
            primitive = new Primitive<boolean[]>((boolean[])dArray2, irType);
        } else if (IrTypePredicatesKt.isBooleanArray(type2)) {
            int n = 0;
            int n16 = $this$toPrimitiveStateArray.size();
            boolean[] blArray = new boolean[n16];
            while (n < n16) {
                int n17 = n++;
                Object object = $this$toPrimitiveStateArray.get(n17);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                blArray[n17] = (Boolean)object;
            }
            IrType irType = type2;
            boolean[] blArray2 = blArray;
            primitive = new Primitive<boolean[]>(blArray2, irType);
        } else {
            Collection $this$toTypedArray$iv = $this$toPrimitiveStateArray;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Primitive<Object[]> primitive2 = new Primitive<Object[]>(thisCollection$iv.toArray(new Object[0]), type2);
            primitive = primitive2;
        }
        return primitive;
    }

    @Nullable
    public static final IrType getVarargType(@NotNull IrFunctionAccessExpression $this$getVarargType, int index) {
        IrSimpleTypeBuilder irSimpleTypeBuilder;
        IrSimpleType type2;
        Intrinsics.checkNotNullParameter((Object)$this$getVarargType, (String)"<this>");
        IrType irType = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index).getVarargElementType();
        if (irType == null) {
            return null;
        }
        IrType varargType = irType;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(varargType);
        if (irClassSymbol != null) {
            IrClassSymbol it = irClassSymbol;
            boolean bl = false;
            return ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index).getType();
        }
        IrType it = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index).getType();
        IrSimpleType irSimpleType = it instanceof IrSimpleType ? (IrSimpleType)it : null;
        if (irSimpleType == null) {
            return null;
        }
        IrSimpleType $this$buildSimpleType$iv = type2 = irSimpleType;
        boolean $i$f$buildSimpleType = false;
        IrSimpleTypeBuilder $this$getVarargType_u24lambda_u249 = irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(varargType).getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrTypeParameter");
        IrTypeParameter typeParameter = (IrTypeParameter)irSymbolOwner;
        IrType irType2 = $this$getVarargType.getTypeArgument(typeParameter.getIndex());
        Intrinsics.checkNotNull((Object)irType2);
        $this$getVarargType_u24lambda_u249.setArguments(CollectionsKt.listOf((Object)IrSimpleTypeImplKt.makeTypeProjection(irType2, Variance.OUT_VARIANCE)));
        return IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder);
    }

    @NotNull
    public static final String getCapitalizedFileName(@NotNull IrFunction $this$getCapitalizedFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$getCapitalizedFileName, (String)"<this>");
        Object object = IrUtilsKt.getFileOrNull($this$getCapitalizedFileName);
        if (object == null || (object = IrDeclarationsKt.getName((IrFile)object)) == null || (object = StringsKt.replace$default((String)object, (String)".kt", (String)"Kt", (boolean)false, (int)4, null)) == null || (object = CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)object)) == null) {
            object = "<UNKNOWN>";
        }
        return object;
    }

    public static final boolean isSubclassOfThrowable(@NotNull IrClass $this$isSubclassOfThrowable) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isSubclassOfThrowable, (String)"<this>");
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)$this$isSubclassOfThrowable, UtilsKt::isSubclassOfThrowable$lambda$12);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IrClass it = (IrClass)element$iv;
                boolean bl2 = false;
                if (!IrTypeUtilsKt.isThrowable(IrUtilsKt.getDefaultType(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsignedArray(@NotNull IrType $this$isUnsignedArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsignedArray, (String)"<this>");
        if (!($this$isUnsignedArray instanceof IrSimpleType) || !(((IrSimpleType)$this$isUnsignedArray).getClassifier() instanceof IrClassSymbol)) {
            return false;
        }
        Object[] objectArray = new String[]{"kotlin.UByteArray", "kotlin.UShortArray", "kotlin.UIntArray", "kotlin.ULongArray"};
        return SetsKt.setOf((Object[])objectArray).contains(UtilsKt.getFqName(((IrSimpleType)$this$isUnsignedArray).getClassifier().getOwner()));
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveArray, (String)"<this>");
        Object object = IrTypesKt.getClass($this$isPrimitiveArray);
        if (object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = StandardNames.isPrimitiveArray((FqNameUnsafe)it);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String internalName(@NotNull IrClass $this$internalName) {
        Intrinsics.checkNotNullParameter((Object)$this$internalName, (String)"<this>");
        StringBuilder internalName = new StringBuilder($this$internalName.getName().asString());
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)($this$internalName instanceof IrDeclarationParent ? (IrDeclarationParent)$this$internalName : null), UtilsKt::internalName$lambda$15), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string2;
            IrDeclarationParent it = (IrDeclarationParent)element$iv;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = it;
            if (irDeclarationParent instanceof IrClass) {
                internalName.insert(0, ((IrClass)it).getName().asString() + '$');
                continue;
            }
            if (!(irDeclarationParent instanceof IrPackageFragment)) continue;
            String it2 = string2 = ((IrPackageFragment)it).getPackageFqName().asString();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            String string3 = ((CharSequence)it2).length() > 0 ? string2 : null;
            if (string3 == null) continue;
            it2 = string3;
            boolean bl3 = false;
            internalName.insert(0, it2 + '.');
        }
        String string4 = internalName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    public static final boolean checkCast(@Nullable IrFunction $this$checkCast, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if ($this$checkCast == null) {
            return true;
        }
        IrType actualType = $this$checkCast.getReturnType();
        if (!(IrTypesKt.getClassifierOrNull(actualType) instanceof IrTypeParameterSymbol)) {
            return true;
        }
        State state = environment.getCallStack$ir_interpreter().loadState($this$checkCast.getSymbol());
        Object object = state instanceof KTypeState ? (KTypeState)state : null;
        if (object == null || (object = ((KTypeState)object).getIrType()) == null) {
            return true;
        }
        Object expectedType = object;
        if (IrTypesKt.getClassifierOrFail((IrType)expectedType) instanceof IrTypeParameterSymbol) {
            return true;
        }
        State state2 = environment.getCallStack$ir_interpreter().peekState();
        if (state2 == null) {
            return true;
        }
        State actualState = state2;
        if (actualState instanceof Primitive && ((Primitive)actualState).getValue() == null) {
            return true;
        }
        if (!StateKt.isSubtypeOf(actualState, (IrType)expectedType)) {
            String convertibleClassName = UtilsKt.getFqName(environment.getCallStack$ir_interpreter().popState().getIrClass());
            environment.getCallStack$ir_interpreter().dropFrame();
            ExceptionUtilsKt.handleUserException(new ClassCastException(convertibleClassName + " cannot be cast to " + RenderIrElementKt.render$default((IrType)expectedType, null, 1, null)), environment);
            return false;
        }
        return true;
    }

    @NotNull
    public static final List<Object> getArgsForMethodInvocation(@NotNull IrFunction $this$getArgsForMethodInvocation, @NotNull CallInterceptor callInterceptor, @NotNull MethodType methodType, @NotNull List<? extends State> args) {
        Intrinsics.checkNotNullParameter((Object)$this$getArgsForMethodInvocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        Intrinsics.checkNotNullParameter((Object)methodType, (String)"methodType");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        List argsValues = CollectionsKt.toMutableList((Collection)ProxyKt.wrap(args, callInterceptor, $this$getArgsForMethodInvocation, methodType));
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.lastOrNull($this$getArgsForMethodInvocation.getValueParameters());
        if ((irValueParameter != null ? irValueParameter.getVarargElementType() : null) != null) {
            Object varargValue = CollectionsKt.last((List)argsValues);
            argsValues.remove(argsValues.size() - 1);
            Collection collection = argsValues;
            Intrinsics.checkNotNull((Object)varargValue, (String)"null cannot be cast to non-null type kotlin.Array<out kotlin.Any?>");
            CollectionsKt.addAll((Collection)collection, (Object[])((Object[])varargValue));
        }
        return argsValues;
    }

    @NotNull
    public static final String fqNameWithNullability(@NotNull IrType $this$fqNameWithNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$fqNameWithNullability, (String)"<this>");
        Object object = IrTypesKt.getClassFqName($this$fqNameWithNullability);
        if (object == null || (object = ((FqName)object).toString()) == null) {
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$fqNameWithNullability);
            IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
            Object object2 = irSymbolOwner instanceof IrDeclarationWithName ? (IrDeclarationWithName)irSymbolOwner : null;
            if ((object2 != null && (object2 = object2.getName()) != null ? ((Name)object2).asString() : (object = null)) == null) {
                object = RenderIrElementKt.render$default($this$fqNameWithNullability, null, 1, null);
            }
        }
        Object fqName = object;
        String nullability = $this$fqNameWithNullability instanceof IrSimpleType && ((IrSimpleType)$this$fqNameWithNullability).getNullability() == SimpleTypeNullability.MARKED_NULLABLE ? "?" : "";
        return (String)fqName + nullability;
    }

    @NotNull
    public static final String getOnlyName(@NotNull IrType $this$getOnlyName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getOnlyName, (String)"<this>");
        if (!($this$getOnlyName instanceof IrSimpleType)) {
            return RenderIrElementKt.render$default($this$getOnlyName, null, 1, null);
        }
        StringBuilder stringBuilder = new StringBuilder();
        IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail($this$getOnlyName).getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        StringBuilder stringBuilder2 = stringBuilder.append(((IrDeclarationWithName)irSymbolOwner).getName().asString());
        switch (WhenMappings.$EnumSwitchMapping$1[((IrSimpleType)$this$getOnlyName).getNullability().ordinal()]) {
            case 1: {
                string2 = "?";
                break;
            }
            case 2: {
                string2 = "";
                break;
            }
            case 3: {
                if (IrTypesKt.getClassifierOrNull($this$getOnlyName) instanceof IrTypeParameterSymbol) {
                    string2 = " & Any";
                    break;
                }
                string2 = "";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stringBuilder2.append(string2).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean accessesTopLevelOrObjectField(@NotNull IrFieldAccessExpression $this$accessesTopLevelOrObjectField) {
        Intrinsics.checkNotNullParameter((Object)$this$accessesTopLevelOrObjectField, (String)"<this>");
        if ($this$accessesTopLevelOrObjectField.getReceiver() == null) return true;
        Object object = $this$accessesTopLevelOrObjectField.getReceiver();
        IrSymbolOwner irSymbolOwner = object != null && (object = ((IrExpression)object).getType()) != null && (object = IrTypesKt.getClassifierOrNull((IrType)object)) != null ? object.getOwner() : null;
        if (!(irSymbolOwner instanceof IrClass)) return false;
        IrClass irClass = (IrClass)irSymbolOwner;
        if (irClass == null) return false;
        if (!IrUtilsKt.isObject(irClass)) return false;
        return true;
    }

    @NotNull
    public static final IrProperty getOriginalPropertyByName(@NotNull IrClass $this$getOriginalPropertyByName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$getOriginalPropertyByName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Sequence<IrProperty> $this$single$iv = IrUtilsKt.getProperties($this$getOriginalPropertyByName);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrProperty it = (IrProperty)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name2)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrProperty property = single$iv;
        IrSimpleFunction irSimpleFunction = property.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrProperty irProperty = UtilsKt.getProperty(UtilsKt.getLastOverridden(irSimpleFunction));
        Intrinsics.checkNotNull((Object)irProperty);
        return irProperty;
    }

    @NotNull
    public static final IrFunction getFunctionThatContainsDefaults(@NotNull IrFunctionAccessExpression $this$getFunctionThatContainsDefaults) {
        int element$iv;
        IrFunction irFunction;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$getFunctionThatContainsDefaults, (String)"<this>");
            irFunction = ((IrFunctionSymbol)$this$getFunctionThatContainsDefaults.getSymbol()).getOwner();
            Iterable $this$first$iv = (Iterable)RangesKt.until((int)0, (int)$this$getFunctionThatContainsDefaults.getValueArgumentsCount());
            boolean $i$f$first = false;
            Iterator iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                int it = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                if (!($this$getFunctionThatContainsDefaults.getValueArgument(it) == null)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        int it = element$iv;
        boolean bl = false;
        IrFunction irFunction2 = UtilsKt.getFunctionThatContainsDefaults$lookup(irFunction.getValueParameters().get(it));
        if (irFunction2 == null) {
            irFunction2 = irFunction;
        }
        return irFunction2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final IrExpression getDefaultWithActualParameters(@NotNull IrValueParameter $this$getDefaultWithActualParameters, @NotNull IrFunction newParent, @NotNull List<? extends IrValueDeclaration> actualParameters) {
        IrExpression expression2;
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultWithActualParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        Intrinsics.checkNotNullParameter(actualParameters, (String)"actualParameters");
        IrExpressionBody irExpressionBody = $this$getDefaultWithActualParameters.getDefaultValue();
        IrExpression irExpression = expression2 = irExpressionBody != null ? irExpressionBody.getExpression() : null;
        if (expression2 instanceof IrConst) {
            return expression2;
        }
        IrDeclarationParent irDeclarationParent = $this$getDefaultWithActualParameters.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
        IrFunction parameterOwner = (IrFunction)irDeclarationParent;
        IrElementTransformerVoid transformer2 = new IrElementTransformerVoid(parameterOwner, newParent, actualParameters){
            final /* synthetic */ IrFunction $parameterOwner;
            final /* synthetic */ IrFunction $newParent;
            final /* synthetic */ List<IrValueDeclaration> $actualParameters;
            {
                this.$parameterOwner = $parameterOwner;
                this.$newParent = $newParent;
                this.$actualParameters = $actualParameters;
            }

            public IrExpression visitGetValue(IrGetValue expression2) {
                IrValueDeclaration irValueDeclaration;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrValueDeclaration irValueDeclaration2 = expression2.getSymbol().getOwner();
                IrValueParameter irValueParameter = irValueDeclaration2 instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration2 : null;
                if (irValueParameter == null) {
                    return super.visitGetValue(expression2);
                }
                IrValueParameter parameter = irValueParameter;
                if (!Intrinsics.areEqual((Object)parameter.getParent(), (Object)this.$parameterOwner)) {
                    return super.visitGetValue(expression2);
                }
                if (parameter.getIndex() == -1) {
                    IrValueParameter irValueParameter2 = this.$newParent.getDispatchReceiverParameter();
                    if (irValueParameter2 == null) {
                        irValueParameter2 = this.$newParent.getExtensionReceiverParameter();
                    }
                    irValueDeclaration = irValueParameter2;
                } else {
                    irValueDeclaration = this.$actualParameters.get(parameter.getIndex());
                }
                IrValueDeclaration newParameter = irValueDeclaration;
                int n = expression2.getStartOffset();
                int n2 = expression2.getEndOffset();
                IrType irType = expression2.getType();
                IrValueDeclaration irValueDeclaration3 = newParameter;
                Intrinsics.checkNotNull((Object)irValueDeclaration3);
                return IrGetValueImplKt.IrGetValueImpl$default(n, n2, irType, irValueDeclaration3.getSymbol(), null, 16, null);
            }
        };
        IrExpression irExpression2 = expression2;
        IrExpression irExpression3 = irExpression2;
        if (irExpression2 == null) return null;
        IrElement $this$deepCopyWithSymbols_u24default$iv = irExpression3;
        boolean $i$f$deepCopyWithSymbols = false;
        IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
        boolean $i$f$deepCopyImpl = false;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
        boolean bl = false;
        SymbolRemapper p0 = deepCopySymbolRemapper;
        TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
        IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv, null, 4, null), null);
        if (irElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        }
        IrExpression irExpression4 = (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrExpression)irElement), newParent);
        irExpression3 = irExpression4;
        if (irExpression4 == null) return null;
        IrElement irElement2 = irExpression3.transform((IrElementTransformer)transformer2, (Object)null);
        return irElement2;
    }

    @NotNull
    public static final IrType getTypeIfReified(@NotNull IrType $this$getTypeIfReified, @NotNull CallStack callStack) {
        Intrinsics.checkNotNullParameter((Object)$this$getTypeIfReified, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callStack, (String)"callStack");
        return UtilsKt.getTypeIfReified($this$getTypeIfReified, (Function1<? super IrClassifierSymbol, ? extends IrType>)((Function1)arg_0 -> UtilsKt.getTypeIfReified$lambda$25(callStack, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType getTypeIfReified(@NotNull IrType $this$getTypeIfReified, @NotNull Function1<? super IrClassifierSymbol, ? extends IrType> getType) {
        void $this$mapTo$iv$iv;
        IrSymbolOwner owner;
        Intrinsics.checkNotNullParameter((Object)$this$getTypeIfReified, (String)"<this>");
        Intrinsics.checkNotNullParameter(getType, (String)"getType");
        if (!($this$getTypeIfReified instanceof IrSimpleType)) {
            return $this$getTypeIfReified;
        }
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$getTypeIfReified);
        IrSymbolOwner irSymbolOwner = owner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        if (owner instanceof IrTypeParameter && ((IrTypeParameter)owner).isReified()) {
            Object object = getType.invoke((Object)((IrTypeParameter)owner).getSymbol());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            return IrTypesKt.mergeNullability((IrSimpleType)object, $this$getTypeIfReified);
        }
        Iterable $this$map$iv = ((IrSimpleType)$this$getTypeIfReified).getArguments();
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument;
            void it;
            IrTypeArgument irTypeArgument2 = (IrTypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (IrTypesKt.getTypeOrNull((IrTypeArgument)it) == null) {
                irTypeArgument = it;
            } else {
                IrSymbolOwner typeOwner;
                IrType type2;
                IrClassifierSymbol irClassifierSymbol2 = IrTypesKt.getClassifierOrNull(type2);
                IrSymbolOwner irSymbolOwner2 = typeOwner = irClassifierSymbol2 != null ? irClassifierSymbol2.getOwner() : null;
                if (typeOwner instanceof IrTypeParameter && !((IrTypeParameter)typeOwner).isReified()) {
                    irTypeArgument = it;
                } else {
                    IrType irType = UtilsKt.getTypeIfReified(type2, getType);
                    Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeArgument");
                    irTypeArgument = (IrTypeArgument)((Object)irType);
                }
            }
            collection.add(irTypeArgument);
        }
        List newArguments2 = (List)destination$iv$iv;
        IrSimpleType $this$buildSimpleType$iv = (IrSimpleType)$this$getTypeIfReified;
        boolean $i$f$buildSimpleType = false;
        Object $this$getTypeIfReified_u24lambda_u2427 = object = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        ((IrSimpleTypeBuilder)$this$getTypeIfReified_u24lambda_u2427).setArguments(newArguments2);
        return IrSimpleTypeImplKt.buildSimpleType((IrSimpleTypeBuilder)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<IrTypeParameterSymbol, KTypeState> loadReifiedTypeArguments(@NotNull IrInterpreterEnvironment $this$loadReifiedTypeArguments, @NotNull IrFunctionAccessExpression expression2) {
        void $this$mapTo$iv$iv;
        IrTypeParameter it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadReifiedTypeArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Iterable $this$filter$iv = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getTypeParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            if (!it.isReified()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((List)destination$iv$iv, arg_0 -> UtilsKt.loadReifiedTypeArguments$lambda$30(expression2, $this$loadReifiedTypeArguments, arg_0));
    }

    public static final boolean hasFunInterfaceParent(@NotNull IrFunction $this$hasFunInterfaceParent) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFunInterfaceParent, (String)"<this>");
        IrClass irClass = IrUtilsKt.getParentClassOrNull($this$hasFunInterfaceParent);
        return irClass != null ? irClass.isFun() : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrFunction getSingleAbstractMethod(@NotNull IrClass $this$getSingleAbstractMethod) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSingleAbstractMethod, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$getSingleAbstractMethod.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$single$iv = (List)destination$iv$iv;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!(it.getModality() == Modality.ABSTRACT)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (IrFunction)((Object)iterable);
    }

    public static final boolean isAccessToNotNullableObject(@Nullable IrExpression $this$isAccessToNotNullableObject) {
        boolean bl;
        IrExpression irExpression = $this$isAccessToNotNullableObject;
        if (irExpression instanceof IrGetObjectValue) {
            bl = !org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(((IrGetObjectValue)$this$isAccessToNotNullableObject).getType());
        } else if (irExpression instanceof IrGetValue) {
            IrClass expectedClass;
            IrValueDeclaration owner = ((IrGetValue)$this$isAccessToNotNullableObject).getSymbol().getOwner();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(((IrGetValue)$this$isAccessToNotNullableObject).getType());
            IrClass irClass = expectedClass = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
            if (expectedClass == null || !IrUtilsKt.isObject(expectedClass) || org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(((IrGetValue)$this$isAccessToNotNullableObject).getType())) {
                return false;
            }
            bl = Intrinsics.areEqual((Object)owner.getOrigin(), (Object)IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER()) || Intrinsics.areEqual((Object)owner.getName().asString(), (Object)"<this>");
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isAccessorOfPropertyWithBackingField(@NotNull IrFunction $this$isAccessorOfPropertyWithBackingField) {
        Intrinsics.checkNotNullParameter((Object)$this$isAccessorOfPropertyWithBackingField, (String)"<this>");
        IrDeclarationBase irDeclarationBase = UtilsKt.getProperty($this$isAccessorOfPropertyWithBackingField);
        return (irDeclarationBase != null && (irDeclarationBase = ((IrProperty)irDeclarationBase).getBackingField()) != null ? ((IrField)irDeclarationBase).getInitializer() : null) != null;
    }

    @NotNull
    public static final String unsignedToString(@NotNull State $this$unsignedToString) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$unsignedToString, (String)"<this>");
        Object object = CollectionsKt.single((Iterable)$this$unsignedToString.getFields().values());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
        Object value2 = ((Primitive)object).getValue();
        if (value2 instanceof Byte) {
            string2 = UByte.toString-impl((byte)UByte.constructor-impl((byte)((Number)value2).byteValue()));
        } else if (value2 instanceof Short) {
            string2 = UShort.toString-impl((short)UShort.constructor-impl((short)((Number)value2).shortValue()));
        } else if (value2 instanceof Integer) {
            string2 = Integer.toUnsignedString(UInt.constructor-impl((int)((Number)value2).intValue()));
        } else {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Number");
            string2 = Long.toUnsignedString(ULong.constructor-impl((long)((Number)value2).longValue()));
        }
        return string2;
    }

    @NotNull
    public static final String specialToStringForJs(@Nullable Object $this$specialToStringForJs) {
        return $this$specialToStringForJs instanceof Float && !Float.isInfinite(((Number)$this$specialToStringForJs).floatValue()) && Intrinsics.areEqual((float)((float)Math.floor(((Number)$this$specialToStringForJs).floatValue())), (Float)((Float)$this$specialToStringForJs)) ? String.valueOf((int)((Number)$this$specialToStringForJs).floatValue()) : ($this$specialToStringForJs instanceof Double && !Double.isInfinite(((Number)$this$specialToStringForJs).doubleValue()) && Intrinsics.areEqual((double)Math.floor(((Number)$this$specialToStringForJs).doubleValue()), (Double)((Double)$this$specialToStringForJs)) ? String.valueOf((long)((Number)$this$specialToStringForJs).doubleValue()) : String.valueOf($this$specialToStringForJs));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Common toState(@NotNull IrEnumEntry $this$toState, @NotNull IrBuiltIns irBuiltIns) {
        Object[] $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toState, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        IrClass enumClass = IrUtilsKt.getParentAsClass((IrDeclaration)$this$toState.getSymbol().getOwner());
        Iterable $this$filterIsInstance$iv = enumClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object t : $this$filterIsInstanceTo$iv$iv) {
            if (!(t instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(t);
        }
        List enumEntries = (List)destination$iv$iv;
        IrClass irClass = $this$toState.getCorrespondingClass();
        if (irClass == null) {
            irClass = enumClass;
        }
        Common enumClassObject = new Common(irClass);
        if (!((Collection)enumEntries).isEmpty()) {
            void $this$filterIsInstanceTo$iv$iv2;
            $this$filterIsInstanceTo$iv$iv = new Primitive[]{new Primitive<String>($this$toState.getName().asString(), irBuiltIns.getStringType()), new Primitive<Integer>(enumEntries.indexOf($this$toState), irBuiltIns.getIntType())};
            List valueArguments = CollectionsKt.listOf((Object[])$this$filterIsInstanceTo$iv$iv);
            Iterable $this$filterIsInstance$iv2 = ((IrClass)irBuiltIns.getEnumClass().getOwner()).getDeclarations();
            boolean $i$f$filterIsInstance2 = false;
            Iterable $i$f$filterIsInstanceTo22 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean bl = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)((List)destination$iv$iv2), (Iterable)valueArguments);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl2 = false;
                IrProperty property = (IrProperty)pair.component1();
                Primitive argument = (Primitive)pair.component2();
                enumClassObject.setField(property.getSymbol(), argument);
            }
        }
        return enumClassObject;
    }

    @Nullable
    public static final IrProperty getProperty(@NotNull IrFunction $this$property) {
        Intrinsics.checkNotNullParameter((Object)$this$property, (String)"<this>");
        Object object = $this$property instanceof IrSimpleFunction ? (IrSimpleFunction)$this$property : null;
        return object != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null ? (IrProperty)object.getOwner() : null;
    }

    @Nullable
    public static final IrProperty getProperty(@NotNull IrField $this$property) {
        Intrinsics.checkNotNullParameter((Object)$this$property, (String)"<this>");
        IrPropertySymbol irPropertySymbol = $this$property.getCorrespondingPropertySymbol();
        return irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
    }

    @Nullable
    public static final IrProperty getCorrespondingProperty(@NotNull IrCall $this$correspondingProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$correspondingProperty, (String)"<this>");
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$correspondingProperty.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        return irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
    }

    public static final boolean isConst(@Nullable IrProperty $this$isConst) {
        IrProperty irProperty = $this$isConst;
        return irProperty != null ? irProperty.isConst() : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getFirstNonInterfaceOverridden$lambda$4(List it) {
        List list;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = (IrSimpleFunction)CollectionsKt.firstOrNull((List)it);
        if (object != null && (object = ((IrSimpleFunction)object).getOverriddenSymbols()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void overriddenSymbol;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((IrSimpleFunction)overriddenSymbol.getOwner());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List getLastOverridden$lambda$7(List it) {
        List list;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = (IrSimpleFunction)CollectionsKt.firstOrNull((List)it);
        if (object != null && (object = ((IrSimpleFunction)object).getOverriddenSymbols()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((IrSimpleFunction)it2.getOwner());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrClass isSubclassOfThrowable$lambda$12(IrClass irClass) {
        Iterable iterable;
        block4: {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            if (IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(irClass))) {
                return null;
            }
            Iterable $this$mapNotNull$iv = irClass.getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl2 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrClass it = (IrClass)element$iv;
                boolean bl = false;
                if (!IrUtilsKt.isClass(it)) continue;
                if (found$iv) {
                    iterable = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            iterable = !found$iv ? null : iterable2;
        }
        return (IrClass)((Object)iterable);
    }

    private static final IrDeclarationParent internalName$lambda$15(IrDeclarationParent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrDeclaration irDeclaration2 = it instanceof IrDeclaration ? (IrDeclaration)((Object)it) : null;
        return irDeclaration2 != null ? irDeclaration2.getParent() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrFunction getFunctionThatContainsDefaults$lookup(IrValueParameter $this$getFunctionThatContainsDefaults_u24lookup) {
        IrElementBase irElementBase;
        block6: {
            Object object;
            IrSimpleFunction irSimpleFunction;
            block7: {
                irElementBase = $this$getFunctionThatContainsDefaults_u24lookup.getDefaultValue();
                if (irElementBase == null) break block7;
                IrExpressionBody it = irElementBase;
                boolean bl = false;
                IrDeclarationParent irDeclarationParent = $this$getFunctionThatContainsDefaults_u24lookup.getParent();
                Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                IrFunction irFunction = (IrFunction)irDeclarationParent;
                irElementBase = irFunction;
                if (irFunction != null) break block6;
            }
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction = (object = $this$getFunctionThatContainsDefaults_u24lookup.getParent()) instanceof IrSimpleFunction ? (IrSimpleFunction)object : null;
            if (irSimpleFunction != null && (object = irSimpleFunction.getOverriddenSymbols()) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)object;
                boolean $i$f$map = false;
                IrFunction irFunction = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((IrSimpleFunction)it.getOwner()).getValueParameters().get($this$getFunctionThatContainsDefaults_u24lookup.getIndex()));
                }
                for (IrValueParameter it : (Iterable)((List)destination$iv$iv)) {
                    boolean bl = false;
                    irFunction = UtilsKt.getFunctionThatContainsDefaults$lookup(it);
                    if (irFunction == null) continue;
                    irElementBase = irFunction;
                    break block6;
                }
                irElementBase = null;
            } else {
                irElementBase = null;
            }
        }
        return irElementBase;
    }

    private static final IrType getTypeIfReified$lambda$25(CallStack $callStack, IrClassifierSymbol it) {
        Intrinsics.checkNotNullParameter((Object)$callStack, (String)"$callStack");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        State state = $callStack.loadState(it);
        Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
        return ((KTypeState)state).getIrType();
    }

    private static final KTypeState loadReifiedTypeArguments$lambda$30(IrFunctionAccessExpression $expression, IrInterpreterEnvironment $this_loadReifiedTypeArguments, IrTypeParameterSymbol it) {
        Intrinsics.checkNotNullParameter((Object)$expression, (String)"$expression");
        Intrinsics.checkNotNullParameter((Object)$this_loadReifiedTypeArguments, (String)"$this_loadReifiedTypeArguments");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrType irType = $expression.getTypeArgument(((IrTypeParameter)it.getOwner()).getIndex());
        Intrinsics.checkNotNull((Object)irType);
        IrType reifiedType = UtilsKt.getTypeIfReified(irType, $this_loadReifiedTypeArguments.getCallStack$ir_interpreter());
        return new KTypeState(reifiedType, (IrClass)$this_loadReifiedTypeArguments.getKTypeClass$ir_interpreter().getOwner());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SimpleTypeNullability.values().length];
            try {
                nArray[SimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

