/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.caches.FirLazyValue;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.deserialization.ClassDeserializationKt;
import org.jetbrains.kotlin.fir.deserialization.FirBuiltinAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.FirMemberDeserializer;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.impl.BinaryVersionAndPackageFragment;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirBuiltinSyntheticFunctionInterfaceProvider;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001-B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J*\u0010 \u001a\u00020!2\u0010\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0#2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0017J&\u0010(\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020)0#2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0017J&\u0010*\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020)0#2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0004J&\u0010+\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020,0#2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;)V", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "syntheticFunctionInterfaceProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSyntheticFunctionInterfaceProvider;", "allPackageFragments", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider$BuiltInsPackageFragment;", "loadBuiltIns", "getPackage", "fqName", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelFunctionSymbolsToByPackageFragments", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "BuiltInsPackageFragment", "fir-deserialization"})
@SourceDebugExtension(value={"SMAP\nFirBuiltinSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBuiltinSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,231:1\n1485#2:232\n1510#2,3:233\n1513#2,3:243\n1557#2:246\n1628#2,3:247\n1454#2,5:250\n1454#2,5:255\n381#3,7:236\n*S KotlinDebug\n*F\n+ 1 FirBuiltinSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider\n*L\n63#1:232\n63#1:233,3\n63#1:243,3\n70#1:246\n70#1:247,3\n113#1:250,5\n124#1:255,5\n63#1:236,7\n*E\n"})
public class FirBuiltinSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final FirModuleData moduleData;
    @NotNull
    private final FirKotlinScopeProvider kotlinScopeProvider;
    @NotNull
    private final FirBuiltinSyntheticFunctionInterfaceProvider syntheticFunctionInterfaceProvider;
    @NotNull
    private final Map<FqName, List<BuiltInsPackageFragment>> allPackageFragments;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    /*
     * WARNING - void declaration
     */
    public FirBuiltinSymbolProvider(@NotNull FirSession session2, @NotNull FirModuleData moduleData, @NotNull FirKotlinScopeProvider kotlinScopeProvider) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider, (String)"kotlinScopeProvider");
        super(session2);
        this.moduleData = moduleData;
        this.kotlinScopeProvider = kotlinScopeProvider;
        this.syntheticFunctionInterfaceProvider = new FirBuiltinSyntheticFunctionInterfaceProvider(session2, this.moduleData, this.kotlinScopeProvider);
        Iterable iterable = this.loadBuiltIns();
        FirBuiltinSymbolProvider firBuiltinSymbolProvider = this;
        boolean $i$f$groupBy = false;
        void var6_7 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BuiltInsPackageFragment it = (BuiltInsPackageFragment)element$iv$iv;
            boolean bl = false;
            FqName key$iv$iv = it.getFqName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        firBuiltinSymbolProvider.allPackageFragments = destination$iv$iv;
        this.symbolNamesProvider = new FirSymbolNamesProvider(this){
            final /* synthetic */ FirBuiltinSymbolProvider this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public Set<String> getPackageNames() {
                Set set;
                Collection $this$mapToSetOrEmpty$iv = FirBuiltinSymbolProvider.access$getAllPackageFragments$p(this.this$0).keySet();
                boolean $i$f$mapToSetOrEmpty = false;
                if (!$this$mapToSetOrEmpty$iv.isEmpty()) {
                    void destination$iv$iv;
                    void $this$mapTo$iv$iv;
                    Iterable iterable = $this$mapToSetOrEmpty$iv;
                    Collection collection = new LinkedHashSet<E>();
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        FqName fqName = (FqName)item$iv$iv;
                        void var10_10 = destination$iv$iv;
                        boolean bl = false;
                        var10_10.add(p0.asString());
                    }
                    set = (Set)destination$iv$iv;
                } else {
                    set = SetsKt.emptySet();
                }
                return set;
            }

            public boolean getHasSpecificClassifierPackageNamesComputation() {
                return false;
            }

            public boolean getHasSpecificCallablePackageNamesComputation() {
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public Set<Name> getTopLevelClassifierNamesInPackage(FqName packageFqName) {
                Set set;
                Set set2;
                Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
                List list = (List)FirBuiltinSymbolProvider.access$getAllPackageFragments$p(this.this$0).get(packageFqName);
                if (list != null) {
                    void var3_3;
                    void $this$flatMapTo$iv;
                    Iterable iterable = list;
                    Collection destination$iv = new LinkedHashSet<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv : $this$flatMapTo$iv) {
                        void $this$mapTo$iv$iv;
                        BuiltInsPackageFragment fragment = (BuiltInsPackageFragment)element$iv;
                        boolean bl = false;
                        Iterable $this$map$iv = fragment.getClassDataFinder().getAllClassIds();
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ClassId classId = (ClassId)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it.getShortClassName());
                        }
                        Iterable list$iv = (List)destination$iv$iv;
                        CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                    }
                    set2 = (Set)var3_3;
                } else {
                    set2 = set = null;
                }
                if (set2 == null) {
                    set = SetsKt.emptySet();
                }
                return set;
            }

            /*
             * WARNING - void declaration
             */
            public Set<Name> getTopLevelCallableNamesInPackage(FqName packageFqName) {
                Set set;
                Set set2;
                Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
                List list = (List)FirBuiltinSymbolProvider.access$getAllPackageFragments$p(this.this$0).get(packageFqName);
                if (list != null) {
                    void var3_3;
                    void $this$flatMapTo$iv;
                    Iterable iterable = list;
                    Collection destination$iv = new LinkedHashSet<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv : $this$flatMapTo$iv) {
                        BuiltInsPackageFragment it = (BuiltInsPackageFragment)element$iv;
                        boolean bl = false;
                        Iterable list$iv = it.getTopLevelCallableNames();
                        CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                    }
                    set2 = (Set)var3_3;
                } else {
                    set2 = set = null;
                }
                if (set2 == null) {
                    set = SetsKt.emptySet();
                }
                return set;
            }

            public boolean getMayHaveSyntheticFunctionTypes() {
                return true;
            }

            public boolean mayHaveSyntheticFunctionType(ClassId classId) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                return FirBuiltinSymbolProvider.access$getSyntheticFunctionInterfaceProvider$p(this.this$0).getSymbolNamesProvider().mayHaveSyntheticFunctionType(classId);
            }
        };
    }

    @NotNull
    public final FirModuleData getModuleData() {
        return this.moduleData;
    }

    @NotNull
    public final FirKotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BuiltInsPackageFragment> loadBuiltIns() {
        void $this$mapTo$iv$iv;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Function1 streamProvider = arg_0 -> FirBuiltinSymbolProvider.loadBuiltIns$lambda$1(classLoader, arg_0);
        Set<FqName> packageFqNames = StandardClassIds.INSTANCE.getBuiltInsPackages();
        Iterable $this$map$iv = packageFqNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            InputStream inputStream;
            void fqName;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String resourcePath = BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath((FqName)fqName);
            if ((InputStream)streamProvider.invoke((Object)resourcePath) == null) {
                throw new IllegalStateException("Resource not found in classpath: " + resourcePath);
            }
            collection.add(new BuiltInsPackageFragment(inputStream, (FqName)fqName, this.moduleData, this.kotlinScopeProvider));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        if (this.allPackageFragments.containsKey(fqName)) {
            return fqName;
        }
        return null;
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        List<BuiltInsPackageFragment> list;
        block5: {
            block4: {
                Object object;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                    list = this.allPackageFragments.get(classId.getPackageFqName());
                    if (list == null) break block4;
                    for (BuiltInsPackageFragment it : (Iterable)list) {
                        boolean bl = false;
                        FirRegularClassSymbol firRegularClassSymbol = it.getClassLikeSymbolByClassId(classId);
                        if (firRegularClassSymbol == null) continue;
                        object = firRegularClassSymbol;
                        break block3;
                    }
                    object = list = null;
                }
                if (object != null) break block5;
            }
            list = this.syntheticFunctionInterfaceProvider.getClassLikeSymbolByClassId(classId);
        }
        return list;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        block1: {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            List<BuiltInsPackageFragment> list = this.allPackageFragments.get(packageFqName);
            if (list == null) break block1;
            Iterable $this$flatMapTo$iv = list;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                BuiltInsPackageFragment it = (BuiltInsPackageFragment)element$iv;
                boolean bl = false;
                Iterable list$iv = it.getTopLevelCallableSymbols(name2);
                CollectionsKt.addAll((Collection)destination, (Iterable)list$iv);
            }
            List cfr_ignored_0 = (List)((Collection)destination);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.getTopLevelFunctionSymbolsToByPackageFragments(destination, packageFqName, name2);
    }

    protected final void getTopLevelFunctionSymbolsToByPackageFragments(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        block1: {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            List<BuiltInsPackageFragment> list = this.allPackageFragments.get(packageFqName);
            if (list == null) break block1;
            Iterable $this$flatMapTo$iv = list;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                BuiltInsPackageFragment it = (BuiltInsPackageFragment)element$iv;
                boolean bl = false;
                Iterable list$iv = it.getTopLevelFunctionSymbols(name2);
                CollectionsKt.addAll((Collection)destination, (Iterable)list$iv);
            }
            List cfr_ignored_0 = (List)((Collection)destination);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    private static final InputStream loadBuiltIns$lambda$1(ClassLoader $classLoader, String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = $classLoader;
        if (object == null || (object = ((ClassLoader)object).getResourceAsStream(path)) == null) {
            object = ClassLoader.getSystemResourceAsStream(path);
        }
        return object;
    }

    public static final /* synthetic */ Map access$getAllPackageFragments$p(FirBuiltinSymbolProvider $this) {
        return $this.allPackageFragments;
    }

    public static final /* synthetic */ FirBuiltinSyntheticFunctionInterfaceProvider access$getSyntheticFunctionInterfaceProvider$p(FirBuiltinSymbolProvider $this) {
        return $this.syntheticFunctionInterfaceProvider;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u00104\u001a\u0004\u0018\u00010+2\u0006\u00105\u001a\u00020*J\u001e\u00106\u001a\u0004\u0018\u00010+2\u0006\u00105\u001a\u00020*2\n\b\u0002\u00107\u001a\u0004\u0018\u00010,H\u0002J\u0018\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003090/2\u0006\u0010:\u001a\u00020.J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020.0<J\u0014\u0010=\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010:\u001a\u00020.R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%R\"\u0010(\u001a\u0016\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+\u0012\u0006\u0012\u0004\u0018\u00010,0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010-\u001a\u001c\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u0002000/\u0012\u0006\u0012\u0004\u0018\u0001010)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0/03X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider$BuiltInsPackageFragment;", "", "stream", "Ljava/io/InputStream;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "<init>", "(Ljava/io/InputStream;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "binaryVersionAndPackageFragment", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/BinaryVersionAndPackageFragment;", "version", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "packageProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getPackageProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder;", "getClassDataFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder;", "memberDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/FirMemberDeserializer;", "getMemberDeserializer", "()Lorg/jetbrains/kotlin/fir/deserialization/FirMemberDeserializer;", "memberDeserializer$delegate", "Lkotlin/Lazy;", "classCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "functionCache", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "", "functionsNameCache", "Lorg/jetbrains/kotlin/fir/caches/FirLazyValue;", "getClassLikeSymbolByClassId", "classId", "findAndDeserializeClass", "parentContext", "getTopLevelCallableSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "getTopLevelCallableNames", "", "getTopLevelFunctionSymbols", "fir-deserialization"})
    @SourceDebugExtension(value={"SMAP\nFirBuiltinSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBuiltinSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider$BuiltInsPackageFragment\n+ 2 FirCachesFactory.kt\norg/jetbrains/kotlin/fir/caches/FirCachesFactoryKt\n+ 3 FirCacheWithPostCompute.kt\norg/jetbrains/kotlin/fir/caches/FirCacheWithPostComputeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n69#2,3:232\n17#3:235\n1557#4:236\n1628#4,3:237\n*S KotlinDebug\n*F\n+ 1 FirBuiltinSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirBuiltinSymbolProvider$BuiltInsPackageFragment\n*L\n172#1:232,3\n203#1:235\n179#1:236\n179#1:237,3\n*E\n"})
    private static final class BuiltInsPackageFragment {
        @NotNull
        private final FqName fqName;
        @NotNull
        private final FirModuleData moduleData;
        @NotNull
        private final FirKotlinScopeProvider kotlinScopeProvider;
        @NotNull
        private final BinaryVersionAndPackageFragment binaryVersionAndPackageFragment;
        @NotNull
        private final NameResolverImpl nameResolver;
        @NotNull
        private final ProtoBasedClassDataFinder classDataFinder;
        @NotNull
        private final Lazy memberDeserializer$delegate;
        @NotNull
        private final FirCache<ClassId, FirRegularClassSymbol, FirDeserializationContext> classCache;
        @NotNull
        private final FirCache functionCache;
        @NotNull
        private final FirLazyValue<List<Name>> functionsNameCache;

        public BuiltInsPackageFragment(@NotNull InputStream stream, @NotNull FqName fqName, @NotNull FirModuleData moduleData, @NotNull FirKotlinScopeProvider kotlinScopeProvider) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
            Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider, (String)"kotlinScopeProvider");
            this.fqName = fqName;
            this.moduleData = moduleData;
            this.kotlinScopeProvider = kotlinScopeProvider;
            this.binaryVersionAndPackageFragment = BinaryVersionAndPackageFragment.Companion.createFromStream(stream);
            ProtoBuf.StringTable stringTable2 = this.getPackageProto().getStrings();
            Intrinsics.checkNotNullExpressionValue((Object)stringTable2, (String)"getStrings(...)");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = this.getPackageProto().getQualifiedNames();
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getQualifiedNames(...)");
            this.nameResolver = new NameResolverImpl(stringTable2, qualifiedNameTable);
            this.classDataFinder = new ProtoBasedClassDataFinder(this.getPackageProto(), this.nameResolver, this.getVersion(), (Function1<? super ClassId, ? extends SourceElement>)((Function1)BuiltInsPackageFragment::classDataFinder$lambda$0));
            this.memberDeserializer$delegate = LazyKt.lazy(() -> BuiltInsPackageFragment.memberDeserializer_delegate$lambda$1(this));
            this.classCache = FirCachesFactoryKt.getFirCachesFactory(this.moduleData.getSession()).createCacheWithPostCompute(BuiltInsPackageFragment::classCache$lambda$2, (arg_0, arg_1, arg_2) -> BuiltInsPackageFragment.classCache$lambda$3(this, arg_0, arg_1, arg_2));
            FirCachesFactory $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(this.moduleData.getSession());
            boolean $i$f$createCache = false;
            this.functionCache = $this$createCache$iv.createCache((Function2)new Function2(this){
                final /* synthetic */ BuiltInsPackageFragment this$0;
                {
                    this.this$0 = builtInsPackageFragment;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final Object invoke(Object key, Void void_) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    ProtoBuf.Function it;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Name name2 = (Name)key;
                    boolean bl = false;
                    List<ProtoBuf.Function> list = this.this$0.getPackageProto().getPackage().getFunctionList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getFunctionList(...)");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (ProtoBuf.Function)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)NameResolverUtilKt.getName(BuiltInsPackageFragment.access$getNameResolver$p(this.this$0), it.getName()), (Object)name2)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (ProtoBuf.Function)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        FirMemberDeserializer firMemberDeserializer = BuiltInsPackageFragment.access$getMemberDeserializer(this.this$0);
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(FirMemberDeserializer.loadFunction$default(firMemberDeserializer, it, null, null, null, 14, null).getSymbol());
                    }
                    return (List)destination$iv$iv;
                }
            });
            this.functionsNameCache = FirCachesFactoryKt.getFirCachesFactory(this.moduleData.getSession()).createLazyValue(() -> BuiltInsPackageFragment.functionsNameCache$lambda$8(this));
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final FirModuleData getModuleData() {
            return this.moduleData;
        }

        @NotNull
        public final FirKotlinScopeProvider getKotlinScopeProvider() {
            return this.kotlinScopeProvider;
        }

        @NotNull
        public final BuiltInsBinaryVersion getVersion() {
            return this.binaryVersionAndPackageFragment.getVersion();
        }

        @NotNull
        public final ProtoBuf.PackageFragment getPackageProto() {
            return this.binaryVersionAndPackageFragment.getPackageFragment();
        }

        @NotNull
        public final ProtoBasedClassDataFinder getClassDataFinder() {
            return this.classDataFinder;
        }

        private final FirMemberDeserializer getMemberDeserializer() {
            Lazy lazy = this.memberDeserializer$delegate;
            return (FirMemberDeserializer)lazy.getValue();
        }

        @Nullable
        public final FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return BuiltInsPackageFragment.findAndDeserializeClass$default(this, classId, null, 2, null);
        }

        private final FirRegularClassSymbol findAndDeserializeClass(ClassId classId, FirDeserializationContext parentContext) {
            boolean classIdExists = this.classDataFinder.getAllClassIds().contains(classId);
            if (!classIdExists) {
                return null;
            }
            return this.classCache.getValue(classId, parentContext);
        }

        static /* synthetic */ FirRegularClassSymbol findAndDeserializeClass$default(BuiltInsPackageFragment builtInsPackageFragment, ClassId classId, FirDeserializationContext firDeserializationContext, int n, Object object) {
            if ((n & 2) != 0) {
                firDeserializationContext = null;
            }
            return builtInsPackageFragment.findAndDeserializeClass(classId, firDeserializationContext);
        }

        @NotNull
        public final List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull Name name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return this.getTopLevelFunctionSymbols(name2);
        }

        @NotNull
        public final Collection<Name> getTopLevelCallableNames() {
            return this.functionsNameCache.getValue();
        }

        @NotNull
        public final List<FirNamedFunctionSymbol> getTopLevelFunctionSymbols(@NotNull Name name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            FirCache $this$getValue$iv = this.functionCache;
            boolean $i$f$getValue = false;
            return (List)$this$getValue$iv.getValue(name2, null);
        }

        private static final SourceElement classDataFinder$lambda$0(ClassId it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
            return sourceElement;
        }

        private static final FirMemberDeserializer memberDeserializer_delegate$lambda$1(BuiltInsPackageFragment this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            FqName fqName = this$0.fqName;
            ProtoBuf.Package package_ = this$0.getPackageProto().getPackage();
            Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"getPackage(...)");
            return FirDeserializationContext.Companion.createForPackage(fqName, package_, this$0.nameResolver, this$0.moduleData, new FirBuiltinAnnotationDeserializer(this$0.moduleData.getSession()), new FirConstDeserializer(this$0.moduleData.getSession(), BuiltInSerializerProtocol.INSTANCE), null).getMemberDeserializer();
        }

        private static final Pair classCache$lambda$2(ClassId classId, FirDeserializationContext context2) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return TuplesKt.to((Object)new FirRegularClassSymbol(classId), (Object)context2);
        }

        private static final Unit classCache$lambda$3(BuiltInsPackageFragment this$0, ClassId classId, FirRegularClassSymbol symbol, FirDeserializationContext parentContext) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            ClassData classData = this$0.classDataFinder.findClassData(classId);
            Intrinsics.checkNotNull((Object)classData);
            ClassData classData2 = classData;
            ProtoBuf.Class classProto2 = classData2.getClassProto();
            ClassDeserializationKt.deserializeClassToSymbol(classId, classProto2, symbol, this$0.nameResolver, this$0.moduleData.getSession(), this$0.moduleData, null, this$0.kotlinScopeProvider, BuiltInSerializerProtocol.INSTANCE, parentContext, null, FirDeclarationOrigin.BuiltIns.INSTANCE, (Function2<? super ClassId, ? super FirDeserializationContext, FirRegularClassSymbol>)((Function2)new Function2<ClassId, FirDeserializationContext, FirRegularClassSymbol>((Object)this$0){

                public final FirRegularClassSymbol invoke(ClassId p0, FirDeserializationContext p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return BuiltInsPackageFragment.access$findAndDeserializeClass((BuiltInsPackageFragment)this.receiver, p0, p1);
                }

                public final String getSignature() {
                    return "findAndDeserializeClass(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;";
                }

                public final String getName() {
                    return "findAndDeserializeClass";
                }

                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(BuiltInsPackageFragment.class);
                }
            }));
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final List functionsNameCache$lambda$8(BuiltInsPackageFragment this$0) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            List<ProtoBuf.Function> list = this$0.getPackageProto().getPackage().getFunctionList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFunctionList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Function function2 = (ProtoBuf.Function)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(NameResolverUtilKt.getName(this$0.nameResolver, it.getName()));
            }
            return (List)destination$iv$iv;
        }

        public static final /* synthetic */ FirRegularClassSymbol access$findAndDeserializeClass(BuiltInsPackageFragment $this, ClassId classId, FirDeserializationContext parentContext) {
            return $this.findAndDeserializeClass(classId, parentContext);
        }

        public static final /* synthetic */ NameResolverImpl access$getNameResolver$p(BuiltInsPackageFragment $this) {
            return $this.nameResolver;
        }

        public static final /* synthetic */ FirMemberDeserializer access$getMemberDeserializer(BuiltInsPackageFragment $this) {
            return $this.getMemberDeserializer();
        }
    }
}

