/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.PreliminaryLoopVisitor;
import org.jetbrains.kotlin.fir.util.MultimapKt;
import org.jetbrains.kotlin.fir.util.SetMultimap;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000/\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0003*\u0001\u000f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u0006J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/PreliminaryLoopVisitor;", "", "<init>", "()V", "reassignedVariablesPerElement", "Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/name/Name;", "enterCapturingStatement", "", "statement", "exitCapturingStatement", "resetState", "", "visitor", "org/jetbrains/kotlin/fir/resolve/dfa/PreliminaryLoopVisitor$visitor$1", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PreliminaryLoopVisitor$visitor$1;", "resolve"})
public final class PreliminaryLoopVisitor {
    @NotNull
    private final SetMultimap<FirStatement, Name> reassignedVariablesPerElement = MultimapKt.setMultimapOf();
    @NotNull
    private final visitor.1 visitor = new FirVisitor<Unit, FirStatement>(this){
        final /* synthetic */ PreliminaryLoopVisitor this$0;
        {
            this.this$0 = $receiver;
        }

        public void visitElement(FirElement element, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this, data);
        }

        public void visitVariableAssignment(FirVariableAssignment variableAssignment, FirStatement data) {
            FirNamedReference reference2;
            Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
            KtSourceElement ktSourceElement = variableAssignment.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement) {
                return;
            }
            if (FirExpressionUtilKt.getExplicitReceiver(variableAssignment) != null) {
                return;
            }
            Object object = ReferenceUtilsKt.getCalleeReference(variableAssignment);
            FirNamedReference firNamedReference = reference2 = object instanceof FirNamedReference ? (FirNamedReference)object : null;
            if (reference2 != null) {
                if (data == null) {
                    object = "Required value was null.";
                    throw new IllegalArgumentException(object.toString());
                }
                PreliminaryLoopVisitor.access$getReassignedVariablesPerElement$p(this.this$0).put(data, reference2.getName());
            }
            this.visitElement((FirElement)variableAssignment, data);
        }

        public void visitWhileLoop(FirWhileLoop whileLoop, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
            this.visitCapturingStatement(whileLoop, data);
        }

        public void visitDoWhileLoop(FirDoWhileLoop doWhileLoop, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
            this.visitCapturingStatement(doWhileLoop, data);
        }

        public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
            this.visitCapturingStatement(anonymousFunction, data);
        }

        public void visitSimpleFunction(FirSimpleFunction simpleFunction, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            this.visitCapturingStatement(simpleFunction, data);
        }

        public void visitRegularClass(FirRegularClass regularClass, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            this.visitCapturingStatement(regularClass, data);
        }

        public void visitAnonymousObject(FirAnonymousObject anonymousObject, FirStatement data) {
            Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
            this.visitCapturingStatement(anonymousObject, data);
        }

        private final void visitCapturingStatement(FirStatement statement, FirStatement parent2) {
            this.visitElement((FirElement)statement, statement);
            if (parent2 != null) {
                PreliminaryLoopVisitor.access$getReassignedVariablesPerElement$p(this.this$0).putAll(parent2, PreliminaryLoopVisitor.access$getReassignedVariablesPerElement$p(this.this$0).get(statement));
            }
        }
    };

    @NotNull
    public final Set<Name> enterCapturingStatement(@NotNull FirStatement statement) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        boolean bl2 = bl = statement instanceof FirLoop || statement instanceof FirClass || statement instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!this.reassignedVariablesPerElement.contains(statement)) {
            statement.accept(this.visitor, null);
        }
        return (Set)this.reassignedVariablesPerElement.get(statement);
    }

    @NotNull
    public final Set<Name> exitCapturingStatement(@NotNull FirStatement statement) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        boolean bl2 = bl = statement instanceof FirLoop || statement instanceof FirClass || statement instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return (Set)this.reassignedVariablesPerElement.removeKey(statement);
    }

    public final void resetState() {
        this.reassignedVariablesPerElement.clear();
    }

    public static final /* synthetic */ SetMultimap access$getReassignedVariablesPerElement$p(PreliminaryLoopVisitor $this) {
        return $this.reassignedVariablesPerElement;
    }
}

