/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAssignmentOperatorStatement;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.Stack;
import org.jetbrains.kotlin.fir.resolve.dfa.StackKt;
import org.jetbrains.kotlin.fir.resolve.dfa.UtilKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ*\u0010\u001e\u001a\u00020\u00142\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010 2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010!\u001a\u0004\u0018\u00010\t2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J$\u0010#\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u00072\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J*\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00110\u00102\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010&\u001a\u00020\u0014H\u0002J\u000e\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0016J\u000e\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\u0016J\u0014\u0010/\u001a\u00020\u00162\f\u00100\u001a\b\u0012\u0004\u0012\u0002010 J\u000e\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u0014J\u0016\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u001bR\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "", "<init>", "()V", "rootFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "assignedLocalVariablesByDeclaration", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "variableAssignments", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "scopes", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Stack;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "postponedLambdas", "", "", "reset", "", "isAccessToUnstableLocalVariable", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "targetType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isStableType", "assignments", "", "getInfoForDeclaration", "symbol", "buildInfoForRoot", "root", "enterScope", "evaluatedInPlace", "enterFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "exitFunction", "enterClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "exitClass", "enterFunctionCall", "lambdaArgs", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "exitFunctionCall", "callCompleted", "visitAssignment", "property", "type", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,500:1\n1755#2,2:501\n1757#2:506\n1755#2,3:507\n1734#2,3:510\n1611#2,9:514\n1863#2:523\n1864#2:525\n1620#2:526\n1293#2,4:527\n1293#2,4:531\n295#2,2:535\n188#3,3:503\n1#4:513\n1#4:524\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n*L\n68#1:501,2\n68#1:506\n79#1:507,3\n82#1:510,3\n180#1:514,9\n180#1:523\n180#1:525\n180#1:526\n180#1:527,4\n201#1:531,4\n208#1:535,2\n72#1:503,3\n180#1:524\n*E\n"})
public final class FirLocalVariableAssignmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FirFunctionSymbol<?> rootFunction;
    @Nullable
    private Map<FirBasedSymbol<?>, Companion.Fork> assignedLocalVariablesByDeclaration;
    @Nullable
    private Map<FirProperty, ? extends List<Companion.Assignment>> variableAssignments;
    @NotNull
    private final Stack<Pair<Companion.Fork, Companion.VariableAssignments>> scopes = StackKt.stackOf(new Pair[0]);
    @NotNull
    private final Stack<Map<Companion.Fork, Boolean>> postponedLambdas = StackKt.stackOf(new Map[0]);

    public final void reset() {
        this.rootFunction = null;
        this.assignedLocalVariablesByDeclaration = null;
        this.variableAssignments = null;
        this.postponedLambdas.reset();
        this.scopes.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAccessToUnstableLocalVariable(@NotNull FirExpression fir, @Nullable ConeKotlinType targetType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (this.assignedLocalVariablesByDeclaration == null) {
            return false;
        }
        FirElement firElement = UtilKt.unwrapElement(fir);
        if (!(firElement instanceof FirQualifiedAccessExpression)) return false;
        FirQualifiedAccessExpression firQualifiedAccessExpression = (FirQualifiedAccessExpression)firElement;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression realFir = firQualifiedAccessExpression;
        FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(realFir.getCalleeReference(), false, 1, null);
        Object object = firPropertySymbol;
        if (firPropertySymbol == null) return false;
        if ((object = (FirProperty)((FirBasedSymbol)object).getFir()) == null) {
            return false;
        }
        Object property = object;
        if (!this.isStableType((Collection<Companion.Assignment>)((Companion.VariableAssignments)this.scopes.top().getSecond()).get((FirProperty)property), targetType, session2)) return true;
        Iterable $this$any$iv = this.postponedLambdas.all();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Map lambdas = (Map)element$iv;
            boolean bl2 = false;
            Map $this$any$iv2 = lambdas;
            boolean $i$f$any2 = false;
            if ($this$any$iv2.isEmpty()) {
                bl = false;
                continue;
            }
            Iterator iterator3 = $this$any$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator3.next();
                boolean bl3 = false;
                Companion.Fork lambda2 = (Companion.Fork)entry.getKey();
                boolean dataFlowOnly = (Boolean)entry.getValue();
                if (dataFlowOnly && lambda2.getAssignedInside().contains((FirProperty)property)) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isStableType(Collection<Companion.Assignment> assignments, ConeKotlinType targetType, FirSession session2) {
        boolean bl;
        block10: {
            Companion.Assignment it;
            boolean bl2;
            block9: {
                if (assignments == null) {
                    return true;
                }
                if (targetType == null) {
                    return false;
                }
                Iterable $this$any$iv = assignments;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Companion.Assignment)element$iv;
                        boolean bl3 = false;
                        if (!(it.getType() == null)) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return false;
            }
            Iterable $this$all$iv = assignments;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (Companion.Assignment)element$iv;
                    boolean bl4 = false;
                    TypeCheckerProviderContext typeCheckerProviderContext = TypeComponentsKt.getTypeContext(session2);
                    ConeKotlinType coneKotlinType = it.getType();
                    Intrinsics.checkNotNull((Object)coneKotlinType);
                    if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerProviderContext, (KotlinTypeMarker)coneKotlinType, (KotlinTypeMarker)targetType, false, 8, null)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final Companion.Fork getInfoForDeclaration(FirBasedSymbol<?> symbol) {
        FirFunctionSymbol<?> firFunctionSymbol = this.rootFunction;
        if (firFunctionSymbol == null) {
            return null;
        }
        FirFunctionSymbol<?> root = firFunctionSymbol;
        if (Intrinsics.areEqual(root, symbol)) {
            return null;
        }
        Map<FirBasedSymbol<?>, Companion.Fork> cachedMap = this.buildInfoForRoot(root);
        return cachedMap.get(symbol);
    }

    private final Map<FirBasedSymbol<?>, Companion.Fork> buildInfoForRoot(FirFunctionSymbol<?> root) {
        Map<FirBasedSymbol<?>, Companion.Fork> map = this.assignedLocalVariablesByDeclaration;
        if (map != null) {
            Map<FirBasedSymbol<?>, Companion.Fork> it = map;
            boolean bl = false;
            return it;
        }
        Companion.MiniCfgBuilder.MiniCfgData data = new Companion.MiniCfgBuilder.MiniCfgData();
        new Companion.MiniCfgBuilder().visitElement((FirElement)root.getFir(), data);
        this.assignedLocalVariablesByDeclaration = data.getForks();
        this.variableAssignments = data.getAssignments();
        return data.getForks();
    }

    private final Pair<Companion.Fork, Companion.VariableAssignments> enterScope(FirBasedSymbol<?> symbol, boolean evaluatedInPlace) {
        Companion.Fork currentInfo = this.getInfoForDeclaration(symbol);
        Companion.VariableAssignments prohibitInThisScope = ((Companion.VariableAssignments)this.scopes.top().getSecond()).copy();
        this.scopes.push((Pair<Companion.Fork, Companion.VariableAssignments>)TuplesKt.to((Object)currentInfo, (Object)prohibitInThisScope));
        if (!evaluatedInPlace) {
            for (Pair<Companion.Fork, Companion.VariableAssignments> pair : this.scopes.all()) {
                Companion.Fork outerInfo = (Companion.Fork)pair.component1();
                Companion.VariableAssignments prohibitInOuterScope = (Companion.VariableAssignments)pair.component2();
                Companion.Fork fork = currentInfo;
                prohibitInOuterScope.merge(fork != null ? fork.getAssignedInside() : null);
                Companion.Fork fork2 = outerInfo;
                prohibitInThisScope.merge(fork2 != null ? fork2.getAssignedLater() : null);
            }
        }
        return this.scopes.top();
    }

    public final void enterFunction(@NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (this.rootFunction == null) {
            this.rootFunction = function2.getSymbol();
            this.scopes.push((Pair<Companion.Fork, Companion.VariableAssignments>)TuplesKt.to(null, (Object)new Companion.VariableAssignments()));
            return;
        }
        Pair<Companion.Fork, Companion.VariableAssignments> pair = this.enterScope((FirBasedSymbol)function2.getSymbol(), function2 instanceof FirAnonymousFunction && EventOccurrencesRangeKt.isInPlace(((FirAnonymousFunction)function2).getInvocationKind()));
        Companion.Fork info = (Companion.Fork)pair.component1();
        Companion.VariableAssignments prohibitSmartCasts = (Companion.VariableAssignments)pair.component2();
        for (Map<Companion.Fork, Boolean> concurrentLambdas : this.postponedLambdas.all()) {
            for (Map.Entry<Companion.Fork, Boolean> entry : concurrentLambdas.entrySet()) {
                Companion.Fork otherLambda = entry.getKey();
                boolean dataFlowOnly = entry.getValue();
                if (dataFlowOnly || Intrinsics.areEqual((Object)otherLambda, (Object)info)) continue;
                prohibitSmartCasts.merge(otherLambda.getAssignedInside());
            }
        }
    }

    public final void exitFunction() {
        this.scopes.pop();
        if (StackKt.isEmpty(this.scopes)) {
            this.rootFunction = null;
            this.assignedLocalVariablesByDeclaration = null;
            this.variableAssignments = null;
        }
    }

    public final void enterClass(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (this.rootFunction == null) {
            return;
        }
        Pair<Companion.Fork, Companion.VariableAssignments> pair = this.enterScope((FirBasedSymbol)klass.getSymbol(), klass instanceof FirAnonymousObject);
        Companion.Fork info = (Companion.Fork)pair.component1();
        Companion.VariableAssignments prohibitSmartCasts = (Companion.VariableAssignments)pair.component2();
        if (klass instanceof FirAnonymousObject && info != null) {
            prohibitSmartCasts.merge(info.getAssignedInside());
        }
    }

    public final void exitClass() {
        if (this.rootFunction == null) {
            return;
        }
        this.scopes.pop();
    }

    /*
     * WARNING - void declaration
     */
    public final void enterFunctionCall(@NotNull Collection<? extends FirAnonymousFunction> lambdaArgs) {
        void var3_5;
        void $this$associateWithTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(lambdaArgs, (String)"lambdaArgs");
        if (this.rootFunction == null) {
            return;
        }
        Iterable iterable = lambdaArgs;
        Stack<Map<Companion.Fork, Boolean>> stack = this.postponedLambdas;
        boolean $i$f$mapNotNull22 = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Companion.Fork $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Companion.Fork it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnonymousFunction it = (FirAnonymousFunction)element$iv$iv;
            boolean bl2 = false;
            if (this.getInfoForDeclaration(it.getSymbol()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Map $i$f$mapNotNull22 = new LinkedHashMap();
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            void destination$iv;
            $this$forEach$iv$iv$iv = (Companion.Fork)element$iv;
            Object t = element$iv;
            void var18_21 = destination$iv;
            boolean bl = false;
            Boolean bl4 = false;
            var18_21.put(t, bl4);
        }
        stack.push((Map<Companion.Fork, Boolean>)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final void exitFunctionCall(boolean callCompleted) {
        if (this.rootFunction == null) {
            return;
        }
        Map<Companion.Fork, Boolean> lambdasInCall = this.postponedLambdas.pop();
        if (!callCompleted) {
            void $this$associateWithTo$iv;
            Iterable iterable = lambdasInCall.keySet();
            Map<Companion.Fork, Boolean> map = StackKt.topOrNull(this.postponedLambdas);
            if (map == null) {
                return;
            }
            Map<Companion.Fork, Boolean> destination$iv = map;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                Companion.Fork fork = (Companion.Fork)element$iv;
                Object t = element$iv;
                Map<Companion.Fork, Boolean> map2 = destination$iv;
                boolean bl = false;
                Boolean bl2 = true;
                map2.put((Companion.Fork)t, bl2);
            }
        }
    }

    public final void visitAssignment(@NotNull FirProperty property, @NotNull ConeKotlinType type2) {
        Object v2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            FirFunctionSymbol<?> firFunctionSymbol = this.rootFunction;
            if (firFunctionSymbol == null) {
                return;
            }
            this.buildInfoForRoot(firFunctionSymbol);
            Map<FirProperty, ? extends List<Companion.Assignment>> map = this.variableAssignments;
            if (map == null || (map = map.get(property)) == null) {
                return;
            }
            Map<FirProperty, ? extends List<Companion.Assignment>> assignments = map;
            Iterable $this$firstOrNull$iv = (Iterable)((Object)assignments);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Companion.Assignment it = (Companion.Assignment)element$iv;
                boolean bl = false;
                if (!(it.getType() == null)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Companion.Assignment assignment = v2;
        if (assignment == null) {
            return;
        }
        Companion.Assignment assignment2 = assignment;
        assignment2.setType(type2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion;", "", "<init>", "()V", "Fork", "Assignment", "VariableAssignments", "MiniFlow", "MiniCfgBuilder", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "setType", "resolve"})
        private static final class Assignment {
            @Nullable
            private ConeKotlinType type;

            public Assignment(@Nullable ConeKotlinType type2) {
                this.type = type2;
            }

            public /* synthetic */ Assignment(ConeKotlinType coneKotlinType, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    coneKotlinType = null;
                }
                this(coneKotlinType);
            }

            @Nullable
            public final ConeKotlinType getType() {
                return this.type;
            }

            public final void setType(@Nullable ConeKotlinType coneKotlinType) {
                this.type = coneKotlinType;
            }

            public Assignment() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "", "assignedLater", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "assignedInside", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;)V", "getAssignedLater", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getAssignedInside", "resolve"})
        private static final class Fork {
            @NotNull
            private final VariableAssignments assignedLater;
            @NotNull
            private final VariableAssignments assignedInside;

            public Fork(@NotNull VariableAssignments assignedLater, @NotNull VariableAssignments assignedInside) {
                Intrinsics.checkNotNullParameter((Object)assignedLater, (String)"assignedLater");
                Intrinsics.checkNotNullParameter((Object)assignedInside, (String)"assignedInside");
                this.assignedLater = assignedLater;
                this.assignedInside = assignedInside;
            }

            @NotNull
            public final VariableAssignments getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final VariableAssignments getAssignedInside() {
                return this.assignedInside;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001CB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0012\u0010!\u001a\u00020\"*\b\u0012\u0004\u0012\u00020\"0#H\u0002J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u0002052\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u0002082\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u0010:\u001a\u00020;2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0014\u0010<\u001a\u00020\u0002*\u00020\u00032\u0006\u0010=\u001a\u00020>H\u0002J\u001c\u0010<\u001a\u00020\u0002*\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u0010?\u001a\u00020@H\u0002J\u0014\u0010A\u001a\u00020\u0002*\u00020\"2\u0006\u0010B\u001a\u00020\u000bH\u0002\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "<init>", "()V", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitElementWithLexicalScope", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitLocalDeclaration", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitWhenExpression", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "visitTryExpression", "tryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "join", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "visitLoop", "loop", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "visitWhileLoop", "whileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "visitDoWhileLoop", "doWhileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "visitAssignmentOperatorStatement", "assignmentOperatorStatement", "Lorg/jetbrains/kotlin/fir/expressions/FirAssignmentOperatorStatement;", "recordAssignment", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "assignment", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "recordAssignments", "properties", "MiniCfgData", "resolve"})
        @SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,500:1\n1454#2,5:501\n1628#2,3:507\n1628#2,3:510\n1863#2,2:513\n3193#2,10:515\n1863#2,2:525\n1863#2,2:527\n543#2,6:529\n1863#2,2:542\n1863#2,2:544\n1#3:506\n381#4,7:535\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n*L\n352#1:501,5\n384#1:507,3\n395#1:510,3\n433#1:513,2\n437#1:515,10\n438#1:525,2\n439#1:527,2\n472#1:529,6\n481#1:542,2\n488#1:544,2\n475#1:535,7\n*E\n"})
        private static final class MiniCfgBuilder
        extends FirVisitor<Unit, MiniCfgData> {
            @Override
            public void visitElement(@NotNull FirElement element, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                element.acceptChildren(this, data);
            }

            /*
             * WARNING - void declaration
             */
            private final VariableAssignments visitElementWithLexicalScope(FirElement element, MiniCfgData data) {
                void destination$iv;
                void $this$flatMapTo$iv;
                MiniFlow flow = MiniFlow.Companion.start();
                Object object = (Iterable)data.getVariableDeclarations();
                Collection collection = new LinkedHashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    Map it = (Map)element$iv;
                    boolean bl = false;
                    Iterable list$iv = it.values();
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                Set freeVariables = (Set)destination$iv;
                data.setFlow(flow);
                element.acceptChildren(this, data);
                Object $this$visitElementWithLexicalScope_u24lambda_u241 = object = flow.getAssignedLater();
                boolean bl = false;
                ((VariableAssignments)$this$visitElementWithLexicalScope_u24lambda_u241).retain(freeVariables);
                return object;
            }

            @Override
            public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLocalDeclaration(anonymousFunction, data);
            }

            @Override
            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLocalDeclaration(simpleFunction, data);
            }

            @Override
            public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLocalDeclaration(regularClass, data);
            }

            @Override
            public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLocalDeclaration(anonymousObject, data);
            }

            private final void visitLocalDeclaration(FirDeclaration declaration, MiniCfgData data) {
                MiniFlow flow = data.getFlow();
                VariableAssignments assignedInside = this.visitElementWithLexicalScope(declaration, data);
                this.recordAssignments(flow, assignedInside);
                data.setFlow(flow.fork());
                data.getForks().put(declaration.getSymbol(), new Fork(data.getFlow().getAssignedLater(), assignedInside));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull MiniCfgData data) {
                void var13_13;
                void destination$iv;
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                FirVariable firVariable = whenExpression.getSubjectVariable();
                FirElement firElement = firVariable != null ? (FirElement)firVariable : (FirElement)whenExpression.getSubject();
                if (firElement != null) {
                    ((FirStatement)firElement).accept(this, data);
                }
                MiniFlow flow = data.getFlow();
                Iterable iterable = whenExpression.getBranches();
                Object object = new MiniFlow[]{flow};
                object = SetsKt.mutableSetOf((Object[])object);
                MiniCfgBuilder miniCfgBuilder = this;
                MiniCfgData miniCfgData = data;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirWhenBranch firWhenBranch = (FirWhenBranch)item$iv;
                    var13_13 = destination$iv;
                    boolean bl = false;
                    data.setFlow(flow);
                    it.accept(this, data);
                    var13_13.add(data.getFlow());
                }
                var13_13 = destination$iv;
                miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitTryExpression(@NotNull FirTryExpression tryExpression, @NotNull MiniCfgData data) {
                block1: {
                    void var13_13;
                    void destination$iv;
                    void $this$mapTo$iv;
                    Intrinsics.checkNotNullParameter((Object)tryExpression, (String)"tryExpression");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    tryExpression.getTryBlock().accept(this, data);
                    MiniFlow flow = data.getFlow();
                    Iterable iterable = tryExpression.getCatches();
                    Object object = new MiniFlow[]{flow};
                    object = SetsKt.mutableSetOf((Object[])object);
                    MiniCfgBuilder miniCfgBuilder = this;
                    MiniCfgData miniCfgData = data;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        FirCatch firCatch = (FirCatch)item$iv;
                        var13_13 = destination$iv;
                        boolean bl = false;
                        data.setFlow(flow);
                        it.accept(this, data);
                        var13_13.add(data.getFlow());
                    }
                    var13_13 = destination$iv;
                    miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
                    FirBlock firBlock = tryExpression.getFinallyBlock();
                    if (firBlock == null) break block1;
                    firBlock.accept(this, data);
                }
            }

            private final MiniFlow join(Set<MiniFlow> $this$join) {
                MiniFlow miniFlow = (MiniFlow)CollectionsKt.singleOrNull((Iterable)$this$join);
                if (miniFlow == null) {
                    miniFlow = new MiniFlow($this$join);
                }
                return miniFlow;
            }

            @Override
            public void visitLoop(@NotNull FirLoop loop, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                MiniFlow entry = data.getFlow();
                VariableAssignments assignedInside = this.visitElementWithLexicalScope(loop, data);
                this.recordAssignments(entry, assignedInside);
                this.recordAssignments(data.getFlow(), assignedInside);
                Object[] objectArray = new MiniFlow[]{entry, data.getFlow()};
                data.setFlow(this.join(SetsKt.setOf((Object[])objectArray)));
            }

            @Override
            public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLoop((FirLoop)whileLoop, data);
            }

            @Override
            public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitLoop((FirLoop)doWhileLoop, data);
            }

            @Override
            public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull MiniCfgData data) {
                FirExpression it;
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                MiniCfgBuilder visitor2 = this;
                FirFunctionCall $this$visitFunctionCall_u24lambda_u248 = functionCall;
                boolean bl = false;
                FirExpression[] firExpressionArray = new FirExpression[]{$this$visitFunctionCall_u24lambda_u248.getExplicitReceiver(), $this$visitFunctionCall_u24lambda_u248.getDispatchReceiver(), $this$visitFunctionCall_u24lambda_u248.getExtensionReceiver()};
                Iterable $this$forEach$iv = SetsKt.setOfNotNull((Object[])firExpressionArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirExpression it2 = (FirExpression)element$iv;
                    boolean bl2 = false;
                    it2.accept(visitor2, data);
                }
                Iterable $this$partition$iv = $this$visitFunctionCall_u24lambda_u248.getArgumentList().getArguments();
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    it = (FirExpression)element$iv;
                    boolean bl3 = false;
                    if (it instanceof FirAnonymousFunctionExpression) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                firExpressionArray = new Pair(first$iv, second$iv);
                List postponedFunctionArgs = (List)firExpressionArray.component1();
                List normalArgs = (List)firExpressionArray.component2();
                Iterable $this$forEach$iv2 = normalArgs;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl4 = false;
                    it.accept(visitor2, data);
                }
                $this$forEach$iv2 = postponedFunctionArgs;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl5 = false;
                    it.accept(visitor2, data);
                }
                $this$visitFunctionCall_u24lambda_u248.getCalleeReference().accept(visitor2, data);
            }

            @Override
            public void visitBlock(@NotNull FirBlock block, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                data.getVariableDeclarations().addLast((Object)new LinkedHashMap());
                this.visitElement((FirElement)block, data);
                data.getVariableDeclarations().removeLast();
            }

            @Override
            public void visitProperty(@NotNull FirProperty property, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitElement((FirElement)property, data);
                if (property.isLocal()) {
                    ((Map)data.getVariableDeclarations().last()).put(property.getName(), property);
                }
            }

            @Override
            public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull MiniCfgData data) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    this.visitElement((FirElement)variableAssignment, data);
                    if (FirExpressionUtilKt.getExplicitReceiver(variableAssignment) != null) {
                        return;
                    }
                    FirReference firReference = ReferenceUtilsKt.getCalleeReference(variableAssignment);
                    if (firReference == null) break block1;
                    FirReference it = firReference;
                    boolean bl = false;
                    this.recordAssignment(data, it);
                }
            }

            @Override
            public void visitAssignmentOperatorStatement(@NotNull FirAssignmentOperatorStatement assignmentOperatorStatement, @NotNull MiniCfgData data) {
                Intrinsics.checkNotNullParameter((Object)assignmentOperatorStatement, (String)"assignmentOperatorStatement");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitElement((FirElement)assignmentOperatorStatement, data);
                FirExpression firExpression = assignmentOperatorStatement.getLeftArgument();
                FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
                if (firQualifiedAccessExpression == null) {
                    return;
                }
                FirQualifiedAccessExpression lhs = firQualifiedAccessExpression;
                if (lhs.getExplicitReceiver() != null) {
                    return;
                }
                this.recordAssignment(data, lhs.getCalleeReference());
            }

            private final void recordAssignment(MiniCfgData $this$recordAssignment, FirReference reference2) {
                List list;
                Object object;
                Object v1;
                Object name2;
                block5: {
                    Object object2 = reference2 instanceof FirNamedReference ? (FirNamedReference)reference2 : null;
                    if (object2 == null || (object2 = ((FirNamedReference)object2).getName()) == null) {
                        return;
                    }
                    name2 = object2;
                    List $this$lastOrNull$iv = (List)$this$recordAssignment.getVariableDeclarations();
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        Map it = (Map)element$iv;
                        boolean bl = false;
                        if (!it.containsKey(name2)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                if ((object = (Map)v1) == null || (object = (FirProperty)object.get(name2)) == null) {
                    return;
                }
                Object property = object;
                Assignment assignment = new Assignment(null, 1, null);
                Map<FirProperty, List<Assignment>> $this$getOrPut$iv = $this$recordAssignment.getAssignments();
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(property);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put((FirProperty)property, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                list.add((Assignment)assignment);
                this.recordAssignment($this$recordAssignment.getFlow(), (FirProperty)property, assignment);
            }

            private final void recordAssignment(MiniFlow $this$recordAssignment, FirProperty property, Assignment assignment) {
                $this$recordAssignment.getAssignedLater().add(property, assignment);
                Iterable $this$forEach$iv = $this$recordAssignment.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignment(it, property, assignment);
                }
            }

            private final void recordAssignments(MiniFlow $this$recordAssignments, VariableAssignments properties2) {
                if (properties2.isEmpty()) {
                    return;
                }
                $this$recordAssignments.getAssignedLater().merge(properties2);
                Iterable $this$forEach$iv = $this$recordAssignments.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignments(it, properties2);
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\u00180\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "", "<init>", "()V", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "getFlow", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "setFlow", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;)V", "variableDeclarations", "Lkotlin/collections/ArrayDeque;", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getVariableDeclarations", "()Lkotlin/collections/ArrayDeque;", "assignments", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "getAssignments", "()Ljava/util/Map;", "forks", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "getForks", "resolve"})
            public static final class MiniCfgData {
                @NotNull
                private MiniFlow flow = MiniFlow.Companion.start();
                @NotNull
                private final ArrayDeque<Map<Name, FirProperty>> variableDeclarations = new ArrayDeque((Collection)CollectionsKt.listOf((Object)new LinkedHashMap()));
                @NotNull
                private final Map<FirProperty, List<Assignment>> assignments = new LinkedHashMap();
                @NotNull
                private final Map<FirBasedSymbol<?>, Fork> forks = new LinkedHashMap();

                @NotNull
                public final MiniFlow getFlow() {
                    return this.flow;
                }

                public final void setFlow(@NotNull MiniFlow miniFlow) {
                    Intrinsics.checkNotNullParameter((Object)miniFlow, (String)"<set-?>");
                    this.flow = miniFlow;
                }

                @NotNull
                public final ArrayDeque<Map<Name, FirProperty>> getVariableDeclarations() {
                    return this.variableDeclarations;
                }

                @NotNull
                public final Map<FirProperty, List<Assignment>> getAssignments() {
                    return this.assignments;
                }

                @NotNull
                public final Map<FirBasedSymbol<?>, Fork> getForks() {
                    return this.forks;
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "parents", "", "<init>", "(Ljava/util/Set;)V", "getParents", "()Ljava/util/Set;", "assignedLater", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getAssignedLater", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "fork", "Companion", "resolve"})
        private static final class MiniFlow {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Set<MiniFlow> parents;
            @NotNull
            private final VariableAssignments assignedLater;

            public MiniFlow(@NotNull Set<MiniFlow> parents) {
                Intrinsics.checkNotNullParameter(parents, (String)"parents");
                this.parents = parents;
                this.assignedLater = new VariableAssignments();
            }

            @NotNull
            public final Set<MiniFlow> getParents() {
                return this.parents;
            }

            @NotNull
            public final VariableAssignments getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final MiniFlow fork() {
                return new MiniFlow(SetsKt.setOf((Object)this));
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow$Companion;", "", "<init>", "()V", "start", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "resolve"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final MiniFlow start() {
                    return new MiniFlow(SetsKt.emptySet());
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0086\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\u0000J\u0010\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0000J\u0014\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\nJ\u0006\u0010\u0016\u001a\u00020\rR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "", "<init>", "()V", "assignments", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "get", "", "property", "contains", "", "add", "", "assignment", "copy", "merge", "other", "retain", "properties", "isEmpty", "resolve"})
        @SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,500:1\n381#2,7:501\n381#2,7:508\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments\n*L\n311#1:501,7\n323#1:508,7\n*E\n"})
        private static final class VariableAssignments {
            @NotNull
            private final Map<FirProperty, Set<Assignment>> assignments = new LinkedHashMap();

            @Nullable
            public final Set<Assignment> get(@NotNull FirProperty property) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                return this.assignments.get(property);
            }

            public final boolean contains(@NotNull FirProperty property) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                return this.assignments.containsKey(property);
            }

            public final void add(@NotNull FirProperty property, @NotNull Assignment assignment) {
                Set set;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
                Map<FirProperty, Set<Assignment>> $this$getOrPut$iv = this.assignments;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(property);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(property, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                set.add((Assignment)assignment);
            }

            @NotNull
            public final VariableAssignments copy() {
                VariableAssignments copy = new VariableAssignments();
                copy.assignments.putAll(this.assignments);
                return copy;
            }

            public final void merge(@Nullable VariableAssignments other) {
                if (other == null) {
                    return;
                }
                for (Map.Entry<FirProperty, Set<Assignment>> entry : other.assignments.entrySet()) {
                    Set set;
                    FirProperty property = entry.getKey();
                    Set<Assignment> values2 = entry.getValue();
                    Map<FirProperty, Set<Assignment>> $this$getOrPut$iv = this.assignments;
                    boolean $i$f$getOrPut = false;
                    Set value$iv = $this$getOrPut$iv.get(property);
                    if (value$iv == null) {
                        boolean bl = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(property, answer$iv);
                        set = answer$iv;
                    } else {
                        set = value$iv;
                    }
                    set.addAll((Collection<Assignment>)values2);
                }
            }

            public final void retain(@NotNull Set<? extends FirProperty> properties2) {
                Intrinsics.checkNotNullParameter(properties2, (String)"properties");
                this.assignments.keySet().retainAll((Collection)properties2);
            }

            public final boolean isEmpty() {
                return this.assignments.isEmpty();
            }
        }
    }
}

