/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.dfa.FirLocalVariableAssignmentAnalyzer;
import org.jetbrains.kotlin.fir.resolve.dfa.PreliminaryLoopVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Stack;
import org.jetbrains.kotlin.fir.resolve.dfa.StackKt;
import org.jetbrains.kotlin.fir.resolve.dfa.VariableStorageImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphBuilder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowAnalyzerContext;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "graphBuilder", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphBuilder;", "getGraphBuilder", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphBuilder;", "preliminaryLoopVisitor", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PreliminaryLoopVisitor;", "getPreliminaryLoopVisitor", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/PreliminaryLoopVisitor;", "variablesClearedBeforeLoop", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Stack;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "getVariablesClearedBeforeLoop", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/Stack;", "variableAssignmentAnalyzer", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "getVariableAssignmentAnalyzer$resolve", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "value", "Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorageImpl;", "variableStorage", "getVariableStorage", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorageImpl;", "assignmentCounter", "", "newAssignmentIndex", "reset", "", "resolve"})
public final class DataFlowAnalyzerContext {
    @NotNull
    private final ControlFlowGraphBuilder graphBuilder;
    @NotNull
    private final PreliminaryLoopVisitor preliminaryLoopVisitor;
    @NotNull
    private final Stack<List<RealVariable>> variablesClearedBeforeLoop;
    @NotNull
    private final FirLocalVariableAssignmentAnalyzer variableAssignmentAnalyzer;
    @NotNull
    private VariableStorageImpl variableStorage;
    private int assignmentCounter;

    public DataFlowAnalyzerContext(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.graphBuilder = new ControlFlowGraphBuilder();
        this.preliminaryLoopVisitor = new PreliminaryLoopVisitor();
        this.variablesClearedBeforeLoop = StackKt.stackOf(new List[0]);
        this.variableAssignmentAnalyzer = new FirLocalVariableAssignmentAnalyzer();
        this.variableStorage = new VariableStorageImpl(session2);
    }

    @NotNull
    public final ControlFlowGraphBuilder getGraphBuilder() {
        return this.graphBuilder;
    }

    @NotNull
    public final PreliminaryLoopVisitor getPreliminaryLoopVisitor() {
        return this.preliminaryLoopVisitor;
    }

    @NotNull
    public final Stack<List<RealVariable>> getVariablesClearedBeforeLoop() {
        return this.variablesClearedBeforeLoop;
    }

    @NotNull
    public final FirLocalVariableAssignmentAnalyzer getVariableAssignmentAnalyzer$resolve() {
        return this.variableAssignmentAnalyzer;
    }

    @NotNull
    public final VariableStorageImpl getVariableStorage() {
        return this.variableStorage;
    }

    public final int newAssignmentIndex() {
        int n = this.assignmentCounter;
        this.assignmentCounter = n + 1;
        return n;
    }

    public final void reset() {
        this.graphBuilder.reset();
        this.preliminaryLoopVisitor.resetState();
        this.variablesClearedBeforeLoop.reset();
        this.variableAssignmentAnalyzer.reset();
        this.variableStorage = this.variableStorage.clear();
    }
}

