/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.CallToPotentiallyHiddenSymbolResult;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.CallToDeprecatedOverrideOfHidden;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.FirSimpleSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.resolve.calls.SyntheticsKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J4\u0010\u0012\u001a\u00020\u00102\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isDeprecatedHidden", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isHiddenForThisCallSite", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckerSinkKt\n*L\n1#1,862:1\n21#2:863\n28#3,2:864\n22#3,9:866\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n*L\n756#1:863\n761#1:864,2\n761#1:866,9\n*E\n"})
public final class CheckHiddenDeclaration
extends ResolutionStage {
    @NotNull
    public static final CheckHiddenDeclaration INSTANCE = new CheckHiddenDeclaration();

    private CheckHiddenDeclaration() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        block9: {
            void $this$yieldDiagnostic$iv;
            Object $this$isActual$iv;
            block7: {
                FirCallableSymbol symbol;
                block8: {
                    FirBasedSymbol<?> firBasedSymbol = candidate2.getSymbol();
                    FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
                    if (firCallableSymbol == null) {
                        return Unit.INSTANCE;
                    }
                    symbol = firCallableSymbol;
                    $this$isActual$iv = symbol;
                    boolean $i$f$isActual = false;
                    if (((FirCallableSymbol)$this$isActual$iv).getRawStatus().isActual()) {
                        return Unit.INSTANCE;
                    }
                    if (this.isDeprecatedHidden(symbol, context2, callInfo)) break block7;
                    if (!(symbol instanceof FirConstructorSymbol)) break block8;
                    FirTypeAliasSymbol firTypeAliasSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructorSymbol)symbol);
                    if (firTypeAliasSymbol != null ? this.isDeprecatedHidden(firTypeAliasSymbol, context2, callInfo) : false) break block7;
                }
                if (!this.isHiddenForThisCallSite(symbol, callInfo, candidate2, context2.getSession(), sink)) break block9;
            }
            $this$isActual$iv = sink;
            ResolutionDiagnostic diagnostic$iv = HiddenCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final boolean isDeprecatedHidden(FirBasedSymbol<?> $this$isDeprecatedHidden, ResolutionContext context2, CallInfo callInfo) {
        DeprecationInfo deprecation;
        DeprecationInfo deprecationInfo = deprecation = DeprecationUtilsKt.getDeprecation($this$isDeprecatedHidden, context2.getSession(), callInfo.getCallSite());
        return (deprecationInfo != null ? deprecationInfo.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN;
    }

    private final boolean isHiddenForThisCallSite(FirCallableSymbol<?> symbol, CallInfo callInfo, Candidate candidate2, FirSession session2, CheckerSink sink) {
        if (symbol instanceof FirSimpleSyntheticPropertySymbol && SyntheticsKt.getDeprecatedOverrideOfHidden((FirSimpleSyntheticPropertySymbol)symbol)) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        if (((FirCallableDeclaration)symbol.getFir()).getDispatchReceiverType() == null || !(symbol instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        boolean isSuperCall = ResolutionStagesKt.isSuperCall(callInfo.getCallSite(), session2);
        if (DeprecationUtilsKt.hiddenStatusOfCall(symbol, isSuperCall, false) == CallToPotentiallyHiddenSymbolResult.Hidden) {
            return true;
        }
        FirScope firScope = candidate2.getOriginScope();
        FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
        if (firTypeScope == null) {
            return false;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.BooleanRef hidden = new Ref.BooleanRef();
        Ref.BooleanRef deprecated = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> CheckHiddenDeclaration.isHiddenForThisCallSite$lambda$0(isSuperCall, hidden, deprecated, arg_0)));
        if (deprecated.element) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        return hidden.element;
    }

    private static final ProcessorAction isHiddenForThisCallSite$lambda$0(boolean $isSuperCall, Ref.BooleanRef $hidden, Ref.BooleanRef $deprecated, FirNamedFunctionSymbol it) {
        ProcessorAction processorAction;
        Intrinsics.checkNotNullParameter((Object)$hidden, (String)"$hidden");
        Intrinsics.checkNotNullParameter((Object)$deprecated, (String)"$deprecated");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CallToPotentiallyHiddenSymbolResult result2 = DeprecationUtilsKt.hiddenStatusOfCall(it, $isSuperCall, true);
        if (result2 != CallToPotentiallyHiddenSymbolResult.Visible) {
            if (result2 == CallToPotentiallyHiddenSymbolResult.Hidden) {
                $hidden.element = true;
            } else if (result2 == CallToPotentiallyHiddenSymbolResult.VisibleWithDeprecation) {
                $deprecated.element = true;
            }
            processorAction = ProcessorAction.STOP;
        } else {
            processorAction = ProcessorAction.NEXT;
        }
        return processorAction;
    }
}

