/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.DslScopeViolation;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010JL\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u00132\u0016\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014*\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014*\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010 \u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010 \u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckDslScopeViolation;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "<init>", "()V", "dslMarkerClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkImpl", "dslMarkersProvider", "Lkotlin/Function0;", "", "isImplicitReceiverMatching", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "", "getDslMarkersOfImplicitReceiver", "boundSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getDslMarkersOfThisReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirThisReceiverExpression;", "collectDslMarkerAnnotations", "", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckDslScopeViolation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,862:1\n346#2,8:863\n1755#2,3:871\n1863#2,2:874\n1863#2,2:876\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckDslScopeViolation\n*L\n391#1:863,8\n397#1:871,3\n449#1:874,2\n453#1:876,2\n*E\n"})
public final class CheckDslScopeViolation
extends ResolutionStage {
    @NotNull
    public static final CheckDslScopeViolation INSTANCE = new CheckDslScopeViolation();
    @NotNull
    private static final ClassId dslMarkerClassId = ClassId.Companion.fromString$default(ClassId.Companion, "kotlin/DslMarker", false, 2, null);

    private CheckDslScopeViolation() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        CheckDslScopeViolation.check$checkReceiver(context2, candidate2, sink, candidate2.getDispatchReceiver());
        CheckDslScopeViolation.check$checkReceiver(context2, candidate2, sink, candidate2.getChosenExtensionReceiver());
        Object object = candidate2.getDispatchReceiver();
        boolean bl = object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null && (object = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object, context2.getSession())) != null ? FunctionalTypeUtilsKt.isSomeFunctionType((ConeKotlinType)object, context2.getSession()) : false;
        if (bl) {
            FirBasedSymbol<?> firBasedSymbol = candidate2.getSymbol();
            FirNamedFunctionSymbol firNamedFunctionSymbol = firBasedSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firBasedSymbol : null;
            if (Intrinsics.areEqual((Object)(firNamedFunctionSymbol != null ? firNamedFunctionSymbol.getName() : null), (Object)OperatorNameConventions.INVOKE)) {
                LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = candidate2.getArgumentMapping();
                FirExpression firExpression = linkedHashMap != null && (linkedHashMap = linkedHashMap.keySet()) != null ? (FirExpression)CollectionsKt.firstOrNull((Iterable)((Iterable)((Object)linkedHashMap))) : null;
                FirThisReceiverExpression firThisReceiverExpression = firExpression instanceof FirThisReceiverExpression ? (FirThisReceiverExpression)firExpression : null;
                if (firThisReceiverExpression == null) {
                    return Unit.INSTANCE;
                }
                FirThisReceiverExpression firstArg = firThisReceiverExpression;
                if (!firstArg.isImplicit()) {
                    return Unit.INSTANCE;
                }
                this.checkImpl(candidate2, sink, context2, (Function0<? extends Set<ClassId>>)((Function0)() -> CheckDslScopeViolation.check$lambda$2(firstArg, context2)), arg_0 -> CheckDslScopeViolation.check$lambda$3(firstArg, arg_0));
            }
        }
        return Unit.INSTANCE;
    }

    private final void checkImpl(Candidate candidate2, CheckerSink sink, ResolutionContext context2, Function0<? extends Set<ClassId>> dslMarkersProvider, Function1<? super ImplicitReceiverValue<?>, Boolean> isImplicitReceiverMatching) {
        boolean bl;
        block15: {
            int resolvedReceiverIndex;
            block13: {
                int n;
                Iterable $this$indexOfFirst$iv = context2.getBodyResolveContext().getImplicitReceiverStack();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    if (index$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ImplicitReceiverValue it = (ImplicitReceiverValue)item$iv;
                    boolean bl2 = false;
                    if (((Boolean)isImplicitReceiverMatching.invoke((Object)it)).booleanValue()) {
                        n = index$iv;
                        break block13;
                    }
                    ++index$iv;
                }
                n = resolvedReceiverIndex = -1;
            }
            if (resolvedReceiverIndex == -1) {
                return;
            }
            List closerReceivers = CollectionsKt.drop((Iterable)context2.getBodyResolveContext().getImplicitReceiverStack(), (int)(resolvedReceiverIndex + 1));
            if (closerReceivers.isEmpty()) {
                return;
            }
            Set dslMarkers = (Set)dslMarkersProvider.invoke();
            if (dslMarkers.isEmpty()) {
                return;
            }
            Iterable $this$any$iv = closerReceivers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block14: {
                        ImplicitReceiverValue receiver = (ImplicitReceiverValue)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = INSTANCE.getDslMarkersOfImplicitReceiver(receiver, context2);
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ClassId it = (ClassId)element$iv2;
                                boolean bl5 = false;
                                if (!dslMarkers.contains(it)) continue;
                                bl3 = true;
                                break block14;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            sink.reportDiagnostic(new DslScopeViolation(candidate2.getSymbol()));
        }
    }

    private final Set<ClassId> getDslMarkersOfImplicitReceiver(ImplicitReceiverValue<?> $this$getDslMarkersOfImplicitReceiver, ResolutionContext context2) {
        return INSTANCE.getDslMarkersOfImplicitReceiver((FirBasedSymbol<?>)$this$getDslMarkersOfImplicitReceiver.getBoundSymbol(), $this$getDslMarkersOfImplicitReceiver.getType(), context2);
    }

    private final Set<ClassId> getDslMarkersOfImplicitReceiver(FirBasedSymbol<?> boundSymbol, ConeKotlinType type2, ResolutionContext context2) {
        Set set;
        Set $this$getDslMarkersOfImplicitReceiver_u24lambda_u249 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Object object = boundSymbol instanceof FirAnonymousFunctionSymbol ? (FirAnonymousFunctionSymbol)boundSymbol : null;
        if (object != null && (object = (FirAnonymousFunction)((FirBasedSymbol)object).getFir()) != null && (object = ClassMembersKt.getMatchingParameterFunctionType(object)) != null) {
            Object it = object;
            boolean bl2 = false;
            INSTANCE.collectDslMarkerAnnotations((Set<ClassId>)$this$getDslMarkersOfImplicitReceiver_u24lambda_u249, context2, (Collection<? extends FirAnnotation>)CustomAnnotationTypeAttributeKt.getCustomAnnotations(((ConeKotlinType)it).getAttributes()));
            if (((ConeKotlinType)it).getAttributes().contains(CompilerConeAttributes.ExtensionFunctionType.INSTANCE)) {
                ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.firstOrNull((Object[])((ConeKotlinType)it).getTypeArguments());
                if (coneTypeProjection != null && (coneTypeProjection = ConeTypeProjectionKt.getType(coneTypeProjection)) != null) {
                    ConeTypeProjection receiverType = coneTypeProjection;
                    boolean bl3 = false;
                    INSTANCE.collectDslMarkerAnnotations((Set<ClassId>)$this$getDslMarkersOfImplicitReceiver_u24lambda_u249, context2, (ConeKotlinType)receiverType);
                }
            }
        }
        INSTANCE.collectDslMarkerAnnotations((Set<ClassId>)$this$getDslMarkersOfImplicitReceiver_u24lambda_u249, context2, type2);
        return SetsKt.build((Set)set);
    }

    private final Set<ClassId> getDslMarkersOfThisReceiverExpression(FirThisReceiverExpression $this$getDslMarkersOfThisReceiverExpression, ResolutionContext context2) {
        Set set;
        Set $this$getDslMarkersOfThisReceiverExpression_u24lambda_u2410 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        INSTANCE.collectDslMarkerAnnotations((Set<ClassId>)$this$getDslMarkersOfThisReceiverExpression_u24lambda_u2410, context2, FirTypeUtilsKt.getResolvedType($this$getDslMarkersOfThisReceiverExpression));
        return SetsKt.build((Set)set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void collectDslMarkerAnnotations(Set<ClassId> $this$collectDslMarkerAnnotations, ResolutionContext context2, ConeKotlinType type2) {
        this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context2, (Collection<? extends FirAnnotation>)CustomAnnotationTypeAttributeKt.getCustomAnnotations(type2.getAttributes()));
        ConeKotlinType coneKotlinType = type2;
        if (coneKotlinType instanceof ConeFlexibleType) {
            this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context2, ((ConeFlexibleType)type2).getLowerBound());
            this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context2, ((ConeFlexibleType)type2).getUpperBound());
            return;
        } else if (coneKotlinType instanceof ConeCapturedType) {
            if (((ConeCapturedType)type2).getConstructor().getProjection().getKind() != ProjectionKind.OUT) return;
            List<ConeKotlinType> list = ((ConeCapturedType)type2).getConstructor().getSupertypes();
            if (list == null) return;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                INSTANCE.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context2, it);
            }
            return;
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context2, ((ConeDefinitelyNotNullType)type2).getOriginal());
            return;
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)type2).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                INSTANCE.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context2, it);
            }
            return;
        } else {
            if (!(coneKotlinType instanceof ConeClassLikeType)) return;
            FirClassLikeSymbol<?> firClassLikeSymbol = TypeUtilsKt.toSymbol((ConeClassLikeType)type2, context2.getSession());
            if (firClassLikeSymbol == null) {
                return;
            }
            FirClassLikeSymbol<?> classDeclaration = firClassLikeSymbol;
            this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context2, (Collection<? extends FirAnnotation>)classDeclaration.getResolvedAnnotationsWithClassIds());
            FirClassLikeSymbol<?> firClassLikeSymbol2 = classDeclaration;
            if (firClassLikeSymbol2 instanceof FirClassSymbol) {
                for (ConeKotlinType superType : ((FirClassSymbol)classDeclaration).getResolvedSuperTypes()) {
                    this.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context2, superType);
                }
                return;
            } else {
                if (!(firClassLikeSymbol2 instanceof FirTypeAliasSymbol)) throw new NoWhenBranchMatchedException();
                ConeClassLikeType coneClassLikeType = TypeExpansionUtilsKt.directExpansionType$default((ConeClassLikeType)type2, context2.getSession(), null, 2, null);
                if (coneClassLikeType == null) return;
                ConeClassLikeType it = coneClassLikeType;
                boolean bl = false;
                INSTANCE.collectDslMarkerAnnotations($this$collectDslMarkerAnnotations, context2, it);
            }
        }
    }

    private final void collectDslMarkerAnnotations(Set<ClassId> $this$collectDslMarkerAnnotations, ResolutionContext context2, Collection<? extends FirAnnotation> annotations2) {
        for (FirAnnotation firAnnotation : annotations2) {
            FirClassSymbol annotationClass;
            FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(firAnnotation.getAnnotationTypeRef()), context2.getSession()), context2.getSession());
            FirClassSymbol firClassSymbol = firClassifierSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassifierSymbol : null;
            if (firClassSymbol == null || !FirAnnotationUtilsKt.hasAnnotation(annotationClass = firClassSymbol, dslMarkerClassId, context2.getSession())) continue;
            $this$collectDslMarkerAnnotations.add(annotationClass.getClassId());
        }
    }

    private static final Set check$checkReceiver$lambda$0(FirThisReference $thisReference, FirExpression $receiver, ResolutionContext $context) {
        Intrinsics.checkNotNullParameter((Object)$thisReference, (String)"$thisReference");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        return INSTANCE.getDslMarkersOfImplicitReceiver($thisReference.getBoundSymbol(), FirTypeUtilsKt.getResolvedType($receiver), $context);
    }

    private static final boolean check$checkReceiver$lambda$1(FirExpression $receiver, ImplicitReceiverValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getReceiverExpression(), (Object)$receiver);
    }

    private static final void check$checkReceiver(ResolutionContext $context, Candidate $candidate, CheckerSink $sink, FirExpression receiver) {
        FirExpression firExpression = receiver;
        FirReference firReference = firExpression != null ? ReferenceUtilsKt.toReference(firExpression, $context.getSession()) : null;
        FirThisReference firThisReference = firReference instanceof FirThisReference ? (FirThisReference)firReference : null;
        if (firThisReference == null) {
            return;
        }
        FirThisReference thisReference = firThisReference;
        if (thisReference.isImplicit()) {
            INSTANCE.checkImpl($candidate, $sink, $context, (Function0<? extends Set<ClassId>>)((Function0)() -> CheckDslScopeViolation.check$checkReceiver$lambda$0(thisReference, receiver, $context)), arg_0 -> CheckDslScopeViolation.check$checkReceiver$lambda$1(receiver, arg_0));
        }
    }

    private static final Set check$lambda$2(FirThisReceiverExpression $firstArg, ResolutionContext $context) {
        Intrinsics.checkNotNullParameter((Object)$firstArg, (String)"$firstArg");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        return INSTANCE.getDslMarkersOfThisReceiverExpression($firstArg, $context);
    }

    private static final boolean check$lambda$3(FirThisReceiverExpression $firstArg, ImplicitReceiverValue it) {
        Intrinsics.checkNotNullParameter((Object)$firstArg, (String)"$firstArg");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual(it.getBoundSymbol(), $firstArg.getCalleeReference().getBoundSymbol());
    }
}

