/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0006j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00040\u0006j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0004`\u0003\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0006j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003JD\u0010\u0017\u001a\u00020\u00002$\b\u0002\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0006j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R/\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0006j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ArgumentMapping;", "", "parameterToCallArgumentMap", "Lkotlin/collections/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Ljava/util/LinkedHashMap;", "diagnostics", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "<init>", "(Ljava/util/LinkedHashMap;Ljava/util/List;)V", "getParameterToCallArgumentMap", "()Ljava/util/LinkedHashMap;", "Ljava/util/LinkedHashMap;", "getDiagnostics", "()Ljava/util/List;", "toArgumentToParameterMapping", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "numDefaults", "", "component1", "component2", "copy", "(Ljava/util/LinkedHashMap;Ljava/util/List;)Lorg/jetbrains/kotlin/fir/resolve/calls/ArgumentMapping;", "equals", "", "other", "hashCode", "toString", "", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirArgumentsToParametersMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentMapping\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,412:1\n216#2:413\n217#2:416\n1863#3,2:414\n1782#3,4:417\n*S KotlinDebug\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentMapping\n*L\n44#1:413\n44#1:416\n47#1:414,2\n58#1:417,4\n*E\n"})
public final class ArgumentMapping {
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument> parameterToCallArgumentMap;
    @NotNull
    private final List<ResolutionDiagnostic> diagnostics;

    public ArgumentMapping(@NotNull LinkedHashMap<FirValueParameter, ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends ResolutionDiagnostic> diagnostics) {
        Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, (String)"parameterToCallArgumentMap");
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        this.parameterToCallArgumentMap = parameterToCallArgumentMap;
        this.diagnostics = diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument> getParameterToCallArgumentMap() {
        return this.parameterToCallArgumentMap;
    }

    @NotNull
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirExpression, FirValueParameter> toArgumentToParameterMapping() {
        LinkedHashMap<FirExpression, FirValueParameter> argumentToParameterMapping = new LinkedHashMap<FirExpression, FirValueParameter>();
        Map $this$forEach$iv = this.parameterToCallArgumentMap;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            FirValueParameter valueParameter2 = (FirValueParameter)entry.getKey();
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)entry.getValue();
            ResolvedCallArgument resolvedCallArgument = resolvedArgument;
            if (resolvedCallArgument instanceof ResolvedCallArgument.SimpleArgument) {
                ((Map)argumentToParameterMapping).put(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument(), valueParameter2);
                continue;
            }
            if (resolvedCallArgument instanceof ResolvedCallArgument.VarargArgument) {
                Iterable $this$forEach$iv2 = ((ResolvedCallArgument.VarargArgument)resolvedArgument).getArguments();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    FirExpression it = (FirExpression)element$iv2;
                    boolean bl2 = false;
                    ((Map)argumentToParameterMapping).put(it, valueParameter2);
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)resolvedCallArgument, (Object)ResolvedCallArgument.DefaultArgument.INSTANCE)) continue;
            throw new NoWhenBranchMatchedException();
        }
        return argumentToParameterMapping;
    }

    /*
     * WARNING - void declaration
     */
    public final int numDefaults() {
        int n;
        Collection<ResolvedCallArgument> collection = this.parameterToCallArgumentMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ResolvedCallArgument it = (ResolvedCallArgument)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)ResolvedCallArgument.DefaultArgument.INSTANCE) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument> component1() {
        return this.parameterToCallArgumentMap;
    }

    @NotNull
    public final List<ResolutionDiagnostic> component2() {
        return this.diagnostics;
    }

    @NotNull
    public final ArgumentMapping copy(@NotNull LinkedHashMap<FirValueParameter, ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends ResolutionDiagnostic> diagnostics) {
        Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, (String)"parameterToCallArgumentMap");
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        return new ArgumentMapping(parameterToCallArgumentMap, diagnostics);
    }

    public static /* synthetic */ ArgumentMapping copy$default(ArgumentMapping argumentMapping2, LinkedHashMap linkedHashMap, List list, int n, Object object) {
        if ((n & 1) != 0) {
            linkedHashMap = argumentMapping2.parameterToCallArgumentMap;
        }
        if ((n & 2) != 0) {
            list = argumentMapping2.diagnostics;
        }
        return argumentMapping2.copy(linkedHashMap, list);
    }

    @NotNull
    public String toString() {
        return "ArgumentMapping(parameterToCallArgumentMap=" + this.parameterToCallArgumentMap + ", diagnostics=" + this.diagnostics + ')';
    }

    public int hashCode() {
        int result2 = this.parameterToCallArgumentMap.hashCode();
        result2 = result2 * 31 + ((Object)this.diagnostics).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArgumentMapping)) {
            return false;
        }
        ArgumentMapping argumentMapping2 = (ArgumentMapping)other;
        if (!Intrinsics.areEqual(this.parameterToCallArgumentMap, argumentMapping2.parameterToCallArgumentMap)) {
            return false;
        }
        return Intrinsics.areEqual(this.diagnostics, argumentMapping2.diagnostics);
    }
}

