/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationBuildingUtilsKt;
import org.jetbrains.kotlin.fir.deserialization.AbstractAnnotationDeserializer;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttribute;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlags;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0000\u0012\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!J\u000e\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!J\u0018\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020#H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0014H\u0002J\f\u0010,\u001a\u00020-*\u00020.H\u0002J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b*\u0006\u0012\u0002\b\u000300J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020#H\u0002J5\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u001c2\f\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u0002082\u0006\u0010(\u001a\u00020#H\u0002\u00a2\u0006\u0002\u00109J3\u0010:\u001a\u0002022\u0006\u00103\u001a\u00020\u001c2\f\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u0002082\u0006\u0010(\u001a\u00020#H\u0002\u00a2\u0006\u0002\u00109J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020?H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;", "", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "annotationDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;", "typeParameterProtos", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "parent", "containingSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Lorg/jetbrains/kotlin/fir/deserialization/AbstractAnnotationDeserializer;Ljava/util/List;Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "typeParameterDescriptors", "", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "typeParameterNames", "", "ownTypeParameters", "getOwnTypeParameters", "()Ljava/util/List;", "computeClassifier", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "fqNameIndex", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "attributesFromAnnotations", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "simpleType", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "attributes", "typeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeTypeParameterLookupTag;", "typeParameterId", "convertVariance", "Lorg/jetbrains/kotlin/types/Variance;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Variance;", "typeParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "createSuspendFunctionTypeForBasicCase", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "functionTypeConstructor", "arguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "isNullable", "", "(Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;ZLorg/jetbrains/kotlin/fir/types/ConeAttributes;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "createSuspendFunctionType", "typeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierLookupTag;", "typeArgument", "typeArgumentProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;", "fir-deserialization"})
@SourceDebugExtension(value={"SMAP\nFirTypeDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeDeserializer.kt\norg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,294:1\n1628#2,2:295\n1630#2:298\n1557#2:301\n1628#2,3:302\n1557#2:305\n1628#2,3:306\n49#3:297\n49#3:300\n1#4:299\n37#5,2:309\n37#5,2:311\n*S KotlinDebug\n*F\n+ 1 FirTypeDeserializer.kt\norg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer\n*L\n88#1:295,2\n88#1:298\n162#1:301\n162#1:302,3\n179#1:305\n179#1:306,3\n89#1:297\n112#1:300\n179#1:309,2\n230#1:311,2\n*E\n"})
public final class FirTypeDeserializer {
    @NotNull
    private final FirModuleData moduleData;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;
    @NotNull
    private final AbstractAnnotationDeserializer annotationDeserializer;
    @Nullable
    private final FirTypeDeserializer parent;
    @Nullable
    private final FirBasedSymbol<?> containingSymbol;
    @NotNull
    private final Map<Integer, FirTypeParameterSymbol> typeParameterDescriptors;
    @NotNull
    private final Map<String, FirTypeParameterSymbol> typeParameterNames;

    /*
     * WARNING - void declaration
     */
    public FirTypeDeserializer(@NotNull FirModuleData moduleData, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @NotNull AbstractAnnotationDeserializer annotationDeserializer, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @Nullable FirTypeDeserializer parent2, @Nullable FirBasedSymbol<?> containingSymbol) {
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)annotationDeserializer, (String)"annotationDeserializer");
        Intrinsics.checkNotNullParameter(typeParameterProtos, (String)"typeParameterProtos");
        this.moduleData = moduleData;
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
        this.annotationDeserializer = annotationDeserializer;
        this.parent = parent2;
        this.containingSymbol = containingSymbol;
        this.typeParameterDescriptors = !((Collection)typeParameterProtos).isEmpty() ? (Map)new LinkedHashMap() : MapsKt.emptyMap();
        if (!((Collection)typeParameterProtos).isEmpty()) {
            FirTypeParameterBuilder firTypeParameterBuilder;
            this.typeParameterNames = new LinkedHashMap();
            Map<Integer, FirTypeParameterSymbol> map = this.typeParameterDescriptors;
            Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<kotlin.Int, org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol>");
            LinkedHashMap result2 = (LinkedHashMap)map;
            List builders = new ArrayList();
            for (ProtoBuf.TypeParameter proto : typeParameterProtos) {
                if (!proto.hasId()) continue;
                Name name2 = NameResolverUtilKt.getName(this.nameResolver, proto.getName());
                Object object = new FirTypeParameterSymbol();
                FirTypeParameterSymbol it = object;
                boolean bl = false;
                this.typeParameterNames.put(name2.asString(), it);
                FirTypeParameterSymbol symbol = object;
                object = builders;
                FirTypeParameterBuilder $this$_init__u24lambda_u241 = firTypeParameterBuilder = new FirTypeParameterBuilder();
                boolean bl2 = false;
                $this$_init__u24lambda_u241.setModuleData(this.moduleData);
                $this$_init__u24lambda_u241.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
                $this$_init__u24lambda_u241.setOrigin(FirDeclarationOrigin.Library.INSTANCE);
                $this$_init__u24lambda_u241.setName(name2);
                $this$_init__u24lambda_u241.setSymbol(symbol);
                FirBasedSymbol<?> firBasedSymbol = this.containingSymbol;
                if (firBasedSymbol == null) {
                    throw new IllegalStateException("Top-level type parameter ???".toString());
                }
                $this$_init__u24lambda_u241.setContainingDeclarationSymbol(firBasedSymbol);
                ProtoBuf.TypeParameter.Variance variance = proto.getVariance();
                Intrinsics.checkNotNullExpressionValue((Object)variance, (String)"getVariance(...)");
                $this$_init__u24lambda_u241.setVariance(this.convertVariance(variance));
                $this$_init__u24lambda_u241.setReified(proto.getReified());
                CollectionsKt.addAll((Collection)$this$_init__u24lambda_u241.getAnnotations(), (Iterable)this.annotationDeserializer.loadTypeParameterAnnotations(proto, this.nameResolver));
                object.add(firTypeParameterBuilder);
                ((Map)result2).put(proto.getId(), symbol);
            }
            Iterator<ProtoBuf.TypeParameter> iterator2 = ((Iterable)typeParameterProtos).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                void $this$mapTo$iv;
                FirTypeParameterBuilder builder;
                int index = n++;
                ProtoBuf.TypeParameter proto = iterator2.next();
                FirTypeParameterBuilder $this$_init__u24lambda_u244 = firTypeParameterBuilder = (builder = (FirTypeParameterBuilder)builders.get(index));
                boolean bl = false;
                Iterable iterable = ProtoTypeTableUtilKt.upperBounds(proto, this.typeTable);
                Collection destination$iv = $this$_init__u24lambda_u244.getBounds();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
                    ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv;
                    Collection collection = destination$iv;
                    boolean bl3 = false;
                    boolean $i$f$buildResolvedTypeRef = false;
                    FirResolvedTypeRefBuilder $this$lambda_u244_u24lambda_u243_u24lambda_u242 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                    boolean bl4 = false;
                    $this$lambda_u244_u24lambda_u243_u24lambda_u242.setType(this.type((ProtoBuf.Type)it));
                    collection.add(firResolvedTypeRefBuilder.build());
                }
                FirDeclarationBuildingUtilsKt.addDefaultBoundIfNecessary($this$_init__u24lambda_u244);
                firTypeParameterBuilder.build();
            }
        } else {
            this.typeParameterNames = MapsKt.emptyMap();
        }
    }

    @NotNull
    public final List<FirTypeParameterSymbol> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    private final ConeClassLikeLookupTag computeClassifier(int fqNameIndex) {
        try {
            ClassId classId;
            ClassId it = classId = NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex);
            boolean bl = false;
            ClassId classId2 = !it.isLocal() ? classId : null;
            if (classId2 == null) {
                classId2 = StandardClassIds.INSTANCE.getAny();
            }
            ClassId id = classId2;
            return TypeConstructionUtilsKt.toLookupTag(id);
        }
        catch (Throwable e) {
            if (PlatformExceptionUtilsKt.shouldIjPlatformExceptionBeRethrown(e)) {
                throw e;
            }
            throw new RuntimeException("Looking up for " + NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex), e);
        }
    }

    @NotNull
    public final FirResolvedTypeRef typeRef(@NotNull ProtoBuf.Type proto) {
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $this$typeRef_u24lambda_u246 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$typeRef_u24lambda_u246.getAnnotations(), (Iterable)this.annotationDeserializer.loadTypeAnnotations(proto, this.nameResolver));
        $this$typeRef_u24lambda_u246.setType(this.type(proto, CopyUtilsKt.computeTypeAttributes$default($this$typeRef_u24lambda_u246.getAnnotations(), this.moduleData.getSession(), null, false, false, 6, null)));
        return firResolvedTypeRefBuilder.build();
    }

    private final ConeAttributes attributesFromAnnotations(ProtoBuf.Type proto) {
        return CopyUtilsKt.computeTypeAttributes$default(this.annotationDeserializer.loadTypeAnnotations(proto, this.nameResolver), this.moduleData.getSession(), null, false, false, 6, null);
    }

    @NotNull
    public final ConeKotlinType type(@NotNull ProtoBuf.Type proto) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        return this.type(proto, this.attributesFromAnnotations(proto));
    }

    @NotNull
    public final ConeSimpleKotlinType simpleType(@NotNull ProtoBuf.Type proto) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        ConeSimpleKotlinType coneSimpleKotlinType = this.simpleType(proto, this.attributesFromAnnotations(proto));
        if (coneSimpleKotlinType == null) {
            coneSimpleKotlinType = new ConeErrorType(new ConeSimpleDiagnostic("?!id:0", DiagnosticKind.DeserializationError), false, null, null, null, 30, null);
        }
        return coneSimpleKotlinType;
    }

    private final ConeKotlinType type(ProtoBuf.Type proto, ConeAttributes attributes) {
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            ConeKotlinType coneKotlinType;
            boolean isDynamic;
            ConeSimpleKotlinType lowerBound = this.simpleType(proto, attributes);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.typeTable);
            Intrinsics.checkNotNull((Object)type2);
            ConeSimpleKotlinType upperBound = this.simpleType(type2, attributes);
            boolean bl = isDynamic = Intrinsics.areEqual((Object)lowerBound, (Object)FirTypeUtilsKt.getConeType(this.moduleData.getSession().getBuiltinTypes().getNothingType())) && Intrinsics.areEqual((Object)upperBound, (Object)FirTypeUtilsKt.getConeType(this.moduleData.getSession().getBuiltinTypes().getNullableAnyType()));
            if (isDynamic) {
                coneKotlinType = TypeUtilsKt.create$default(ConeDynamicType.Companion, this.moduleData.getSession(), null, 2, null);
            } else {
                ConeSimpleKotlinType coneSimpleKotlinType = lowerBound;
                Intrinsics.checkNotNull((Object)coneSimpleKotlinType);
                ConeSimpleKotlinType coneSimpleKotlinType2 = upperBound;
                Intrinsics.checkNotNull((Object)coneSimpleKotlinType2);
                coneKotlinType = new ConeFlexibleType(coneSimpleKotlinType, coneSimpleKotlinType2);
            }
            return coneKotlinType;
        }
        ConeSimpleKotlinType coneSimpleKotlinType = this.simpleType(proto, attributes);
        return coneSimpleKotlinType != null ? (ConeKotlinType)coneSimpleKotlinType : (ConeKotlinType)new ConeErrorType(new ConeSimpleDiagnostic("?!id:0", DiagnosticKind.DeserializationError), false, null, null, null, 30, null);
    }

    private final ConeTypeParameterLookupTag typeParameterSymbol(int typeParameterId) {
        Object object = this.typeParameterDescriptors.get(typeParameterId);
        if (object == null || (object = ((FirTypeParameterSymbol)object).toLookupTag()) == null) {
            FirTypeDeserializer firTypeDeserializer = this.parent;
            object = firTypeDeserializer != null ? firTypeDeserializer.typeParameterSymbol(typeParameterId) : null;
        }
        return object;
    }

    private final Variance convertVariance(ProtoBuf.TypeParameter.Variance $this$convertVariance) {
        Variance variance;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$convertVariance.ordinal()]) {
            case 1: {
                variance = Variance.IN_VARIANCE;
                break;
            }
            case 2: {
                variance = Variance.OUT_VARIANCE;
                break;
            }
            case 3: {
                variance = Variance.INVARIANT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> typeParameters(@NotNull FirClassLikeSymbol<?> $this$typeParameters) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter($this$typeParameters, (String)"<this>");
        Object e = $this$typeParameters.getFir();
        Object object = e instanceof FirTypeParameterRefsOwner ? (FirTypeParameterRefsOwner)e : null;
        if (object != null && (object = object.getTypeParameters()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbol());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeSimpleKotlinType simpleType(ProtoBuf.Type proto, ConeAttributes attributes) {
        Object object;
        ConeClassLikeType simpleType;
        block13: {
            block12: {
                ConeClassLikeType coneClassLikeType;
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                ConeClassifierLookupTag coneClassifierLookupTag = this.typeSymbol(proto);
                if (coneClassifierLookupTag == null) {
                    return null;
                }
                ConeClassifierLookupTag constructor2 = coneClassifierLookupTag;
                if (constructor2 instanceof ConeTypeParameterLookupTag) {
                    ConeSimpleKotlinType coneSimpleKotlinType;
                    ConeTypeParameterTypeImpl it = new ConeTypeParameterTypeImpl((ConeTypeParameterLookupTag)constructor2, proto.getNullable(), attributes);
                    boolean bl = false;
                    if (Flags.DEFINITELY_NOT_NULL_TYPE.get(proto.getFlags()).booleanValue()) {
                        ConeDefinitelyNotNullType coneDefinitelyNotNullType = TypeUtilsKt.create(ConeDefinitelyNotNullType.Companion, it, TypeComponentsKt.getTypeContext(this.moduleData.getSession()), true);
                        coneSimpleKotlinType = coneDefinitelyNotNullType != null ? (ConeSimpleKotlinType)coneDefinitelyNotNullType : (ConeSimpleKotlinType)it;
                    } else {
                        coneSimpleKotlinType = it;
                    }
                    return coneSimpleKotlinType;
                }
                if (!(constructor2 instanceof ConeClassLikeLookupTag)) {
                    return null;
                }
                Iterable $this$map$iv = FirTypeDeserializer.simpleType$collectAllArguments(proto, this);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.typeArgument((ProtoBuf.Type.Argument)p0));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ConeTypeProjection[] arguments = thisCollection$iv.toArray(new ConeTypeProjection[0]);
                FunctionTypeKind extensionFunctionalKind = FirFunctionTypeKindServiceKt.getFunctionTypeService(this.moduleData.getSession()).extractSingleExtensionKindForDeserializedConeType(((ConeClassLikeLookupTag)constructor2).getClassId(), CustomAnnotationTypeAttributeKt.getCustomAnnotations(attributes));
                if (extensionFunctionalKind != null) {
                    if (!(!(arguments.length == 0))) {
                        return new ConeErrorType(new ConeSimpleDiagnostic("Illegal number of arguments for extension functional type " + extensionFunctionalKind, null, 2, null), false, null, arguments, attributes, 6, null);
                    }
                    ConeClassLikeLookupTagImpl newConstructor = new ConeClassLikeLookupTagImpl(extensionFunctionalKind.numberedClassId(arguments.length - 1));
                    coneClassLikeType = new ConeClassLikeTypeImpl(newConstructor, arguments, proto.getNullable(), attributes);
                } else {
                    coneClassLikeType = simpleType = Flags.SUSPEND_TYPE.get(proto.getFlags()) != false ? this.createSuspendFunctionType((ConeClassLikeLookupTag)constructor2, arguments, proto.getNullable(), attributes) : (ConeClassLikeType)new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)constructor2, arguments, proto.getNullable(), attributes);
                }
                if ((object = ProtoTypeTableUtilKt.abbreviatedType(proto, this.typeTable)) == null) break block12;
                ProtoBuf.Type it = object;
                boolean bl = false;
                ConeSimpleKotlinType coneSimpleKotlinType = this.simpleType(it, attributes);
                object = coneSimpleKotlinType;
                if (coneSimpleKotlinType != null) break block13;
            }
            return simpleType;
        }
        Object abbreviatedType = object;
        return (ConeSimpleKotlinType)TypeUtilsKt.withAttributes((ConeKotlinType)simpleType, simpleType.getAttributes().plus(new AbbreviatedTypeAttribute((ConeKotlinType)abbreviatedType)));
    }

    private final ConeClassLikeType createSuspendFunctionTypeForBasicCase(ConeClassLikeLookupTag functionTypeConstructor, ConeTypeProjection[] arguments, boolean isNullable, ConeAttributes attributes) {
        Object object = ArraysKt.getOrNull((Object[])arguments, (int)(ArraysKt.getLastIndex((Object[])arguments) - 1));
        ConeClassLikeType coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType continuationType = coneClassLikeType;
        if (!FirTypeDeserializer.createSuspendFunctionTypeForBasicCase$isContinuation(continuationType)) {
            return new ConeClassLikeTypeImpl(functionTypeConstructor, arguments, isNullable, attributes);
        }
        ConeTypeProjection suspendReturnType = (ConeTypeProjection)ArraysKt.single((Object[])continuationType.getTypeArguments());
        List valueParameters = ArraysKt.dropLast((Object[])arguments, (int)2);
        FunctionTypeKind.SuspendFunction kind = FunctionTypeKind.SuspendFunction.INSTANCE;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)valueParameters, (Object)suspendReturnType);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(new ClassId(kind.getPackageFqName(), kind.numberedClassName(valueParameters.size()))), thisCollection$iv.toArray(new ConeTypeProjection[0]), isNullable, attributes);
    }

    private final ConeClassLikeType createSuspendFunctionType(ConeClassLikeLookupTag functionTypeConstructor, ConeTypeProjection[] arguments, boolean isNullable, ConeAttributes attributes) {
        ConeClassLikeType result2;
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType coneClassLikeType2;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(functionTypeConstructor, this.moduleData.getSession());
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        Intrinsics.checkNotNull((Object)firClassLikeDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner");
        switch (((FirTypeParameterRefsOwner)firClassLikeDeclaration).getTypeParameters().size() - arguments.length) {
            case 0: {
                coneClassLikeType2 = this.createSuspendFunctionTypeForBasicCase(functionTypeConstructor, arguments, isNullable, attributes);
                break;
            }
            case 1: {
                ConeClassLikeTypeImpl coneClassLikeTypeImpl;
                int arity = arguments.length - 1;
                if (arity >= 0) {
                    FunctionTypeKind.SuspendFunction kind = FunctionTypeKind.SuspendFunction.INSTANCE;
                    coneClassLikeTypeImpl = new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(new ClassId(kind.getPackageFqName(), kind.numberedClassName(arity))), arguments, isNullable, attributes);
                } else {
                    coneClassLikeTypeImpl = null;
                }
                coneClassLikeType2 = coneClassLikeTypeImpl;
                break;
            }
            default: {
                coneClassLikeType2 = null;
            }
        }
        if ((coneClassLikeType = (result2 = coneClassLikeType2)) == null) {
            coneClassLikeType = new ConeErrorType(new ConeSimpleDiagnostic("Bad suspend function in metadata with constructor: " + functionTypeConstructor, DiagnosticKind.DeserializationError), false, null, null, null, 30, null);
        }
        return coneClassLikeType;
    }

    private final ConeClassifierLookupTag typeSymbol(ProtoBuf.Type proto) {
        ConeClassifierLookupTag coneClassifierLookupTag;
        if (proto.hasClassName()) {
            coneClassifierLookupTag = this.computeClassifier(proto.getClassName());
        } else if (proto.hasTypeAliasName()) {
            coneClassifierLookupTag = this.computeClassifier(proto.getTypeAliasName());
        } else if (proto.hasTypeParameter()) {
            coneClassifierLookupTag = this.typeParameterSymbol(proto.getTypeParameter());
        } else if (proto.hasTypeParameterName()) {
            String name2 = this.nameResolver.getString(proto.getTypeParameterName());
            FirTypeParameterSymbol firTypeParameterSymbol = this.typeParameterNames.get(name2);
            coneClassifierLookupTag = firTypeParameterSymbol != null ? firTypeParameterSymbol.toLookupTag() : null;
        } else {
            coneClassifierLookupTag = null;
        }
        return coneClassifierLookupTag;
    }

    private final ConeTypeProjection typeArgument(ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            return ConeStarProjection.INSTANCE;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"getProjection(...)");
        Variance variance = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.typeTable);
        if (type2 == null) {
            return new ConeErrorType(new ConeSimpleDiagnostic("No type recorded", DiagnosticKind.DeserializationError), false, null, null, null, 30, null);
        }
        ProtoBuf.Type type3 = type2;
        ConeKotlinType coneType = this.type(type3);
        return ConeTypeUtilsKt.toTypeProjection(coneType, variance);
    }

    private static final List<ProtoBuf.Type.Argument> simpleType$collectAllArguments(ProtoBuf.Type $this$simpleType_u24collectAllArguments, FirTypeDeserializer this$0) {
        List<ProtoBuf.Type.Argument> list = $this$simpleType_u24collectAllArguments.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getArgumentList(...)");
        Collection collection = list;
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType($this$simpleType_u24collectAllArguments, this$0.typeTable);
        List list2 = type2 != null ? FirTypeDeserializer.simpleType$collectAllArguments(type2, this$0) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    private static final boolean createSuspendFunctionTypeForBasicCase$isContinuation(ConeClassLikeType $this$createSuspendFunctionTypeForBasicCase_u24isContinuation) {
        if ($this$createSuspendFunctionTypeForBasicCase_u24isContinuation.getTypeArguments().length != 1) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$createSuspendFunctionTypeForBasicCase_u24isContinuation.getLookupTag().getClassId(), (Object)StandardClassIds.INSTANCE.getContinuation());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.TypeParameter.Variance.values().length];
            try {
                nArray[ProtoBuf.TypeParameter.Variance.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.TypeParameter.Variance.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.TypeParameter.Variance.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

