/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtVirtualFileSourceFile;
import org.jetbrains.kotlin.cli.common.GroupedKtSources;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.CoreEnvironmentUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"kotlinFileExtensionWithDot", "", "javaFileExtensionWithDot", "collectSources", "Lorg/jetbrains/kotlin/cli/common/GroupedKtSources;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "projectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/VfsBasedProjectEnvironment;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "ktSourceFileComparator", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/KtSourceFile;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "cli"})
@SourceDebugExtension(value={"SMAP\nGroupedKtSources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupedKtSources.kt\norg/jetbrains/kotlin/cli/common/GroupedKtSourcesKt\n+ 2 coreEnvironmentUtils.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CoreEnvironmentUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,94:1\n38#2,46:95\n84#2,6:142\n93#2:155\n1#3:141\n381#4,7:148\n*S KotlinDebug\n*F\n+ 1 GroupedKtSources.kt\norg/jetbrains/kotlin/cli/common/GroupedKtSourcesKt\n*L\n63#1:95,46\n63#1:142,6\n63#1:155\n63#1:141\n75#1:148,7\n*E\n"})
public final class GroupedKtSourcesKt {
    @NotNull
    private static final Comparator<KtSourceFile> ktSourceFileComparator = GroupedKtSourcesKt::ktSourceFileComparator$lambda$0;

    @NotNull
    public static final GroupedKtSources collectSources(@NotNull CompilerConfiguration compilerConfiguration, @NotNull VfsBasedProjectEnvironment projectEnvironment, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)projectEnvironment, (String)"projectEnvironment");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        return GroupedKtSourcesKt.collectSources(compilerConfiguration, projectEnvironment.getProject(), messageCollector);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GroupedKtSources collectSources(@NotNull CompilerConfiguration compilerConfiguration, @NotNull Project project, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        TreeSet<KtSourceFile> platformSources = new TreeSet<KtSourceFile>(ktSourceFileComparator);
        TreeSet<KtSourceFile> commonSources = new TreeSet<KtSourceFile>(ktSourceFileComparator);
        Map sourcesByModuleName = new LinkedHashMap();
        boolean skipScriptsInLtMode = compilerConfiguration.getBoolean(CommonConfigurationKeys.USE_FIR) && compilerConfiguration.getBoolean(CommonConfigurationKeys.USE_LIGHT_TREE);
        boolean skipScriptsInLtModeWarning = false;
        List<KotlinSourceRoot> $this$forAllFiles_u24default$iv = CoreEnvironmentUtilsKt.getSourceRootsCheckingForDuplicates(compilerConfiguration, messageCollector);
        CompilerMessageLocation reportLocation$iv = null;
        boolean $i$f$forAllFiles = false;
        VirtualFileSystem localFileSystem$iv = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles$iv = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator$iv = new PreprocessedFileCreator(project);
        boolean pluginsConfigured$iv = false;
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles_u24default$iv) {
            String sourceRootPath$iv = kotlinSourceRoot.component1();
            boolean isCommon$iv = kotlinSourceRoot.component2();
            String hmppModuleName$iv = kotlinSourceRoot.component3();
            File sourceRoot$iv = new File(sourceRootPath$iv);
            VirtualFile vFile$iv = localFileSystem$iv.findFileByPath(FilesKt.normalize((File)sourceRoot$iv).getPath());
            if (vFile$iv == null) {
                String message$iv = "Source file or directory not found: " + sourceRootPath$iv;
                File buildFilePath$iv = compilerConfiguration.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath$iv != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message$iv + "\n\nbuild file path: " + buildFilePath$iv + "\ncontent:\n" + FilesKt.readText$default((File)buildFilePath$iv, null, (int)1, null));
                }
                CoreEnvironmentUtilsKt.report(compilerConfiguration, CompilerMessageSeverity.ERROR, message$iv, reportLocation$iv);
                continue;
            }
            if (!vFile$iv.isDirectory() && !Intrinsics.areEqual((Object)vFile$iv.getExtension(), (Object)"kt")) {
                if (!pluginsConfigured$iv) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(vFile$iv, project);
                    pluginsConfigured$iv = true;
                }
                if (!Intrinsics.areEqual((Object)vFile$iv.getFileType(), (Object)KotlinFileType.INSTANCE)) {
                    CoreEnvironmentUtilsKt.report(compilerConfiguration, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + sourceRootPath$iv, reportLocation$iv);
                    continue;
                }
            }
            for (File file$iv : FilesKt.walkTopDown((File)sourceRoot$iv)) {
                VirtualFile virtualFile$iv;
                VirtualFile virtualFile;
                if (!file$iv.isFile()) continue;
                File file2 = file$iv.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
                if (localFileSystem$iv.findFileByPath(FilesKt.normalize((File)file2).getPath()) != null) {
                    VirtualFile p0$iv;
                    boolean bl = false;
                    virtualFile = virtualFileCreator$iv.create(p0$iv);
                } else {
                    virtualFile = null;
                }
                if ((virtualFile$iv = virtualFile) == null || !processedFiles$iv.add(virtualFile$iv)) continue;
                if (!pluginsConfigured$iv) {
                    CoreEnvironmentUtilsKt.registerPluginsSuppliedExtensionsIfNeeded(virtualFile$iv, project);
                    pluginsConfigured$iv = true;
                }
                String string2 = hmppModuleName$iv;
                boolean bl = isCommon$iv;
                VirtualFile virtualFile2 = virtualFile$iv;
                boolean bl2 = false;
                KtVirtualFileSourceFile file3 = new KtVirtualFileSourceFile(virtualFile2);
                if (StringsKt.endsWith$default((String)file3.getPath(), (String)".java", (boolean)false, (int)2, null)) continue;
                if (StringsKt.endsWith$default((String)file3.getPath(), (String)".kt", (boolean)false, (int)2, null) || !skipScriptsInLtMode) {
                    Object object;
                    void moduleName;
                    void isCommon;
                    boolean bl3 = isCommon != false ? commonSources.add(file3) : platformSources.add(file3);
                    if (moduleName == null) continue;
                    Map $this$getOrPut$iv = sourcesByModuleName;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(moduleName);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(moduleName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(file3);
                    continue;
                }
                skipScriptsInLtModeWarning = true;
            }
        }
        if (skipScriptsInLtModeWarning) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.STRONG_WARNING, "Scripts are not yet supported with K2 in LightTree mode, consider using K1 or disable LightTree mode with -Xuse-fir-lt=false", null, 4, null);
        }
        return new GroupedKtSources((Collection<? extends KtSourceFile>)platformSources, (Collection<? extends KtSourceFile>)commonSources, sourcesByModuleName);
    }

    private static final int ktSourceFileComparator$lambda$0(KtSourceFile o1, KtSourceFile o2) {
        String string2 = o1.getPath();
        if (string2 == null) {
            throw new IllegalStateException("Expected a file with a well-defined path".toString());
        }
        String path1 = string2;
        String string3 = o2.getPath();
        if (string3 == null) {
            throw new IllegalStateException("Expected a file with a well-defined path".toString());
        }
        String path2 = string3;
        return path1.compareTo(path2);
    }
}

