/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u00a8\u0006\u0005"}, d2={"isTypeSupportedInJsInterop", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isInFunctionReturnPosition", "wasm.frontend"})
public final class WasmJsInteropTypesCheckerKt {
    private static final boolean isTypeSupportedInJsInterop(KotlinType type2, boolean isInFunctionReturnPosition) {
        if (TypeUtilsKt.isUnit(type2) || TypeUtilsKt.isNothing(type2)) {
            return isInFunctionReturnPosition;
        }
        KotlinType nonNullable = TypeUtilsKt.makeNotNullable(type2);
        if (KotlinBuiltIns.isPrimitiveType(nonNullable) || KotlinBuiltIns.isUnsignedNumber(nonNullable) || KotlinBuiltIns.isString(nonNullable)) {
            return true;
        }
        if (TypeUtilsKt.isTypeParameter(nonNullable)) {
            return true;
        }
        ClassifierDescriptor classifierDescriptor = nonNullable.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor instanceof MemberDescriptor && DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)((Object)classifierDescriptor))) {
            return true;
        }
        if (FunctionTypesKt.isFunctionType(type2)) {
            List<TypeProjection> arguments = type2.getArguments();
            int n = CollectionsKt.getLastIndex(arguments);
            for (int i = 0; i < n; ++i) {
                KotlinType kotlinType = arguments.get(i).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                boolean isArgumentSupported = WasmJsInteropTypesCheckerKt.isTypeSupportedInJsInterop(kotlinType, false);
                if (isArgumentSupported) continue;
                return false;
            }
            KotlinType kotlinType = ((TypeProjection)CollectionsKt.last(arguments)).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            return WasmJsInteropTypesCheckerKt.isTypeSupportedInJsInterop(kotlinType, true);
        }
        return false;
    }

    public static final /* synthetic */ boolean access$isTypeSupportedInJsInterop(KotlinType type2, boolean isInFunctionReturnPosition) {
        return WasmJsInteropTypesCheckerKt.isTypeSupportedInJsInterop(type2, isInFunctionReturnPosition);
    }
}

