/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromBaseDirectory;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinPathsFromHomeDir;", "Lorg/jetbrains/kotlin/utils/KotlinPathsFromBaseDirectory;", "homePath", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getHomePath", "()Ljava/io/File;", "libsWithSources", "", "Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;", "getLibsWithSources", "()Ljava/util/Set;", "libsWithSources$delegate", "Lkotlin/Lazy;", "sourcesJar", "jar", "util"})
public final class KotlinPathsFromHomeDir
extends KotlinPathsFromBaseDirectory {
    @NotNull
    private final File homePath;
    @NotNull
    private final Lazy libsWithSources$delegate;

    public KotlinPathsFromHomeDir(@NotNull File homePath) {
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        super(new File(homePath, "lib"));
        this.homePath = homePath;
        this.libsWithSources$delegate = LazyKt.lazy(KotlinPathsFromHomeDir::libsWithSources_delegate$lambda$0);
    }

    @Override
    @NotNull
    public File getHomePath() {
        return this.homePath;
    }

    @NotNull
    public final Set<KotlinPaths.Jar> getLibsWithSources() {
        Lazy lazy = this.libsWithSources$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @Nullable
    public File sourcesJar(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)((Object)jar), (String)"jar");
        return this.getLibsWithSources().contains((Object)jar) ? super.sourcesJar(jar) : null;
    }

    private static final Set libsWithSources_delegate$lambda$0() {
        KotlinPaths.Jar[] jarArray = new KotlinPaths.Jar[]{KotlinPaths.Jar.StdLib, KotlinPaths.Jar.JsStdLib};
        return SetsKt.setOf((Object[])jarArray);
    }
}

