/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.util.Check;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\b\t\n\u000bB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "Lorg/jetbrains/kotlin/util/Check;", "description", "", "<init>", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "NoValueParameters", "SingleValueParameter", "AtLeast", "Equals", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$AtLeast;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$Equals;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$NoValueParameters;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$SingleValueParameter;", "descriptors"})
public abstract class ValueParameterCountCheck
implements Check {
    @NotNull
    private final String description;

    private ValueParameterCountCheck(String description) {
        this.description = description;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }

    public /* synthetic */ ValueParameterCountCheck(String description, DefaultConstructorMarker $constructor_marker) {
        this(description);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$AtLeast;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "n", "", "<init>", "(I)V", "getN", "()I", "check", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptors"})
    public static final class AtLeast
    extends ValueParameterCountCheck {
        private final int n;

        public AtLeast(int n) {
            super("must have at least " + n + " value parameter" + (n > 1 ? "s" : ""), null);
            this.n = n;
        }

        public final int getN() {
            return this.n;
        }

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
            return functionDescriptor.getValueParameters().size() >= this.n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$Equals;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "n", "", "<init>", "(I)V", "getN", "()I", "check", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptors"})
    public static final class Equals
    extends ValueParameterCountCheck {
        private final int n;

        public Equals(int n) {
            super("must have exactly " + n + " value parameters", null);
            this.n = n;
        }

        public final int getN() {
            return this.n;
        }

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
            return functionDescriptor.getValueParameters().size() == this.n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$NoValueParameters;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "<init>", "()V", "check", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptors"})
    public static final class NoValueParameters
    extends ValueParameterCountCheck {
        @NotNull
        public static final NoValueParameters INSTANCE = new NoValueParameters();

        private NoValueParameters() {
            super("must have no value parameters", null);
        }

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
            return functionDescriptor.getValueParameters().isEmpty();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/util/ValueParameterCountCheck$SingleValueParameter;", "Lorg/jetbrains/kotlin/util/ValueParameterCountCheck;", "<init>", "()V", "check", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "descriptors"})
    public static final class SingleValueParameter
    extends ValueParameterCountCheck {
        @NotNull
        public static final SingleValueParameter INSTANCE = new SingleValueParameter();

        private SingleValueParameter() {
            super("must have a single value parameter", null);
        }

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
            return functionDescriptor.getValueParameters().size() == 1;
        }
    }
}

