/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ClassInheritsJavaSealedClassChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class ClassInheritsJavaSealedClassChecker
implements DeclarationChecker {
    @NotNull
    public static final ClassInheritsJavaSealedClassChecker INSTANCE = new ClassInheritsJavaSealedClassChecker();

    private ClassInheritsJavaSealedClassChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor instanceof ClassDescriptor) || !(declaration instanceof KtClassOrObject)) {
            return;
        }
        for (KtSuperTypeListEntry superTypeListEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            LazyJavaClassDescriptor superClass;
            KtTypeReference typeReference;
            if (superTypeListEntry.getTypeReference() == null) continue;
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType(typeReference, bindingContext);
            if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) continue;
            KotlinType superType = kotlinType;
            ClassifierDescriptor classifierDescriptor = superType.getConstructor().getDeclarationDescriptor();
            LazyJavaClassDescriptor lazyJavaClassDescriptor = classifierDescriptor instanceof LazyJavaClassDescriptor ? (LazyJavaClassDescriptor)classifierDescriptor : null;
            if (lazyJavaClassDescriptor == null || !(superClass = lazyJavaClassDescriptor).getJClass().isSealed()) continue;
            context2.getTrace().report(Errors.CLASS_INHERITS_JAVA_SEALED_CLASS.on((KtTypeReference)((PsiElement)typeReference)));
        }
    }
}

