/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000(\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\b\u0005\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u0018\u0010\t\u001a\u00020\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0018\u0010\f\u001a\u00020\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\"\u0018\u0010\u000e\u001a\u00020\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\"\u0018\u0010\u0010\u001a\u00020\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\"\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u0018"}, d2={"minValue", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "maxValue", "unsignedType", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "uIntType", "getUIntType", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/types/SimpleType;", "uLongType", "getULongType", "uByteType", "getUByteType", "uShortType", "getUShortType", "allSignedLiteralTypes", "", "getAllSignedLiteralTypes", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Ljava/util/Collection;", "allUnsignedLiteralTypes", "getAllUnsignedLiteralTypes", "descriptors"})
public final class PrimitiveTypeUtilKt {
    public static final long minValue(@NotNull KotlinType $this$minValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$minValue, (String)"<this>");
        if (UnsignedTypes.isUnsignedType($this$minValue)) {
            return 0L;
        }
        if (KotlinBuiltIns.isByte($this$minValue)) {
            l = -128L;
        } else if (KotlinBuiltIns.isShort($this$minValue)) {
            l = -32768L;
        } else if (KotlinBuiltIns.isInt($this$minValue)) {
            l = Integer.MIN_VALUE;
        } else {
            throw new IllegalStateException(("Can't get min value for type: " + $this$minValue).toString());
        }
        return l;
    }

    public static final long maxValue(@NotNull KotlinType $this$maxValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$maxValue, (String)"<this>");
        if (KotlinBuiltIns.isByte($this$maxValue)) {
            l = 127L;
        } else if (KotlinBuiltIns.isShort($this$maxValue)) {
            l = 32767L;
        } else if (KotlinBuiltIns.isInt($this$maxValue)) {
            l = Integer.MAX_VALUE;
        } else if (KotlinBuiltIns.isUByte($this$maxValue)) {
            l = (long)-1 & 0xFFL;
        } else if (KotlinBuiltIns.isUShort($this$maxValue)) {
            l = (long)-1 & 0xFFFFL;
        } else if (KotlinBuiltIns.isUInt($this$maxValue)) {
            l = (long)-1 & 0xFFFFFFFFL;
        } else {
            throw new IllegalStateException(("Can't get max value for type: " + $this$maxValue).toString());
        }
        return l;
    }

    @NotNull
    public static final SimpleType unsignedType(@NotNull ModuleDescriptor $this$unsignedType, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)$this$unsignedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies($this$unsignedType, classId);
        Intrinsics.checkNotNull((Object)classDescriptor);
        SimpleType simpleType = classDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        return simpleType;
    }

    @NotNull
    public static final SimpleType getUIntType(@NotNull ModuleDescriptor $this$uIntType) {
        Intrinsics.checkNotNullParameter((Object)$this$uIntType, (String)"<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uIntType, StandardNames.FqNames.uInt);
    }

    @NotNull
    public static final SimpleType getULongType(@NotNull ModuleDescriptor $this$uLongType) {
        Intrinsics.checkNotNullParameter((Object)$this$uLongType, (String)"<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uLongType, StandardNames.FqNames.uLong);
    }

    @NotNull
    public static final SimpleType getUByteType(@NotNull ModuleDescriptor $this$uByteType) {
        Intrinsics.checkNotNullParameter((Object)$this$uByteType, (String)"<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uByteType, StandardNames.FqNames.uByte);
    }

    @NotNull
    public static final SimpleType getUShortType(@NotNull ModuleDescriptor $this$uShortType) {
        Intrinsics.checkNotNullParameter((Object)$this$uShortType, (String)"<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uShortType, StandardNames.FqNames.uShort);
    }

    @NotNull
    public static final Collection<KotlinType> getAllSignedLiteralTypes(@NotNull ModuleDescriptor $this$allSignedLiteralTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$allSignedLiteralTypes, (String)"<this>");
        Object[] objectArray = new SimpleType[]{$this$allSignedLiteralTypes.getBuiltIns().getIntType(), $this$allSignedLiteralTypes.getBuiltIns().getLongType(), $this$allSignedLiteralTypes.getBuiltIns().getByteType(), $this$allSignedLiteralTypes.getBuiltIns().getShortType()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final Collection<KotlinType> getAllUnsignedLiteralTypes(@NotNull ModuleDescriptor $this$allUnsignedLiteralTypes) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$allUnsignedLiteralTypes, (String)"<this>");
        if (CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies($this$allUnsignedLiteralTypes)) {
            Object[] objectArray = new SimpleType[]{PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uInt), PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uLong), PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uByte), PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uShort)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

