/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.objects;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.CompanionObjectMappingUtilsKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.translate.intrinsic.objects.DefaultClassObjectIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.objects.ObjectIntrinsic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/objects/ObjectIntrinsics;", "", "<init>", "()V", "cache", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/objects/ObjectIntrinsic;", "getIntrinsic", "classDescriptor", "createIntrinsic", "js.translator"})
public final class ObjectIntrinsics {
    @NotNull
    private final Map<ClassDescriptor, ObjectIntrinsic> cache = new LinkedHashMap();

    @Nullable
    public final ObjectIntrinsic getIntrinsic(@NotNull ClassDescriptor classDescriptor) {
        ObjectIntrinsic objectIntrinsic;
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        if (this.cache.containsKey(classDescriptor)) {
            return this.cache.get(classDescriptor);
        }
        ObjectIntrinsic it = objectIntrinsic = this.createIntrinsic(classDescriptor);
        boolean bl = false;
        this.cache.put(classDescriptor, it);
        return objectIntrinsic;
    }

    private final ObjectIntrinsic createIntrinsic(ClassDescriptor classDescriptor) {
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(classDescriptor), (Object)StandardNames.FqNames._enum) || !CompanionObjectMappingUtilsKt.isMappedIntrinsicCompanionObject(CompanionObjectMapping.INSTANCE, classDescriptor)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        Name name2 = Name.identifier(containingDeclaration.getName().asString() + "CompanionObject");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        Name name3 = name2;
        FqName fqName = new FqName("kotlin.js.internal").child(name3);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"child(...)");
        return new DefaultClassObjectIntrinsic(fqName);
    }
}

