/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.inline.clean.BoxingUnboxingElimination;
import org.jetbrains.kotlin.js.inline.clean.CoroutineStateElimination;
import org.jetbrains.kotlin.js.inline.clean.DeadCodeElimination;
import org.jetbrains.kotlin.js.inline.clean.DoWhileGuardElimination;
import org.jetbrains.kotlin.js.inline.clean.EmptyStatementElimination;
import org.jetbrains.kotlin.js.inline.clean.IfStatementReduction;
import org.jetbrains.kotlin.js.inline.clean.MoveTemporaryVariableDeclarationToAssignment;
import org.jetbrains.kotlin.js.inline.clean.RedundantCallElimination;
import org.jetbrains.kotlin.js.inline.clean.RedundantLabelRemoval;
import org.jetbrains.kotlin.js.inline.clean.RedundantStatementElimination;
import org.jetbrains.kotlin.js.inline.clean.RedundantVariableDeclarationElimination;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination;
import org.jetbrains.kotlin.js.inline.clean.VoidPropertiesElimination;
import org.jetbrains.kotlin.js.inline.clean.WhileConditionFolding;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/FunctionPostProcessor;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "voidName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "getRoot", "()Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "optimizations", "", "Lkotlin/Function0;", "", "getOptimizations", "()Ljava/util/List;", "apply", "", "js.translator"})
@SourceDebugExtension(value={"SMAP\nFunctionPostProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionPostProcessor.kt\norg/jetbrains/kotlin/js/inline/clean/FunctionPostProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class FunctionPostProcessor {
    @NotNull
    private final JsFunction root;
    @Nullable
    private final JsName voidName;
    @NotNull
    private final List<Function0<Boolean>> optimizations;

    public FunctionPostProcessor(@NotNull JsFunction root, @Nullable JsName voidName) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.voidName = voidName;
        Object[] objectArray = new Function0[]{() -> FunctionPostProcessor.optimizations$lambda$0(this), () -> FunctionPostProcessor.optimizations$lambda$1(this), () -> FunctionPostProcessor.optimizations$lambda$2(this), () -> FunctionPostProcessor.optimizations$lambda$3(this), () -> FunctionPostProcessor.optimizations$lambda$4(this), () -> FunctionPostProcessor.optimizations$lambda$5(this), () -> FunctionPostProcessor.optimizations$lambda$6(this), () -> FunctionPostProcessor.optimizations$lambda$7(this), () -> FunctionPostProcessor.optimizations$lambda$8(this), () -> FunctionPostProcessor.optimizations$lambda$9(this), () -> FunctionPostProcessor.optimizations$lambda$10(this), () -> FunctionPostProcessor.optimizations$lambda$11(this), () -> FunctionPostProcessor.optimizations$lambda$12(this), () -> FunctionPostProcessor.optimizations$lambda$14(this)};
        this.optimizations = CollectionsKt.listOf((Object[])objectArray);
    }

    public /* synthetic */ FunctionPostProcessor(JsFunction jsFunction, JsName jsName, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jsName = null;
        }
        this(jsFunction, jsName);
    }

    @NotNull
    public final JsFunction getRoot() {
        return this.root;
    }

    @NotNull
    public final List<Function0<Boolean>> getOptimizations() {
        return this.optimizations;
    }

    public final void apply() {
        boolean hasChanges;
        do {
            hasChanges = false;
            for (Function0<Boolean> opt : this.optimizations) {
                hasChanges |= ((Boolean)opt.invoke()).booleanValue();
            }
        } while (hasChanges);
    }

    private static final boolean optimizations$lambda$0(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new RedundantLabelRemoval(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$1(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new EmptyStatementElimination(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$2(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new WhileConditionFolding(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$3(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new DoWhileGuardElimination(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$4(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new TemporaryVariableElimination(this$0.root).apply();
    }

    private static final boolean optimizations$lambda$5(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new RedundantCallElimination(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$6(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new IfStatementReduction(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$7(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new DeadCodeElimination(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$8(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new RedundantVariableDeclarationElimination(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$9(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new RedundantStatementElimination(this$0.root).apply();
    }

    private static final boolean optimizations$lambda$10(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new CoroutineStateElimination(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$11(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new BoxingUnboxingElimination(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$12(FunctionPostProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsBlock jsBlock = this$0.root.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        return new MoveTemporaryVariableDeclarationToAssignment(jsBlock).apply();
    }

    private static final boolean optimizations$lambda$14(FunctionPostProcessor this$0) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JsName jsName = this$0.voidName;
        if (jsName != null) {
            JsName it = jsName;
            boolean bl2 = false;
            JsBlock jsBlock = this$0.root.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
            bl = new VoidPropertiesElimination(jsBlock, this$0.voidName).apply();
        } else {
            bl = false;
        }
        return bl;
    }
}

