/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.ImportIntoFragmentInliningScope;
import org.jetbrains.kotlin.js.inline.InlineFunctionDefinition;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/InlineSuspendFunctionSplitter;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "scope", "Lorg/jetbrains/kotlin/js/inline/ImportIntoFragmentInliningScope;", "<init>", "(Lorg/jetbrains/kotlin/js/inline/ImportIntoFragmentInliningScope;)V", "getScope", "()Lorg/jetbrains/kotlin/js/inline/ImportIntoFragmentInliningScope;", "visit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "js.translator"})
public final class InlineSuspendFunctionSplitter
extends JsVisitorWithContextImpl {
    @NotNull
    private final ImportIntoFragmentInliningScope scope;

    public InlineSuspendFunctionSplitter(@NotNull ImportIntoFragmentInliningScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.scope = scope2;
    }

    @NotNull
    public final ImportIntoFragmentInliningScope getScope() {
        return this.scope;
    }

    public boolean visit(@NotNull JsInvocation x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(x);
        if (inlineMetadata != null) {
            InlineMetadata metadata = inlineMetadata;
            boolean bl = false;
            FunctionWithWrapper fn = metadata.getFunction();
            if (MetadataProperties.getCoroutineMetadata(fn.getFunction()) != null) {
                ctx.replaceMe((JsNode)this.scope.importFunctionDefinition(new InlineFunctionDefinition(fn, metadata.getTag().getValue())));
                fn.getFunction().setName(null);
                MetadataProperties.setCoroutineMetadata(fn.getFunction(), null);
                MetadataProperties.setInlineableCoroutineBody(fn.getFunction(), true);
                this.getLastStatementLevelContext().addNext((JsNode)x.makeStmt());
            }
            return false;
        }
        FunctionWithWrapper functionWithWrapper = InlineMetadata.Companion.tryExtractFunction(x);
        if (functionWithWrapper != null) {
            FunctionWithWrapper fn = functionWithWrapper;
            boolean bl = false;
            if (MetadataProperties.getCoroutineMetadata(fn.getFunction()) != null) {
                ctx.replaceMe((JsNode)this.scope.importFunctionDefinition(new InlineFunctionDefinition(fn, null)));
            }
            return false;
        }
        return super.visit(x, ctx);
    }
}

