/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterChecker;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterCheckerData;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0083\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u0012\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\f\u0010\u001d\u001a\u00020\u0016*\u00020\u001aH\u0004J\u0014\u0010\u001e\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0016H\u0004J\u0018\u0010 \u001a\u00020\u0013*\u00020\u001a2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer$Data;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "checker", "Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "onWarning", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "suppressExceptions", "", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Z)V", "warningIfError", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "original", "reportIfError", "canBeInterpreted", "interpret", "failAsError", "reportInlinedJavaConst", "result", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "Data", "ir.interpreter"})
public abstract class IrConstTransformer
implements IrElementTransformer<Data> {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final EvaluationMode mode;
    @NotNull
    private final IrInterpreterChecker checker;
    @Nullable
    private final EvaluatedConstTracker evaluatedConstTracker;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onWarning;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onError;
    private final boolean suppressExceptions;

    public IrConstTransformer(@NotNull IrInterpreter interpreter2, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @NotNull IrInterpreterChecker checker, @Nullable EvaluatedConstTracker evaluatedConstTracker, @Nullable InlineConstTracker inlineConstTracker, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onError, boolean suppressExceptions) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.interpreter = interpreter2;
        this.irFile = irFile;
        this.mode = mode;
        this.checker = checker;
        this.evaluatedConstTracker = evaluatedConstTracker;
        this.inlineConstTracker = inlineConstTracker;
        this.onWarning = onWarning;
        this.onError = onError;
        this.suppressExceptions = suppressExceptions;
    }

    private final IrExpression warningIfError(IrExpression $this$warningIfError, IrExpression original) {
        if ($this$warningIfError instanceof IrErrorExpression) {
            this.onWarning.invoke((Object)this.irFile, (Object)original, (Object)$this$warningIfError);
            return original;
        }
        return $this$warningIfError;
    }

    private final IrExpression reportIfError(IrExpression $this$reportIfError, IrExpression original) {
        if ($this$reportIfError instanceof IrErrorExpression) {
            this.onError.invoke((Object)this.irFile, (Object)original, (Object)$this$reportIfError);
            return WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()] == 1 ? (IrExpression)IrConstImpl.Companion.constNull($this$reportIfError.getStartOffset(), $this$reportIfError.getEndOffset(), $this$reportIfError.getType()) : original;
        }
        return $this$reportIfError;
    }

    protected final boolean canBeInterpreted(@NotNull IrExpression $this$canBeInterpreted) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$canBeInterpreted, (String)"<this>");
        try {
            bl = (Boolean)$this$canBeInterpreted.accept(this.checker, new IrInterpreterCheckerData(this.irFile, this.mode, this.interpreter.getIrBuiltIns()));
        }
        catch (Throwable e) {
            if (this.suppressExceptions) {
                return false;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$canBeInterpreted, null, 1, null), e);
        }
        return bl;
    }

    @NotNull
    protected final IrExpression interpret(@NotNull IrExpression $this$interpret, boolean failAsError) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$interpret, (String)"<this>");
        try {
            irExpression = this.interpreter.interpret($this$interpret, this.irFile);
        }
        catch (Throwable e) {
            if (this.suppressExceptions) {
                return $this$interpret;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$interpret, null, 1, null), e);
        }
        IrExpression result2 = irExpression;
        EvaluatedConstTracker evaluatedConstTracker = this.evaluatedConstTracker;
        if (evaluatedConstTracker != null) {
            ConstantValue<?> constantValue;
            int n = result2.getStartOffset();
            int n2 = result2.getEndOffset();
            String string2 = IrDeclarationsKt.getNameWithPackage(this.irFile);
            if (result2 instanceof IrErrorExpression) {
                constantValue = ErrorValue.Companion.create(((IrErrorExpression)result2).getDescription());
            } else {
                Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
                constantValue = IrTreeBuildUtilsKt.toConstantValue((IrConst)result2);
            }
            evaluatedConstTracker.save(n, n2, string2, constantValue);
        }
        if (result2 instanceof IrConst) {
            this.reportInlinedJavaConst($this$interpret, (IrConst)result2);
        }
        return failAsError ? this.reportIfError(result2, $this$interpret) : this.warningIfError(result2, $this$interpret);
    }

    private final void reportInlinedJavaConst(IrExpression $this$reportInlinedJavaConst, IrConst<?> result2) {
        IrVisitorsKt.acceptVoid($this$reportInlinedJavaConst, new IrElementVisitorVoid(this, result2){
            final /* synthetic */ IrConstTransformer this$0;
            final /* synthetic */ IrConst<?> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            private final void report(IrField field) {
                block0: {
                    InlineConstTracker inlineConstTracker = IrConstTransformer.access$getInlineConstTracker$p(this.this$0);
                    if (inlineConstTracker == null) break block0;
                    IrConstTransformerKt.reportOnIr(inlineConstTracker, IrConstTransformer.access$getIrFile$p(this.this$0), field, this.$result);
                }
            }

            public void visitGetField(IrGetField expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.report((IrField)expression2.getSymbol().getOwner());
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrDeclarationBase irDeclarationBase = UtilsKt.getProperty(expression2.getSymbol().getOwner());
                if (irDeclarationBase != null && (irDeclarationBase = irDeclarationBase.getBackingField()) != null) {
                    IrDeclarationBase backingField = irDeclarationBase;
                    boolean bl = false;
                    this.report((IrField)backingField);
                }
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitElement(IrElement element, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
            }

            public void visitGetField(IrGetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitCall(IrCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
            }

            public void visitDeclaration(IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
            }

            public void visitValueParameter(IrValueParameter declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
            }

            public void visitValueParameter(IrValueParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
            }

            public void visitClass(IrClass declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
            }

            public void visitClass(IrClass declaration) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
            }

            public void visitTypeParameter(IrTypeParameter declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
            }

            public void visitTypeParameter(IrTypeParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
            }

            public void visitFunction(IrFunction declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
            }

            public void visitFunction(IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
            }

            public void visitConstructor(IrConstructor declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
            }

            public void visitConstructor(IrConstructor declaration) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
            }

            public void visitEnumEntry(IrEnumEntry declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
            }

            public void visitEnumEntry(IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
            }

            public void visitField(IrField declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
            }

            public void visitField(IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
            }

            public void visitModuleFragment(IrModuleFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
            }

            public void visitModuleFragment(IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
            }

            public void visitProperty(IrProperty declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
            }

            public void visitProperty(IrProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
            }

            public void visitScript(IrScript declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
            }

            public void visitScript(IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
            }

            public void visitTypeAlias(IrTypeAlias declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
            }

            public void visitTypeAlias(IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
            }

            public void visitVariable(IrVariable declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
            }

            public void visitVariable(IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
            }

            public void visitPackageFragment(IrPackageFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
            }

            public void visitPackageFragment(IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
            }

            public void visitFile(IrFile declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
            }

            public void visitFile(IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
            }

            public void visitExpression(IrExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitExpression(IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitBody(IrBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBody(IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitExpressionBody(IrExpressionBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExpressionBody(IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitBlockBody(IrBlockBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBlockBody(IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public void visitConstructorCall(IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitContainerExpression(IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitBlock(IrBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitBlock(IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitComposite(IrComposite expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
            }

            public void visitComposite(IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2, data);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock(this, expression2);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock);
            }

            public void visitSyntheticBody(IrSyntheticBody body2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitSyntheticBody(IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitBreakContinue(IrBreakContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitBreakContinue(IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreak(IrBreak jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreak(IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitContinue(IrContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitContinue(IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitCallableReference(IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitFunctionReference(IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitPropertyReference(IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitClassReference(IrClassReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitClassReference(IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitConst(IrConst<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConst(IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public void visitConstantValue(IrConstantValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public void visitConstantValue(IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantObject(IrConstantObject expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public void visitConstantObject(IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantArray(IrConstantArray expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public void visitConstantArray(IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitErrorExpression(IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitSetField(IrSetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitSetField(IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitGetClass(IrGetClass expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitGetClass(IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitLoop(IrLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
            }

            public void visitLoop(IrLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
            }

            public void visitWhileLoop(IrWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
            }

            public void visitWhileLoop(IrWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
            }

            public void visitReturn(IrReturn expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitReturn(IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitThrow(IrThrow expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitThrow(IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitTry(IrTry aTry, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTry(IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitCatch(IrCatch aCatch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitCatch(IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitValueAccess(IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
            }

            public void visitGetValue(IrGetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitGetValue(IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitSetValue(IrSetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public void visitSetValue(IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitVararg(IrVararg expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitVararg(IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitSpreadElement(IrSpreadElement spread, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitSpreadElement(IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitWhen(IrWhen expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitWhen(IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitBranch(IrBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBranch(IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitElseBranch(IrElseBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitElseBranch(IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }
        });
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitScript(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitReturnableBlock(@NotNull IrReturnableBlock expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitReturnableBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
    }

    @Override
    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLoop(this, loop, data);
    }

    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop, data);
    }

    @Override
    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop, data);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    public static final /* synthetic */ InlineConstTracker access$getInlineConstTracker$p(IrConstTransformer $this) {
        return $this.inlineConstTracker;
    }

    public static final /* synthetic */ IrFile access$getIrFile$p(IrConstTransformer $this) {
        return $this.irFile;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer$Data;", "", "inConstantExpression", "", "<init>", "(Z)V", "getInConstantExpression", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "ir.interpreter"})
    public static final class Data {
        private final boolean inConstantExpression;

        public Data(boolean inConstantExpression) {
            this.inConstantExpression = inConstantExpression;
        }

        public /* synthetic */ Data(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getInConstantExpression() {
            return this.inConstantExpression;
        }

        public final boolean component1() {
            return this.inConstantExpression;
        }

        @NotNull
        public final Data copy(boolean inConstantExpression) {
            return new Data(inConstantExpression);
        }

        public static /* synthetic */ Data copy$default(Data data, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = data.inConstantExpression;
            }
            return data.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Data(inConstantExpression=" + this.inConstantExpression + ')';
        }

        public int hashCode() {
            return Boolean.hashCode(this.inConstantExpression);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            return this.inConstantExpression == data.inConstantExpression;
        }

        public Data() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EvaluationMode.values().length];
            try {
                nArray[EvaluationMode.ONLY_INTRINSIC_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

