/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.ic.SrcFileArtifact;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformerKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrModule;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrProgramFragment;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrProgramFragments;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact;", "", "moduleName", "", "fileArtifacts", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SrcFileArtifact;", "artifactsDir", "Ljava/io/File;", "forceRebuildJs", "", "externalModuleName", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/io/File;ZLjava/lang/String;)V", "getFileArtifacts", "()Ljava/util/List;", "getArtifactsDir", "()Ljava/io/File;", "getForceRebuildJs", "()Z", "moduleSafeName", "getModuleSafeName", "()Ljava/lang/String;", "moduleExternalName", "getModuleExternalName", "loadJsIrModule", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModule;", "reexportedInModuleWithName", "backend.js"})
@SourceDebugExtension(value={"SMAP\nModuleArtifact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleArtifact.kt\norg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1053#2:58\n1368#2:59\n1454#2,5:60\n*S KotlinDebug\n*F\n+ 1 ModuleArtifact.kt\norg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact\n*L\n50#1:58\n50#1:59\n50#1:60,5\n*E\n"})
public final class ModuleArtifact {
    @NotNull
    private final List<SrcFileArtifact> fileArtifacts;
    @Nullable
    private final File artifactsDir;
    private final boolean forceRebuildJs;
    @NotNull
    private final String moduleSafeName;
    @NotNull
    private final String moduleExternalName;

    public ModuleArtifact(@NotNull String moduleName, @NotNull List<SrcFileArtifact> fileArtifacts, @Nullable File artifactsDir, boolean forceRebuildJs, @Nullable String externalModuleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter(fileArtifacts, (String)"fileArtifacts");
        this.fileArtifacts = fileArtifacts;
        this.artifactsDir = artifactsDir;
        this.forceRebuildJs = forceRebuildJs;
        this.moduleSafeName = IrModuleToJsTransformerKt.getSafeModuleName(moduleName);
        String string2 = externalModuleName;
        if (string2 == null) {
            string2 = this.moduleSafeName;
        }
        this.moduleExternalName = string2;
    }

    public /* synthetic */ ModuleArtifact(String string2, List list, File file2, boolean bl, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            file2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        this(string2, list, file2, bl, string3);
    }

    @NotNull
    public final List<SrcFileArtifact> getFileArtifacts() {
        return this.fileArtifacts;
    }

    @Nullable
    public final File getArtifactsDir() {
        return this.artifactsDir;
    }

    public final boolean getForceRebuildJs() {
        return this.forceRebuildJs;
    }

    @NotNull
    public final String getModuleSafeName() {
        return this.moduleSafeName;
    }

    @NotNull
    public final String getModuleExternalName() {
        return this.moduleExternalName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsIrModule loadJsIrModule(@Nullable String reexportedInModuleWithName) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$sortedBy$iv = this.fileArtifacts;
        boolean $i$f$sortedBy = false;
        Iterable $this$flatMap$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SrcFileArtifact it = (SrcFileArtifact)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getSrcFilePath());
                it = (SrcFileArtifact)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getSrcFilePath())));
            }
        });
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SrcFileArtifact it = (SrcFileArtifact)element$iv$iv;
            boolean bl = false;
            JsIrProgramFragments fragments = it.loadJsIrFragments();
            Object[] objectArray = new JsIrProgramFragment[2];
            JsIrProgramFragments jsIrProgramFragments = fragments;
            objectArray[0] = jsIrProgramFragments != null ? jsIrProgramFragments.getMainFragment() : null;
            JsIrProgramFragments jsIrProgramFragments2 = fragments;
            objectArray[1] = jsIrProgramFragments2 != null ? jsIrProgramFragments2.getExportFragment() : null;
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List fragments = (List)destination$iv$iv;
        return new JsIrModule(this.moduleSafeName, this.moduleExternalName, fragments, reexportedInModuleWithName, null, 16, null);
    }

    public static /* synthetic */ JsIrModule loadJsIrModule$default(ModuleArtifact moduleArtifact, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return moduleArtifact.loadJsIrModule(string2);
    }
}

