/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.AbiSnapshot;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransactionKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.PackagePartProtoData;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.MessageLite;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/AbiSnapshotImpl;", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "protos", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/incremental/ProtoData;", "<init>", "(Ljava/util/Map;)V", "getProtos", "()Ljava/util/Map;", "Companion", "incremental-compilation-impl"})
public final class AbiSnapshotImpl
implements AbiSnapshot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<FqName, ProtoData> protos;

    public AbiSnapshotImpl(@NotNull Map<FqName, ProtoData> protos) {
        Intrinsics.checkNotNullParameter(protos, (String)"protos");
        this.protos = protos;
    }

    @Override
    @NotNull
    public Map<FqName, ProtoData> getProtos() {
        return this.protos;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u00020\n*\u00020\u0007J\u001d\u0010\u000b\u001a\u00020\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u00020\f*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u00020\f*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\f*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/incremental/AbiSnapshotImpl$Companion;", "", "<init>", "()V", "readStringArray", "", "", "Ljava/io/ObjectInputStream;", "(Ljava/io/ObjectInputStream;)[Ljava/lang/String;", "readAbiSnapshot", "Lorg/jetbrains/kotlin/incremental/AbiSnapshotImpl;", "writeStringArray", "", "Ljava/io/ObjectOutputStream;", "stringArray", "(Ljava/io/ObjectOutputStream;[Ljava/lang/String;)V", "writeAbiSnapshot", "abiSnapshot", "Lorg/jetbrains/kotlin/incremental/AbiSnapshot;", "writeMessageWithNameResolverImpl", "message", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "writeMessageWithJvmNameResolver", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "write", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "buildInfo", "file", "Ljava/io/File;", "read", "incremental-compilation-impl"})
    @SourceDebugExtension(value={"SMAP\nAbiSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiSnapshot.kt\norg/jetbrains/kotlin/incremental/AbiSnapshotImpl$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,161:1\n13346#2,2:162\n*S KotlinDebug\n*F\n+ 1 AbiSnapshot.kt\norg/jetbrains/kotlin/incremental/AbiSnapshotImpl$Companion\n*L\n71#1:162,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] readStringArray(@NotNull ObjectInputStream $this$readStringArray) {
            Intrinsics.checkNotNullParameter((Object)$this$readStringArray, (String)"<this>");
            int size = $this$readStringArray.readInt();
            Object[] stringArray = new String[size];
            int n = 0;
            while (n < size) {
                int it = n++;
                boolean bl = false;
                stringArray[it] = $this$readStringArray.readUTF();
            }
            return (String[])ArraysKt.requireNoNulls((Object[])stringArray);
        }

        @NotNull
        public final AbiSnapshotImpl readAbiSnapshot(@NotNull ObjectInputStream $this$readAbiSnapshot) {
            Intrinsics.checkNotNullParameter((Object)$this$readAbiSnapshot, (String)"<this>");
            int size = $this$readAbiSnapshot.readInt();
            HashMap mutableMap = new HashMap();
            for (int i = 0; i < size; ++i) {
                FqName fqName;
                int it = i;
                boolean bl = false;
                String fqNameString = $this$readAbiSnapshot.readUTF();
                boolean isClassProtoData = $this$readAbiSnapshot.readBoolean();
                if (isClassProtoData) {
                    fqName = new FqName(fqNameString);
                    String[] bytes = Companion.readStringArray($this$readAbiSnapshot);
                    String[] strings2 = Companion.readStringArray($this$readAbiSnapshot);
                    Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(bytes, strings2);
                    JvmNameResolver nameResolver = (JvmNameResolver)pair.component1();
                    ProtoBuf.Class classProto2 = (ProtoBuf.Class)pair.component2();
                    ((Map)mutableMap).put(fqName, new ClassProtoData(classProto2, nameResolver));
                    continue;
                }
                fqName = new FqName(fqNameString);
                FqName packageFqName = new FqName($this$readAbiSnapshot.readUTF());
                String[] bytes = Companion.readStringArray($this$readAbiSnapshot);
                String[] strings3 = Companion.readStringArray($this$readAbiSnapshot);
                Pair<JvmNameResolver, ProtoBuf.Package> pair = JvmProtoBufUtil.readPackageDataFrom(bytes, strings3);
                JvmNameResolver nameResolver = (JvmNameResolver)pair.component1();
                ProtoBuf.Package proto = (ProtoBuf.Package)pair.component2();
                ((Map)mutableMap).put(fqName, new PackagePartProtoData(proto, nameResolver, packageFqName));
            }
            return new AbiSnapshotImpl(mutableMap);
        }

        public final void writeStringArray(@NotNull ObjectOutputStream $this$writeStringArray, @NotNull String[] stringArray) {
            Intrinsics.checkNotNullParameter((Object)$this$writeStringArray, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"stringArray");
            $this$writeStringArray.writeInt(stringArray.length);
            String[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                $this$writeStringArray.writeUTF(it);
            }
        }

        public final void writeAbiSnapshot(@NotNull ObjectOutputStream $this$writeAbiSnapshot, @NotNull AbiSnapshot abiSnapshot2) {
            Intrinsics.checkNotNullParameter((Object)$this$writeAbiSnapshot, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)abiSnapshot2, (String)"abiSnapshot");
            $this$writeAbiSnapshot.writeInt(abiSnapshot2.getProtos().size());
            for (Map.Entry<FqName, ProtoData> entry : abiSnapshot2.getProtos().entrySet()) {
                NameResolver nameResolver;
                NameResolver nameResolver2;
                ProtoData protoData;
                $this$writeAbiSnapshot.writeUTF(entry.getKey().asString());
                ProtoData protoData2 = protoData = entry.getValue();
                if (protoData2 instanceof ClassProtoData) {
                    $this$writeAbiSnapshot.writeBoolean(true);
                    nameResolver = nameResolver2 = ((ClassProtoData)protoData).getNameResolver();
                    if (nameResolver instanceof NameResolverImpl) {
                        this.writeMessageWithNameResolverImpl($this$writeAbiSnapshot, ((ClassProtoData)protoData).getProto(), (NameResolverImpl)nameResolver2);
                        continue;
                    }
                    if (nameResolver instanceof JvmNameResolver) {
                        this.writeMessageWithJvmNameResolver($this$writeAbiSnapshot, ((ClassProtoData)protoData).getProto(), (JvmNameResolver)nameResolver2);
                        continue;
                    }
                    throw new IllegalStateException("Can't store name resolver for class proto: " + nameResolver2.getClass());
                }
                if (protoData2 instanceof PackagePartProtoData) {
                    $this$writeAbiSnapshot.writeBoolean(false);
                    $this$writeAbiSnapshot.writeUTF(((PackagePartProtoData)protoData).getPackageFqName().asString());
                    nameResolver = nameResolver2 = ((PackagePartProtoData)protoData).getNameResolver();
                    if (nameResolver instanceof JvmNameResolver) {
                        this.writeMessageWithJvmNameResolver($this$writeAbiSnapshot, ((PackagePartProtoData)protoData).getProto(), (JvmNameResolver)nameResolver2);
                        continue;
                    }
                    if (nameResolver instanceof NameResolverImpl) {
                        this.writeMessageWithNameResolverImpl($this$writeAbiSnapshot, ((PackagePartProtoData)protoData).getProto(), (NameResolverImpl)nameResolver2);
                        continue;
                    }
                    throw new IllegalStateException("Can't store name resolver for package proto: " + nameResolver2.getClass());
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        private final void writeMessageWithNameResolverImpl(ObjectOutputStream $this$writeMessageWithNameResolverImpl, MessageLite message, NameResolverImpl nameResolver) {
            int it;
            JvmStringTable stringTable2 = new JvmStringTable(null, 1, null);
            int n = nameResolver.getStrings().getStringCount();
            int n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                stringTable2.getStringIndex(nameResolver.getString(it));
            }
            n = nameResolver.getQualifiedNames().getQualifiedNameCount();
            n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                stringTable2.getQualifiedClassNameIndex(nameResolver.getQualifiedClassName(it), nameResolver.isLocalClassName(it));
            }
            String[] writeData = JvmProtoBufUtil.writeData(message, stringTable2);
            this.writeStringArray($this$writeMessageWithNameResolverImpl, writeData);
            int size = nameResolver.getStrings().getStringCount();
            $this$writeMessageWithNameResolverImpl.writeInt(size);
            int n3 = 0;
            while (n3 < size) {
                int it2 = n3++;
                boolean bl = false;
                String string2 = nameResolver.getString(it2);
                $this$writeMessageWithNameResolverImpl.writeUTF(string2);
            }
        }

        private final void writeMessageWithJvmNameResolver(ObjectOutputStream $this$writeMessageWithJvmNameResolver, MessageLite message, JvmNameResolver nameResolver) {
            String[] writeData = JvmProtoBufUtil.writeData(message, new JvmStringTable(nameResolver));
            this.writeStringArray($this$writeMessageWithJvmNameResolver, writeData);
            this.writeStringArray($this$writeMessageWithJvmNameResolver, nameResolver.getStrings());
        }

        public final void write(@NotNull IncrementalCompilationContext icContext, @NotNull AbiSnapshot buildInfo, @NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
            Intrinsics.checkNotNullParameter((Object)buildInfo, (String)"buildInfo");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            CompilationTransaction compilationTransaction = icContext.getTransaction();
            Path path = file2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            CompilationTransactionKt.write(compilationTransaction, path, (Function0<Unit>)((Function0)() -> Companion.write$lambda$7(file2, buildInfo)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final AbiSnapshot read(@NotNull File file2) {
            AbiSnapshotImpl abiSnapshotImpl;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Closeable closeable = new ObjectInputStream(new FileInputStream(file2));
            Throwable throwable = null;
            try {
                ObjectInputStream it = (ObjectInputStream)closeable;
                boolean bl = false;
                abiSnapshotImpl = Companion.readAbiSnapshot(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return abiSnapshotImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit write$lambda$7(File $file, AbiSnapshot $buildInfo) {
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            Intrinsics.checkNotNullParameter((Object)$buildInfo, (String)"$buildInfo");
            Closeable closeable = new ObjectOutputStream(new FileOutputStream($file));
            Throwable throwable = null;
            try {
                ObjectOutputStream it = (ObjectOutputStream)closeable;
                boolean bl = false;
                Companion.writeAbiSnapshot(it, $buildInfo);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

