/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.constant.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitor;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitorData;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformer;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerData;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010J*\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0014H\u0002J\u0019\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationSerializer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "stringTable", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;)V", "getStringTable$fir_serialization", "()Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "serializeAnnotation", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/constant/AnnotationValue;", "coneType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "argumentsMapping", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "valueProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value$Builder;", "constant", "valueProto$fir_serialization", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationSerializer.kt\norg/jetbrains/kotlin/fir/serialization/FirAnnotationSerializer\n+ 2 FirToConstantValueTransformer.kt\norg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformerKt\n+ 3 ConstantValueUtils.kt\norg/jetbrains/kotlin/fir/serialization/constant/ConstantValueUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n35#2,2:81\n55#3:83\n1#4:84\n*S KotlinDebug\n*F\n+ 1 FirAnnotationSerializer.kt\norg/jetbrains/kotlin/fir/serialization/FirAnnotationSerializer\n*L\n32#1:81,2\n38#1:83\n*E\n"})
public final class FirAnnotationSerializer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirElementAwareStringTable stringTable;
    @Nullable
    private final ConstValueProvider constValueProvider;

    public FirAnnotationSerializer(@NotNull FirSession session2, @NotNull FirElementAwareStringTable stringTable2, @Nullable ConstValueProvider constValueProvider) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)stringTable2, (String)"stringTable");
        this.session = session2;
        this.stringTable = stringTable2;
        this.constValueProvider = constValueProvider;
    }

    @NotNull
    public final FirElementAwareStringTable getStringTable$fir_serialization() {
        return this.stringTable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull FirAnnotation annotation) {
        ConstantValue constantValue;
        void $this$toConstantValue$iv;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        FirExpression firExpression = annotation;
        FirSession firSession = this.session;
        ConstValueProvider constValueProvider$iv = this.constValueProvider;
        boolean $i$f$toConstantValue = false;
        ConstValueProvider constValueProvider = constValueProvider$iv;
        ConstantValue<Object> constantValue2 = constValueProvider != null ? constValueProvider.findConstantValueFor((FirExpression)$this$toConstantValue$iv) : null;
        if (!(constantValue2 instanceof AnnotationValue)) {
            constantValue2 = null;
        }
        if ((constantValue = (ConstantValue)((AnnotationValue)constantValue2)) == null) {
            void session$iv;
            Object r = $this$toConstantValue$iv.accept(FirToConstantValueTransformer.INSTANCE, new FirToConstantValueTransformerData((FirSession)session$iv, constValueProvider$iv));
            if (!(r instanceof AnnotationValue)) {
                r = null;
            }
            constantValue = (AnnotationValue)r;
        }
        AnnotationValue annotationValue = (AnnotationValue)constantValue;
        if (annotationValue == null) {
            throw new IllegalStateException(("Cannot serialize annotation " + UtilsKt.render(annotation)).toString());
        }
        AnnotationValue annotationValue2 = annotationValue;
        return this.serializeAnnotation(annotationValue2);
    }

    @NotNull
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull AnnotationValue annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        AnnotationValue $this$coneTypeSafe$iv = annotation;
        boolean $i$f$coneTypeSafe = false;
        KotlinTypeMarker kotlinTypeMarker = ((AnnotationValue.Value)$this$coneTypeSafe$iv.getValue()).getType();
        if (!(kotlinTypeMarker instanceof ConeClassLikeType)) {
            kotlinTypeMarker = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)kotlinTypeMarker));
        return this.serializeAnnotation(coneClassLikeType != null ? TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType, this.session, null, 2, null) : null, ((AnnotationValue.Value)annotation.getValue()).getArgumentsMapping());
    }

    /*
     * WARNING - void declaration
     */
    private final ProtoBuf.Annotation serializeAnnotation(ConeClassLikeType coneType, Map<Name, ? extends ConstantValue<?>> argumentsMapping) {
        int n;
        ProtoBuf.Annotation.Builder builder;
        ProtoBuf.Annotation.Builder $this$serializeAnnotation_u24lambda_u242 = builder = ProtoBuf.Annotation.newBuilder();
        boolean bl = false;
        Object object = coneType;
        if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            throw new IllegalStateException(((Function0)() -> FirAnnotationSerializer.serializeAnnotation$lambda$2$lambda$0(coneType)).toString());
        }
        Object lookupTag = object;
        ProtoBuf.Annotation.Builder builder2 = $this$serializeAnnotation_u24lambda_u242;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)lookupTag, this.session);
        if (firClassLikeSymbol != null) {
            void it;
            FirClassLikeSymbol<?> firClassLikeSymbol2 = firClassLikeSymbol;
            ProtoBuf.Annotation.Builder builder3 = builder2;
            boolean bl2 = false;
            builder2 = builder3;
            n = ((Number)this.stringTable.getFqNameIndex((FirClassLikeDeclaration)it.getFir())).intValue();
        } else {
            n = this.stringTable.getQualifiedClassNameIndex(((ConeClassLikeLookupTag)lookupTag).getClassId());
        }
        builder2.setId(n);
        for (Map.Entry<Name, ConstantValue<?>> entry : argumentsMapping.entrySet()) {
            Name name2 = entry.getKey();
            ConstantValue<?> argument = entry.getValue();
            if (!(argument instanceof ErrorValue)) {
                FirAnnotationSerializer.serializeAnnotation$lambda$2$addArgument(this, $this$serializeAnnotation_u24lambda_u242, argument, name2);
                continue;
            }
            if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).getFlag(AnalysisFlags.getMetadataCompilation()).booleanValue()) continue;
            ConstantValue<?> constantValue = argument;
            Object object2 = constantValue instanceof ErrorValue.ErrorValueWithMessage ? (ErrorValue.ErrorValueWithMessage)constantValue : null;
            if (object2 == null || (object2 = ((ErrorValue.ErrorValueWithMessage)object2).getMessage()) == null) {
                object2 = "Error value after conversion of expression of " + name2 + " argument";
            }
            Object object3 = object2;
            throw new IllegalStateException(object3.toString());
        }
        ProtoBuf.Annotation annotation = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"build(...)");
        return annotation;
    }

    @NotNull
    public final ProtoBuf.Annotation.Argument.Value.Builder valueProto$fir_serialization(@NotNull ConstantValue<?> constant) {
        ProtoBuf.Annotation.Argument.Value.Builder builder;
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        ProtoBuf.Annotation.Argument.Value.Builder $this$valueProto_u24lambda_u243 = builder = ProtoBuf.Annotation.Argument.Value.newBuilder();
        boolean bl = false;
        AnnotationArgumentVisitor annotationArgumentVisitor = FirAnnotationArgumentVisitor.INSTANCE;
        Intrinsics.checkNotNull((Object)$this$valueProto_u24lambda_u243);
        constant.accept(annotationArgumentVisitor, new FirAnnotationArgumentVisitorData(this, $this$valueProto_u24lambda_u243));
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
        return builder2;
    }

    private static final String serializeAnnotation$lambda$2$lambda$0(ConeClassLikeType $coneType) {
        return "Annotation without proper lookup tag: " + $coneType;
    }

    private static final void serializeAnnotation$lambda$2$addArgument(FirAnnotationSerializer this$0, ProtoBuf.Annotation.Builder $this_apply, ConstantValue<?> argumentExpression, Name parameterName) {
        ProtoBuf.Annotation.Argument.Builder argument = ProtoBuf.Annotation.Argument.newBuilder();
        FirElementAwareStringTable firElementAwareStringTable = this$0.stringTable;
        String string2 = parameterName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        argument.setNameId(firElementAwareStringTable.getStringIndex(string2));
        argument.setValue(this$0.valueProto$fir_serialization(argumentExpression));
        $this_apply.addArgument(argument);
    }
}

