/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable;", "Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "localPoppedUpClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Ljava/util/List;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;)V", "getLocalClassIdReplacement", "Lorg/jetbrains/kotlin/name/ClassId;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmElementAwareStringTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmElementAwareStringTable.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1863#2,2:60\n*S KotlinDebug\n*F\n+ 1 FirJvmElementAwareStringTable.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmElementAwareStringTable\n*L\n52#1:60,2\n*E\n"})
public final class FirJvmElementAwareStringTable
extends JvmStringTable
implements FirElementAwareStringTable {
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final List<IrAttributeContainer> localPoppedUpClasses;

    public FirJvmElementAwareStringTable(@NotNull IrTypeMapper typeMapper2, @NotNull Fir2IrComponents components, @NotNull List<? extends IrAttributeContainer> localPoppedUpClasses, @Nullable JvmNameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)typeMapper2, (String)"typeMapper");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Intrinsics.checkNotNullParameter(localPoppedUpClasses, (String)"localPoppedUpClasses");
        super(nameResolver);
        this.typeMapper = typeMapper2;
        this.components = components;
        this.localPoppedUpClasses = localPoppedUpClasses;
    }

    public /* synthetic */ FirJvmElementAwareStringTable(IrTypeMapper irTypeMapper, Fir2IrComponents fir2IrComponents, List list, JvmNameResolver jvmNameResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            jvmNameResolver = null;
        }
        this(irTypeMapper, fir2IrComponents, list, jvmNameResolver);
    }

    @Override
    @NotNull
    public ClassId getLocalClassIdReplacement(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        return this.getLocalClassIdReplacement(this.components.getClassifierStorage().getIrClass(firClass));
    }

    private final ClassId getLocalClassIdReplacement(IrClass $this$getLocalClassIdReplacement) {
        String thisClassName = StringsKt.replace$default((String)this.typeMapper.classInternalName($this$getLocalClassIdReplacement), (char)'/', (char)'.', (boolean)false, (int)4, null);
        if (this.localPoppedUpClasses.contains($this$getLocalClassIdReplacement.getAttributeOwnerId())) {
            FqName thisClassFqName = new FqName(thisClassName);
            FqName fqName = thisClassFqName.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"parent(...)");
            FqName fqName2 = FqName.topLevel(thisClassFqName.shortName());
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"topLevel(...)");
            return new ClassId(fqName, fqName2, true);
        }
        IrClass topmostClassParent = (IrClass)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)$this$getLocalClassIdReplacement, FirJvmElementAwareStringTable::getLocalClassIdReplacement$lambda$0));
        String topmostClassParentName = StringsKt.replace$default((String)this.typeMapper.classInternalName(topmostClassParent), (char)'/', (char)'.', (boolean)false, (int)4, null);
        FqName prefixFqName = new FqName(topmostClassParentName);
        ClassId classId = null;
        FqName fqName = prefixFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"parent(...)");
        FqName fqName3 = FqName.topLevel(prefixFqName.shortName());
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"topLevel(...)");
        classId = new ClassId(fqName, fqName3, true);
        if (thisClassName.length() == topmostClassParentName.length()) {
            return classId;
        }
        String string2 = thisClassName.substring(topmostClassParentName.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        char[] cArray = new char[]{'$'};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Name name2 = Name.identifier(it);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            classId = classId.createNestedClassId(name2);
        }
        return classId;
    }

    private static final IrClass getLocalClassIdReplacement$lambda$0(IrClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrDeclarationParent irDeclarationParent = it.getParent();
        return irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
    }
}

