/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.ConversionTypeOrigin;
import org.jetbrains.kotlin.fir.backend.DelicateDeclarationStorageApi;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrCommonMemberStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrIrGeneratedDeclarationsRegistrar;
import org.jetbrains.kotlin.fir.backend.Fir2IrLocalClassStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrSymbolsMappingForLazyClasses;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.FirProviderWithGeneratedFiles;
import org.jetbrains.kotlin.fir.backend.IrBuiltInsOverFir;
import org.jetbrains.kotlin.fir.backend.LeakedDeclarationCaches;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DelegatedMemberGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGeneratorKt;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrClassifiersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyDeclarationsGenerator;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.lazy.Fir2IrLazyClass;
import org.jetbrains.kotlin.fir.lazy.Fir2IrLazyTypeAlias;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.signaturer.FirBasedSignatureComposer;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.overrides.IrFakeOverrideBuilder;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrEnumEntrySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrTypeAliasSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrTypeParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00a0\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\"0$H\u0007J\u0016\u0010(\u001a\u00020)*\u00020*2\b\b\u0002\u0010+\u001a\u00020,H\u0002J\u0015\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b0J'\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u0002042\b\b\u0002\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b5J\"\u00106\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u0002042\b\b\u0002\u0010+\u001a\u00020,H\u0002J!\u00107\u001a\u0004\u0018\u00010\u00122\u0006\u00102\u001a\u00020\u00112\b\b\u0002\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b8J\u0016\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010+\u001a\u00020,J\u0010\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020\u0011H\u0002J\"\u0010?\u001a\u00020\u00192\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020B2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010DJ\b\u0010E\u001a\u00020\fH\u0002J\u001d\u0010F\u001a\u00020\"2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\bHJ\u000e\u0010I\u001a\u00020\u00192\u0006\u0010J\u001a\u00020 J\u0010\u0010I\u001a\u0004\u0018\u00010\u00192\u0006\u0010K\u001a\u00020LJ\u0010\u0010M\u001a\u0004\u0018\u00010\u00192\u0006\u0010N\u001a\u00020 J\u0012\u0010O\u001a\u0004\u0018\u00010\u00192\u0006\u0010N\u001a\u00020 H\u0002J\u0012\u0010P\u001a\u00020\f2\n\u0010Q\u001a\u0006\u0012\u0002\b\u00030RJ\u0010\u0010P\u001a\u0004\u0018\u00010\f2\u0006\u0010K\u001a\u00020LJ\u001c\u0010S\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010G\u001a\u00020\u00192\u0006\u0010N\u001a\u00020 J\u0010\u0010T\u001a\u00020\u00192\u0006\u0010N\u001a\u00020 H\u0002J\u0006\u0010U\u001a\u00020\"J.\u0010V\u001a\u00020\u00192\u0006\u0010W\u001a\u00020X2\b\b\u0002\u0010Y\u001a\u00020Z2\b\b\u0002\u0010[\u001a\u00020\\2\n\b\u0002\u0010]\u001a\u0004\u0018\u00010BJ \u0010^\u001a\u00020\u00192\u0006\u0010W\u001a\u00020X2\u0006\u0010[\u001a\u00020\\2\b\u0010]\u001a\u0004\u0018\u00010\u0019J\u0016\u0010_\u001a\u00020\"2\u0006\u0010`\u001a\u00020\u00152\u0006\u0010a\u001a\u00020\u0019J\u000e\u0010b\u001a\u00020\u00162\u0006\u0010`\u001a\u00020\u0015J\"\u0010c\u001a\u00020d2\u0006\u0010`\u001a\u00020\u00152\u0006\u0010]\u001a\u00020\u00192\n\b\u0002\u0010C\u001a\u0004\u0018\u00010DJ\u0016\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020BJ\u0017\u0010h\u001a\u0004\u0018\u00010f2\u0006\u0010i\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\bjJ\u000e\u0010k\u001a\u00020\u000f2\u0006\u0010l\u001a\u00020mJ\u0010\u0010n\u001a\u0004\u0018\u00010\u00192\u0006\u0010o\u001a\u00020\u0018J\u0016\u0010p\u001a\u00020\u00192\u0006\u0010o\u001a\u00020\u00182\u0006\u0010q\u001a\u00020rR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00190\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\t\u0010s\u001a\u00020tX\u0096\u0005R\t\u0010u\u001a\u00020vX\u0096\u0005R\t\u0010w\u001a\u00020xX\u0096\u0005R\t\u0010y\u001a\u00020zX\u0096\u0005R\t\u0010{\u001a\u00020|X\u0096\u0005R\t\u0010}\u001a\u00020\u0000X\u0096\u0005R\t\u0010~\u001a\u00020\u007fX\u0096\u0005R\u000b\u0010\u0080\u0001\u001a\u00030\u0081\u0001X\u0096\u0005R\u000b\u0010\u0082\u0001\u001a\u00030\u0083\u0001X\u0096\u0005R\u000b\u0010\u0084\u0001\u001a\u00030\u0085\u0001X\u0096\u0005R\u000b\u0010\u0086\u0001\u001a\u00030\u0087\u0001X\u0096\u0005R\u000b\u0010\u0088\u0001\u001a\u00030\u0089\u0001X\u0096\u0005R\u000b\u0010\u008a\u0001\u001a\u00030\u008b\u0001X\u0096\u0005R\r\u0010\u008c\u0001\u001a\u00030\u008d\u00018\u0016X\u0097\u0005R\u000b\u0010\u008e\u0001\u001a\u00030\u008f\u0001X\u0096\u0005R\u000b\u0010\u0090\u0001\u001a\u00030\u0091\u0001X\u0096\u0005R\u000b\u0010\u0092\u0001\u001a\u00030\u0093\u0001X\u0096\u0005R\u0011\u0010\u0094\u0001\u001a\t\u0012\u0005\u0012\u00030\u0095\u00010\u001bX\u0096\u0005R\u000b\u0010\u0096\u0001\u001a\u00030\u0097\u0001X\u0096\u0005R\u000b\u0010\u0098\u0001\u001a\u00030\u0099\u0001X\u0096\u0005R\u000b\u0010\u009a\u0001\u001a\u00030\u009b\u0001X\u0096\u0005R\u000b\u0010\u009c\u0001\u001a\u00030\u009d\u0001X\u0096\u0005R\u000b\u0010\u009e\u0001\u001a\u00030\u009f\u0001X\u0096\u0005R\u000b\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001X\u0096\u0005R\u000b\u0010\u00a2\u0001\u001a\u00030\u00a3\u0001X\u0096\u0005R\u000b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001X\u0096\u0005R\u000b\u0010\u00a6\u0001\u001a\u00030\u00a7\u0001X\u0096\u0005R\u000b\u0010\u00a8\u0001\u001a\u00030\u00a9\u0001X\u0096\u0005\u00a8\u0006\u00aa\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "components", "commonMemberStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "<init>", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "classCache", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "typeAliasCache", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeAliasSymbol;", "typeParameterCache", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "typeParameterCacheForSetter", "enumEntryCache", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/ir/symbols/IrEnumEntrySymbol;", "codeFragmentCache", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fieldsForContextReceivers", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "localStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalClassStorage;", "localClassesCreatedOnTheFly", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "forEachCachedDeclarationSymbol", "", "block", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "processMembersOfClassesOnTheFlyImmediately", "", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "typeOrigin", "Lorg/jetbrains/kotlin/fir/backend/ConversionTypeOrigin;", "preCacheTypeParameters", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "preCacheTypeParameters$fir2ir", "getIrTypeParameter", "typeParameter", "index", "", "getIrTypeParameter$fir2ir", "createAndCacheIrTypeParameter", "getCachedIrTypeParameter", "getCachedIrTypeParameter$fir2ir", "getIrTypeParameterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "firTypeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "createIrTypeParameterForNonCachedDeclaration", "firTypeParameter", "createAndCacheIrClass", "regularClass", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "predefinedOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "createClassSymbol", "cacheIrClass", "irClass", "cacheIrClass$fir2ir", "getIrClass", "firClass", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "getCachedIrLocalClass", "klass", "getCachedIrClass", "getIrClassSymbol", "firClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getFieldsWithContextReceiversForClass", "createAndCacheLocalIrClassOnTheFly", "processMembersOfClassesCreatedOnTheFly", "createAndCacheAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "name", "Lorg/jetbrains/kotlin/name/Name;", "irParent", "getIrAnonymousObjectForEnumEntry", "putEnumEntryClassInScope", "enumEntry", "correspondingClass", "getIrEnumEntrySymbol", "createAndCacheIrEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "createAndCacheIrTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "typeAlias", "getCachedTypeAlias", "firTypeAlias", "getCachedTypeAlias$fir2ir", "getIrTypeAliasSymbol", "firTypeAliasSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "getCachedIrCodeFragment", "codeFragment", "createAndCacheCodeFragmentClass", "containingFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "callablesGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "classifierStorage", "classifiersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "configuration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "delegatedMemberGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "firProvider", "Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "irBuiltIns", "Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irProviders", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "lazyDeclarationsGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "manglers", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents$Manglers;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "symbolsMappingForLazyClasses", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrClassifierStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrClassifierStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 Fir2IrConversionScope.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope\n*L\n1#1,429:1\n1863#2,2:430\n1863#2,2:432\n1863#2,2:434\n1863#2:436\n1863#2,2:437\n1864#2:439\n1557#2:448\n1628#2,3:449\n1#3:440\n21#4:441\n21#4:442\n21#4:443\n226#5:444\n381#6,3:445\n384#6,4:452\n70#7,7:456\n*S KotlinDebug\n*F\n+ 1 Fir2IrClassifierStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage\n*L\n65#1:430,2\n66#1:432,2\n67#1:434,2\n68#1:436\n69#1:437,2\n68#1:439\n249#1:448\n249#1:449,3\n184#1:441\n202#1:442\n227#1:443\n227#1:444\n248#1:445,3\n248#1:452,4\n284#1:456,7\n*E\n"})
public final class Fir2IrClassifierStorage
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final Fir2IrConversionScope conversionScope;
    @NotNull
    private final Map<FirRegularClass, IrClassSymbol> classCache;
    @NotNull
    private final Map<FirTypeAlias, IrTypeAliasSymbol> typeAliasCache;
    @NotNull
    private final Map<FirTypeParameter, IrTypeParameter> typeParameterCache;
    @NotNull
    private final Map<FirTypeParameter, IrTypeParameter> typeParameterCacheForSetter;
    @NotNull
    private final Map<FirEnumEntry, IrEnumEntrySymbol> enumEntryCache;
    @NotNull
    private final Map<FirCodeFragment, IrClass> codeFragmentCache;
    @NotNull
    private final Map<IrClass, List<IrField>> fieldsForContextReceivers;
    @NotNull
    private final Fir2IrLocalClassStorage localStorage;
    @NotNull
    private final Map<FirClass, IrClass> localClassesCreatedOnTheFly;
    private boolean processMembersOfClassesOnTheFlyImmediately;

    public Fir2IrClassifierStorage(@NotNull Fir2IrComponents components, @NotNull Fir2IrCommonMemberStorage commonMemberStorage, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)commonMemberStorage, (String)"commonMemberStorage");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        this.components = components;
        this.conversionScope = conversionScope;
        this.classCache = commonMemberStorage.getClassCache();
        this.typeAliasCache = new LinkedHashMap();
        this.typeParameterCache = commonMemberStorage.getTypeParameterCache();
        this.typeParameterCacheForSetter = new LinkedHashMap();
        this.enumEntryCache = commonMemberStorage.getEnumEntryCache();
        this.codeFragmentCache = new LinkedHashMap();
        this.fieldsForContextReceivers = new LinkedHashMap();
        this.localStorage = new Fir2IrLocalClassStorage(commonMemberStorage.getLocalClassCache());
        this.localClassesCreatedOnTheFly = new LinkedHashMap();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirProviderWithGeneratedFiles getFirProvider() {
        return this.components.getFirProvider();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.components.getConverter();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public IrBuiltInsOverFir getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public Fir2IrComponents.Manglers getManglers() {
        return this.components.getManglers();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.components.getIrProviders();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public FirBasedSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    @Override
    @NotNull
    public Fir2IrCallableDeclarationsGenerator getCallablesGenerator() {
        return this.components.getCallablesGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifiersGenerator getClassifiersGenerator() {
        return this.components.getClassifiersGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyDeclarationsGenerator getLazyDeclarationsGenerator() {
        return this.components.getLazyDeclarationsGenerator();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public DelegatedMemberGenerator getDelegatedMemberGenerator() {
        return this.components.getDelegatedMemberGenerator();
    }

    @Override
    @NotNull
    public IrFakeOverrideBuilder getFakeOverrideBuilder() {
        return this.components.getFakeOverrideBuilder();
    }

    @Override
    @NotNull
    public Fir2IrSymbolsMappingForLazyClasses getSymbolsMappingForLazyClasses() {
        return this.components.getSymbolsMappingForLazyClasses();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.components.getExtensions();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.components.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrIrGeneratedDeclarationsRegistrar getAnnotationsFromPluginRegistrar() {
        return this.components.getAnnotationsFromPluginRegistrar();
    }

    @DelicateDeclarationStorageApi
    public final void forEachCachedDeclarationSymbol(@NotNull Function1<? super IrSymbol, Unit> block) {
        IrBindableSymbol<ClassDescriptor, IrClass> it;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Iterable $this$forEach$iv = this.classCache.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrClassSymbol)element$iv;
            boolean bl = false;
            block.invoke((Object)it);
        }
        $this$forEach$iv = this.typeAliasCache.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrTypeAliasSymbol)element$iv;
            boolean bl = false;
            block.invoke((Object)it);
        }
        $this$forEach$iv = this.enumEntryCache.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrEnumEntrySymbol)element$iv;
            boolean bl = false;
            block.invoke((Object)it);
        }
        $this$forEach$iv = this.fieldsForContextReceivers.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List fields2 = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = fields2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrField it2 = (IrField)element$iv2;
                boolean bl2 = false;
                block.invoke((Object)it2.getSymbol());
            }
        }
    }

    private final IrType toIrType(FirTypeRef $this$toIrType, ConversionTypeOrigin typeOrigin) {
        Fir2IrTypeConverter $this$toIrType_u24lambda_u245 = this.getTypeConverter();
        boolean bl = false;
        return $this$toIrType_u24lambda_u245.toIrType($this$toIrType, typeOrigin);
    }

    static /* synthetic */ IrType toIrType$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeRef firTypeRef, ConversionTypeOrigin conversionTypeOrigin, int n, Object object) {
        if ((n & 1) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.toIrType(firTypeRef, conversionTypeOrigin);
    }

    public final void preCacheTypeParameters$fir2ir(@NotNull FirTypeParameterRefsOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Iterator iterator2 = ((Iterable)owner.getTypeParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            FirTypeParameterRef typeParameter = (FirTypeParameterRef)iterator2.next();
            FirTypeParameter original = (FirTypeParameter)typeParameter.getSymbol().getFir();
            IrTypeParameter irTypeParameter = Fir2IrClassifierStorage.getCachedIrTypeParameter$fir2ir$default(this, original, null, 2, null);
            if (irTypeParameter == null) {
                irTypeParameter = Fir2IrClassifierStorage.createAndCacheIrTypeParameter$default(this, original, index, null, 4, null);
            }
            if (!(owner instanceof FirProperty) || !((FirProperty)owner).isVar()) continue;
            ConversionTypeOrigin context2 = ConversionTypeOrigin.SETTER;
            IrTypeParameter irTypeParameter2 = this.getCachedIrTypeParameter$fir2ir(original, context2);
            if (irTypeParameter2 != null) continue;
            irTypeParameter2 = this.createAndCacheIrTypeParameter(original, index, context2);
        }
    }

    @NotNull
    public final IrTypeParameter getIrTypeParameter$fir2ir(@NotNull FirTypeParameter typeParameter, int index, @NotNull ConversionTypeOrigin typeOrigin) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkNotNullParameter((Object)((Object)typeOrigin), (String)"typeOrigin");
        IrTypeParameter irTypeParameter = this.getCachedIrTypeParameter$fir2ir(typeParameter, typeOrigin);
        if (irTypeParameter != null) {
            IrTypeParameter it = irTypeParameter;
            boolean bl = false;
            return it;
        }
        IrTypeParameter irTypeParameter2 = this.createAndCacheIrTypeParameter(typeParameter, index, typeOrigin);
        this.getClassifiersGenerator().initializeTypeParameterBounds(typeParameter, irTypeParameter2);
        return irTypeParameter2;
    }

    public static /* synthetic */ IrTypeParameter getIrTypeParameter$fir2ir$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeParameter firTypeParameter, int n, ConversionTypeOrigin conversionTypeOrigin, int n2, Object object) {
        if ((n2 & 4) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.getIrTypeParameter$fir2ir(firTypeParameter, n, conversionTypeOrigin);
    }

    private final IrTypeParameter createAndCacheIrTypeParameter(FirTypeParameter typeParameter, int index, ConversionTypeOrigin typeOrigin) {
        IrTypeParameterSymbolImpl symbol = new IrTypeParameterSymbolImpl(null, 1, null);
        IrTypeParameter irTypeParameter = this.getClassifiersGenerator().createIrTypeParameterWithoutBounds(typeParameter, index, symbol);
        if (typeOrigin.getForSetter()) {
            this.typeParameterCacheForSetter.put(typeParameter, irTypeParameter);
        } else {
            this.typeParameterCache.put(typeParameter, irTypeParameter);
        }
        return irTypeParameter;
    }

    static /* synthetic */ IrTypeParameter createAndCacheIrTypeParameter$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeParameter firTypeParameter, int n, ConversionTypeOrigin conversionTypeOrigin, int n2, Object object) {
        if ((n2 & 4) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.createAndCacheIrTypeParameter(firTypeParameter, n, conversionTypeOrigin);
    }

    @Nullable
    public final IrTypeParameter getCachedIrTypeParameter$fir2ir(@NotNull FirTypeParameter typeParameter, @NotNull ConversionTypeOrigin typeOrigin) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkNotNullParameter((Object)((Object)typeOrigin), (String)"typeOrigin");
        return typeOrigin.getForSetter() ? this.typeParameterCacheForSetter.get(typeParameter) : this.typeParameterCache.get(typeParameter);
    }

    public static /* synthetic */ IrTypeParameter getCachedIrTypeParameter$fir2ir$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeParameter firTypeParameter, ConversionTypeOrigin conversionTypeOrigin, int n, Object object) {
        if ((n & 2) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.getCachedIrTypeParameter$fir2ir(firTypeParameter, conversionTypeOrigin);
    }

    @NotNull
    public final IrTypeParameterSymbol getIrTypeParameterSymbol(@NotNull FirTypeParameterSymbol firTypeParameterSymbol, @NotNull ConversionTypeOrigin typeOrigin) {
        Object cachedSymbol;
        Intrinsics.checkNotNullParameter((Object)firTypeParameterSymbol, (String)"firTypeParameterSymbol");
        Intrinsics.checkNotNullParameter((Object)((Object)typeOrigin), (String)"typeOrigin");
        FirTypeParameter firTypeParameter = (FirTypeParameter)firTypeParameterSymbol.getFir();
        Object object = this.getCachedIrTypeParameter$fir2ir(firTypeParameter, typeOrigin);
        if (object == null || (object = ((IrTypeParameter)object).getSymbol()) == null) {
            IrTypeParameter irTypeParameter = this.typeParameterCache.get(firTypeParameter);
            object = irTypeParameter != null ? irTypeParameter.getSymbol() : null;
        }
        if ((cachedSymbol = object) != null) {
            return cachedSymbol;
        }
        if (this.components.getConfiguration().getAllowNonCachedDeclarations()) {
            return this.createIrTypeParameterForNonCachedDeclaration(firTypeParameter);
        }
        throw new IllegalStateException(("Cannot find cached type parameter by FIR symbol: " + firTypeParameterSymbol.getName() + " of the owner: " + firTypeParameter.getContainingDeclarationSymbol()).toString());
    }

    private final IrTypeParameterSymbol createIrTypeParameterForNonCachedDeclaration(FirTypeParameter firTypeParameter) {
        IrTypeParameter irTypeParameter;
        int n;
        FirBasedSymbol<?> firTypeParameterOwnerSymbol = firTypeParameter.getContainingDeclarationSymbol();
        Object obj = firTypeParameterOwnerSymbol.getFir();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner");
        FirTypeParameterRefsOwner firTypeParameterOwner = (FirTypeParameterRefsOwner)obj;
        int it = n = firTypeParameterOwner.getTypeParameters().indexOf(firTypeParameter);
        boolean bl = false;
        if (!(it >= 0)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        int index = n;
        boolean isSetter = firTypeParameterOwner instanceof FirPropertyAccessor && ((FirPropertyAccessor)firTypeParameterOwner).isSetter();
        ConversionTypeOrigin conversionTypeOrigin = isSetter ? ConversionTypeOrigin.SETTER : ConversionTypeOrigin.DEFAULT;
        IrTypeParameter it2 = irTypeParameter = this.createAndCacheIrTypeParameter(firTypeParameter, index, conversionTypeOrigin);
        boolean bl2 = false;
        this.getClassifiersGenerator().initializeTypeParameterBounds(firTypeParameter, it2);
        return irTypeParameter.getSymbol();
    }

    @NotNull
    public final IrClass createAndCacheIrClass(@NotNull FirRegularClass regularClass, @NotNull IrDeclarationParent parent2, @Nullable IrDeclarationOrigin predefinedOrigin) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClassSymbol symbol = this.createClassSymbol();
        IrClass it = irClass = this.getClassifiersGenerator().createIrClass(regularClass, parent2, symbol, predefinedOrigin);
        boolean bl = false;
        this.cacheIrClass$fir2ir(regularClass, it);
        return irClass;
    }

    public static /* synthetic */ IrClass createAndCacheIrClass$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirRegularClass firRegularClass, IrDeclarationParent irDeclarationParent, IrDeclarationOrigin irDeclarationOrigin, int n, Object object) {
        if ((n & 4) != 0) {
            irDeclarationOrigin = null;
        }
        return fir2IrClassifierStorage.createAndCacheIrClass(firRegularClass, irDeclarationParent, irDeclarationOrigin);
    }

    private final IrClassSymbol createClassSymbol() {
        return new IrClassSymbolImpl(null, 1, null);
    }

    @LeakedDeclarationCaches
    public final void cacheIrClass$fir2ir(@NotNull FirRegularClass regularClass, @NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        FirMemberDeclaration $this$visibility$iv = regularClass;
        boolean $i$f$getVisibility = false;
        if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) {
            this.localStorage.set(regularClass, irClass);
        } else {
            this.classCache.put(regularClass, irClass.getSymbol());
        }
    }

    @NotNull
    public final IrClass getIrClass(@NotNull FirClass firClass) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ClassId parentId;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
                IrClass irClass = this.getCachedIrClass(firClass);
                if (irClass != null) {
                    IrClass it = irClass;
                    boolean bl = false;
                    return it;
                }
                if (firClass instanceof FirAnonymousObject) break block8;
                if (!(firClass instanceof FirRegularClass)) break block9;
                FirMemberDeclaration $this$visibility$iv = firClass;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block9;
            }
            return this.createAndCacheLocalIrClassOnTheFly(firClass);
        }
        if (!(firClass instanceof FirRegularClass)) {
            String $i$f$getVisibility = "Failed requirement.";
            throw new IllegalArgumentException($i$f$getVisibility.toString());
        }
        IrClassSymbol symbol = this.createClassSymbol();
        ClassId classId = ((FirRegularClass)firClass).getSymbol().getClassId();
        ClassId classId2 = parentId = classId.getOuterClassId();
        if (classId2 != null) {
            ClassId it = classId2;
            boolean bl = false;
            firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.getSession()).getClassLikeSymbolByClassId(it);
        } else {
            firClassLikeSymbol = null;
        }
        FirClassLikeSymbol<?> parentClass = firClassLikeSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = parentClass;
        IrDeclarationParent irDeclarationParent = this.getDeclarationStorage().findIrParent$fir2ir(classId.getPackageFqName(), firClassLikeSymbol2 != null ? firClassLikeSymbol2.toLookupTag() : null, ((FirRegularClass)firClass).getSymbol(), ((FirRegularClass)firClass).getOrigin());
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        IrDeclarationParent irParent = irDeclarationParent;
        this.classCache.put((FirRegularClass)firClass, symbol);
        if (!Fir2IrCallableDeclarationsGeneratorKt.isExternalParent(irParent)) {
            boolean bl = false;
            String string2 = "Source classes should be created separately before referencing";
            throw new IllegalStateException(string2.toString());
        }
        Fir2IrLazyClass irClass = this.getLazyDeclarationsGenerator().createIrLazyClass((FirRegularClass)firClass, irParent, symbol);
        irClass.prepareTypeParameters();
        return irClass;
    }

    @Nullable
    public final IrClass getIrClass(@NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(lookupTag, this.getSession());
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return null;
        }
        FirClassSymbol firClassSymbol2 = firClassSymbol;
        return this.getIrClass((FirClass)firClassSymbol2.getFir());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final IrClass getCachedIrLocalClass(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!(klass instanceof FirAnonymousObject)) {
            if (!(klass instanceof FirRegularClass)) return null;
            FirMemberDeclaration $this$visibility$iv = klass;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) return null;
        }
        boolean bl = true;
        boolean condition$iv = bl;
        boolean $i$f$runIf = false;
        if (!condition$iv) return null;
        boolean bl2 = false;
        IrClass irClass = this.localStorage.get(klass);
        return irClass;
    }

    private final IrClass getCachedIrClass(FirClass klass) {
        IrClass irClass = this.getCachedIrLocalClass(klass);
        if (irClass == null) {
            IrClassSymbol irClassSymbol = this.classCache.get(klass);
            irClass = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
        }
        return irClass;
    }

    @NotNull
    public final IrClassSymbol getIrClassSymbol(@NotNull FirClassSymbol<?> firClassSymbol) {
        Intrinsics.checkNotNullParameter(firClassSymbol, (String)"firClassSymbol");
        return this.getIrClass((FirClass)firClassSymbol.getFir()).getSymbol();
    }

    @Nullable
    public final IrClassSymbol getIrClassSymbol(@NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
        IrClass irClass = this.getIrClass(lookupTag);
        return irClass != null ? irClass.getSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrField> getFieldsWithContextReceiversForClass(@NotNull IrClass irClass, @NotNull FirClass klass) {
        List list;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!(klass instanceof FirRegularClass) || ((FirRegularClass)klass).getContextReceivers().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Map<IrClass, List<IrField>> $this$getOrPut$iv = this.fieldsForContextReceivers;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(irClass);
        if (value$iv == null) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)((FirRegularClass)klass).getContextReceivers());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrField irField;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                int index = indexedValue.component1();
                FirContextReceiver contextReceiver = (FirContextReceiver)indexedValue.component2();
                IrFactory irFactory = this.components.getIrFactory();
                IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getFIELD_FOR_CLASS_CONTEXT_RECEIVER();
                Name name2 = Name.identifier("contextReceiverField" + index);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
                IrField it = irField = irFactory.createField(-1, -1, irDeclarationOrigin, name2, descriptorVisibility, new IrFieldSymbolImpl(null, 1, null), Fir2IrClassifierStorage.toIrType$default(this, contextReceiver.getTypeRef(), null, 1, null), true, false, false);
                boolean bl3 = false;
                it.setParent(irClass);
                collection.add(irField);
            }
            List answer$iv = (List)destination$iv$iv;
            $this$getOrPut$iv.put(irClass, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        return list;
    }

    private final IrClass createAndCacheLocalIrClassOnTheFly(FirClass klass) {
        Fir2IrClassifiersGenerator.LocalIrClassInfo localIrClassInfo = this.getClassifiersGenerator().createLocalIrClassOnTheFly(klass, this.processMembersOfClassesOnTheFlyImmediately);
        IrClass irClass = localIrClassInfo.component1();
        FirClass firClassOrLocalParent = localIrClassInfo.component2();
        IrClass irClassOrLocalParent = localIrClassInfo.component3();
        if (!this.processMembersOfClassesOnTheFlyImmediately) {
            this.localClassesCreatedOnTheFly.put(firClassOrLocalParent, irClassOrLocalParent);
        }
        return irClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processMembersOfClassesCreatedOnTheFly() {
        this.processMembersOfClassesOnTheFlyImmediately = true;
        for (Map.Entry<FirClass, IrClass> entry : this.localClassesCreatedOnTheFly.entrySet()) {
            FirClass klass = entry.getKey();
            IrClass irClass = entry.getValue();
            Fir2IrConversionScope this_$iv = this.conversionScope;
            boolean $i$f$withContainingFirClass = false;
            ((Collection)this_$iv.getContainingFirClassStack()).add(klass);
            try {
                boolean bl = false;
                this.getClassifiersGenerator().processClassHeader(klass, irClass);
                this.getConverter().processClassMembers$fir2ir(klass, irClass);
                this.getConverter().bindFakeOverridesInClass(irClass);
            }
            finally {
                this_$iv.getContainingFirClassStack().remove(this_$iv.getContainingFirClassStack().size() - 1);
            }
        }
        this.localClassesCreatedOnTheFly.clear();
    }

    @NotNull
    public final IrClass createAndCacheAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull Visibility visibility, @NotNull Name name2, @Nullable IrDeclarationParent irParent) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        IrClass it = irClass = this.getClassifiersGenerator().createAnonymousObject(anonymousObject, visibility, name2, irParent);
        boolean bl = false;
        this.localStorage.set(anonymousObject, it);
        return irClass;
    }

    public static /* synthetic */ IrClass createAndCacheAnonymousObject$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirAnonymousObject firAnonymousObject, Visibility visibility, Name name2, IrDeclarationParent irDeclarationParent, int n, Object object) {
        if ((n & 2) != 0) {
            visibility = Visibilities.Local.INSTANCE;
        }
        if ((n & 4) != 0) {
            name2 = SpecialNames.NO_NAME_PROVIDED;
        }
        if ((n & 8) != 0) {
            irDeclarationParent = null;
        }
        return fir2IrClassifierStorage.createAndCacheAnonymousObject(firAnonymousObject, visibility, name2, irDeclarationParent);
    }

    @NotNull
    public final IrClass getIrAnonymousObjectForEnumEntry(@NotNull FirAnonymousObject anonymousObject, @NotNull Name name2, @Nullable IrClass irParent) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        IrClass irClass = this.localStorage.get(anonymousObject);
        if (irClass != null) {
            IrClass it = irClass;
            boolean bl = false;
            return it;
        }
        IrClass irAnonymousObject = this.createAndCacheAnonymousObject(anonymousObject, Visibilities.Private.INSTANCE, name2, irParent);
        this.getClassifiersGenerator().processClassHeader(anonymousObject, irAnonymousObject);
        return irAnonymousObject;
    }

    public final void putEnumEntryClassInScope(@NotNull FirEnumEntry enumEntry, @NotNull IrClass correspondingClass) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter((Object)correspondingClass, (String)"correspondingClass");
        FirExpression firExpression = enumEntry.getInitializer();
        Intrinsics.checkNotNull((Object)firExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression");
        this.localStorage.set(((FirAnonymousObjectExpression)firExpression).getAnonymousObject(), correspondingClass);
    }

    @NotNull
    public final IrEnumEntrySymbol getIrEnumEntrySymbol(@NotNull FirEnumEntry enumEntry) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        IrEnumEntrySymbol irEnumEntrySymbol = this.enumEntryCache.get(enumEntry);
        if (irEnumEntrySymbol != null) {
            IrEnumEntrySymbol it = irEnumEntrySymbol;
            boolean bl = false;
            return it;
        }
        IrEnumEntrySymbolImpl symbol = new IrEnumEntrySymbolImpl(null, 1, null);
        this.enumEntryCache.put(enumEntry, symbol);
        IrDeclarationParent irDeclarationParent = this.getDeclarationStorage().findIrParent$fir2ir(enumEntry, null);
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass irParent = (IrClass)irDeclarationParent;
        if (Fir2IrCallableDeclarationsGeneratorKt.isExternalParent(irParent)) {
            this.getClassifiersGenerator().createIrEnumEntry(enumEntry, irParent, symbol, irParent.getOrigin());
        }
        return symbol;
    }

    @NotNull
    public final IrEnumEntry createAndCacheIrEnumEntry(@NotNull FirEnumEntry enumEntry, @NotNull IrClass irParent, @Nullable IrDeclarationOrigin predefinedOrigin) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter((Object)irParent, (String)"irParent");
        IrEnumEntrySymbol symbol = this.getIrEnumEntrySymbol(enumEntry);
        FirFile containingFile = this.getFirProvider().getFirCallableContainerFile(enumEntry.getSymbol());
        IrDeclarationOrigin irDeclarationOrigin = predefinedOrigin;
        if (irDeclarationOrigin == null) {
            irDeclarationOrigin = containingFile != null ? (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getDEFINED() : irParent.getOrigin();
        }
        IrDeclarationOrigin predefinedOrigin2 = irDeclarationOrigin;
        return this.getClassifiersGenerator().createIrEnumEntry(enumEntry, irParent, symbol, predefinedOrigin2);
    }

    public static /* synthetic */ IrEnumEntry createAndCacheIrEnumEntry$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirEnumEntry firEnumEntry, IrClass irClass, IrDeclarationOrigin irDeclarationOrigin, int n, Object object) {
        if ((n & 4) != 0) {
            irDeclarationOrigin = null;
        }
        return fir2IrClassifierStorage.createAndCacheIrEnumEntry(firEnumEntry, irClass, irDeclarationOrigin);
    }

    @NotNull
    public final IrTypeAlias createAndCacheIrTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull IrDeclarationParent parent2) {
        IrTypeAlias irTypeAlias;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrTypeAliasSymbolImpl symbol = new IrTypeAliasSymbolImpl(null, 1, null);
        IrTypeAlias it = irTypeAlias = this.getClassifiersGenerator().createIrTypeAlias(typeAlias, parent2, symbol);
        boolean bl = false;
        this.typeAliasCache.put(typeAlias, symbol);
        return irTypeAlias;
    }

    @Nullable
    public final IrTypeAlias getCachedTypeAlias$fir2ir(@NotNull FirTypeAlias firTypeAlias) {
        Intrinsics.checkNotNullParameter((Object)firTypeAlias, (String)"firTypeAlias");
        IrTypeAliasSymbol irTypeAliasSymbol = this.typeAliasCache.get(firTypeAlias);
        return irTypeAliasSymbol != null ? (IrTypeAlias)irTypeAliasSymbol.getOwner() : null;
    }

    @NotNull
    public final IrTypeAliasSymbol getIrTypeAliasSymbol(@NotNull FirTypeAliasSymbol firTypeAliasSymbol) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ClassId parentId;
        Intrinsics.checkNotNullParameter((Object)firTypeAliasSymbol, (String)"firTypeAliasSymbol");
        FirTypeAlias firTypeAlias = (FirTypeAlias)firTypeAliasSymbol.getFir();
        IrTypeAlias irTypeAlias = this.getCachedTypeAlias$fir2ir(firTypeAlias);
        if (irTypeAlias != null) {
            IrTypeAlias it = irTypeAlias;
            boolean bl = false;
            return it.getSymbol();
        }
        ClassId typeAliasId = firTypeAliasSymbol.getClassId();
        ClassId classId = parentId = typeAliasId.getOuterClassId();
        if (classId != null) {
            ClassId it = classId;
            boolean bl = false;
            firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.getSession()).getClassLikeSymbolByClassId(it);
        } else {
            firClassLikeSymbol = null;
        }
        FirClassLikeSymbol<?> parentClass = firClassLikeSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = parentClass;
        IrDeclarationParent irDeclarationParent = this.getDeclarationStorage().findIrParent$fir2ir(typeAliasId.getPackageFqName(), firClassLikeSymbol2 != null ? firClassLikeSymbol2.toLookupTag() : null, firTypeAliasSymbol, firTypeAlias.getOrigin());
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        IrDeclarationParent irParent = irDeclarationParent;
        IrTypeAliasSymbolImpl symbol = new IrTypeAliasSymbolImpl(null, 1, null);
        Fir2IrLazyTypeAlias irTypeAlias2 = this.getLazyDeclarationsGenerator().createIrLazyTypeAlias(firTypeAlias, irParent, symbol);
        this.typeAliasCache.put(firTypeAlias, symbol);
        irTypeAlias2.prepareTypeParameters();
        return symbol;
    }

    @Nullable
    public final IrClass getCachedIrCodeFragment(@NotNull FirCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        return this.codeFragmentCache.get(codeFragment);
    }

    @NotNull
    public final IrClass createAndCacheCodeFragmentClass(@NotNull FirCodeFragment codeFragment, @NotNull IrFile containingFile) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        IrClassSymbol symbol = this.createClassSymbol();
        IrClass it = irClass = this.getClassifiersGenerator().createCodeFragmentClass(codeFragment, containingFile, symbol);
        boolean bl = false;
        this.codeFragmentCache.put(codeFragment, it);
        return irClass;
    }
}

