/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010*\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J7\u0010\u0016\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0082\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "<init>", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "loadClassifierExperimentalities", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageBaseChecker$Experimentality;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isSupertypeRef", "", "findSymbol", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkContainingClasses", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "qualifier", "", "Lorg/jetbrains/kotlin/fir/types/FirQualifierPart;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageTypeRefChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageTypeRefChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n26#2:98\n26#2:99\n1755#3,3:100\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageTypeRefChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptInUsageTypeRefChecker\n*L\n35#1:98\n80#1:99\n91#1:100,3\n*E\n"})
public final class FirOptInUsageTypeRefChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirOptInUsageTypeRefChecker INSTANCE = new FirOptInUsageTypeRefChecker();

    private FirOptInUsageTypeRefChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        FirClassLikeSymbol<?> typeAliasExpandedSymbol;
        FirClassLikeSymbol<?> symbol;
        ConeClassLikeType coneType;
        block16: {
            ClassId classId;
            FirClassLikeSymbol<?> processedSymbol;
            FirTypeRef delegatedTypeRef;
            KtSourceElement source;
            block15: {
                FirAnnotation lastAnnotationCall;
                Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                source = typeRef.getSource();
                FirResolvedTypeRef firResolvedTypeRef = typeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)typeRef : null;
                delegatedTypeRef = firResolvedTypeRef != null ? firResolvedTypeRef.getDelegatedTypeRef() : null;
                KtSourceElement ktSourceElement = source;
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                    return;
                }
                FirTypeRef $this$coneTypeSafe$iv = typeRef;
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
                if (coneClassLikeType == null) {
                    return;
                }
                coneType = coneClassLikeType;
                FirClassLikeSymbol<?> firClassLikeSymbol = this.findSymbol(typeRef, context2.getSession());
                if (firClassLikeSymbol == null) {
                    return;
                }
                symbol = firClassLikeSymbol;
                Object object2 = symbol instanceof FirTypeAliasSymbol ? (FirTypeAliasSymbol)symbol : null;
                typeAliasExpandedSymbol = object2 != null && (object2 = ((FirTypeAliasSymbol)object2).getResolvedExpandedTypeRef()) != null ? this.findSymbol((FirTypeRef)object2, context2.getSession()) : null;
                FirClassLikeSymbol<?> firClassLikeSymbol2 = typeAliasExpandedSymbol;
                if (firClassLikeSymbol2 == null) {
                    firClassLikeSymbol2 = symbol;
                }
                processedSymbol = firClassLikeSymbol2;
                classId = processedSymbol.getClassId();
                Object object3 = CollectionsKt.lastOrNull(context2.getCallsOrAssignments());
                FirAnnotation firAnnotation = lastAnnotationCall = object3 instanceof FirAnnotation ? (FirAnnotation)object3 : null;
                if (lastAnnotationCall == null) break block15;
                if (lastAnnotationCall.getAnnotationTypeRef() == typeRef) break block16;
            }
            if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) || Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
            } else if (FirOptInUsageBaseChecker.INSTANCE.isExperimentalMarker(processedSymbol, context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), (DiagnosticContext)context2, null, 8, null);
            } else if (delegatedTypeRef instanceof FirUserTypeRef && !((Collection)((FirUserTypeRef)delegatedTypeRef).getQualifier()).isEmpty()) {
                this.checkContainingClasses(processedSymbol, source, ((FirUserTypeRef)delegatedTypeRef).getQualifier(), context2, reporter);
            }
        }
        FirClass firClass = (object = CollectionsKt.lastOrNull(context2.getContainingDeclarations())) instanceof FirClass ? (FirClass)object : null;
        List list = firClass != null ? firClass.getSuperTypeRefs() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        boolean isSupertypeRef = list.contains(typeRef);
        FirOptInUsageBaseChecker $this$check_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set experimentalities = new LinkedHashSet();
        experimentalities.addAll((Collection)INSTANCE.loadClassifierExperimentalities(symbol, context2, isSupertypeRef));
        if (typeAliasExpandedSymbol != null) {
            experimentalities.addAll((Collection)INSTANCE.loadClassifierExperimentalities(typeAliasExpandedSymbol, context2, isSupertypeRef));
        }
        experimentalities.addAll((Collection)$this$check_u24lambda_u240.loadExperimentalitiesFromConeArguments(context2, ArraysKt.toList((Object[])coneType.getTypeArguments())));
        FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u240, experimentalities, typeRef, context2, reporter, null, 16, null);
    }

    private final Set<FirOptInUsageBaseChecker.Experimentality> loadClassifierExperimentalities(FirClassLikeSymbol<?> $this$loadClassifierExperimentalities, CheckerContext context2, boolean isSupertypeRef) {
        return isSupertypeRef ? FirOptInUsageBaseChecker.INSTANCE.loadExperimentalitiesFromSupertype($this$loadClassifierExperimentalities, context2) : FirOptInUsageBaseChecker.INSTANCE.loadExperimentalities((FirBasedSymbol)$this$loadClassifierExperimentalities, context2, false, null);
    }

    private final FirClassLikeSymbol<?> findSymbol(FirTypeRef $this$findSymbol, FirSession session2) {
        FirTypeRef $this$coneTypeSafe$iv = $this$findSymbol;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType coneType = coneClassLikeType;
        return LookupTagUtilsKt.toSymbol(coneType.getLookupTag(), session2);
    }

    private final void checkContainingClasses(FirClassLikeSymbol<?> $this$checkContainingClasses, KtSourceElement source, List<? extends FirQualifierPart> qualifier, CheckerContext context2, DiagnosticReporter reporter) {
        FirOptInUsageTypeRefChecker firOptInUsageTypeRefChecker = this;
        while (true) {
            boolean bl;
            Object containingClassSymbol;
            block6: {
                Object object;
                if ((object = ClassMembersKt.getContainingClassLookupTag($this$checkContainingClasses)) == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context2.getSession())) == null) {
                    return;
                }
                containingClassSymbol = object;
                Iterable $this$any$iv = (Iterable)qualifier;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirQualifierPart it = (FirQualifierPart)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)((FirClassLikeSymbol)containingClassSymbol).getName())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl && FirOptInUsageBaseChecker.INSTANCE.isExperimentalMarker((FirClassLikeSymbol<?>)containingClassSymbol, context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), (DiagnosticContext)context2, null, 8, null);
            }
            FirOptInUsageTypeRefChecker firOptInUsageTypeRefChecker2 = firOptInUsageTypeRefChecker;
            KtSourceElement ktSourceElement = source;
            Object object = qualifier;
            CheckerContext checkerContext = context2;
            DiagnosticReporter diagnosticReporter = reporter;
            firOptInUsageTypeRefChecker = firOptInUsageTypeRefChecker2;
            $this$checkContainingClasses = containingClassSymbol;
            source = ktSourceElement;
            qualifier = object;
            context2 = checkerContext;
            reporter = diagnosticReporter;
        }
    }
}

