/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,62:1\n543#2,6:63\n35#3:69\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n*L\n47#1:63,6\n54#1:69\n*E\n"})
public final class FirOptInUsageAccessChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirOptInUsageAccessChecker INSTANCE = new FirOptInUsageAccessChecker();

    private FirOptInUsageAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KtSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (sourceKind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers || sourceKind instanceof KtFakeSourceElementKind.PropertyFromParameter) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(expression2, context2)) {
            return;
        }
        Object object = ReferenceUtilsKt.toReference(expression2, context2.getSession());
        if (object == null || (object = FirReferenceUtilsKt.toResolvedBaseSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object resolvedSymbol = object;
        FirOptInUsageBaseChecker $this$check_u24lambda_u241 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (expression2 instanceof FirVariableAssignment) {
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u241.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context2, true, null), (Iterable)$this$check_u24lambda_u241.loadExperimentalitiesFromTypeArguments(context2, CollectionsKt.emptyList()));
            FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u241, experimentalities, ((FirVariableAssignment)expression2).getLValue(), context2, reporter, null, 16, null);
        } else if (expression2 instanceof FirQualifiedAccessExpression) {
            Object object2;
            Object object3 = ((FirQualifiedAccessExpression)expression2).getDispatchReceiver();
            ConeKotlinType dispatchReceiverType = object3 != null && (object3 = FirTypeUtilsKt.getResolvedType((FirExpression)object3)) != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object3, context2.getSession()) : null;
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u241.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context2, false, dispatchReceiverType), (Iterable)$this$check_u24lambda_u241.loadExperimentalitiesFromTypeArguments(context2, ((FirQualifiedAccessExpression)expression2).getTypeArguments()));
            KtSourceElement ktSourceElement2 = ((FirQualifiedAccessExpression)expression2).getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                FirDeclaration firDeclaration;
                block14: {
                    List<FirDeclaration> $this$lastOrNull$iv = context2.getContainingDeclarations();
                    boolean $i$f$lastOrNull = false;
                    ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        FirDeclaration element$iv;
                        FirDeclaration it = element$iv = iterator$iv.previous();
                        boolean bl2 = false;
                        if (!(it instanceof FirProperty)) continue;
                        firDeclaration = element$iv;
                        break block14;
                    }
                    firDeclaration = null;
                }
                FirDeclaration firDeclaration2 = firDeclaration;
                FirProperty firProperty = firDeclaration2 instanceof FirProperty ? (FirProperty)firDeclaration2 : null;
                if (firProperty == null) {
                    return;
                }
                FirProperty property = firProperty;
                object2 = property.getDelegate();
                if (object2 == null || (object2 = ((FirExpression)object2).getSource()) == null || (object2 = KtSourceElementKt.fakeElement$default((KtSourceElement)object2, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE, 0, 0, 6, null)) == null) {
                    return;
                }
            } else {
                object2 = ((FirQualifiedAccessExpression)expression2).getSource();
            }
            KtSourceElement source = object2;
            $this$check_u24lambda_u241.reportNotAcceptedExperimentalities(experimentalities, expression2, context2, reporter, source);
        } else if (expression2 instanceof FirDelegatedConstructorCall && resolvedSymbol instanceof FirConstructorSymbol) {
            FirCallableSymbol $this$isFromEnumClass$iv = (FirCallableSymbol)resolvedSymbol;
            boolean $i$f$isFromEnumClass = false;
            if ($this$isFromEnumClass$iv.getRawStatus().isFromEnumClass()) {
                Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = $this$check_u24lambda_u241.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context2, false, null);
                FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u241, experimentalities, ((FirDelegatedConstructorCall)expression2).getCalleeReference(), context2, reporter, null, 16, null);
            }
        }
    }
}

