/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.ConstantArgumentKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010$\u001a\u00020\u0002\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u0002002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010F\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\u0006\u0010G\u001a\u00020HH\u0002J\u0018\u0010I\u001a\u00020\u00022\u0006\u0010J\u001a\u00020E2\u0006\u0010G\u001a\u00020KH\u0002J\u001a\u0010L\u001a\u00020\u00022\u0006\u0010M\u001a\u00020N2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010O\u001a\u00020\u00022\u0006\u0010P\u001a\u00020Q2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010R\u001a\u00020\u00022\u0006\u0010S\u001a\u00020T2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010U\u001a\u00020\t*\u0006\u0012\u0002\b\u00030VH\u0002J\f\u0010W\u001a\u00020X*\u00020YH\u0002J\f\u0010Z\u001a\u00020\t*\u00020EH\u0002J\f\u0010[\u001a\u00020\t*\u00020\\H\u0002J\u0012\u0010]\u001a\u00020\t*\b\u0012\u0002\b\u0003\u0018\u00010^H\u0002J\u0018\u0010_\u001a\b\u0012\u0002\b\u0003\u0018\u00010V*\b\u0012\u0002\b\u0003\u0018\u00010^H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirConstCheckVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConstantArgumentKind;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "intrinsicConstEvaluation", "", "compileTimeFunctions", "", "Lorg/jetbrains/kotlin/name/Name;", "compileTimeExtensionFunctions", "Ljava/util/HashSet;", "Lkotlin/jvm/internal/EnhancedNullability;", "compileTimeConversionFunctions", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "visitWhenExpression", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "visitWhenSubjectExpression", "whenSubjectExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenSubjectExpression;", "visitLiteralExpression", "T", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "visitComparisonExpression", "comparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "visitStringConcatenationCall", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitArrayLiteral", "arrayLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "visitThisReceiverExpression", "thisReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirThisReceiverExpression;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitIntegerLiteralOperatorCall", "integerLiteralOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitNamedFunction", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "visitConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitCallableReferenceAccess", "callableReferenceAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "canBeEvaluated", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getExpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isCompileTimeBuiltinCall", "isCompileTimeBuiltinProperty", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "fromKotlin", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getReferencedClassSymbol", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConstChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstChecks.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirConstCheckVisitor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirConstChecks.kt\norg/jetbrains/kotlin/fir/analysis/checkers/ConstantArgumentKind\n+ 5 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 6 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 7 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 8 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 9 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,367:1\n37#2,2:368\n1628#3,3:370\n1628#3,3:373\n1863#3:384\n1864#3:389\n626#3,12:424\n1863#3:445\n1864#3:450\n59#4,4:376\n59#4,4:380\n59#4,4:385\n59#4,4:391\n59#4,4:396\n59#4,4:400\n59#4,4:404\n59#4,4:409\n59#4,4:440\n59#4,4:446\n43#5:390\n43#5:395\n43#5:408\n43#5:439\n43#5:444\n160#6:413\n117#6,4:414\n98#6:418\n86#6:419\n92#6:421\n121#6,2:422\n39#7:420\n32#8:436\n24#8:437\n13#8:438\n26#9:451\n26#9:452\n*S KotlinDebug\n*F\n+ 1 FirConstChecks.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirConstCheckVisitor\n*L\n69#1:368,2\n75#1:370,3\n79#1:373,3\n110#1:384\n110#1:389\n211#1:424,12\n288#1:445\n288#1:450\n104#1:376,4\n108#1:380,4\n112#1:385,4\n135#1:391,4\n154#1:396,4\n161#1:400,4\n162#1:404,4\n184#1:409,4\n277#1:440,4\n289#1:446,4\n131#1:390\n145#1:395\n183#1:408\n269#1:439\n288#1:444\n209#1:413\n209#1:414,4\n209#1:418\n209#1:419\n209#1:421\n209#1:422,2\n209#1:420\n216#1:436\n231#1:437\n231#1:438\n348#1:451\n363#1:452\n*E\n"})
final class FirConstCheckVisitor
extends FirVisitor {
    @NotNull
    private final FirSession session;
    private final boolean intrinsicConstEvaluation;
    @NotNull
    private final Set<Name> compileTimeFunctions;
    @NotNull
    private final HashSet<Name> compileTimeExtensionFunctions;
    @NotNull
    private final HashSet<Name> compileTimeConversionFunctions;

    /*
     * WARNING - void declaration
     */
    public FirConstCheckVisitor(@NotNull FirSession session2) {
        void var3_3;
        String it;
        Collection collection;
        Collection destination$iv;
        Object item$iv;
        Object $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.intrinsicConstEvaluation = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
        Object object = new SpreadBuilder(9);
        Collection $this$toTypedArray$iv = OperatorNameConventions.BINARY_OPERATION_NAMES;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object.addSpread((Object)thisCollection$iv.toArray(new Name[0]));
        $this$toTypedArray$iv = OperatorNameConventions.UNARY_OPERATION_NAMES;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        object.addSpread((Object)thisCollection$iv.toArray(new Name[0]));
        object.add((Object)OperatorNameConventions.SHL);
        object.add((Object)OperatorNameConventions.SHR);
        object.add((Object)OperatorNameConventions.USHR);
        object.add((Object)OperatorNameConventions.OR);
        object.add((Object)OperatorNameConventions.AND);
        object.add((Object)OperatorNameConventions.XOR);
        object.add((Object)OperatorNameConventions.COMPARE_TO);
        this.compileTimeFunctions = SetsKt.setOf((Object[])object.toArray((Object[])new Name[object.size()]));
        object = new String[]{"floorDiv", "mod", "code"};
        object = CollectionsKt.listOf((Object[])object);
        $this$toTypedArray$iv = new HashSet();
        FirConstCheckVisitor firConstCheckVisitor = this;
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv = iterator2.next();
            String string2 = (String)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(Name.identifier(it));
        }
        firConstCheckVisitor.compileTimeExtensionFunctions = (HashSet)destination$iv;
        $this$mapTo$iv = new String[]{"toInt", "toLong", "toShort", "toByte", "toFloat", "toDouble", "toChar", "toBoolean"};
        $this$mapTo$iv = CollectionsKt.listOf((Object[])$this$mapTo$iv);
        destination$iv = new HashSet();
        firConstCheckVisitor = this;
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv = iterator2.next();
            it = (String)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(Name.identifier(it));
        }
        firConstCheckVisitor.compileTimeConversionFunctions = (HashSet)var3_3;
    }

    @NotNull
    public ConstantArgumentKind visitElement(@NotNull FirElement element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ConstantArgumentKind.NOT_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitErrorExpression(@NotNull FirErrorExpression errorExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)errorExpression, (String)"errorExpression");
        return ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)namedArgumentExpression, (String)"namedArgumentExpression");
        return (ConstantArgumentKind)((Object)namedArgumentExpression.getExpression().accept(this, data));
    }

    @NotNull
    public ConstantArgumentKind visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
        return typeOperatorCall.getOperation() == FirOperation.AS ? ConstantArgumentKind.NOT_CONST : ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitWhenExpression(@NotNull FirWhenExpression whenExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        if (!ExhaustivenessStatusKt.isProperlyExhaustive(whenExpression) || !this.intrinsicConstEvaluation) {
            return ConstantArgumentKind.NOT_CONST;
        }
        Object object = whenExpression.getSubject();
        if (object != null && (object = (ConstantArgumentKind)((Object)object.accept(this, data))) != null) {
            Object this_$iv = object;
            boolean $i$f$ifNotValidConst = false;
            if (this_$iv != ConstantArgumentKind.VALID_CONST) {
                Object it = this_$iv;
                boolean bl = false;
                return it;
            }
        }
        for (FirWhenBranch branch : whenExpression.getBranches()) {
            if (!(branch.getCondition() instanceof FirElseIfTrueCondition)) {
                ConstantArgumentKind this_$iv = (ConstantArgumentKind)((Object)branch.getCondition().accept(this, data));
                boolean $i$f$ifNotValidConst = false;
                if (this_$iv != ConstantArgumentKind.VALID_CONST) {
                    ConstantArgumentKind it = this_$iv;
                    boolean bl = false;
                    return it;
                }
            }
            Iterable $this$forEach$iv = branch.getResult().getStatements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirStatement stmt = (FirStatement)element$iv;
                boolean bl = false;
                if (!(stmt instanceof FirExpression)) {
                    return ConstantArgumentKind.NOT_CONST;
                }
                ConstantArgumentKind this_$iv = (ConstantArgumentKind)((Object)((FirExpression)stmt).accept(this, data));
                boolean $i$f$ifNotValidConst = false;
                if (this_$iv == ConstantArgumentKind.VALID_CONST) continue;
                ConstantArgumentKind it = this_$iv;
                boolean bl2 = false;
                return it;
            }
        }
        return ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitWhenSubjectExpression(@NotNull FirWhenSubjectExpression whenSubjectExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)whenSubjectExpression, (String)"whenSubjectExpression");
        return this.intrinsicConstEvaluation ? ConstantArgumentKind.VALID_CONST : ConstantArgumentKind.NOT_CONST;
    }

    @NotNull
    public <T> ConstantArgumentKind visitLiteralExpression(@NotNull FirLiteralExpression<T> literalExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(literalExpression, (String)"literalExpression");
        return ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitComparisonExpression(@NotNull FirComparisonExpression comparisonExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)comparisonExpression, (String)"comparisonExpression");
        return (ConstantArgumentKind)((Object)comparisonExpression.getCompareToCall().accept(this, data));
    }

    @NotNull
    public ConstantArgumentKind visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)stringConcatenationCall, (String)"stringConcatenationCall");
        FirCall $this$arguments$iv = stringConcatenationCall;
        boolean $i$f$getArguments = false;
        for (FirExpression exp : $this$arguments$iv.getArgumentList().getArguments()) {
            if (exp instanceof FirResolvedQualifier || exp instanceof FirGetClassCall) {
                return ConstantArgumentKind.NOT_CONST;
            }
            ConstantArgumentKind this_$iv = (ConstantArgumentKind)((Object)exp.accept(this, data));
            boolean $i$f$ifNotValidConst = false;
            if (this_$iv == ConstantArgumentKind.VALID_CONST) continue;
            ConstantArgumentKind it = this_$iv;
            boolean bl = false;
            return it;
        }
        return ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
        if (equalityOperatorCall.getOperation() == FirOperation.IDENTITY || equalityOperatorCall.getOperation() == FirOperation.NOT_IDENTITY) {
            return ConstantArgumentKind.NOT_CONST;
        }
        FirCall $this$arguments$iv = equalityOperatorCall;
        boolean $i$f$getArguments = false;
        for (FirExpression exp : $this$arguments$iv.getArgumentList().getArguments()) {
            if (exp instanceof FirLiteralExpression && ((FirLiteralExpression)exp).getValue() == null) {
                return ConstantArgumentKind.NOT_CONST;
            }
            if (exp instanceof FirResolvedQualifier || exp instanceof FirGetClassCall || ConeBuiltinTypeUtilsKt.isUnsignedType(this.getExpandedType(exp))) {
                return ConstantArgumentKind.NOT_CONST;
            }
            ConstantArgumentKind this_$iv = (ConstantArgumentKind)((Object)exp.accept(this, data));
            boolean $i$f$ifNotValidConst = false;
            if (this_$iv == ConstantArgumentKind.VALID_CONST) continue;
            ConstantArgumentKind it = this_$iv;
            boolean bl = false;
            return it;
        }
        return ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
        ConstantArgumentKind this_$iv = (ConstantArgumentKind)((Object)binaryLogicExpression.getLeftOperand().accept(this, data));
        boolean $i$f$ifNotValidConst = false;
        if (this_$iv != ConstantArgumentKind.VALID_CONST) {
            ConstantArgumentKind it = this_$iv;
            boolean bl = false;
            return it;
        }
        this_$iv = (ConstantArgumentKind)((Object)binaryLogicExpression.getRightOperand().accept(this, data));
        $i$f$ifNotValidConst = false;
        if (this_$iv != ConstantArgumentKind.VALID_CONST) {
            ConstantArgumentKind it = this_$iv;
            boolean bl = false;
            return it;
        }
        return ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitGetClassCall(@NotNull FirGetClassCall getClassCall, @Nullable Void data) {
        Object object;
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        ConeKotlinTypeProjection coneType = this.getExpandedType(getClassCall.getArgument());
        if (coneType instanceof ConeErrorType) {
            return ConstantArgumentKind.NOT_CONST;
        }
        while (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(coneType), (Object)StandardClassIds.INSTANCE.getArray()) && (coneKotlinTypeProjection = (object = ArraysKt.first((Object[])ConeTypeUtilsKt.lowerBoundIfFlexible(coneType).getTypeArguments())) instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)object : null) != null && (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) != null) {
            coneType = coneKotlinTypeProjection;
        }
        return coneType instanceof ConeTypeParameterType ? ConstantArgumentKind.KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR : (!(getClassCall.getArgument() instanceof FirResolvedQualifier) ? ConstantArgumentKind.NOT_KCLASS_LITERAL : ConstantArgumentKind.VALID_CONST);
    }

    @NotNull
    public ConstantArgumentKind visitArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)arrayLiteral, (String)"arrayLiteral");
        FirCall $this$arguments$iv = arrayLiteral;
        boolean $i$f$getArguments = false;
        for (FirExpression exp : $this$arguments$iv.getArgumentList().getArguments()) {
            ConstantArgumentKind this_$iv = (ConstantArgumentKind)((Object)exp.accept(this, data));
            boolean $i$f$ifNotValidConst = false;
            if (this_$iv == ConstantArgumentKind.VALID_CONST) continue;
            ConstantArgumentKind it = this_$iv;
            boolean bl = false;
            return it;
        }
        return ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitThisReceiverExpression(@NotNull FirThisReceiverExpression thisReceiverExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)thisReceiverExpression, (String)"thisReceiverExpression");
        return ConstantArgumentKind.NOT_CONST;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public ConstantArgumentKind visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @Nullable Void data) {
        block20: {
            Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
            v0 = ReferenceUtilsKt.toReference(propertyAccessExpression, this.session);
            var4_4 = propertySymbol = v0 != null ? FirReferenceUtilsKt.toResolvedCallableSymbol(v0, true) : null;
            if (var4_4 == null) {
                return ConstantArgumentKind.VALID_CONST;
            }
            if (!(var4_4 instanceof FirPropertySymbol)) break block20;
            var7_5 = this.getReferencedClassSymbol(propertySymbol);
            v1 = var7_5 instanceof FirRegularClassSymbol != false ? (FirRegularClassSymbol)var7_5 : null;
            v2 = classKindOfParent = v1 != null ? v1.getClassKind() : null;
            if (classKindOfParent == ClassKind.ENUM_CLASS) {
                return ConstantArgumentKind.ENUM_NOT_CONST;
            }
            var6_10 = propertySymbol;
            var18_12 = this;
            $i$f$unwrapFakeOverrides = false;
            $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
            $i$f$unwrapFakeOverrides = false;
            current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
            while (true) {
                $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
                $i$f$originalIfFakeOverride = false;
                $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                $i$f$getOriginalForSubstitutionOverride = false;
                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                $i$f$isSynthetic = false;
                if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                // 2 sources

                {
                    v3 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                } else {
                    v3 = v4 = null;
                }
                if (v3 == null) {
                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    $i$f$getBaseForIntersectionOverride = false;
                    v4 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                }
                if (v4 == null) break;
                current$iv$iv = next$iv$iv = v4;
            }
            v5 = current$iv$iv.getSymbol();
            if (v5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
            }
            if (var18_12.canBeEvaluated((FirPropertySymbol)v5) || this.isCompileTimeBuiltinProperty((FirPropertySymbol)propertySymbol)) {
                $i$f$unwrapFakeOverrides /* !! */  = new FirExpression[]{propertyAccessExpression.getDispatchReceiver(), propertyAccessExpression.getExtensionReceiver()};
                $i$f$unwrapFakeOverrides /* !! */  = CollectionsKt.listOf((Object[])$i$f$unwrapFakeOverrides /* !! */ );
                $i$f$single = false;
                single$iv = null;
                found$iv = false;
                for (T element$iv : $this$single$iv) {
                    it = (FirExpression)element$iv;
                    $i$a$-single-FirConstCheckVisitor$visitPropertyAccessExpression$receiver$1 = false;
                    if (!(it != null)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                receiver = single$iv;
                v6 /* !! */  = receiver;
                if (v6 /* !! */  == null || (v6 /* !! */  = (ConstantArgumentKind)v6 /* !! */ .accept(this, data)) == null) {
                    v6 /* !! */  = ConstantArgumentKind.VALID_CONST;
                }
                return v6 /* !! */ ;
            }
            if (((FirPropertySymbol)propertySymbol).isLocal()) {
                return ConstantArgumentKind.NOT_CONST;
            }
            if (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(this.getExpandedType(propertyAccessExpression)), (Object)StandardClassIds.INSTANCE.getKClass())) {
                return ConstantArgumentKind.NOT_KCLASS_LITERAL;
            }
            $this$isConst$iv = propertySymbol;
            $i$f$isConst = false;
            if ($this$isConst$iv.getRawStatus().isConst()) {
                return ConstantArgumentKind.VALID_CONST;
            }
            $this$isConst$iv = ((FirProperty)((FirPropertySymbol)propertySymbol).getFir()).getInitializer();
            return $this$isConst$iv instanceof FirLiteralExpression ? (((FirPropertySymbol)propertySymbol).isVal() ? ConstantArgumentKind.NOT_CONST_VAL_IN_CONST_EXPRESSION : ConstantArgumentKind.NOT_CONST) : ($this$isConst$iv instanceof FirGetClassCall != false ? ConstantArgumentKind.NOT_KCLASS_LITERAL : ConstantArgumentKind.NOT_CONST);
        }
        if (var4_4 instanceof FirFieldSymbol) {
            $this$isStatic$iv = propertySymbol;
            $i$f$isStatic = false;
            if ($this$isStatic$iv.getRawStatus().isStatic()) {
                $this$modality$iv = propertySymbol;
                $i$f$getModality = false;
                if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL && ((FirFieldSymbol)propertySymbol).getHasConstantInitializer()) {
                    return ConstantArgumentKind.VALID_CONST;
                }
            }
        } else if (var4_4 instanceof FirEnumEntrySymbol) {
            return ConstantArgumentKind.VALID_CONST;
        }
        return ConstantArgumentKind.NOT_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitIntegerLiteralOperatorCall(@NotNull FirIntegerLiteralOperatorCall integerLiteralOperatorCall, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)integerLiteralOperatorCall, (String)"integerLiteralOperatorCall");
        return this.visitFunctionCall((FirFunctionCall)integerLiteralOperatorCall, data);
    }

    @NotNull
    public ConstantArgumentKind visitFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        FirNamedReference calleeReference = functionCall.getCalleeReference();
        if (calleeReference instanceof FirErrorNamedReference || calleeReference instanceof FirResolvedErrorReference) {
            return ConstantArgumentKind.VALID_CONST;
        }
        if (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(this.getExpandedType(functionCall)), (Object)StandardClassIds.INSTANCE.getKClass())) {
            return ConstantArgumentKind.NOT_KCLASS_LITERAL;
        }
        if (!(calleeReference instanceof FirResolvedNamedReference)) {
            return ConstantArgumentKind.NOT_CONST;
        }
        FirBasedSymbol<?> symbol = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
        return symbol instanceof FirNamedFunctionSymbol ? this.visitNamedFunction(functionCall, (FirNamedFunctionSymbol)symbol) : (symbol instanceof FirConstructorSymbol ? this.visitConstructorCall(functionCall, (FirConstructorSymbol)symbol) : ConstantArgumentKind.NOT_CONST);
    }

    private final ConstantArgumentKind visitNamedFunction(FirFunctionCall functionCall, FirNamedFunctionSymbol symbol) {
        if (!this.canBeEvaluated(symbol) && !this.isCompileTimeBuiltinCall(functionCall)) {
            return ConstantArgumentKind.NOT_CONST;
        }
        FirCall $this$arguments$iv = functionCall;
        boolean $i$f$getArguments = false;
        for (FirExpression exp : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)$this$arguments$iv.getArgumentList().getArguments(), (Object)functionCall.getDispatchReceiver()), (Object)functionCall.getExtensionReceiver())) {
            if (exp == null) continue;
            ClassId expClassId = FirHelpersKt.fullyExpandedClassId(ConeTypeUtilsKt.lowerBoundIfFlexible(this.getExpandedType(exp)), this.session);
            if (!CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getConstantAllowedTypes(), (Object)expClassId)) {
                return ConstantArgumentKind.NOT_CONST;
            }
            ConstantArgumentKind this_$iv = (ConstantArgumentKind)((Object)exp.accept(this, null));
            boolean $i$f$ifNotValidConst = false;
            if (this_$iv == ConstantArgumentKind.VALID_CONST) continue;
            ConstantArgumentKind it = this_$iv;
            boolean bl = false;
            return it;
        }
        return ConstantArgumentKind.VALID_CONST;
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantArgumentKind visitConstructorCall(FirFunctionCall constructorCall, FirConstructorSymbol symbol) {
        ConstantArgumentKind constantArgumentKind;
        FirBasedSymbol<?> firBasedSymbol = this.getReferencedClassSymbol(symbol);
        FirRegularClassSymbol firRegularClassSymbol = firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
        ClassKind classKindOfParent = firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null;
        if (classKindOfParent == ClassKind.ANNOTATION_CLASS) {
            constantArgumentKind = ConstantArgumentKind.VALID_CONST;
        } else if (ConeBuiltinTypeUtilsKt.isUnsignedType(this.getExpandedType(constructorCall))) {
            void $this$forEach$iv;
            Object $this$arguments$iv = constructorCall;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression argumentExpression = (FirExpression)element$iv;
                boolean bl = false;
                ConstantArgumentKind this_$iv = (ConstantArgumentKind)((Object)argumentExpression.accept(this, null));
                boolean $i$f$ifNotValidConst = false;
                if (this_$iv == ConstantArgumentKind.VALID_CONST) continue;
                ConstantArgumentKind it = this_$iv;
                boolean bl2 = false;
                return it;
            }
            constantArgumentKind = ConstantArgumentKind.VALID_CONST;
        } else {
            constantArgumentKind = ConstantArgumentKind.NOT_CONST;
        }
        return constantArgumentKind;
    }

    @NotNull
    public ConstantArgumentKind visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
        ConeKotlinType expressionType = this.getExpandedType(qualifiedAccessExpression);
        if (FunctionalTypeUtilsKt.isReflectFunctionType(expressionType, this.session) || InferenceUtilsKt.isKProperty(expressionType, this.session) || InferenceUtilsKt.isKMutableProperty(expressionType, this.session)) {
            Object object = qualifiedAccessExpression.getDispatchReceiver();
            if (object == null || (object = (ConstantArgumentKind)((Object)object.accept(this, data))) == null) {
                object = ConstantArgumentKind.VALID_CONST;
            }
            return object;
        }
        return ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
        return ConstantArgumentKind.VALID_CONST;
    }

    @NotNull
    public ConstantArgumentKind visitCallableReferenceAccess(@NotNull FirCallableReferenceAccess callableReferenceAccess, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)callableReferenceAccess, data);
    }

    private final boolean canBeEvaluated(FirBasedSymbol<?> $this$canBeEvaluated) {
        return this.intrinsicConstEvaluation && FirAnnotationUtilsKt.hasAnnotation($this$canBeEvaluated, StandardClassIds.Annotations.INSTANCE.getIntrinsicConstEvaluation(), this.session);
    }

    private final ConeKotlinType getExpandedType(FirExpression $this$getExpandedType) {
        return TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getResolvedType($this$getExpandedType), this.session);
    }

    private final boolean isCompileTimeBuiltinCall(FirFunctionCall $this$isCompileTimeBuiltinCall) {
        ClassId receiverClassId;
        FirCallableSymbol symbol;
        FirNamedReference calleeReference = $this$isCompileTimeBuiltinCall.getCalleeReference();
        if (!(calleeReference instanceof FirResolvedNamedReference)) {
            return false;
        }
        Name name2 = ((FirResolvedNamedReference)calleeReference).getName();
        FirBasedSymbol<?> firBasedSymbol = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
        FirCallableSymbol firCallableSymbol = symbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (!this.fromKotlin(symbol)) {
            return false;
        }
        Object object = $this$isCompileTimeBuiltinCall.getDispatchReceiver();
        ClassId classId = object != null && (object = this.getExpandedType((FirExpression)object)) != null ? ConeTypeUtilsKt.getClassId((ConeKotlinType)object) : (receiverClassId = null);
        if (CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getUnsignedTypes(), (Object)receiverClassId)) {
            return false;
        }
        if (this.compileTimeFunctions.contains(name2) || this.compileTimeExtensionFunctions.contains(name2) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.TO_STRING) || this.compileTimeConversionFunctions.contains(name2)) {
            return true;
        }
        return Intrinsics.areEqual((Object)((FirResolvedNamedReference)calleeReference).getName(), (Object)OperatorNameConventions.GET) && Intrinsics.areEqual((Object)receiverClassId, (Object)StandardClassIds.INSTANCE.getString());
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCompileTimeBuiltinProperty(FirPropertySymbol $this$isCompileTimeBuiltinProperty) {
        boolean bl;
        ConeKotlinType coneKotlinType;
        ConeSimpleKotlinType coneSimpleKotlinType = $this$isCompileTimeBuiltinProperty.getDispatchReceiverType();
        if (coneSimpleKotlinType != null) {
            coneKotlinType = coneSimpleKotlinType;
        } else {
            FirReceiverParameter firReceiverParameter = $this$isCompileTimeBuiltinProperty.getReceiverParameter();
            FirPureAbstractElement firPureAbstractElement = firReceiverParameter;
            if (firReceiverParameter == null) return false;
            FirTypeRef firTypeRef = firPureAbstractElement.getTypeRef();
            firPureAbstractElement = firTypeRef;
            if (firTypeRef == null) return false;
            FirPureAbstractElement firPureAbstractElement2 = firPureAbstractElement;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = firPureAbstractElement2 instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firPureAbstractElement2 : null;
            ConeKotlinType coneKotlinType2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                return false;
            }
            coneKotlinType = coneKotlinType2;
            if (coneKotlinType2 == null) {
                return false;
            }
        }
        ConeKotlinType receiverType = coneKotlinType;
        ClassId classId = FirHelpersKt.fullyExpandedClassId(receiverType, this.session);
        if (classId == null) {
            return false;
        }
        ClassId receiverClassId = classId;
        String string2 = $this$isCompileTimeBuiltinProperty.getName().asString();
        switch (string2.hashCode()) {
            case 3059181: {
                if (string2.equals("code")) break;
                return false;
            }
            case -1106363674: {
                if (!string2.equals("length")) return false;
                bl = Intrinsics.areEqual((Object)receiverClassId, (Object)StandardClassIds.INSTANCE.getString());
                return bl;
            }
        }
        bl = Intrinsics.areEqual((Object)receiverClassId, (Object)StandardClassIds.INSTANCE.getChar());
        return bl;
        return false;
    }

    private final boolean fromKotlin(FirCallableSymbol<?> $this$fromKotlin) {
        FirCallableSymbol<?> firCallableSymbol = $this$fromKotlin;
        return Intrinsics.areEqual(firCallableSymbol != null && (firCallableSymbol = firCallableSymbol.getCallableId()) != null && (firCallableSymbol = ((CallableId)((Object)firCallableSymbol)).getPackageName()) != null ? ((FqName)((Object)firCallableSymbol)).asString() : null, (Object)"kotlin");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final FirBasedSymbol<?> getReferencedClassSymbol(FirCallableSymbol<?> $this$getReferencedClassSymbol) {
        FirClassifierSymbol<?> firClassifierSymbol;
        FirResolvedTypeRef firResolvedTypeRef;
        if ($this$getReferencedClassSymbol != null && (firResolvedTypeRef = $this$getReferencedClassSymbol.getResolvedReturnTypeRef()) != null) {
            ConeLookupTagBasedType coneLookupTagBasedType;
            void $this$coneTypeSafe$iv;
            Object object = firResolvedTypeRef;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef2 = (FirResolvedTypeRef)$this$coneTypeSafe$iv;
            ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                coneKotlinType = null;
            }
            if ((coneLookupTagBasedType = (ConeLookupTagBasedType)((ConeKotlinType)((ConeLookupTagBasedType)coneKotlinType))) != null && (object = coneLookupTagBasedType.getLookupTag()) != null) {
                firClassifierSymbol = LookupTagUtilsKt.toSymbol((ConeClassifierLookupTag)object, this.session);
                return firClassifierSymbol;
            }
        }
        firClassifierSymbol = null;
        return firClassifierSymbol;
    }
}

