/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/XcodeStyleMessageRenderer;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "<init>", "()V", "render", "", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "renderPreamble", "renderUsage", "usage", "renderConclusion", "getName", "cli"})
public final class XcodeStyleMessageRenderer
implements MessageRenderer {
    @Override
    @NotNull
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        StringBuilder stringBuilder;
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: 
            case 2: {
                string2 = "warning";
                break;
            }
            case 3: 
            case 4: {
                string2 = "error";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string2 = "note";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String xcodeSeverity = string2;
        StringBuilder $this$render_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CompilerMessageSourceLocation compilerMessageSourceLocation = location;
        if (compilerMessageSourceLocation != null) {
            CompilerMessageSourceLocation compilerMessageSourceLocation2;
            CompilerMessageSourceLocation $this$render_u24lambda_u241_u24lambda_u240 = compilerMessageSourceLocation2 = compilerMessageSourceLocation;
            boolean bl2 = false;
            $this$render_u24lambda_u241.append($this$render_u24lambda_u241_u24lambda_u240.getPath() + ':' + $this$render_u24lambda_u241_u24lambda_u240.getLine() + ':' + $this$render_u24lambda_u241_u24lambda_u240.getColumn() + ": ");
        }
        $this$render_u24lambda_u241.append(xcodeSeverity + ": " + message);
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @Override
    @NotNull
    public String renderPreamble() {
        return "";
    }

    @Override
    @NotNull
    public String renderUsage(@NotNull String usage) {
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        return usage;
    }

    @Override
    @NotNull
    public String renderConclusion() {
        return "";
    }

    @Override
    @NotNull
    public String getName() {
        return "XcodeStyle";
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerMessageSeverity.values().length];
            try {
                nArray[CompilerMessageSeverity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.STRONG_WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.EXCEPTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.LOGGING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.OUTPUT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerMessageSeverity.INFO.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

