/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.AbstractDiagnosticDescriptor;
import org.jetbrains.kotlin.checkers.diagnostics.AbstractTestDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.TextDiagnostic;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/checkers/ActualDiagnosticDescriptor;", "Lorg/jetbrains/kotlin/checkers/AbstractDiagnosticDescriptor;", "start", "", "end", "diagnostics", "", "Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractTestDiagnostic;", "<init>", "(IILjava/util/List;)V", "getDiagnostics", "()Ljava/util/List;", "textDiagnosticsMap", "", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic;", "getTextDiagnosticsMap", "()Ljava/util/Map;", "frontend"})
public final class ActualDiagnosticDescriptor
extends AbstractDiagnosticDescriptor {
    @NotNull
    private final List<AbstractTestDiagnostic> diagnostics;

    public ActualDiagnosticDescriptor(int start, int end, @NotNull List<? extends AbstractTestDiagnostic> diagnostics) {
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        super(start, end);
        this.diagnostics = diagnostics;
    }

    @NotNull
    public final List<AbstractTestDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final Map<AbstractTestDiagnostic, TextDiagnostic> getTextDiagnosticsMap() {
        Map diagnosticMap = new LinkedHashMap();
        for (AbstractTestDiagnostic diagnostic : this.diagnostics) {
            diagnosticMap.put(diagnostic, TextDiagnostic.Companion.asTextDiagnostic(diagnostic));
        }
        return diagnosticMap;
    }
}

