/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.SourceMapsInfo;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.wasm.ir.debug.DebugData;
import org.jetbrains.kotlin.wasm.ir.debug.DebugInformationGenerator;
import org.jetbrains.kotlin.wasm.ir.debug.DebugSection;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocationMapping;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0017\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0010H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/utils/SourceMapGenerator;", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformationGenerator;", "baseFileName", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "sourceMapFileName", "sourceLocationMappings", "", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocationMapping;", "addSourceLocation", "", "location", "generateDebugInformation", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugInformation;", "", "Lorg/jetbrains/kotlin/wasm/ir/debug/DebugSection;", "()Ljava/util/List;", "generate", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nSourceMapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapGenerator.kt\norg/jetbrains/kotlin/backend/wasm/utils/SourceMapGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class SourceMapGenerator
implements DebugInformationGenerator {
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final String sourceMapFileName;
    @NotNull
    private final List<SourceLocationMapping> sourceLocationMappings;

    public SourceMapGenerator(@NotNull String baseFileName, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)baseFileName, (String)"baseFileName");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.configuration = configuration2;
        this.sourceMapFileName = baseFileName + ".map";
        this.sourceLocationMappings = new ArrayList();
    }

    @Override
    public void addSourceLocation(@NotNull SourceLocationMapping location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.sourceLocationMappings.add(location);
    }

    @Override
    @NotNull
    public List<DebugSection> generateDebugInformation() {
        return CollectionsKt.listOf((Object)new DebugSection("sourceMappingURL", DebugData.StringData.box-impl(DebugData.StringData.constructor-impl(this.sourceMapFileName))));
    }

    @Nullable
    public final String generate() {
        SourceMapsInfo sourceMapsInfo = SourceMapsInfo.Companion.from(this.configuration);
        if (sourceMapsInfo == null) {
            return null;
        }
        SourceMapsInfo sourceMapsInfo2 = sourceMapsInfo;
        SourceMap3Builder sourceMapBuilder2 = new SourceMap3Builder(null, (Function0<Integer>)((Function0)SourceMapGenerator::generate$lambda$0), sourceMapsInfo2.getSourceMapPrefix());
        SourceFilePathResolver pathResolver = SourceFilePathResolver.Companion.create(sourceMapsInfo2.getSourceRoots(), sourceMapsInfo2.getSourceMapPrefix(), sourceMapsInfo2.getOutputDir());
        SourceLocation.Location prev = null;
        int prevGeneratedLine = 0;
        for (SourceLocationMapping mapping : this.sourceLocationMappings) {
            SourceLocation sourceLocation;
            SourceLocation sourceLocation2;
            SourceLocation sourceLocation3;
            SourceLocation.Location generatedLocation = mapping.getGeneratedLocation();
            SourceLocation it = sourceLocation3 = mapping.getSourceLocation();
            boolean bl = false;
            if ((!Intrinsics.areEqual((Object)it, prev) || prevGeneratedLine != generatedLocation.getLine() ? sourceLocation3 : null) == null) continue;
            sourceLocation2 = sourceLocation2;
            if (!(generatedLocation.getLine() >= prevGeneratedLine)) {
                boolean bl2 = false;
                String string2 = "The order of the mapping is wrong";
                throw new IllegalArgumentException(string2.toString());
            }
            if (prevGeneratedLine != generatedLocation.getLine()) {
                int n = generatedLocation.getLine() - prevGeneratedLine;
                int n2 = 0;
                while (n2 < n) {
                    int it2 = n2++;
                    boolean bl3 = false;
                    sourceMapBuilder2.newLine();
                }
                prevGeneratedLine = generatedLocation.getLine();
            }
            if ((sourceLocation = sourceLocation2) instanceof SourceLocation.NoLocation) {
                sourceMapBuilder2.addEmptyMapping(generatedLocation.getColumn());
                continue;
            }
            if (sourceLocation instanceof SourceLocation.Location) {
                sourceLocation3 = sourceLocation2;
                SourceLocation.Location $this$generate_u24lambda_u245 = (SourceLocation.Location)sourceLocation3;
                boolean bl4 = false;
                CharSequence charSequence = pathResolver.getPathRelativeToSourceRoots(new File($this$generate_u24lambda_u245.getFile()));
                Regex regex = new Regex("^\\.\\./");
                String string3 = "";
                String relativePath = regex.replace(charSequence, string3);
                sourceMapBuilder2.addMapping(relativePath, null, SourceMapGenerator::generate$lambda$5$lambda$4, $this$generate_u24lambda_u245.getLine(), $this$generate_u24lambda_u245.getColumn(), null, generatedLocation.getColumn());
                prev = $this$generate_u24lambda_u245;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return sourceMapBuilder2.build();
    }

    private static final int generate$lambda$0() {
        throw new IllegalStateException("This should not be called for Kotlin/Wasm".toString());
    }

    private static final Reader generate$lambda$5$lambda$4() {
        return null;
    }
}

