/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.LineAndColumn;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\r\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"hasSyntheticOrUndefinedLocation", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "getHasSyntheticOrUndefinedLocation", "(Lorg/jetbrains/kotlin/ir/IrElement;)Z", "getSourceLocation", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "fileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "type", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/LocationType;", "buildUnreachableForVerifier", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "buildUnreachableAfterNothingType", "backend.wasm"})
public final class LocationUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getHasSyntheticOrUndefinedLocation(IrElement $this$hasSyntheticOrUndefinedLocation) {
        boolean bl;
        int n = $this$hasSyntheticOrUndefinedLocation.getStartOffset();
        if (-2 <= n) {
            if (n < 0) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        n = $this$hasSyntheticOrUndefinedLocation.getEndOffset();
        if (-2 > n) return false;
        if (n >= 0) return false;
        return true;
    }

    @NotNull
    public static final SourceLocation getSourceLocation(@NotNull IrElement $this$getSourceLocation, @Nullable IrFileEntry fileEntry, @NotNull LocationType type2) {
        Intrinsics.checkNotNullParameter((Object)$this$getSourceLocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        if (fileEntry == null) {
            return SourceLocation.Companion.NoLocation("fileEntry is null");
        }
        if (LocationUtilsKt.getHasSyntheticOrUndefinedLocation($this$getSourceLocation)) {
            return SourceLocation.Companion.NoLocation("Synthetic declaration");
        }
        String path = fileEntry.getName();
        LineAndColumn lineAndColumn = type2.getLineAndColumnNumberFor($this$getSourceLocation, fileEntry);
        int line = lineAndColumn.component1();
        int column = lineAndColumn.component2();
        if (line < 0 || column < 0) {
            return SourceLocation.Companion.NoLocation("startLine or startColumn < 0");
        }
        return new SourceLocation.Location(path, line, column);
    }

    public static /* synthetic */ SourceLocation getSourceLocation$default(IrElement irElement, IrFileEntry irFileEntry, LocationType locationType, int n, Object object) {
        if ((n & 2) != 0) {
            locationType = LocationType.START;
        }
        return LocationUtilsKt.getSourceLocation(irElement, irFileEntry, locationType);
    }

    public static final void buildUnreachableForVerifier(@NotNull WasmExpressionBuilder $this$buildUnreachableForVerifier) {
        Intrinsics.checkNotNullParameter((Object)$this$buildUnreachableForVerifier, (String)"<this>");
        $this$buildUnreachableForVerifier.buildUnreachable(SourceLocation.Companion.NoLocation("This instruction should never be reached, but required for wasm verifier"));
    }

    public static final void buildUnreachableAfterNothingType(@NotNull WasmExpressionBuilder $this$buildUnreachableAfterNothingType) {
        Intrinsics.checkNotNullParameter((Object)$this$buildUnreachableAfterNothingType, (String)"<this>");
        $this$buildUnreachableAfterNothingType.buildUnreachable(SourceLocation.Companion.NoLocation("The unreachable instruction after an expression with Nothing type to make sure that execution doesn't come here (or it fails fast if so). It also might be required for wasm verifier."));
    }
}

