/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.builtins.FunctionInterfacePackageFragment;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.library.SerializedIrFile;
import org.jetbrains.kotlin.library.SerializedIrModule;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH&\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u001eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer;", "Serializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "compatibilityMode", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "normalizeAbsolutePaths", "", "sourceBaseDirs", "", "", "shouldCheckSignaturesOnUniqueness", "<init>", "(Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;ZLjava/util/Collection;Z)V", "getDiagnosticReporter", "()Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "getCompatibilityMode", "()Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "getNormalizeAbsolutePaths", "()Z", "getSourceBaseDirs", "()Ljava/util/Collection;", "createSerializerForFile", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "backendSpecificFileFilter", "globalDeclarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "getGlobalDeclarationTable", "()Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "serializeIrFile", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "serializedIrModule", "Lorg/jetbrains/kotlin/library/SerializedIrModule;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrModuleSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrModuleSerializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n774#2:51\n865#2,2:52\n774#2:54\n865#2,2:55\n1557#2:57\n1628#2,3:58\n*S KotlinDebug\n*F\n+ 1 IrModuleSerializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleSerializer\n*L\n42#1:51\n42#1:52,2\n43#1:54\n43#1:55,2\n44#1:57\n44#1:58,3\n*E\n"})
public abstract class IrModuleSerializer<Serializer extends IrFileSerializer> {
    @NotNull
    private final IrDiagnosticReporter diagnosticReporter;
    @NotNull
    private final CompatibilityMode compatibilityMode;
    private final boolean normalizeAbsolutePaths;
    @NotNull
    private final Collection<String> sourceBaseDirs;
    private final boolean shouldCheckSignaturesOnUniqueness;

    public IrModuleSerializer(@NotNull IrDiagnosticReporter diagnosticReporter, @NotNull CompatibilityMode compatibilityMode, boolean normalizeAbsolutePaths, @NotNull Collection<String> sourceBaseDirs, boolean shouldCheckSignaturesOnUniqueness) {
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)compatibilityMode, (String)"compatibilityMode");
        Intrinsics.checkNotNullParameter(sourceBaseDirs, (String)"sourceBaseDirs");
        this.diagnosticReporter = diagnosticReporter;
        this.compatibilityMode = compatibilityMode;
        this.normalizeAbsolutePaths = normalizeAbsolutePaths;
        this.sourceBaseDirs = sourceBaseDirs;
        this.shouldCheckSignaturesOnUniqueness = shouldCheckSignaturesOnUniqueness;
    }

    @NotNull
    protected final IrDiagnosticReporter getDiagnosticReporter() {
        return this.diagnosticReporter;
    }

    @NotNull
    protected final CompatibilityMode getCompatibilityMode() {
        return this.compatibilityMode;
    }

    protected final boolean getNormalizeAbsolutePaths() {
        return this.normalizeAbsolutePaths;
    }

    @NotNull
    protected final Collection<String> getSourceBaseDirs() {
        return this.sourceBaseDirs;
    }

    @NotNull
    public abstract Serializer createSerializerForFile(@NotNull IrFile var1);

    protected boolean backendSpecificFileFilter(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return true;
    }

    @NotNull
    protected abstract GlobalDeclarationTable getGlobalDeclarationTable();

    private final SerializedIrFile serializeIrFile(IrFile file2) {
        Serializer fileSerializer = this.createSerializerForFile(file2);
        return ((IrFileSerializer)fileSerializer).serializeIrFile(file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SerializedIrModule serializedIrModule(@NotNull IrModuleFragment module2) {
        void $this$mapTo$iv$iv;
        IrFile p0;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Iterable $this$filter$iv = module2.getFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrFile it = (IrFile)element$iv$iv;
            boolean bl = false;
            if (!(!(IrPackageFragmentsKt.getPackageFragmentDescriptor(it) instanceof FunctionInterfacePackageFragment))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (IrFile)element$iv$iv;
            boolean bl = false;
            if (!this.backendSpecificFileFilter(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (IrFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.serializeIrFile(p0));
        }
        List serializedFiles = (List)destination$iv$iv;
        if (this.shouldCheckSignaturesOnUniqueness) {
            this.getGlobalDeclarationTable().getClashDetector$ir_serialization_common().reportErrorsTo(this.diagnosticReporter);
        }
        return new SerializedIrModule(serializedFiles);
    }
}

