/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.diagnostics.IdSignatureClashDetector;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTableKt;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u0016\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;)V", "publicIdSignatureComputer", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "getPublicIdSignatureComputer", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "clashDetector", "Lorg/jetbrains/kotlin/backend/common/diagnostics/IdSignatureClashDetector;", "getClashDetector$ir_serialization_common", "()Lorg/jetbrains/kotlin/backend/common/diagnostics/IdSignatureClashDetector;", "table", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getTable", "()Ljava/util/HashMap;", "loadKnownBuiltins", "", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "computeSignatureByDeclaration", "declaration", "compatibleMode", "", "recordInSignatureClashDetector", "isExportedDeclaration", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nDeclarationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,94:1\n1863#2:95\n1864#2:97\n1#3:96\n381#4,7:98\n*S KotlinDebug\n*F\n+ 1 DeclarationTable.kt\norg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable\n*L\n26#1:95\n26#1:97\n37#1:98,7\n*E\n"})
public abstract class GlobalDeclarationTable {
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final PublicIdSignatureComputer publicIdSignatureComputer;
    @NotNull
    private final IdSignatureClashDetector clashDetector;
    @NotNull
    private final HashMap<IrDeclaration, IdSignature> table;

    public GlobalDeclarationTable(@NotNull KotlinMangler.IrMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.mangler = mangler;
        this.publicIdSignatureComputer = new PublicIdSignatureComputer(this.mangler);
        this.clashDetector = new IdSignatureClashDetector();
        this.table = new HashMap();
    }

    @NotNull
    public final PublicIdSignatureComputer getPublicIdSignatureComputer() {
        return this.publicIdSignatureComputer;
    }

    @NotNull
    public final IdSignatureClashDetector getClashDetector$ir_serialization_common() {
        return this.clashDetector;
    }

    @NotNull
    protected final HashMap<IrDeclaration, IdSignature> getTable() {
        return this.table;
    }

    protected final void loadKnownBuiltins(@NotNull IrBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Iterable $this$forEach$iv = DeclarationTableKt.getKnownBuiltins(builtIns);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdSignature idSignature;
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            IrSymbol symbol = ((IrSymbolOwner)it).getSymbol();
            Map map = this.table;
            IdSignature idSignature2 = symbol.getSignature();
            Intrinsics.checkNotNull((Object)idSignature2);
            IdSignature id = idSignature = idSignature2;
            boolean bl2 = false;
            this.clashDetector.trackDeclaration(it, id);
            map.put(it, idSignature);
        }
    }

    @NotNull
    public final IdSignature computeSignatureByDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode, boolean recordInSignatureClashDetector) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Map $this$getOrPut$iv = this.table;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature answer$iv = this.publicIdSignatureComputer.composePublicIdSignature(declaration, compatibleMode);
            $this$getOrPut$iv.put(declaration, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Object v = object;
        IdSignature it = (IdSignature)v;
        boolean bl = false;
        if (recordInSignatureClashDetector && it.isPubliclyVisible() && !it.isLocal()) {
            this.clashDetector.trackDeclaration(declaration, it);
        }
        return (IdSignature)v;
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KotlinMangler.IrMangler $this$isExportedDeclaration_u24lambda_u244 = this.mangler;
        boolean bl = false;
        return $this$isExportedDeclaration_u24lambda_u244.isExported(declaration, compatibleMode);
    }
}

