/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableCollection;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.AbstractKotlinSuppressCache;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;
import org.jetbrains.kotlin.util.ExtensionProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\nH\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0002H&J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0016\u0010\u001d\u001a\u00020\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0014J\"\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u000bH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "<init>", "()V", "diagnosticSuppressors", "Lorg/jetbrains/kotlin/util/ExtensionProvider;", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticSuppressor;", "filter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "getFilter", "()Lkotlin/jvm/functions/Function1;", "isSuppressedByExtension", "suppressor", "diagnostic", "getSuppressionAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "annotated", "getSuppressingStrings", "", "", "processAnnotation", "", "builder", "Lorg/jetbrains/kotlin/com/google/common/collect/ImmutableSet$Builder;", "annotationDescriptor", "isSuppressed", "request", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "getClosestAnnotatedAncestorElement", "element", "rootElement", "excludeSelf", "DiagnosticSuppressRequest", "Companion", "frontend"})
public abstract class KotlinSuppressCache
extends AbstractKotlinSuppressCache<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtensionProvider<DiagnosticSuppressor> diagnosticSuppressors = ExtensionProvider.Companion.create(DiagnosticSuppressor.Companion.getEP_NAME());
    @NotNull
    private final Function1<Diagnostic, Boolean> filter = (Function1)new Function1<Diagnostic, Boolean>(this){
        final /* synthetic */ KotlinSuppressCache this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final Boolean invoke(Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            return !this.this$0.isSuppressed(new DiagnosticSuppressRequest(diagnostic));
        }
    };

    @NotNull
    public final Function1<Diagnostic, Boolean> getFilter() {
        return this.filter;
    }

    protected boolean isSuppressedByExtension(@NotNull DiagnosticSuppressor suppressor, @NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return suppressor.isSuppressed(diagnostic);
    }

    @NotNull
    public abstract List<AnnotationDescriptor> getSuppressionAnnotations(@NotNull PsiElement var1);

    @Override
    @NotNull
    protected Set<String> getSuppressingStrings(@NotNull PsiElement annotated) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        ImmutableSet.Builder<String> builder2 = ImmutableSet.builder();
        for (AnnotationDescriptor annotationDescriptor : this.getSuppressionAnnotations(annotated)) {
            Intrinsics.checkNotNull(builder2);
            this.processAnnotation(builder2, annotationDescriptor);
        }
        ImmutableCollection immutableCollection = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableCollection, (String)"build(...)");
        return (Set)((Object)immutableCollection);
    }

    private final void processAnnotation(ImmutableSet.Builder<String> builder2, AnnotationDescriptor annotationDescriptor) {
        if (!Intrinsics.areEqual((Object)annotationDescriptor.getFqName(), (Object)StandardNames.FqNames.suppress)) {
            return;
        }
        for (ConstantValue<?> arrayValue : annotationDescriptor.getAllValueArguments().values()) {
            if (!(arrayValue instanceof ArrayValue)) continue;
            for (ConstantValue value2 : (List)((ArrayValue)arrayValue).getValue()) {
                if (!(value2 instanceof StringValue)) continue;
                String string2 = ((String)((StringValue)value2).getValue()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                builder2.add((Object)string2);
            }
        }
    }

    @Override
    protected boolean isSuppressed(@NotNull AbstractKotlinSuppressCache.SuppressRequest<PsiElement> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        PsiElement element = request.getElement();
        if (!element.isValid()) {
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null) {
            return true;
        }
        if (request instanceof DiagnosticSuppressRequest) {
            for (DiagnosticSuppressor suppressor : (List)this.diagnosticSuppressors.get()) {
                if (!this.isSuppressedByExtension(suppressor, ((DiagnosticSuppressRequest)request).getDiagnostic())) continue;
                return true;
            }
        }
        return super.isSuppressed(request);
    }

    @Override
    @Nullable
    protected PsiElement getClosestAnnotatedAncestorElement(@NotNull PsiElement element, @NotNull PsiElement rootElement, boolean excludeSelf) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        return KtStubbedPsiUtil.getPsiOrStubParent(element, KtAnnotated.class, excludeSelf);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Companion;", "", "<init>", "()V", "getDiagnosticSuppressKey", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getDiagnosticSuppressKey$frontend", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDiagnosticSuppressKey$frontend(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            String string2 = diagnostic.getFactory().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$DiagnosticSuppressRequest;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "getDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "getElement", "()Lcom/intellij/psi/PsiElement;", "rootElement", "getRootElement", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "getSuppressKey", "()Ljava/lang/String;", "frontend"})
    protected static final class DiagnosticSuppressRequest
    implements AbstractKotlinSuppressCache.SuppressRequest<PsiElement> {
        @NotNull
        private final Diagnostic diagnostic;

        public DiagnosticSuppressRequest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            this.diagnostic = diagnostic;
        }

        @NotNull
        public final Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Override
        @NotNull
        public PsiElement getElement() {
            return this.diagnostic.getPsiElement();
        }

        @Override
        @NotNull
        public PsiElement getRootElement() {
            PsiFile psiFile = this.getElement().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            return psiFile;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return this.diagnostic.getSeverity();
        }

        @Override
        @NotNull
        public String getSuppressKey() {
            return Companion.getDiagnosticSuppressKey$frontend(this.diagnostic);
        }
    }
}

