/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExplicitApiDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkVisibilityModifier", "state", "Lorg/jetbrains/kotlin/config/ExplicitApiMode;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "checkExplicitReturnType", "Companion", "frontend"})
public final class ExplicitApiDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ExplicitApiMode state = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExplicitApiMode());
        if (state == ExplicitApiMode.DISABLED) {
            return;
        }
        if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility)) {
            return;
        }
        if (descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
            return;
        }
        if (!DescriptorUtilsKt.isEffectivelyPublicApi((DeclarationDescriptorWithVisibility)descriptor2) && !DescriptorUtilsKt.isPublishedApi(descriptor2)) {
            return;
        }
        this.checkVisibilityModifier(state, declaration, (DeclarationDescriptorWithVisibility)descriptor2, context2);
        this.checkExplicitReturnType(state, declaration, descriptor2, context2);
    }

    private final void checkVisibilityModifier(ExplicitApiMode state, KtDeclaration declaration, DeclarationDescriptorWithVisibility descriptor2, DeclarationCheckerContext context2) {
        PsiElement modifier = KtPsiUtilKt.visibilityModifier(declaration);
        if (modifier != null) {
            return;
        }
        if (Companion.explicitVisibilityIsNotRequired(descriptor2)) {
            return;
        }
        DiagnosticFactory0<KtDeclaration> diagnostic = state == ExplicitApiMode.STRICT ? Errors.NO_EXPLICIT_VISIBILITY_IN_API_MODE : Errors.NO_EXPLICIT_VISIBILITY_IN_API_MODE_WARNING;
        BindingTrace bindingTrace = context2.getTrace();
        SimpleDiagnostic<KtDeclaration> simpleDiagnostic = diagnostic.on((KtDeclaration)((PsiElement)declaration));
        Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
        DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
    }

    private final void checkExplicitReturnType(ExplicitApiMode state, KtDeclaration declaration, DeclarationDescriptor descriptor2, DeclarationCheckerContext context2) {
        if (!(declaration instanceof KtCallableDeclaration)) {
            return;
        }
        if (!Companion.returnTypeCheckIsApplicable((KtCallableDeclaration)declaration)) {
            return;
        }
        boolean shouldReport = Companion.returnTypeRequired((KtCallableDeclaration)declaration, descriptor2, true, false, false);
        if (shouldReport) {
            DiagnosticFactory0<KtNamedDeclaration> diagnostic = state == ExplicitApiMode.STRICT ? Errors.NO_EXPLICIT_RETURN_TYPE_IN_API_MODE : Errors.NO_EXPLICIT_RETURN_TYPE_IN_API_MODE_WARNING;
            BindingTrace bindingTrace = context2.getTrace();
            SimpleDiagnostic<KtNamedDeclaration> simpleDiagnostic = diagnostic.on((KtNamedDeclaration)declaration);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J0\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ \u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExplicitApiDeclarationChecker$Companion;", "", "<init>", "()V", "explicitVisibilityIsNotRequired", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "returnTypeRequired", "element", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "checkForPublicApi", "checkForInternal", "checkForPrivate", "returnTypeCheckIsApplicable", "publicReturnTypeShouldBePresentInApiMode", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean explicitVisibilityIsNotRequired(@NotNull DeclarationDescriptor descriptor2) {
            Object object;
            DeclarationDescriptor declarationDescriptor;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            ClassConstructorDescriptor classConstructorDescriptor = descriptor2 instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)descriptor2 : null;
            boolean bl = classConstructorDescriptor != null ? classConstructorDescriptor.isPrimary() : false;
            if (bl) {
                return true;
            }
            if (descriptor2 instanceof PropertyDescriptor) {
                declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
                ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                boolean bl2 = classDescriptor2 != null ? classDescriptor2.isData() : false;
                if (bl2) {
                    return true;
                }
            }
            boolean bl3 = (object = descriptor2 instanceof CallableDescriptor ? (CallableDescriptor)descriptor2 : null) != null && (object = object.getOverriddenDescriptors()) != null ? !object.isEmpty() : false;
            if (bl3) {
                return true;
            }
            if (descriptor2 instanceof PropertyAccessorDescriptor) {
                return true;
            }
            if (descriptor2 instanceof PropertyDescriptor) {
                declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
                ClassDescriptor classDescriptor3 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                if ((classDescriptor3 != null ? classDescriptor3.getKind() : null) == ClassKind.ANNOTATION_CLASS) {
                    return true;
                }
            }
            return false;
        }

        public final boolean returnTypeRequired(@NotNull KtCallableDeclaration element, @Nullable DeclarationDescriptor descriptor2, boolean checkForPublicApi, boolean checkForInternal, boolean checkForPrivate) {
            Visibility visibility2;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element);
            boolean bl = ktClassOrObject != null ? ktClassOrObject.isLocal() : false;
            if (bl) {
                return false;
            }
            if (element instanceof KtFunction && ((KtFunction)element).isLocal()) {
                return false;
            }
            if (element instanceof KtProperty && ((KtProperty)element).isLocal()) {
                return false;
            }
            CallableMemberDescriptor callableMemberDescriptor = descriptor2 instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)descriptor2 : null;
            Object object = callableMemberDescriptor;
            Visibility visibility3 = visibility2 = object != null && (object = EffectiveVisibilityUtilsKt.effectiveVisibility$default((DeclarationDescriptorWithVisibility)object, null, false, 3, null)) != null ? ((EffectiveVisibility)object).toVisibility() : null;
            boolean isPublicApi = (visibility3 != null ? visibility3.isPublicAPI() : false) || Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE) && DescriptorUtilsKt.isPublishedApi(callableMemberDescriptor);
            return checkForPublicApi && isPublicApi || checkForInternal && Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE) || checkForPrivate && Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE);
        }

        public final boolean returnTypeCheckIsApplicable(@NotNull KtCallableDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.getContainingFile() instanceof KtCodeFragment) {
                return false;
            }
            if (element instanceof KtFunctionLiteral) {
                return false;
            }
            if (element instanceof KtConstructor) {
                return false;
            }
            if (element.getTypeReference() != null) {
                return false;
            }
            return !(element instanceof KtNamedFunction) || !((KtNamedFunction)element).hasBlockBody();
        }

        public final boolean publicReturnTypeShouldBePresentInApiMode(@NotNull KtCallableDeclaration element, @NotNull LanguageVersionSettings languageVersionSettings2, @Nullable DeclarationDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
            boolean isInApiMode = languageVersionSettings2.getFlag(AnalysisFlags.getExplicitApiMode()) != ExplicitApiMode.DISABLED;
            return isInApiMode && this.returnTypeRequired(element, descriptor2, true, false, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

